---
layout: page
lang-ref: elements-page
title: Theme Elements Showcase
header:
    title: "Consulting"
    subtitle: Elements
    class: inverted
vertical-tabs:
    id: vertical-tabs-showcase
    orientation: vertical
    tabs:
        - id: praesent-ac
          title: Praesent ac
          content: >-
            Lorem ipsum dolor sit amet, consectetur adipiscing elit. In mattis justo nibh, eleifend volutpat odio ullamcorper a. Nullam malesuada pharetra tincidunt. Mauris sed velit id leo congue commodo. Phasellus vel blandit magna. Etiam ut risus mattis, maximus lorem a, facilisis quam. Suspendisse potenti. Suspendisse at nisl metus. Nullam vitae quam eu nisl fringilla venenatis. Suspendisse tincidunt pulvinar lacus pretium convallis.
        - id: ac-adipiscing
          title: Ac adipiscing
          content: >-
            Sed cursus porta dictum. Proin volutpat odio pulvinar, egestas orci vel, placerat nunc. Nunc nunc libero, dignissim et eleifend ac, fringilla ut dolor. Vivamus ac quam nisi. Morbi ipsum dolor, luctus quis risus at, facilisis rutrum dolor. Duis eu gravida ipsum, eget luctus augue. Aliquam nec luctus leo, at faucibus lorem. Pellentesque placerat sed ex sed pellentesque. Sed et libero id tellus dapibus auctor sit amet a erat.
        - id: faucibus
          title: Faucibus
          content: >-
            Etiam eget malesuada lectus. Pellentesque ac mollis elit. Quisque tincidunt ex vel urna rutrum, et aliquet erat volutpat. Praesent consequat mi ac metus tempus congue in ac orci. Duis rutrum ultricies pretium. Cras fermentum elit blandit orci suscipit porta. Quisque vel ante odio. Quisque lacinia eros sit amet dui tempus fringilla at quis orci. Aliquam purus nibh, aliquet et sem id, rhoncus gravida enim. Ut maximus tortor vel tempor tincidunt. Aliquam est ante, condimentum eget facilisis non, suscipit a nibh.
        - id: in-mi-primis
          title: In mi primis
          content: >-
            Vivamus iaculis in erat in vulputate. Mauris hendrerit auctor ipsum, vel viverra felis suscipit in. Proin blandit ex quis ante lacinia egestas. Vivamus pulvinar lobortis ex, at efficitur quam placerat vitae. Proin aliquam placerat sapien, ut facilisis felis ultricies eget. Sed tincidunt risus nec tempus vestibulum. Suspendisse felis tortor, dictum eget magna id, faucibus suscipit lorem. Sed nisl eros, tempus non tempus in, tincidunt sed sapien. Nunc purus erat, fermentum id tortor in, imperdiet finibus tellus.
---
<!-- Content -->
<section id="normal-style">
    <header class="main">
        <h1>Elements</h1>
    </header>
    <!-- Content -->
    <h2 id="content">Sample Content</h2>
    <p>Praesent ac adipiscing ullamcorper semper ut amet ac risus. Lorem sapien ut odio odio nunc. Ac adipiscing nibh porttitor erat risus justo adipiscing adipiscing amet placerat accumsan. Vis. Faucibus odio magna tempus adipiscing a non. In mi primis arcu ut non accumsan vivamus ac blandit adipiscing adipiscing arcu metus praesent turpis eu ac lacinia nunc ac commodo gravida adipiscing eget accumsan ac nunc adipiscing adipiscing lorem ipsum dolor sit amet nullam veroeros adipiscing.</p>
    <div class="row">
        <div class="col-6 col-12-small">
            <h3>Sem turpis amet semper</h3>
            <p>Nunc lacinia ante nunc ac lobortis. Interdum adipiscing gravida odio porttitor sem non mi integer non faucibus ornare mi ut ante amet placerat aliquet. Volutpat commodo eu sed ante lacinia. Sapien a lorem in integer ornare praesent commodo adipiscing arcu in massa commodo lorem accumsan at odio massa ac ac. Semper adipiscing varius montes viverra nibh in adipiscing blandit tempus accumsan.</p>
        </div>
        <div class="col-6 col-12-small">
            <h3>Magna odio tempus commodo</h3>
            <p>In arcu accumsan arcu adipiscing accumsan orci ac. Felis id enim aliquet. Accumsan ac integer lobortis commodo ornare aliquet accumsan erat tempus amet porttitor. Ante commodo blandit adipiscing integer semper orci eget. Faucibus commodo adipiscing mi eu nullam accumsan morbi arcu ornare odio mi adipiscing nascetur lacus ac interdum morbi accumsan vis mi accumsan.</p>
        </div>
        <!-- Break -->
        <div class="col-4 col-12-medium">
            <h3>Interdum sapien gravida</h3>
            <p>Nunc lacinia ante nunc ac lobortis. Interdum adipiscing gravida odio porttitor sem non mi integer non faucibus ornare mi ut ante amet placerat aliquet. Volutpat eu sed ante lacinia sapien lorem accumsan varius montes viverra nibh in adipiscing blandit.</p>
        </div>
        <div class="col-4 col-12-medium">
            <h3>Faucibus consequat lorem</h3>
            <p>Nunc lacinia ante nunc ac lobortis. Interdum adipiscing gravida odio porttitor sem non mi integer non faucibus ornare mi ut ante amet placerat aliquet. Volutpat eu sed ante lacinia sapien lorem accumsan varius montes viverra nibh in adipiscing blandit.</p>
        </div>
        <div class="col-4 col-12-medium">
            <h3>Accumsan montes viverra</h3>
            <p>Nunc lacinia ante nunc ac lobortis. Interdum adipiscing gravida odio porttitor sem non mi integer non faucibus ornare mi ut ante amet placerat aliquet. Volutpat eu sed ante lacinia sapien lorem accumsan varius montes viverra nibh in adipiscing blandit.</p>
        </div>
    </div>
    <hr class="major" />
    <!-- Elements -->
    <h2 id="elements">Elements</h2>
    <div class="row gtr-200">
        <div class="col-6 col-12-medium col-12-small">
            <!-- Text stuff -->
            <h3>Text</h3>
            <p>This is <b>bold</b> and this is <strong>strong</strong>. This is <i>italic</i> and this is <em>emphasized</em>.
            This is <sup>superscript</sup> text and this is <sub>subscript</sub> text.
            This is <u>underlined</u> and this is code: <code>for (;;) { ... }</code>.
            Finally, this is a <a href="#">link</a>.</p>
            <hr />
            <h2>Heading Level 2</h2>
            <h3>Heading Level 3</h3>
            <h4>Heading Level 4</h4>
            <hr />
            <p>Nunc lacinia ante nunc ac lobortis. Interdum adipiscing gravida odio porttitor sem non mi integer non faucibus ornare mi ut ante amet placerat aliquet. Volutpat eu sed ante lacinia sapien lorem accumsan varius montes viverra nibh in adipiscing blandit tempus accumsan.</p>
            <!-- Lists -->
            <h3>Lists</h3>
            <div class="row">
                <div class="col-6 col-12-small">
                    <h4>Unordered</h4>
                    <ul>
                        <li>Dolor etiam magna etiam.</li>
                        <li>Sagittis lorem eleifend.</li>
                        <li>Felis dolore viverra.</li>
                    </ul>
                    <h4>Alternate</h4>
                    <ul class="alt">
                        <li>Dolor etiam magna etiam.</li>
                        <li>Sagittis lorem eleifend.</li>
                        <li>Felis feugiat viverra.</li>
                    </ul>
                </div>
                <div class="col-6 col-12-small">
                    <h4>Ordered</h4>
                    <ol>
                        <li>Dolor etiam magna etiam.</li>
                        <li>Etiam vel lorem sed viverra.</li>
                        <li>Felis dolore viverra.</li>
                        <li>Dolor etiam magna etiam.</li>
                        <li>Etiam vel lorem sed viverra.</li>
                        <li>Felis dolore viverra.</li>
                    </ol>
                    <h4>Icons</h4>
                    <ul class="icons">
                        <li><a href="#" class="icon brands fa-twitter"><span class="label">Twitter</span></a></li>
                        <li><a href="#" class="icon brands fa-facebook-f"><span class="label">Facebook</span></a></li>
                        <li><a href="#" class="icon brands fa-instagram"><span class="label">Instagram</span></a></li>
                        <li><a href="#" class="icon brands fa-github"><span class="label">Github</span></a></li>
                        <li><a href="#" class="icon brands fa-dribbble"><span class="label">Dribbble</span></a></li>
                        <li><a href="#" class="icon brands fa-tumblr"><span class="label">Tumblr</span></a></li>
                    </ul>
                </div>
            </div>
            <h4>Definition</h4>
            <dl>
                <dt>Item1</dt>
                <dd>
                    <p>Lorem ipsum dolor vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent. Lorem ipsum dolor.</p>
                </dd>
                <dt>Item2</dt>
                <dd>
                    <p>Lorem ipsum dolor vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent. Lorem ipsum dolor.</p>
                </dd>
                <dt>Item3</dt>
                <dd>
                    <p>Lorem ipsum dolor vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent. Lorem ipsum dolor.</p>
                </dd>
            </dl>
            <h4>Actions</h4>
            <ul class="actions">
                <li><a href="#" class="button primary">Default</a></li>
                <li><a href="#" class="button">Default</a></li>
            </ul>
            <ul class="actions small">
                <li><a href="#" class="button primary small">Small</a></li>
                <li><a href="#" class="button small">Small</a></li>
            </ul>
            <div class="row">
                <div class="col-6 col-12-small">
                    <ul class="actions stacked">
                        <li><a href="#" class="button primary">Default</a></li>
                        <li><a href="#" class="button">Default</a></li>
                    </ul>
                </div>
                <div class="col-6 col-12-small">
                    <ul class="actions stacked">
                        <li><a href="#" class="button primary small">Small</a></li>
                        <li><a href="#" class="button small">Small</a></li>
                    </ul>
                </div>
                <div class="col-6 col-12-small">
                    <ul class="actions stacked">
                        <li><a href="#" class="button primary fit">Default</a></li>
                        <li><a href="#" class="button fit">Default</a></li>
                    </ul>
                </div>
                <div class="col-6 col-12-small">
                    <ul class="actions stacked">
                        <li><a href="#" class="button primary small fit">Small</a></li>
                        <li><a href="#" class="button small fit">Small</a></li>
                    </ul>
                </div>
            </div>
            <h4>Pagination</h4>
            <ul class="pagination">
                <li><span class="button disabled">Prev</span></li>
                <li><a href="#" class="page active">1</a></li>
                <li><a href="#" class="page">2</a></li>
                <li><a href="#" class="page">3</a></li>
                <li><span>&hellip;</span></li>
                <li><a href="#" class="page">8</a></li>
                <li><a href="#" class="page">9</a></li>
                <li><a href="#" class="page">10</a></li>
                <li><a href="#" class="button">Next</a></li>
            </ul>
            <!-- Blockquote -->
            <h3>Blockquote</h3>
            <blockquote>Lorem ipsum dolor vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent. Lorem ipsum dolor. Lorem ipsum dolor vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus.</blockquote>
            <!-- Table -->
            <h3>Table</h3>
            <h4>Default</h4>
            <div class="table-wrapper">
                <table>
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Price</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Item1</td>
                            <td>Ante turpis integer aliquet porttitor.</td>
                            <td>29.99</td>
                        </tr>
                        <tr>
                            <td>Item2</td>
                            <td>Vis ac commodo adipiscing arcu aliquet.</td>
                            <td>19.99</td>
                        </tr>
                        <tr>
                            <td>Item3</td>
                            <td> Morbi faucibus arcu accumsan lorem.</td>
                            <td>29.99</td>
                        </tr>
                        <tr>
                            <td>Item4</td>
                            <td>Vitae integer tempus condimentum.</td>
                            <td>19.99</td>
                        </tr>
                        <tr>
                            <td>Item5</td>
                            <td>Ante turpis integer aliquet porttitor.</td>
                            <td>29.99</td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="2"></td>
                            <td>100.00</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <h4>Alternate</h4>
            <div class="table-wrapper">
                <table class="alt">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Price</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Item1</td>
                            <td>Ante turpis integer aliquet porttitor.</td>
                            <td>29.99</td>
                        </tr>
                        <tr>
                            <td>Item2</td>
                            <td>Vis ac commodo adipiscing arcu aliquet.</td>
                            <td>19.99</td>
                        </tr>
                        <tr>
                            <td>Item3</td>
                            <td> Morbi faucibus arcu accumsan lorem.</td>
                            <td>29.99</td>
                        </tr>
                        <tr>
                            <td>Item4</td>
                            <td>Vitae integer tempus condimentum.</td>
                            <td>19.99</td>
                        </tr>
                        <tr>
                            <td>Item5</td>
                            <td>Ante turpis integer aliquet porttitor.</td>
                            <td>29.99</td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="2"></td>
                            <td>100.00</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- Tabs -->
            <h3>Horizontal Tabs</h3>
            <div class="horizontal-tabset">
                <!-- Tab 1 -->
                <input type="radio" name="horizontal-tabset" id="horizontal-tab1" aria-controls="horizontal-panel1" checked>
                <label for="horizontal-tab1">Praesent ac</label>
                <!-- Tab 2 -->
                <input type="radio" name="horizontal-tabset" id="horizontal-tab2" aria-controls="horizontal-panel2">
                <label for="horizontal-tab2">Ac adipiscing</label>
                <!-- Tab 3 -->
                <input type="radio" name="horizontal-tabset" id="horizontal-tab3" aria-controls="horizontal-panel3">
                <label for="horizontal-tab3">Faucibus</label>
                <div class="tab-panels">
                    <section id="horizontal-panel1" class="tab-panel">
                        <h2>Praesent ac</h2>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In mattis justo nibh, eleifend volutpat odio ullamcorper a. Nullam malesuada pharetra tincidunt. Mauris sed velit id leo congue commodo. Phasellus vel blandit magna. Etiam ut risus mattis, maximus lorem a, facilisis quam. Suspendisse potenti. Suspendisse at nisl metus. Nullam vitae quam eu nisl fringilla venenatis. Suspendisse tincidunt pulvinar lacus pretium convallis.</p>
                    </section>
                    <section id="horizontal-panel2" class="tab-panel">
                        <h2>Ac adipiscing</h2>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In mattis justo nibh, eleifend volutpat odio ullamcorper a. Nullam malesuada pharetra tincidunt. Mauris sed velit id leo congue commodo. Phasellus vel blandit magna. Etiam ut risus mattis, maximus lorem a, facilisis quam. Suspendisse potenti. Suspendisse at nisl metus. Nullam vitae quam eu nisl fringilla venenatis. Suspendisse tincidunt pulvinar lacus pretium convallis.</p>
                    </section>
                    <section id="horizontal-panel3" class="tab-panel">
                        <h2>Faucibus</h2>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In mattis justo nibh, eleifend volutpat odio ullamcorper a. Nullam malesuada pharetra tincidunt. Mauris sed velit id leo congue commodo. Phasellus vel blandit magna. Etiam ut risus mattis, maximus lorem a, facilisis quam. Suspendisse potenti. Suspendisse at nisl metus. Nullam vitae quam eu nisl fringilla venenatis. Suspendisse tincidunt pulvinar lacus pretium convallis.</p>
                    </section>
                </div>
            </div>
        </div>
        <div class="col-6 col-12-medium col-12-small">
            <!-- Buttons -->
            <h3>Buttons</h3>
            <ul class="actions">
                <li><a href="#" class="button primary">Primary</a></li>
                <li><a href="#" class="button">Default</a></li>
            </ul>
            <ul class="actions">
                <li><a href="#" class="button large">Large</a></li>
                <li><a href="#" class="button">Default</a></li>
                <li><a href="#" class="button small">Small</a></li>
            </ul>
            <ul class="actions">
                <li><a href="#" class="button primary large">Large</a></li>
                <li><a href="#" class="button primary">Default</a></li>
                <li><a href="#" class="button primary small">Small</a></li>
            </ul>
            <ul class="actions fit">
                <li><a href="#" class="button primary fit">Fit</a></li>
                <li><a href="#" class="button fit">Fit</a></li>
            </ul>
            <ul class="actions fit small">
                <li><a href="#" class="button primary fit small">Fit + Small</a></li>
                <li><a href="#" class="button fit small">Fit + Small</a></li>
            </ul>
            <ul class="actions">
                <li><a href="#" class="button primary icon solid fa-search">Icon</a></li>
                <li><a href="#" class="button icon solid fa-download">Icon</a></li>
            </ul>
            <ul class="actions">
                <li><span class="button primary disabled">Primary</span></li>
                <li><span class="button disabled">Default</span></li>
            </ul>
            <!-- Form -->
            <h3>Form</h3>
            <form method="post" action="#">
                <div class="row gtr-uniform">
                    <div class="col-6 col-12-xsmall">
                        <label for="demo-name">Some Label</label>
                    </div>
                    <div class="col-6 col-12-xsmall">
                        <label for="demo-email">Another Label</label>
                    </div>
                    <div class="col-6 col-12-xsmall">
                        <input type="text" name="demo-name" id="demo-name" value="" placeholder="Name" />
                    </div>
                    <div class="col-6 col-12-xsmall">
                        <input type="email" name="demo-email" id="demo-email" value="" placeholder="Email" />
                    </div>
                    <!-- Break -->
                    <div class="col-12">
                        <select name="demo-category" id="demo-category">
                            <option value="">- Category -</option>
                            <option value="1">Manufacturing</option>
                            <option value="1">Shipping</option>
                            <option value="1">Administration</option>
                            <option value="1">Human Resources</option>
                        </select>
                    </div>
                    <!-- Break -->
                    <div class="col-4 col-12-small">
                        <input type="radio" id="demo-priority-low" name="demo-priority" checked>
                        <label for="demo-priority-low">Low</label>
                    </div>
                    <div class="col-4 col-12-small">
                        <input type="radio" id="demo-priority-normal" name="demo-priority">
                        <label for="demo-priority-normal">Normal</label>
                    </div>
                    <div class="col-4 col-12-small">
                        <input type="radio" id="demo-priority-high" name="demo-priority">
                        <label for="demo-priority-high">High</label>
                    </div>
                    <!-- Break -->
                    <div class="col-6 col-12-small">
                        <input type="checkbox" id="demo-copy" name="demo-copy">
                        <label for="demo-copy">Email me a copy</label>
                    </div>
                    <div class="col-6 col-12-small">
                        <input type="checkbox" id="demo-human" name="demo-human" checked>
                        <label for="demo-human">I am a human</label>
                    </div>
                    <!-- Break -->
                    <div class="col-12">
                        <textarea name="demo-message" id="demo-message" placeholder="Enter your message" rows="6"></textarea>
                    </div>
                    <!-- Break -->
                    <div class="col-12">
                        <ul class="actions">
                            <li><input type="submit" value="Send Message" class="primary" /></li>
                            <li><input type="reset" value="Reset" /></li>
                        </ul>
                    </div>
                </div>
            </form>
            <!-- Image -->
            <h3>Image</h3>
            <h4>Fit</h4>
            <div class="box alt">
                <div class="row gtr-50 gtr-uniform">
                    <div class="col-12">
                        <span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic11.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic11.webp' | absolute_url }}" alt="" /></span>
                    </div>
                    <!-- Break -->
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic01.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic01.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic02.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic02.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic03.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic03.webp' | absolute_url }}" alt="" /></span></div>
                    <!-- Break -->
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic03.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic03.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic01.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic01.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic02.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic02.webp' | absolute_url }}" alt="" /></span></div>
                    <!-- Break -->
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic02.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic02.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic03.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic03.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic01.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic01.webp' | absolute_url }}" alt="" /></span></div>
                </div>
            </div>
            <h4>Left &amp; Right</h4>
            <p><span class="image left"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic01.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic01.webp' | absolute_url }}" alt="" /></span>Lorem ipsum dolor sit accumsan interdum nisi, quis tincidunt felis sagittis eget. tempus euismod. Vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent tincidunt felis sagittis eget. tempus euismod. Vestibulum ante ipsum primis sagittis eget. tempus euismod. Vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent.</p>
            <p><span class="image right"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic02.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic02.webp' | absolute_url }}" alt="" /></span>Lorem ipsum dolor sit accumsan interdum nisi, quis tincidunt felis sagittis eget. tempus euismod. Vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent tincidunt felis sagittis eget. tempus euismod. Vestibulum ante ipsum primis sagittis eget. tempus euismod. Vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent.</p>
            <!-- Box -->
            <h3>Box</h3>
            <div class="box">
                <p>Felis sagittis eget tempus primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent tincidunt felis sagittis eget. tempus euismod. Magna sed etiam ante ipsum primis in faucibus vestibulum.</p>
            </div>
            <!-- Preformatted Code -->
            <h3>Preformatted</h3>
            <pre><code>i = 0;

while (!deck.isInOrder()) {
print 'Iteration ' + i;
deck.shuffle();
i++;
}

print 'It took ' + i + ' iterations to sort the deck.';
            </code></pre>
            <!-- Tabs -->
            <h3>Vertical Tabs</h3>
            {% include tabs.html id=page.vertical-tabs.id headers-width="30" show-title="false" tabs=page.vertical-tabs.tabs %}
        </div>
    </div>
</section>

<!-- Inverted Section -->
<section id="inverted-style" class="inverted">
    <header class="main">
        <h1>Elements</h1>
    </header>
    <!-- Content -->
    <h2 id="content">Sample Content</h2>
    <p>Praesent ac adipiscing ullamcorper semper ut amet ac risus. Lorem sapien ut odio odio nunc. Ac adipiscing nibh porttitor erat risus justo adipiscing adipiscing amet placerat accumsan. Vis. Faucibus odio magna tempus adipiscing a non. In mi primis arcu ut non accumsan vivamus ac blandit adipiscing adipiscing arcu metus praesent turpis eu ac lacinia nunc ac commodo gravida adipiscing eget accumsan ac nunc adipiscing adipiscing lorem ipsum dolor sit amet nullam veroeros adipiscing.</p>
    <div class="row">
        <div class="col-6 col-12-small">
            <h3>Sem turpis amet semper</h3>
            <p>Nunc lacinia ante nunc ac lobortis. Interdum adipiscing gravida odio porttitor sem non mi integer non faucibus ornare mi ut ante amet placerat aliquet. Volutpat commodo eu sed ante lacinia. Sapien a lorem in integer ornare praesent commodo adipiscing arcu in massa commodo lorem accumsan at odio massa ac ac. Semper adipiscing varius montes viverra nibh in adipiscing blandit tempus accumsan.</p>
        </div>
        <div class="col-6 col-12-small">
            <h3>Magna odio tempus commodo</h3>
            <p>In arcu accumsan arcu adipiscing accumsan orci ac. Felis id enim aliquet. Accumsan ac integer lobortis commodo ornare aliquet accumsan erat tempus amet porttitor. Ante commodo blandit adipiscing integer semper orci eget. Faucibus commodo adipiscing mi eu nullam accumsan morbi arcu ornare odio mi adipiscing nascetur lacus ac interdum morbi accumsan vis mi accumsan.</p>
        </div>
        <!-- Break -->
        <div class="col-4 col-12-medium">
            <h3>Interdum sapien gravida</h3>
            <p>Nunc lacinia ante nunc ac lobortis. Interdum adipiscing gravida odio porttitor sem non mi integer non faucibus ornare mi ut ante amet placerat aliquet. Volutpat eu sed ante lacinia sapien lorem accumsan varius montes viverra nibh in adipiscing blandit.</p>
        </div>
        <div class="col-4 col-12-medium">
            <h3>Faucibus consequat lorem</h3>
            <p>Nunc lacinia ante nunc ac lobortis. Interdum adipiscing gravida odio porttitor sem non mi integer non faucibus ornare mi ut ante amet placerat aliquet. Volutpat eu sed ante lacinia sapien lorem accumsan varius montes viverra nibh in adipiscing blandit.</p>
        </div>
        <div class="col-4 col-12-medium">
            <h3>Accumsan montes viverra</h3>
            <p>Nunc lacinia ante nunc ac lobortis. Interdum adipiscing gravida odio porttitor sem non mi integer non faucibus ornare mi ut ante amet placerat aliquet. Volutpat eu sed ante lacinia sapien lorem accumsan varius montes viverra nibh in adipiscing blandit.</p>
        </div>
    </div>
    <hr class="major" />
    <!-- Elements -->
    <h2 id="elements">Elements</h2>
    <div class="row gtr-200">
        <div class="col-6 col-12-medium col-12-small">
            <!-- Text stuff -->
            <h3>Text</h3>
            <p>This is <b>bold</b> and this is <strong>strong</strong>. This is <i>italic</i> and this is <em>emphasized</em>.
            This is <sup>superscript</sup> text and this is <sub>subscript</sub> text.
            This is <u>underlined</u> and this is code: <code>for (;;) { ... }</code>.
            Finally, this is a <a href="#">link</a>.</p>
            <hr />
            <h2>Heading Level 2</h2>
            <h3>Heading Level 3</h3>
            <h4>Heading Level 4</h4>
            <hr />
            <p>Nunc lacinia ante nunc ac lobortis. Interdum adipiscing gravida odio porttitor sem non mi integer non faucibus ornare mi ut ante amet placerat aliquet. Volutpat eu sed ante lacinia sapien lorem accumsan varius montes viverra nibh in adipiscing blandit tempus accumsan.</p>
            <!-- Lists -->
            <h3>Lists</h3>
            <div class="row">
                <div class="col-6 col-12-small">
                    <h4>Unordered</h4>
                    <ul>
                        <li>Dolor etiam magna etiam.</li>
                        <li>Sagittis lorem eleifend.</li>
                        <li>Felis dolore viverra.</li>
                    </ul>
                    <h4>Alternate</h4>
                    <ul class="alt">
                        <li>Dolor etiam magna etiam.</li>
                        <li>Sagittis lorem eleifend.</li>
                        <li>Felis feugiat viverra.</li>
                    </ul>
                </div>
                <div class="col-6 col-12-small">
                    <h4>Ordered</h4>
                    <ol>
                        <li>Dolor etiam magna etiam.</li>
                        <li>Etiam vel lorem sed viverra.</li>
                        <li>Felis dolore viverra.</li>
                        <li>Dolor etiam magna etiam.</li>
                        <li>Etiam vel lorem sed viverra.</li>
                        <li>Felis dolore viverra.</li>
                    </ol>
                    <h4>Icons</h4>
                    <ul class="icons">
                        <li><a href="#" class="icon brands fa-twitter"><span class="label">Twitter</span></a></li>
                        <li><a href="#" class="icon brands fa-facebook-f"><span class="label">Facebook</span></a></li>
                        <li><a href="#" class="icon brands fa-instagram"><span class="label">Instagram</span></a></li>
                        <li><a href="#" class="icon brands fa-github"><span class="label">Github</span></a></li>
                        <li><a href="#" class="icon brands fa-dribbble"><span class="label">Dribbble</span></a></li>
                        <li><a href="#" class="icon brands fa-tumblr"><span class="label">Tumblr</span></a></li>
                    </ul>
                </div>
            </div>
            <h4>Definition</h4>
            <dl>
                <dt>Item1</dt>
                <dd>
                    <p>Lorem ipsum dolor vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent. Lorem ipsum dolor.</p>
                </dd>
                <dt>Item2</dt>
                <dd>
                    <p>Lorem ipsum dolor vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent. Lorem ipsum dolor.</p>
                </dd>
                <dt>Item3</dt>
                <dd>
                    <p>Lorem ipsum dolor vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent. Lorem ipsum dolor.</p>
                </dd>
            </dl>
            <h4>Actions</h4>
            <ul class="actions">
                <li><a href="#" class="button primary">Default</a></li>
                <li><a href="#" class="button">Default</a></li>
            </ul>
            <ul class="actions small">
                <li><a href="#" class="button primary small">Small</a></li>
                <li><a href="#" class="button small">Small</a></li>
            </ul>
            <div class="row">
                <div class="col-6 col-12-small">
                    <ul class="actions stacked">
                        <li><a href="#" class="button primary">Default</a></li>
                        <li><a href="#" class="button">Default</a></li>
                    </ul>
                </div>
                <div class="col-6 col-12-small">
                    <ul class="actions stacked">
                        <li><a href="#" class="button primary small">Small</a></li>
                        <li><a href="#" class="button small">Small</a></li>
                    </ul>
                </div>
                <div class="col-6 col-12-small">
                    <ul class="actions stacked">
                        <li><a href="#" class="button primary fit">Default</a></li>
                        <li><a href="#" class="button fit">Default</a></li>
                    </ul>
                </div>
                <div class="col-6 col-12-small">
                    <ul class="actions stacked">
                        <li><a href="#" class="button primary small fit">Small</a></li>
                        <li><a href="#" class="button small fit">Small</a></li>
                    </ul>
                </div>
            </div>
            <h4>Pagination</h4>
            <ul class="pagination">
                <li><span class="button disabled">Prev</span></li>
                <li><a href="#" class="page active">1</a></li>
                <li><a href="#" class="page">2</a></li>
                <li><a href="#" class="page">3</a></li>
                <li><span>&hellip;</span></li>
                <li><a href="#" class="page">8</a></li>
                <li><a href="#" class="page">9</a></li>
                <li><a href="#" class="page">10</a></li>
                <li><a href="#" class="button">Next</a></li>
            </ul>
            <!-- Blockquote -->
            <h3>Blockquote</h3>
            <blockquote>Lorem ipsum dolor vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent. Lorem ipsum dolor. Lorem ipsum dolor vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus.</blockquote>
            <!-- Table -->
            <h3>Table</h3>
            <h4>Default</h4>
            <div class="table-wrapper">
                <table>
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Price</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Item1</td>
                            <td>Ante turpis integer aliquet porttitor.</td>
                            <td>29.99</td>
                        </tr>
                        <tr>
                            <td>Item2</td>
                            <td>Vis ac commodo adipiscing arcu aliquet.</td>
                            <td>19.99</td>
                        </tr>
                        <tr>
                            <td>Item3</td>
                            <td> Morbi faucibus arcu accumsan lorem.</td>
                            <td>29.99</td>
                        </tr>
                        <tr>
                            <td>Item4</td>
                            <td>Vitae integer tempus condimentum.</td>
                            <td>19.99</td>
                        </tr>
                        <tr>
                            <td>Item5</td>
                            <td>Ante turpis integer aliquet porttitor.</td>
                            <td>29.99</td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="2"></td>
                            <td>100.00</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <h4>Alternate</h4>
            <div class="table-wrapper">
                <table class="alt">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Price</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Item1</td>
                            <td>Ante turpis integer aliquet porttitor.</td>
                            <td>29.99</td>
                        </tr>
                        <tr>
                            <td>Item2</td>
                            <td>Vis ac commodo adipiscing arcu aliquet.</td>
                            <td>19.99</td>
                        </tr>
                        <tr>
                            <td>Item3</td>
                            <td> Morbi faucibus arcu accumsan lorem.</td>
                            <td>29.99</td>
                        </tr>
                        <tr>
                            <td>Item4</td>
                            <td>Vitae integer tempus condimentum.</td>
                            <td>19.99</td>
                        </tr>
                        <tr>
                            <td>Item5</td>
                            <td>Ante turpis integer aliquet porttitor.</td>
                            <td>29.99</td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="2"></td>
                            <td>100.00</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- Tabs -->
            <h3>Horizontal Tabs</h3>
            <div class="horizontal-tabset">
                <!-- Tab 1 -->
                <input type="radio" name="horizontal-tabset-inverted" id="horizontal-tab-inverted1" aria-controls="horizontal-panel-inverted1" checked>
                <label for="horizontal-tab-inverted1">Praesent ac</label>
                <!-- Tab 2 -->
                <input type="radio" name="horizontal-tabset-inverted" id="horizontal-tab-inverted2" aria-controls="horizontal-panel-inverted2">
                <label for="horizontal-tab-inverted2">Ac adipiscing</label>
                <!-- Tab 3 -->
                <input type="radio" name="horizontal-tabset-inverted" id="horizontal-tab-inverted3" aria-controls="horizontal-panel-inverted3">
                <label for="horizontal-tab-inverted3">Faucibus</label>
                <div class="tab-panels">
                    <section id="horizontal-panel-inverted1" class="tab-panel">
                        <h2>Praesent ac</h2>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In mattis justo nibh, eleifend volutpat odio ullamcorper a. Nullam malesuada pharetra tincidunt. Mauris sed velit id leo congue commodo. Phasellus vel blandit magna. Etiam ut risus mattis, maximus lorem a, facilisis quam. Suspendisse potenti. Suspendisse at nisl metus. Nullam vitae quam eu nisl fringilla venenatis. Suspendisse tincidunt pulvinar lacus pretium convallis.</p>
                    </section>
                    <section id="horizontal-panel-inverted2" class="tab-panel">
                        <h2>Ac adipiscing</h2>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In mattis justo nibh, eleifend volutpat odio ullamcorper a. Nullam malesuada pharetra tincidunt. Mauris sed velit id leo congue commodo. Phasellus vel blandit magna. Etiam ut risus mattis, maximus lorem a, facilisis quam. Suspendisse potenti. Suspendisse at nisl metus. Nullam vitae quam eu nisl fringilla venenatis. Suspendisse tincidunt pulvinar lacus pretium convallis.</p>
                    </section>
                    <section id="horizontal-panel-inverted3" class="tab-panel">
                        <h2>Faucibus</h2>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In mattis justo nibh, eleifend volutpat odio ullamcorper a. Nullam malesuada pharetra tincidunt. Mauris sed velit id leo congue commodo. Phasellus vel blandit magna. Etiam ut risus mattis, maximus lorem a, facilisis quam. Suspendisse potenti. Suspendisse at nisl metus. Nullam vitae quam eu nisl fringilla venenatis. Suspendisse tincidunt pulvinar lacus pretium convallis.</p>
                    </section>
                </div>
            </div>
        </div>
        <div class="col-6 col-12-medium col-12-small">
            <!-- Buttons -->
            <h3>Buttons</h3>
            <ul class="actions">
                <li><a href="#" class="button primary">Primary</a></li>
                <li><a href="#" class="button">Default</a></li>
            </ul>
            <ul class="actions">
                <li><a href="#" class="button large">Large</a></li>
                <li><a href="#" class="button">Default</a></li>
                <li><a href="#" class="button small">Small</a></li>
            </ul>
            <ul class="actions">
                <li><a href="#" class="button primary large">Large</a></li>
                <li><a href="#" class="button primary">Default</a></li>
                <li><a href="#" class="button primary small">Small</a></li>
            </ul>
            <ul class="actions fit">
                <li><a href="#" class="button primary fit">Fit</a></li>
                <li><a href="#" class="button fit">Fit</a></li>
            </ul>
            <ul class="actions fit small">
                <li><a href="#" class="button primary fit small">Fit + Small</a></li>
                <li><a href="#" class="button fit small">Fit + Small</a></li>
            </ul>
            <ul class="actions">
                <li><a href="#" class="button primary icon solid fa-search">Icon</a></li>
                <li><a href="#" class="button icon solid fa-download">Icon</a></li>
            </ul>
            <ul class="actions">
                <li><span class="button primary disabled">Primary</span></li>
                <li><span class="button disabled">Default</span></li>
            </ul>
            <!-- Form -->
            <h3>Form</h3>
            <form method="post" action="#">
                <div class="row gtr-uniform">
                    <div class="col-6 col-12-xsmall">
                        <label for="demo-name">Some Label</label>
                    </div>
                    <div class="col-6 col-12-xsmall">
                        <label for="demo-email">Another Label</label>
                    </div>
                    <div class="col-6 col-12-xsmall">
                        <input type="text" name="demo-name" id="demo-name" value="" placeholder="Name" />
                    </div>
                    <div class="col-6 col-12-xsmall">
                        <input type="email" name="demo-email" id="demo-email" value="" placeholder="Email" />
                    </div>
                    <!-- Break -->
                    <div class="col-12">
                        <select name="demo-category" id="demo-category">
                            <option value="">- Category -</option>
                            <option value="1">Manufacturing</option>
                            <option value="1">Shipping</option>
                            <option value="1">Administration</option>
                            <option value="1">Human Resources</option>
                        </select>
                    </div>
                    <!-- Break -->
                    <div class="col-4 col-12-small">
                        <input type="radio" id="demo-priority-low" name="demo-priority" checked>
                        <label for="demo-priority-low">Low</label>
                    </div>
                    <div class="col-4 col-12-small">
                        <input type="radio" id="demo-priority-normal" name="demo-priority">
                        <label for="demo-priority-normal">Normal</label>
                    </div>
                    <div class="col-4 col-12-small">
                        <input type="radio" id="demo-priority-high" name="demo-priority">
                        <label for="demo-priority-high">High</label>
                    </div>
                    <!-- Break -->
                    <div class="col-6 col-12-small">
                        <input type="checkbox" id="demo-copy" name="demo-copy">
                        <label for="demo-copy">Email me a copy</label>
                    </div>
                    <div class="col-6 col-12-small">
                        <input type="checkbox" id="demo-human" name="demo-human" checked>
                        <label for="demo-human">I am a human</label>
                    </div>
                    <!-- Break -->
                    <div class="col-12">
                        <textarea name="demo-message" id="demo-message" placeholder="Enter your message" rows="6"></textarea>
                    </div>
                    <!-- Break -->
                    <div class="col-12">
                        <ul class="actions">
                            <li><input type="submit" value="Send Message" class="primary" /></li>
                            <li><input type="reset" value="Reset" /></li>
                        </ul>
                    </div>
                </div>
            </form>
            <!-- Image -->
            <h3>Image</h3>
            <h4>Fit</h4>
            <div class="box alt">
                <div class="row gtr-50 gtr-uniform">
                    <div class="col-12">
                        <span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic11.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic11.webp' | absolute_url }}" alt="" /></span>
                    </div>
                    <!-- Break -->
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic01.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic01.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic02.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic02.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic03.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic03.webp' | absolute_url }}" alt="" /></span></div>
                    <!-- Break -->
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic03.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic03.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic01.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic01.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic02.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic02.webp' | absolute_url }}" alt="" /></span></div>
                    <!-- Break -->
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic02.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic02.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic03.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic03.webp' | absolute_url }}" alt="" /></span></div>
                    <div class="col-4"><span class="image fit"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic01.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic01.webp' | absolute_url }}" alt="" /></span></div>
                </div>
            </div>
            <h4>Left &amp; Right</h4>
            <p><span class="image left"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic01.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic01.webp' | absolute_url }}" alt="" /></span>Lorem ipsum dolor sit accumsan interdum nisi, quis tincidunt felis sagittis eget. tempus euismod. Vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent tincidunt felis sagittis eget. tempus euismod. Vestibulum ante ipsum primis sagittis eget. tempus euismod. Vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent.</p>
            <p><span class="image right"><img class="lazy-loading" src="{{ 'assets/images/placeholder/pic02.webp' | absolute_url }}" data-src="{{ 'assets/images/content/pic02.webp' | absolute_url }}" alt="" /></span>Lorem ipsum dolor sit accumsan interdum nisi, quis tincidunt felis sagittis eget. tempus euismod. Vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent tincidunt felis sagittis eget. tempus euismod. Vestibulum ante ipsum primis sagittis eget. tempus euismod. Vestibulum ante ipsum primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent.</p>
            <!-- Box -->
            <h3>Box</h3>
            <div class="box">
                <p>Felis sagittis eget tempus primis in faucibus vestibulum. Blandit adipiscing eu felis iaculis volutpat ac adipiscing accumsan eu faucibus. Integer ac pellentesque praesent tincidunt felis sagittis eget. tempus euismod. Magna sed etiam ante ipsum primis in faucibus vestibulum.</p>
            </div>
            <!-- Preformatted Code -->
            <h3>Preformatted</h3>
            <pre><code>i = 0;

while (!deck.isInOrder()) {
print 'Iteration ' + i;
deck.shuffle();
i++;
}

print 'It took ' + i + ' iterations to sort the deck.';
            </code></pre>
            <!-- Tabs -->
            <h3>Vertical Tabs</h3>
            <div class="vertical-tabset">
                <div id="vertical-tab-inverted1" class="vertical-tab">
                    <input type="radio" name="vertical-tabs-inverted" id="vertical-tab-inverted-option1" checked>
                    <label for="vertical-tab-inverted-option1">Praesent ac</label>
                    <section class="tab-panel">
                        <h2>Praesent ac</h2>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In mattis justo nibh, eleifend volutpat odio ullamcorper a. Nullam malesuada pharetra tincidunt. Mauris sed velit id leo congue commodo. Phasellus vel blandit magna. Etiam ut risus mattis, maximus lorem a, facilisis quam. Suspendisse potenti. Suspendisse at nisl metus. Nullam vitae quam eu nisl fringilla venenatis. Suspendisse tincidunt pulvinar lacus pretium convallis.</p>
                    </section>
                </div>
                <div id="vertical-tab-inverted2" class="vertical-tab">
                    <input type="radio" name="vertical-tabs-inverted" id="vertical-tab-inverted-option2">
                    <label for="vertical-tab-inverted-option2">Ac adipiscing</label>
                    <section class="tab-panel">
                        <h2>Ac adipiscing</h2>
                        <p>Sed cursus porta dictum. Proin volutpat odio pulvinar, egestas orci vel, placerat nunc. Nunc nunc libero, dignissim et eleifend ac, fringilla ut dolor. Vivamus ac quam nisi. Morbi ipsum dolor, luctus quis risus at, facilisis rutrum dolor. Duis eu gravida ipsum, eget luctus augue. Aliquam nec luctus leo, at faucibus lorem. Pellentesque placerat sed ex sed pellentesque. Sed et libero id tellus dapibus auctor sit amet a erat.</p>
                    </section>
                </div>
                <div id="vertical-tab-inverted3" class="vertical-tab">
                    <input type="radio" name="vertical-tabs-inverted" id="vertical-tab-inverted-option3">
                    <label for="vertical-tab-inverted-option3">Faucibus</label>
                    <section class="tab-panel">
                        <h2>Faucibus</h2>
                        <p>Etiam eget malesuada lectus. Pellentesque ac mollis elit. Quisque tincidunt ex vel urna rutrum, et aliquet erat volutpat. Praesent consequat mi ac metus tempus congue in ac orci. Duis rutrum ultricies pretium. Cras fermentum elit blandit orci suscipit porta. Quisque vel ante odio. Quisque lacinia eros sit amet dui tempus fringilla at quis orci. Aliquam purus nibh, aliquet et sem id, rhoncus gravida enim. Ut maximus tortor vel tempor tincidunt.</p>
                    </section>
                </div>
                <div id="vertical-tab-inverted4" class="vertical-tab">
                    <input type="radio" name="vertical-tabs-inverted" id="vertical-tab-inverted-option4">
                    <label for="vertical-tab-inverted-option4">In mi primis</label>
                    <section class="tab-panel">
                        <h2>In mi primis</h2>
                        <p>Vivamus iaculis in erat in vulputate. Mauris hendrerit auctor ipsum, vel viverra felis suscipit in. Proin blandit ex quis ante lacinia egestas. Vivamus pulvinar lobortis ex, at efficitur quam placerat vitae. Proin aliquam placerat sapien, ut facilisis felis ultricies eget. Sed tincidunt risus nec tempus vestibulum. Suspendisse felis tortor, dictum eget magna id, faucibus suscipit lorem. Sed nisl eros, tempus non tempus in, tincidunt sed sapien. Nunc purus erat, fermentum id tortor in, imperdiet finibus tellus.</p>
                    </section>
                </div>
            </div>
        </div>
    </div>
</section>
