---
id: committer-guide
title: 项目管理体系
keywords:
- API 网关
- APISIX
- Apache APISIX
- APISIX committer 指南
description: 本文介绍了 Apache APISIX committers 的一些准则，包括贡献的类型与贡献者的晋升路线，以及贡献者如何成为 committer，进一步成为 PMC 成员。
---

本文档介绍了 Apache APISIX 贡献者的结构。

参考[贡献指南](/docs/general/contributor-guide/)以了解更多关于贡献流程的信息。

## 如何成为 Apache APISIX committer？

任何人都可以成为 Apache 项目的贡献者。成为贡献者意味着你对此项目感兴趣，并以某种方式为其做出贡献，包括从提出合理的问题（记录项目并向开发者提供反馈）到从事新功能和补丁的开发。

如果你已经成为一个项目的有价值的贡献者，你可能会被邀请成为 committer。Committer 是 Apache 软件基金会（Apache Software Foundation，简称 ASF）的一个专用术语，象征着致力于某个特定项目的人。它为你带来了对项目仓库和资源的写入权限。

更多的细节可以在[这里](https://community.apache.org/contributors/)找到。

## 晋升

Apache APISIX 社区遵循 Apache 社区接受新 committer 的流程。在贡献者积极参加 APISIX 社区的活动后，(P) PMC 成员将决定是否邀请该贡献者加入 Committers 和 (P) PMC。

1. 此过程首先在 @private 中进行讨论和投票。只有当前的 PMC 成员可以提名一个新的 committer 或 PMC 成员。讨论中的每封新邮件都将延长该过程 72 小时，所以请耐心等待结果。

2. 如果投票通过，将向贡献者发送一封邀请信，邀请其成为 committer，并注明 @private CC'ed。

3. 新的 committer 可以签署 [ICLA](https://www.apache.org/licenses/contributor-agreements.html#clas) 并申请 Apache ID 和电子邮件地址。

4. 然后可以通过 [GitBox](https://gitbox.apache.org/setup/) 将 Apache 账户和 GitHub 账户关联起来。

5. 新的 committer 需要更新[团队](/team)页面添加个人信息。

## 职责

以下是 ASF committer 的期望职责。

1. 开发新的功能。

2. 重构代码。

3. 及时可靠地 Review PR。

4. 考虑并接受功能请求。

5. 回答问题。

6. 更新文档和示例。

7. 改进流程和工具。

8. 引导新的贡献者加入社区。

## 如何成为 Apache APISIX PMC 成员？

在 APISIX 社区，获得更多成绩的 committer 可以被邀请成为项目管理委员会（Project Management Committee，简称 PMC）的一员。

Apache 社区的理念之一是“社区优于代码”。一个充满活力且持续成长的开源社区自然会受到开发者们的青睐，同时也会提供既有意思又有价值的内容。
