---
id: how-to-contribute
title: How to Contribute
keywords:
  - API gateway
  - APISIX
  - Apache APISIX
  - contributor guide
description: Guidelines for Apache APISIX contributors.
---

**• Engage with the Community • Build Connections • Earn Rewards**

Apache APISIX is an open-source project developed and maintained by a friendly community of users, contributors, committers, and project management committee (PMC) members.

Everyone is welcome to join and contribute to the project in multiple ways, not only with code contributions. Contributions like asking questions, reporting bugs, proposing new features, improving documentation, adding to the website, organizing events, or writing blog posts among other contributions, are welcome and recognized.

This document is a guide for new members of the APISIX community to get started with contributing to the projects.

### Are you new to Apache APISIX?

This [step-by-step guide](https://boburmirzo.github.io/apisix-workshop/) helps you get started with APISIX and you will learn core concepts like Route, Upstream, and Plugins in the API Gateway and try some features with examples yourself. It will also show you how to use Apache APISIX to deploy, configure, and securely publish APIs from both CLI and APISIX Dashboard.

### What are the benefits for you?

- Become a part of the world’s fastest-growing, most welcoming open-source community.

- Build your personal brand recognition and thought leadership in the API world.

- Drive innovation for connecting the world with APIs.

- Receive recognition to become a Committer or PMC member.

### Ways You Can Contribute

Here’s a list of activities you can do to get started contributing:

| CONTRIBUTION TYPE                  | HOW TO CONTRIBUTE                                                                                                                                                                                                                                                                                                                                                                    |
| :--------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Be a part of the Slack channel     | Join the [Slack channel](https://apisix.apache.org/docs/general/join/#join-the-slack-channel) to enlarge your network and help to address questions from the community.                                                                                                                                                                                                              |
| Share on Social                    | Reshare or retweet our latest [Twitter](https://twitter.com/ApacheAPISIX), [Instagram](https://www.instagram.com/apache_apisix/), or [LinkedIn](https://www.linkedin.com/company/apache-apisix/) posts                                                                                                                                                                               |
| Produce a social media publication | Share the use cases that APISIX helps empower or the data processing performance you achieved. Spread the word about the upcoming APISIX [events](https://apisix.apache.org/docs/general/events/): summits, conferences, and meetups.                                                                                                                                                |
| Participate and share ideas        | 1. Subscribe to our [mailing lists](https://apisix.apache.org/docs/general/join/#subscribe-to-the-mailing-list).<br/>2. Stay in the loop of our [Issues on GitHub](https://github.com/apache/apisix/issues), participate in discussions to brainstorm solutions, and help the community solve their mailing list questions.                                                          |
| Write a Blog                       | 1. Follow this guide while writing/updating blog posts on the Apache APISIX website.<br/>2. Submit your post on our following 3rd party posting channels.<br/> Dev.to - https://dev.to/apisix<br/>Hashnode - https://apisix.hashnode.dev/<br/>Medium - https://medium.com/apache-apisix<br/>                                                                                         |
| Create a Video                     | Record a video tutorial about Apache APISIX and publish it on our [YouTube channel](https://www.youtube.com/channel/UCgPD18cMhOg5rmPVnQhAC8g).                                                                                                                                                                                                                                       |
| Present at an APISIX meetup        | Propose a talk topic by emailing dev@apisix.apache.org and we schedule it for the next monthly meeting.                                                                                                                                                                                                                                                                              |
| Present at Another event           | 1. Once your talk is accepted, notify us dev@apisix.apache.org of the speaking date & time.<br/>2. Share the event on your social media.<br/>3. Send us a link (if recorded) to your session recording. We can help with further promotion.                                                                                                                                          |
| Organize an event                  | Send an email to dev@apisix.apache.org to share your idea about the APISIX event you want to organize. We are looking for local community organizers who will help us grow our APISIX community                                                                                                                                                                                      |
| File a bug                         | Create a [GitHub issue](https://github.com/apache/apisix/issues) and mark it as a bug<br/>OR<br/>Send an email to dev@apisix.apache.org with the subject: [Bug] <bug summary\> and include as much detail as possible.                                                                                                                                                               |
| Propose a feature                  | Create a [GitHub issue](https://github.com/apache/apisix/issues) and mark it as a bug<br/>OR<br/>Send an email to dev@apisix.apache.org with the subject: [Feature Proposal] <your idea\>.                                                                                                                                                                                           |
| Fix an open issue                  | To start, you can go through this [curated list of "good first issues"](https://apisix.apache.org/contribute/).<br/>Fix issues tagged with "[good first issue](https://apisix.apache.org/docs/general/contributor-guide/#good-first-issues)" or "[help wanted](https://github.com/apache/apisix/issues?q=is%3Aopen+label%3A%22help+wanted%22+sort%3Aupdated-desc)" labels on GitHub. |
| Improve documentation              | Find the documentation on the [Apache APISIX](https://apisix.apache.org/) website you would like to update/improve, follow the [documentation style guide](https://apisix.apache.org/docs/general/documentation-style-guide/) and [submit a new Pull request](https://apisix.apache.org/docs/general/contributor-guide/#open-a-pull-request) with a semantic doc.                    |
| Help Prepare/Test a Release        | Anybody can propose a release via the dev@apisix.apache.org mailing list. Try Apache APISIX releases in your projects, vote for release candidates, and inform the community about the results and any issues found via ev@apisix.apache.org. Learn more about the Apache APISIX [release guide](https://apisix.apache.org/docs/general/release-guide/).                             |
| Other ideas?                       | If you want to contribute in another way and you’re not sure how to get started, send a proposal to dev@apisix.apache.org                                                                                                                                                                                                                                                            |

Have you already contributed to some of the above activities during the last 2 months?
Please, claim your [Recognition of Valuable Contribution](https://docs.google.com/forms/d/e/1FAIpQLSeulo9oMf7PIsSeJwPnlZwNdPiWqPN_VgoCSd8cd8g9n8JmRg/viewform) Certification from the Apache APISIX PMC Chair.

![Certification Apache APISIX](https://static.apiseven.com/uploads/2023/02/09/5ZjlxCPK_Certificate111.psd.png)

## Become a Committer

If you become a valuable contributor to the project you may be invited to become a Committer. A Committer is a term used at the [ASF](https://www.apache.org/) to mean someone who is committed to a particular project.

Committers are community members that have a write access to the project’s repositories (i.e., they can modify the code, documentation, and website by themselves and also assist with code reviews and accept other contributions).

Learn more about how to [become an Apache APISIX committer](https://apisix.apache.org/docs/general/committer-guide/#how-do-i-become-an-apache-apisix-committer).

Are you already contributing actively last 6 months?

Please, claim to become a Committer here.

## Become a Project Management Committee (PMC) Member

The PMC is the official managing body of the project as per the Apache Software Foundation governance model: “The Apache Way”. PMC members vote to set Apache Apisix’s community and technical direction and are directly responsible for overseeing releases and the healthy development of the community.

PMC members are also responsible for ensuring their project follows certain core requirements set by the board or other corporate officers of the ASF, like following Legal, Branding, and Infrastructure related requirements, along with ensuring their community operates within the [ASF Code of Conduct](https://www.apache.org/foundation/policies/conduct#code-of-conduct).

A PMC member is also a committer, so if they are not initiated already, they will automatically become committers when joining the PMC. Therefore, the traits of Apache APISIX committers also apply to PMC members.

Learn more about how to [become an Apache APISIX PMC member](https://apisix.apache.org/docs/general/committer-guide/#how-do-i-become-an-apache-apisix-pmc-member).
