---
id: committer-guide
title: Project management structure
keywords:
- API gateway
- APISIX
- Apache APISIX
- committer guide
description: This article covers some guidelines for Apache APISIX committers. It walks through the type of contributions and the contributor ladder and how contributors can become committers and then PMC members.
---

This document walks through how Apache APISIX contributors are structured.

See [Contributing flow](/docs/general/contributor-guide/) to learn more about the contributing process.

## How do I become an Apache APISIX committer?

Anyone can be a contributor to an Apache project. Being a contributor means that you take an interest in the project and contribute to it in some way, ranging from asking sensible questions (which documents the project and provides feedback to developers) to working on new features and patches.

If you become a valuable contributor to the project you may be invited to become a Committer. A Committer is a term used at the ASF to signify someone who is committed to a particular project. It brings with it the privilege of write access to the project repository and resources.

More details could be found [here](https://community.apache.org/contributors/).

## Promotion

The Apache APISIX community follows the Apache Community’s process of accepting a new committer. After a contributor participates in APISIX's community actively, (P) PMC members will decide whether to invite the contributor to join Committers and (P) PMC.

1. This process starts with a discussion and vote in @private. Only the current PMC members can nominate a new committer or a PMC member. Each new email in the discussion will extend the process for 72 hours. Please remain patient as PMC members arrive at a decision.

2. If the vote passes, an offer letter is sent to the contributor to become a committer with @private CC’ed.

3. The new committer can then sign the [ICLA](https://www.apache.org/licenses/contributor-agreements.html#clas) and apply for an Apache ID and email address.

4. You can now link your Apache account and your GitHub account via [GitBox](https://gitbox.apache.org/setup/).

5. The [Team](/team) page is updated with the new committer.

## Responsibilities

The following are the expected responsibilities of an ASF Committer.

1. Develop new features.

2. Refactor code.

3. Review pull requests reliably and in time.

4. Consider and accept feature requests.

5. Answer questions.

6. Update documentation and examples.

7. Improve processes and tools.

8. Guide new contributors to join the community.

## How do I become an Apache APISIX PMC member?

In APISIX community, a committer who has earned even more merits can be invited to be a part of the Project Management Committee (PMC).

One thing that is sometimes hard to understand when you are new to the open development process used at the ASF, is that we value the community more than the code. A strong and healthy community will be respectful and be a fun and rewarding place. More importantly, a diverse and healthy community can continue to support the code over the longer term, even as individual companies come and go from the field.
