---
id: code-samples
title: Code samples
keywords:
  - API gateway
  - Code samples
  - Example projects
  - Source code
description: Apache APISIX code samples and projects.
---

**Welcome to Apache APISIX Code Samples!**

Our Code Samples is your go-to resource for exploring the full potential of Apache APISIX, boosting your understanding of our platform's features, and accelerating your API development.

In our collection, you'll find a diverse range of code samples, including exposing new APIs, handling API calls, securing, and observing your APIs with Apache APISIX, and many more.

Now, feel free to dive in! Whether you're a beginner in need of a jumpstart or an experienced developer seeking more efficient solutions, our Code Samples are here to empower you on your journey. And if you ever get stuck or need further assistance, our [community of developers](https://join.slack.com/t/the-asf/shared_invite/zt-vlfbf7ch-HkbNHiU_uDlcH_RvaHv9gQ) is always here to help. Happy coding!

| Title | Description | Source code | Tutorial | Category | Level | Language |
| --- | --- | --- | --- | --- | --- | --- |
| Hands-on lab Apache APISIX | It shows a couple of nifty features that can help your information system cope with the challenges introduced by APIs | [APISIX Workshop for beginner](https://github.com/Boburmirzo/apisix-workshop) | [Hands-on lab reference](https://boburmirzo.github.io/apisix-workshop/) | Authentication, Security, Serverless, Observability, Transformation | Beginner | Shell |
| How to create a File-proxy custom plugin in Lua | Learn to develop a new plugin that exposes the static files through API and fetches a file from a specified URL. | [APISIX File Proxy Plugin Demo](https://github.com/Boburmirzo/apisix-file-proxy-plugin-demo) | [Custom Plugin Development With ChatGPT](https://api7.ai/blog/plugin-development-with-lua-and-chatgpt) | Custom plugin, File proxy | Intermediate | Lua, Yaml |
| Managing AI-powered Java App with API Management | It demonstrates how to use OpenAI ChatGPT APIs in Spring Boot, secure and manage the traffic with Apache APISIX | [APISIX Java OpenAI API Management](https://github.com/Boburmirzo/apisix-java-chatgpt-openaiapi) | [Managing AI powered Java app with APISIX](https://api7.ai/blog/managing-ai-powered-java-apps) | Security, Authentication, JWT plugin, Consumers | Intermediate | Java, Yaml |
| Manage .NET-based APIs with Apache APISIX API Gateway | This is an example project focused on the usage of APISIX for applications developed in [ASP .NET Core 6](https://docs.microsoft.com/en-us/aspnet/core/?view=aspnetcore-6.0) | [APISIX .NET Docker example](https://github.com/Boburmirzo/apisix-dotnet-docker) | [Manage .NET microservices APIs with APISIX](https://dev.to/apisix/manage-net-microservices-apis-with-apache-apisix-api-gateway-2cbk) | Security, Authentication, Rate Limiting, Caching | Beginner | C#, Yaml |
| Chaining API requests with API Gateway | Learn how to create a custom plugin for APISIX API Gateway to handle client requests that should be called in sequence. | [APISIX Request Pipeline Plugin demo](https://github.com/Boburmirzo/apisix-plugin-pipeline-request-demo) | [Chaining API requests with APISIX](https://api7.ai/blog/chaining-api-requests-with-api-gateway) | Custom plugin, Serverless, Request Chaining | Intermediate | Lua, Shell |
| Manage OpenAI APIs with Apache APISIX | Manages the OpenAI API traffic by creating a route, upstream and enabling some plugins. | [APISIX OpenAI API demo](https://github.com/Boburmirzo/apisix-open-ai-api) | [Powering AI capabilities with APISIX](https://api7.ai/blog/power-ai-capabilities-with-apache-apisix) | AI, Traffic control, Consumer, Rate-limiting, Prometheus, API versioning, Traffic split | Beginner | Shell, Yaml |
| Dynamic routing based on JWT Claim with Apache APISIX and Okta | Explore the benefits of adopting dynamic routing based on authentication attributes | [Dynamic routing with APISIX](https://github.com/Boburmirzo/dynamic-routing-with-apisix) | [Dynamic routing with APISIX blog post](https://api7.ai/blog/dynamic-routing-based-on-user-credentials) | Dynamic routing, JWT, Authentication, Consumer management | Advanced | Shell, Yaml |
| Manage serverless APIs with Apache APISIX and Azure Functions | A simple example of how to manage Java-based serverless APIs built with Azure functions. | [Manage serverless APIs with APISIX demo](https://github.com/Boburmirzo/apisix-manage-serverless-apis) | [Manage serverless APIs with APISIX](https://api7.ai/blog/manage-serverless-apis-with-apache-apisix) | Serverless, Basic auth, Rate-limiting, Traffic management | Intermediate | Java, Shell |
| Manage API Consumers | Explains how to manage your single or multiple API consumers with Apache APISIX. | [API consumers management with APISIX demo](https://github.com/Boburmirzo/apisix-api-consumers-management) | [Manage API consumers blog post](https://apisix.apache.org/docs/apisix/tutorials/manage-api-consumers/) | API consumers, Rate-limiting, Consumer groups | Beginner | Shell |
| Secure APIs with Apache APISIX API Gateway | How to use APISIX Plugins for securing your [Spring Boot REST APIs](https://spring.io/guides/tutorials/rest/s) and it demonstrates how to effectively use them. | [APISIX plugins for Spring Boot Apps demo](https://github.com/Boburmirzo/apisix-plugin-spring-rest-demo) | [APISIX plugins to secure Spring Boot REST APIs blog post](https://dev.to/apisix/secure-spring-boot-rest-api-with-apache-apisix-api-gateway-1nmg) | Security, Authorization, Authentication, Monitoring | Beginner | Java |
| An API observability with Apache APISIX Plugins Example | Learn observing your APIs with Apache APISIX plugins | [APISIX observability plugins demo](https://github.com/Boburmirzo/apisix-observability-plugins) | [Observability plugins usage tutorial](https://boburmirzo.github.io/apisix-observability-plugins/) | Observability, Traces, Metrics, Logs | Beginner | Shell |
| End-to-end tracing with OpenTelemetry | Use OpenTelemetry and APISIX to start your journey into observability | [Open Telemetry tracing with APISIX demo](https://github.com/nfrankel/opentelemetry-tracing) | [Open Telemetry tracing tutorial](https://blog.frankel.ch/end-to-end-tracing-opentelemetry/) | Observability, Traces, OpenTelemetry | Intermediate | Kotlin, Python, Rust |
| Chopping the monolith | Extract HTTP endpoints from the monolith and gradually migrate to microservices using API Gateway | [Chopping monolith demo](https://github.com/nfrankel/chop-monolith) | [Chopping monolith tutorial](https://blog.frankel.ch/chopping-monolith/) | Azure function, Response-rewrite | Beginner | Kotlin, JavaScript, HTML, Shell |
| Evolving your RESTful APIs, a step-by-step approach | Use API Gateway to evolve APIs step by step by versioning, splitting the traffic, doing canary releases, and more. | [Evolve APIs demo](https://github.com/nfrankel/evolve-apis) | [Evolve APIs blog post](https://blog.frankel.ch/evolve-apis/) | Proxy rewrite, Proxy mirror, Traffic split, Response rewrite, Redirect | Intermediate | Kotlin, Lua, Java |
| Discussing Backend For Front-end | Use API Gateway to build Backend For Frontend solution. | [Backend for front-end demo](https://github.com/nfrankel/backend-for-frontend) | [Backend for front-end blog post](https://blog.frankel.ch/backend-for-frontend/) | Public endpoint, Proxy-rewrite, Routing | Beginner | Python, Lua |
| Getting Hands-On with the New Kubernetes Gateway API | Tutorial about using the Gateway API in practice with Apache APISIX Ingress. | [Getting Hands-On with the New Kubernetes Gateway API demo](https://github.com/navendu-pottekkat/gateway-api) | [Getting Hands-On with the New Kubernetes Gateway API tutorial](https://navendu.me/posts/kubernetes-gateway-with-apisix/) | Ingress, Kubernetes, Routing | Beginner | Shell |
| Custom Plugins in APISIX Ingress | Learn how to create and use a small custom Plugin with APISIX deployed in Kubernetes. | [Custom plugin development for APISIX Ingress demo](https://github.com/navendu-pottekkat/apisix-in-kubernetes/tree/master/custom-plugin) | [Custom plugin development for APISIX Ingress blog post](https://navendu.me/posts/custom-plugins-in-apisix-ingress/) | Custom plugins, Ingress, Kubernetes | Intermediate | Lua |
| Canary Release in Kubernetes With Apache APISIX Ingress | Guide on setting up a canary release in Kubernetes using [APISIX Ingress Controller](https://apisix.apache.org/docs/ingress-controller/next/getting-started/). | [Canary release in Kubernetes with APISIX demo](https://github.com/navendu-pottekkat/apisix-in-kubernetes/tree/master) | [Canary release in Kubernetes with APISIX blog post](https://navendu.me/posts/canary-in-kubernetes/) | Ingress, Kubernetes, Canary release | Intermediate | Lua |
| An Introduction to Monitoring Microservices with Prometheus and Grafana | Instruction on how you can set up monitoring on your microservice application using two of the popular tools in this space, [Prometheus](https://prometheus.io/), and [Grafana](https://grafana.com/). | [Monitoring microservices demo](https://github.com/navendu-pottekkat/monitoring-101) | [Intro to monitoring microservices APIs with APISIX blog post](https://navendu.me/posts/introduction-to-monitoring-microservices/) | Observability, Prometheus, Grafana | Intermediate | Go, Python |
| Monitor API Health Check with APISIX and Prometheus | This example demonstrates how to enable and monitor API health checks using APISIX and Prometheus. | [Monitor API Health Check with APISIX and Prometheus demo](https://github.com/Boburmirzo/apisix-prometheus-api-health-check) | [Prometheus Plugin Demo](https://docs.api7.ai/apisix/how-to-guide/observability/monitor-apisix-with-prometheus) | Observability, Prometheus, Grafana | Intermediate | Go, Python |
