---
title: "借力 APISIX 的高可用，实现企业亿级流量"
authors:
  - name: 王院生
    title: Author
    url: https://github.com/membphis
    image_url: https://github.com/membphis.png
  - name: Yilia Lin
    title: Technical Writer
    url: https://github.com/Yilialinn
    image_url: https://github.com/Yilialinn.png
keywords:
  - 开源社区
  - API 网关
  - Apache APISIX
  - 支流科技
  - API7
description: 本文整理自 2023 年 11 月王院生在 APISIX 上海 Meetup 的演讲。
tags: [Case Studies]
image: https://static.apiseven.com/uploads/2023/03/02/aweIgc5n_%E4%BF%A1%E6%81%AF%E6%8A%80%E6%9C%AF%20%284%29.png
---

> 作者：王院生，支流科技联合创始人兼 CTO，Apache APISIX PMC 成员，《Apache APISIX 实战》作者。本文整理自 2023 年 11 月王院生在 APISIX 上海 Meetup 的演讲。
<!--truncate-->

## 支流科技简介

支流科技是一家成立于 2019 年的 API 全生命周期管理公司，致力于提供全面高效的 API 设计、API 开发、API 门户、API 货币化解决方案，服务对象包括 Zoom、爱奇艺、WPS、vivo、OPPO、Airwallex 等众多全球客户。我们曾开源并向 Apache 软件基金会捐赠了 API 网关 APISIX，如今 Apache APISIX 成为了 GitHub 上最活跃的 API 网关项目之一。目前，APISIX 每天处理超过 1 万亿次 API 调用，深受世界各国各行业的用户信赖。

在 Apache APISIX 基础之上，支流科技提供 API7 企业版及 API7 门户等企业级产品，满足企业用户的核心需求，包括多集群管理、多工作分区、权限管理、版本管理、审计、统计报表等企业级功能。支流科技在亚太地区 API 管理市场排名第一，被评为 2022 年 Gartner API 网关市场指南代表供应商，并荣获了 2022 年红鲱鱼全球百强奖项。

## 为什么高可用对企业 API 如此重要

首先，让我们探讨 API 的重要性。简而言之，在数字世界中，API 实际上扮演着交通工具的角色。就像在现实生活中，如果没有车辆、道路、轮船和飞机，我们将无法正常生活。而 API 实际上就是数字世界的交通工具，其重要性不言而喻。

![Importance of API](https://static.apiseven.com/uploads/2023/12/15/ZKCGwMQG_img_v3_0265_ee1b4bad-ffc4-4fcc-95c1-79b12358780g.jpg)

### API 管理核心“三高”

在了解了 API 的重要性之后，再依据重要性排序来了解 API 管理的核心“三高”，即高安全性、高可用性和高性能。

- **高安全**：安全性是 API 网关产品最重要的基本要求之一。如果一款 API 网关产品在安全方面存在问题，那么无论它在其他方面表现得多么出色，用户也无法选择它。安全性不仅依赖于产品本身，也与其周边生态息息相关。

- **高可用**：高可用性的主要目的是为了保障业务的连续性。API 网关的高可用性是指 API 网关能够在面临故障或者异常情况时，仍然能够提供服务的能力。这通常通过冗余和负载均衡等技术来实现。冗余是指部署多个API网关实例，以防止单点故障。负载均衡则是通过将请求分发到多个 API 网关实例，以确保每个实例的负载都保持在可接受的范围内，从而提高整体的服务质量和可靠性。

- **高性能**：与前两个因素相比，高性能并非影响用户选择的关键因素，更像额外加分项。性能优异的 API 网关，同等资源配置能够提供更大业务吞吐量，从而提升系统整体稳定性或降本增效。

![Importance of high availability](https://static.apiseven.com/uploads/2023/12/15/YQBEykJ1_img_v3_0265_f82609c6-a9f7-4c60-8d28-1e9baa036aag.jpg)

### API 网关的重要性：内外网间的隔离屏障

API 网关位于内部网络和外部网络之间，充当了两者之间的隔离屏障。在上图中，API 网关需要能够接收来自包括人员、机器和车辆等不同终端设备的请求。所有这些请求，既有合法请求，也有非法请求，众多黑客都在外面各种尝试获取企业敏感数据。API 网关的重要安全职责就是流量清洗，把这万分之一甚至亿分之一的恶意请求识别并拦截，保护内部服务和数据。

#### 私网安全威胁甚于公网

在中国许多企业高度重视内网、外网的隔离位置的安全，内部会采用私有机房、私有云以及专线等配套设施。正因为有了这层网络隔离，企业用户降低内网安全要求。

我在 2006 年亲身经历了“熊猫烧香”事件，它在局域网内自我传播。比较庆幸的是它当时只感染 Windows 电脑，内部网络中的 Linux 服务器没受影响。不少企业内部还在使用类似“裸奔”的方式，即内部服务直接调用，比如明文 HTTP 请求、无身份认证、无访问权限控制、限流限速等等。

#### 逃生机制的重要性

API 流量网关所处的位置通常涵盖三个安全产品线：DDoS 流量清洗、Web 应用防火墙（WAF）和 API 安全解决方案。以大家所熟知的 WAF 产品为例，一个请求是否有威胁的判断逻辑，通常这个时间必须要低于 50~100 毫秒内。超过此阈值，调用方将认为 WAF 服务不可用跳过 WAF，这就是逃生的安全策略。

以 WAF 为代表的所有 API 安全产品，都应当具备一定的逃生机制，无论是私有 WAF 又或是云上 WAF 产品，这是基础要求，避免系统可用性被安全产品限制。

## 高可用指标及常见  API 网关部署架构

### 企业服务主流部署架构

企业服务部署架构有四种：纯私有云、多云、混合云和单朵云。其中单朵云只占不到 5%，而剩余 95% 的企业都选择前三种部署方式。单朵云的部署架构是由单一云服务提供商提供的部署架构，用户只需使用云服务提供商解决方案即可。这类用户体量通常不大，服务简单，无需过多关注架构的细节。

而纯私有云、多云、混合云这三种架构类型在全球企业中占据了绝对主导地位。在这三种不同部署架构下，企业用户都需要一个可以云中立、允许二次扩展的 API 网关产品。云产品因为不能部署到其他云服务或私有云，所以优先被排除。

#### API 网关要求：云中立、允许二次扩展、“三高”

云中立指的是软件具备在不同的云平台上运行的能力，甚至可以在不同虚拟机上使用，也可以称之为全平台运行。网关支持二次开发是一个重要因素，几乎所有企业在 API 网关位置有或多或少的自定义需求，比如个性化监控、告警、安全策略等，这是诸多企业选择 APISIX 的重要因素。最后，高安全性、稳定性和可用性是非常重要的指标。

![Popular deployment architectures](https://static.apiseven.com/uploads/2023/12/15/GdcfxEBy_img_v3_0265_bf87a395-d06e-4ce9-9185-4c3b506e97ag.jpg)

上图展示了不同的高可用性指标及其出现故障的时间。可用性为“99%” 的情况下，每天可以有 14 分钟的停机时间，即使出现问题第二天处理也来得及，毕竟服务不可能每天都出问题。“99.9999%” 这种情况比较罕见，越高的可用性意味着企业需要承担越昂贵的部署成本。企业服务可用性通常选择 99.9%、99.99%或99.999%，今天我们重点聊聊这几种高可用架构。

### 无状态服务横向扩展系统能力

有状态服务和无状态服务的主要区别在于两个来自相同发起者的请求在服务器端是否具备上下文关系。

**有状态服务**

- 服务器端一般都要保存请求的相关信息，每个请求可以默认地使用以前的请求信息。
- 有状态服务常常用于实现事务¹。例如，在商城里购买一件商品需要经过放入购物车、确认订单、付款等多个步骤。
- 有状态服务可以比较容易地实现事务，在不需要考虑水平扩展时，是比较好的选择。

**无状态服务**

- 服务器端所能够处理的过程必须全部来自于请求所携带的信息，以及其他服务器端自身所保存的、并且可以被所有请求所使用的公共信息。
- 服务要设计为无状态的，这主要是从可伸缩性来考虑的。如果server是无状态的，那么对于客户端来说，就可以将请求发送到任意一台server上，然后就可以通过负载均衡等手段，实现水平扩展。
- 无状态服务的优势在于可以很方便地水平伸缩，但是在实现事务时，需要做一些额外的动作。

总的来说，有状态服务和无状态服务各有优势，选择哪种服务取决于具体的应用场景和需求。近年来，随着信息数量暴增，后端服务架构越来越复杂，企业应尽量减少有状态服务的数量，这可以极大简化软件架构，并提升系统弹性扩缩容能力。更容易理解一些，状态最好只存在于数据库、MQ 等基础服务组件。

### 常见高可用部署架构

在互联网行业中，不涉及支付的业务通常采用“99.9%”或“99.99%”的高可用性水平。例如我们日常浏览的视频、购物、评论等。

部署“99.9%”的可用性相对简单，只需要建立好主、备数据库，确保数据库之间有一个良好的主备关系并能够切换。这个过程可以自动化更好，即使不通过自动化的形式，在出现故障时也有足够的时间进行人工干预处理也可接受，该种部署方式成本较低且相对简单。

“99.9%”和“99.99%”之间唯一的区别在于“99.9%”是单机房，而“99.99%”是双机房，并且机房之间可以交叉访问。这样即使出现单机房故障，也不影响业务正常服务。

![High availability of 99.9% & 99.99%](https://static.apiseven.com/uploads/2023/12/15/dNwgm5Zl_img_v3_0265_f9df3e70-9e6f-4021-96ea-aed3a29a002g.jpg)

下图描述的是高可用性为“99.999%”的“两地三中心”部署架构。图中展示的左侧是华东，右侧是华南，总共有三个中心，分别是可用区 A、B 和 C。图中的 LB、外部服务和应用服务都没有状态，只有 RDS Master 是有状态的。这种架构要求数据库实现三主多活。左侧的服务可以通过在负载均衡器（LB）、网关和服务层之间进行交叉调度，实现不同中心之间的负载均衡。只有应用程序符合无状态的要求，才能轻松地实现高可用性。

![High availability of 99.999%](https://static.apiseven.com/uploads/2023/12/15/5mWc2kxZ_img_v3_0265_3af5959b-57c2-4237-9bad-808795d7ecbg.jpg)

更多内容可查看文章：[《搞懂异地多活，看这篇就够了》](http://kaito-kidd.com/2021/10/15/what-is-the-multi-site-high-availability-design/)。

## 高可用架构认知盲区

### 高可用架构，从计算机诞生起一直在迭代

高可用架构并非是最近才出现的，实际上，从计算机诞生的那一天起，它就已经存在了。在没有 DNS 的时代是直接通过 IP 进行访问的。后来人们意识到必须解决单点问题，即一台机器发生故障后需要有应对措施，以免整个互联网崩溃。因此，在设计互联网时，人们逐步引入了对应解决方案，就是 DNS。

高可用在业务本质上没有为系统增添任何新功能，它只是为了确保投资回报的可能性。但无论是最早的传统单一大应用还是现在，高可用一直都是标配，只是实现方式略有差异。

以前要实现高可用性，意味着需要购买昂贵的小型机器或专用的硬件设备，成本非常高，并且定制能力差。谷歌在早期也遇到了这些问题，他们通过统一管理廉价服务器，最终实现了专用硬件的效果，最终看到了分布式数据库、K8s 这样的解决方案。

### 高可用架构，只能解决架构部分

高可用架构提供的只是架构方面的解决方案，单纯依靠高可用方案提升整个系统可用性是不切实际的。架构之外的问题仍然需要工程师亲自去提升，比如前面提到的 WAF、DDoS 逃生，企业应用自身的稳定性等。一般来讲，企业应用自身的可用性要比公司最终可用性目标高一个数量级。

### 高可用与安全一样，均是全方位立体“防护”

安全性不仅仅是 API 网关的问题，不能只看单个点，而应该从整个 API 体系的角度，全面考虑与 API 网关相关的因素。首先要关注自身，然后再考虑外部因素，最后梳理整体部署架构，避免盲区。从内部而言，可以考虑以下几个方面：

- **通过软件工程规范，拉高质量下限**：先确保自身的高可用与安全，必须通过软件工程的方法，提升自身服务及其相关服务的质量；再认真进行测试和灰度；企业应建立完善的研发、上线流程。

- **如果是非必要流程，考虑建立逃生机制**：WAF 和 DDoS 都是可插拔的，可以根据需求加入或移除它们。对于外部服务，一定要严肃对待异常流程，最好最坏打算。

- **依赖服务均需支持高可用，比如  LB、DNS 服务等**：务必对依赖服务进行排查，比如负载均衡（LB）和域名系统（DNS）。特别是对于 DNS，必须提供备用选项，去除单点依赖。

- **变量因子需支持回滚机制，比如服务发现等**：管理服务最好能支持回滚操作，及时取消错误操作。开源 APISIX，没有直接提供回滚 API，是因为 etcd 本身有 version 历史记录，可以借用这个特性随时回滚。API7 企业版（基于 APISIX 的商业 API 网关解决方案）对此特性做了产品化实现，只需在界面上点击按钮即可一键回滚。

## APISIX 与 API7 企业版高可用最佳实践

开源 APISIX 和 API7 企业版的高可用解决方案略有不同。开源方案的设计初衷是尽量保持无状态，以便进行横向扩展、缩容和高可用性的调整。无论某单个控制面或数据面发生故障，都不会影响整个网关系统的运行。

### 开源方案 APISIX

开源方案的早期 0.* 版本存在一些错误和崩溃，但这并没有影响其发展。正是因为 APISIX 本身是无状态的，非常容易支持高可用性。生产环境使用 APISIX，实现高可用性只需专注于 etcd 高可用性即可。而 etcd 的高可用性，官网有非常完整的描述，与传统关系型数据库相比，etcd 高可用方案可以说简单至极。

![APISIX adopts etcd](https://static.apiseven.com/uploads/2023/12/15/eAz7Qm7X_img_v3_0265_8d146483-702f-4ebf-83c4-25f761cb81dg.jpg)

### 商业方案 API7 企业版

为了满足国家信创要求，并兼顾商业公司成本和风险，API7 企业版最终还是选择了关系型数据库作为配置存储。同时为了保持与开源方案的兼容性，API7 企业版数据面仍然使用 etcd 通信协议，它通过引入一个新的服务，将数据库中的配置翻译成 etcd 通信协议，从而完成配置分发。

![APISIX vs API7](https://static.apiseven.com/uploads/2024/01/03/vRe5zylN_20240103-091409.jpeg)

## 总结

API 在数字世界中扮演着交通工具的角色，它连接着不同的系统和服务，实现数据和功能的交互。同时，API 也作为内外网之间的隔离屏障，确保系统的安全性。

APISIX 和 API7 企业版作为 API 网关产品，保证高性能基础上，提供极佳的高可用性和高安全性能力，为企业构建稳定、高效和安全的 API 管理系统提供更好解决方案。有效管理和优化 API，助力企业提升业务创新能力和竞争力，为终端用户提供更卓越数字化服务体验。

欢迎访问我们商业公司的网站，了解更多关于 API 的用户案例和信息：[https://www.apiseven.com/blog](https://www.apiseven.com/blog)。
