---
title: "政采云 APISIX 优化跨网 RPC 性能实践"
authors:
  - name: 王晓彬
    title: Author
    url: https://github.com/wxbty
    image_url: https://github.com/wxbty.png
  - name: Jing Yan
    title: Technical Writer
    url: https://github.com/JYan00
    image_url: https://github.com/JYan00.png
keywords:
  - 开源社区
  - API 网关
  - Apache APISIX
  - 政采云
description: 政采云借力 APISIX 显著提升了网关性能，减少了协议转换的成本，并实现了中间件层面的收敛。
tags: [Case Studies]
image: https://static.apiseven.com/uploads/2023/12/08/XDJDiILW_Zheng.jpeg
---

> 作者：王晓彬，Apache Dubbo Commiter、政采云资深开发工程师。
<!--truncate-->

为解决数据跨网问题，政采云搭建了一条基于 Dubbo 的“高速公路”，同时采用了 APISIX 作为中心网关，为网络路由、公共特性提供支持。本文将重点介绍政采云“高速公路”工程建设中如何优化网关和协议的性能以应对挑战。

## 背景介绍

政采云平台是一个政府采购专属平台，为各级政府部门和国有企业提供支持。从网络架构的角度来看，政采云平台是一个集合了公有云、私有云和政务云的混合云网络。

![Zhengcaiyun_platform](https://static.apiseven.com/uploads/2023/12/08/ngOYh85r_ZCY-1.png)

例如，浙江政府部门在政采云平台上进行采购时，实际上是在云平台上进行操作。该云平台是部署在浙江的一个微服务网络体系，是公司自行部署和运维的平台。除了浙江，还有广西等六七个地区都在云平台上进行采购。

此外，我们还会为一些分支机构提供服务，例如设立在各个省份的分公司。这些分公司可能有着各自的需求，根据不同省份的行政区划，在当地环境部署同一套微服务框架。同时，一些其他非区划机构，如银行、军队等可能也会选择私有部署。

以上的这些微服务，就构成了混合云网络的一部分。所以对于业务来说，跨网数据传输是一个常见的需求场景。

为了满足这种需求，政采云“高速公路”工程于 2022 年底启动，旨在整合现有的网络传输方案，提供一致、便捷和高速的跨网业务体验。随着跨网方案整合的推进，公司的跨网流量越来越多地流向了新型基础设施——政采云“高速公路”工程。

## “高速公路”工程

“高速公路”工程一共分为三个阶段。第一阶段是基于 Dubbo 的“高速公路”工程落地；第二阶段则将之前的一些方案整合到新方案中；第三阶段将解决前两个阶段产生的问题，并进行进一步的优化。

第一阶段基于 Dubbo 构建了一个新型的架构，其中心是 APISIX。每个节点代表一个岛端，即不同的省或其他区划。云平台其实也是一个特殊的岛端，我们的平台会涉及多个岛端，形成一个混合云网络。

![Highway_structure1](https://static.apiseven.com/uploads/2023/12/08/vyV7DBH3_ZCY-2.png)

为什么要采用这个星型的网络架构呢？因为跨网的需求从一开始就存在，在政采云创立初期，业务就会点对点跨网传输数据，然后逐渐形成了网状架构。我们之前有多个与跨网相关的项目或方案，有基础平台提供的，也有业务自行开发的。“高速公路”项目的目的，是将它们整合在一起，提供统一的技术底座，降低各自运维和跑各种流程的成本，让业务方能聚焦在自己的业务上，也能集成更多的公共特性。一方面，如果每个业务都自己开发，在功能上会有一些限制，因为各业务线只关注于各自特定的领域；另一方面，如果将业务开放供他人使用，又可能会面临多种问题，比如需要支持定制本业务线不关心的特性。

“高速公路”的星型架构也是整合的结果。在之前的网状结构中，每个岛段之间的互联需要经过一系列流程。比如，我们需要和山西和上海这两个省份的运维沟通交流，让他们开一些端口，基于他们的端口进行服务部署后，再实现网络交互。这样一来，网状结构的线很多，也很复杂。如果一共有 n 个岛，可能就有 n 个平方的线。而这个星型架构的好处在于它简洁，相较于之前的网状结构，避免了两两互联的复杂性。

## 挑战

“高速公路”方案得到了公司的大力支持，在 2023 年上半年通过新业务的试点后，下半年开始陆续迁移历史跨网方案的业务。从监控中，我们感受到了来自流量的压力。具体表现为：

* **心跳应用告警频繁发生**：我们在每个路段都部署了一个心跳应用，以确保高速公路的稳定性。这个应用是通用的，负责网络互通，一旦出现问题就会触发告警。举例来说，如果在某个时间段内请求变得缓慢，一次请求超过 1 秒，我们就会收到告警，从而意识到存在问题。而在监控中，心跳应用告警频繁发生。

* **监控指标如响应时间（RT）和吞吐量下降**：我们还使用了 Prometheus 的格式化界面 BRAF。在该界面上，一些关于响应量和吞吐量的曲线明显有下降的趋势。

这两个方面的压力随着我们历史方案切入“高速公路”后，随着流量的增加而逐渐显现。

为了确保业务的稳定性并提高用户体验，我们采取了各种优化措施。总体而言，我们主要探索了三种思路：

![Optimization_solutions](https://static.apiseven.com/uploads/2023/12/08/5vj9xKBr_ZCY-3.png)

* **资源优化**：这种优化思路相对较简单，主要涉及资源的重新调配。具体措施包括对单点的中心网关和 Dubbo 网关进行资源隔离，以最小化故障对系统的影响。此外，通过直接增加 pod 、升级 CPU 等方式，也能有效缓解压力。这样可以确保在资源方面有足够的储备，以满足系统在高负载情况下的需求。然而，这种方法并不能从根本上解决问题，因为如果架构存在短板，某些资源上做不到能水平扩展，那么在一定条件下就会出现故障，有可能不能在短时间内解决。

* **性能优化**：这一思路需要在架构层面进行深入优化，以尽可能填补木桶模型的短板。这是非常重要的，因为只有通过性能的最大化利用，才能实现系统的水平扩展。

* **最佳实践引导**：每个框架都有一些缺陷或不合适的地方，我们需要引导用户，避免一些可能引起问题的操作。如果用户执意采取某些操作，我们也需要给出合理的建议。例如，基于跨网的 Dubbo 框架默认支持大流量但小请求的并发，基于 Dubbo 的高速公路也有相同的特性。如果用户基于 Dubbo 传输大文件，可能会给我们造成较大的压力，因此我们需要给出建议，让他们用其他的方法去传输。

综合考虑这几种思路，我们在资源准备充足的同时，通过性能优化，确保系统的稳定性和高可用性，并引导用户进行合理操作。

## 问题与目标

### RPC 请求过程

![Highway_structure2](https://static.apiseven.com/uploads/2023/12/08/9z9QAsg5_ZCY-4.png)

在我们的架构中，例如在 A 省和 B 省之间，需要进行跨网的 RPC 请求。这一请求可能涉及不同省份的微服务架构。每个省份的微服务架构事实上是相同的一套代码，无论是在集群 A 还是集群 B 中，都有 APP1 和 APP2。区别在于，某些岛可能不需要 APP2，比如文件服务在三线城市是不需要的，因此不予部署。在存在跨网需求的情况下，例如需要调用短信服务，那么 APP2 就是必需的。

在 APP1 调用 APP2 时，如果没有路由信息的正常情况下，通常会是本地集群的调用。但是，我们在 APP1 中引入了“高速公路”的 SDK，该 SDK 允许 APP1 在 Dubbo 调用时携带路由信息，而这些路由信息可能有多种方式。因此，我们可以指定请求要到达的地方，比如 B 省。

APP1 中的 SDK 会将流量切换到 A 集群的 Dubbo 网关，然后由 Dubbo 网关将 Dubbo 请求转换为 HTTP 请求，再转发到新型网络架构中的 APISIX，随后由 APISIX 将 HTTP 请求传递到目标服务。

APISIX 首先解析请求中的一些路由信息，发现需要转到 B 省，然后将请求发送到 B 省的 Dubbo 网关。此时，B 省的 Dubbo 网关获得路由信息、参数、请求、序列化协议等信息后，再次使用 Dubbo 的泛化调用，最终将请求真正发送到 B 省的 APP2 上。

这就是一次跨网的 RPC 请求过程。

### 为何需要 Dubbo 网关

在这一过程中，可能会引发一些问题，例如公司内部可能会对为何需要一个 Dubbo 网关提出疑问。Dubbo 网关的功能在于将协议数据转换成 HTTP，那是否可以省略 Dubbo 网关，直接将请求发送至中心网关呢？

关于这个问题，我们有以下几个方面需要考虑。首先，Dubbo 网关的作用是将 Dubbo 协议的数据还原为 HTTP 协议。尽管在某些情况下可能会节省一个步骤，但在这一步骤中，有一些 IP 收敛和功能收敛需要完成，这些功能与第一个版本的特性有关。此外，Dubbo 网关的实现存在一些问题，它是一个 Java 实现 的 Spring Boot 程序，并且引入了 Dubbo SDK。当 APP 的请求切换过来时，在没有相应 provider 的情况下，Dubbo 默认返回“Service not found”，类似于 HTTP 的“404 not found”。

为了解决这个问题，我们增强了 Dubbo，对源码进行了定制化开发，即可以转发请求，并将其成果贡献给了 Dubbo 社区。

### 总体架构中的网关

总体架构中包括三个网关，其中包括中心网关和两个 Dubbo 网关。中心网关采用了 APISIX，在第一个版本中已经使用过。主要的使用场景是执行路由（反向代理），根据 HTTP Header 信息将请求转发至不同网络的集群。使用 APISIX 过程中，也遇到了 Dashboard 相关的一些问题，例如，将测试环境的路由配置导出到生产环境，Dashboard 会报错。总体来说，这里对APISIX 的使用，就是普通的网关场景。

## 跨网 RPC 性能分析

![RPC_analysis](https://static.apiseven.com/uploads/2023/12/08/h5uPd3Rf_ZCY-5.png)

* **客户端**：客户端已整合 Dubbo 的 SDK，该 SDK 的行为包括生成代理、方法调用、参数序列化以及发起网络请求等。当前情况下，这一组件难以更改，因为我们采用的是统一的 Dubbo，因此 SDK 的行为不会发生变化。

* **本地网络**：在本地集群中，存在一个切流量的动作，因此本地网络会涉及 Dubbo 的传输。这涉及 I/O 模型、Dubbo 协议、数据格式（如参数）等。Dubbo 使用了基于 Netty 的异步非阻塞模型的 I/O 模型，对于 Dubbo 来说，使用这种 I/O 模型本身是没有问题的，符合其性能要求。而 Dubbo 协议的数据包采用了简洁而灵活的结构，没有冗余的头部信息，而是根据需求灵活携带必要的数据，以二进制格式进行高效的编码和解码。

* **Dubbo 网关**：在这一过程中，Dubbo 网关充当流量转发角色，不负责业务处理。在这个情境中，牵涉到消息接收的 I/O 模型：是选择阻塞式接收消息，还是采用异步方式呢？同时也牵涉到数据包的解析：这一过程会有一些消耗，因为 Dubbo 数据需要转化成 HTTP 数据，其中会涉及到一系列序列化和反序列化的动作；此外，还有自定义的扩展，即基于本地集群还包括一些公共特性，如限流、鉴权等。

* **公网网络**：网关请求处理完成后，将通过 HTTP 转发到 APISIX 的中心网关，转出去的时候通过了 HttpClient。因为 HttpClient 在默认情况下是阻塞式的，所以性能稍显不足。之所以选择自研网关而非使用现有解决方案，是因为第一个版本将迅速实现并投入使用视为首要因素，而性能优化则作为后续工作。然而，这个方案产生的问题是，Dubbo 协议转换为 HTTP 的行为是自定义的，目前没有任何网关能够支持这种自定义行为。因此，我们采用基于 Netty 的 Java 应用进行自研。同时，在公网端也涉及一些 I/O 模型、HTTP 协议、数据格式等问题，我们选择了性能极佳的 APISIX 来解决这些问题。

* **中心网关**：在整个架构中，中心网关 APISIX 扮演着关键角色，尤其是在公司级公共功能方面，它负责处理流量，具备高效的转发效率和公共扩展。在新型网络架构下，中心网关成为单点，因此我们需要关注单点故障等问题。我们目前的立场是将公共扩展看作公司级公共功能，可以在这一层面上进行一些扩展工作，如拦截流量并执行相应操作。 APISIX 插件式的特性使我们能够对其进行其他一些扩展，例如，在审计时，我们不鼓励无序的跨域调用，而是通过控制台注册信息（如应用名、责任人等）校验后，再进行审计。在中心网关中，我们也处理了单点故障的问题，进行了故障隔离和资源隔离。我们对稳定性和扩展性的要求很高，而 APISIX 很好地满足了我们的需求。

* **目标集群**：中心网关请求转发后，与之前的本地网络相似。因为只是一个中点调用，形式有所不同而已。由于经过一系列操作，Dubbo 数据包此时已通过 HTTP 封装，解析出来后，并不能进行点对点调用，仍需使用 Dubbo 的泛化调用，需要了解接口名、参数等，然后进行调用，调用后再按原路返回。

## 优化目标：提高吞吐量

![Optimization_goal](https://static.apiseven.com/uploads/2023/12/08/fhnNz8Ez_ZCY-6.png)

性能压测是在第一版架构上线之前进行的，目的是深入了解跨网的 RPC 架构可能存在的瓶颈。若没有进行性能压测，缺乏数据支撑，我们将无法确定系统的底线。因此，我们经过一系列性能压测，以更好地优化我们的系统。

压测脚本与请求量实际上存在关联，例如，请求的数据大小逐渐增大，从 2KB 到 8KB。在进行压测时，我们设定了一些前置条件，如当 CPU 占用率达到 80% 左右，磁盘开关达到 80% 左右时，即停止压测。这时，我们可以观察性能表现。通过设置前置条件和逐渐增加数据，我们能够查看最终的性能指标。

我们发现瓶颈主要在于带宽，即在带宽存在差异的情况下，性能的差异最为显著。我们通过修改网关和 CPU 的参数重新进行压力测试，但是得到的结果和原本的相差不大，从而排除了这些可能的影响因素；而在网络上存在数据过载时，性能会受到限制。因而，我们推断出瓶颈在带宽。尤其对于不同的岛端，由于每个岛端具有不同的带宽，因此需要与每个岛端的运维机构进行协调。例如，上海可能有 30 兆的带宽，而山西可能有 50 兆的带宽，显然，山西的表现更为出色。

综合之前的分析，我们认为问题一是流量网关，问题二是需要优化 HTTP 协议。

## 网关优化实践

### 自研 Dubbo 网关的问题

在使用自研 Dubbo 网关时，我们也遇到了一些问题：

![Dubbo_challenges](https://static.apiseven.com/uploads/2023/12/08/EyDZm1nV_ZCY-7.png)

* **I/O 模式**：将 Dubbo 转换为 HTTP 实际上是采用了一种隧道机制。由于网络的复杂性，我们选择使用 HTTP 来承载这个隧道，通过这个隧道将数据传输到目的地，一旦到达目的地，我们再解开。隧道机制的一个不太理想的方面是，在这个隧道中需要转换协议的数据，尤其是在到达 Dubbo 网关时，而我们自行编写的一些组件，性能可能也无法达到最佳水平。

* **两次序列化**：在进行两次序列化时，涉及一个 JavaBeanDescriptor 对象，这是 Dubbo 中的一个 API。在进行序列化和反序列化时，由于业务对象在参数中无法直接进行序列化，因此需要在 SDK 中进行封装，将 JavaBean 转换为 Dubbo 内部的一种结构，在到达目的地后再进行解封操作。这样的处理方式才能够确保参数中的业务对象能够顺利地进行序列化和反序列化。此外，还有一层问题是 Dubbo 本身采用的序列化方式，即使用 Hessian2。进行两次序列化时，使用 Hessian2 可能对性能造成相当大的消耗。
  
* **其他业务扩展**：Dubbo 网关需要一些业务扩展，不仅仅是在中心网关上，本地集群网关也是必要的。另外，我们还需要一些即插即用的功能，例如限流等。

### 选择 APISIX 的原因

目前，我们选择使用 APISIX 来替代自己研发的 Dubbo 网关。因为我们自行开发的网关存在一些潜在问题，所以我们并不打算在这方面投入过多资源，而是计划引入现成的专业解决方案并立即投入使用，以节省开发资源，提高效率。选择 APISIX 的原因如下，可供大家参考：

* **社区活跃，代码质量高**：APISIX 开源社区的活跃度极高，代码质量有一定保障。
  
* **架构合理，高性能**：APISIX 是基于高性能的 OpenResty 开发的，从架构和设计角度对性能追求极致，因此可以满足我们对网关性能的基本要求。

* **高扩展性**：APISIX 具有出色的扩展性，能够满足我们的自定义需求。简而言之，我们既希望享有类似 NGINX 的高性能，又希望可以根据需要扩展功能。

## 协议优化实践

协议方面，我们尝试使用了 Dubbo 协议作为隧道协议，替换掉了 HTTP 协议。

![Dubbo_optimization](https://static.apiseven.com/uploads/2023/12/08/SAygDDdv_ZCY-8.jpeg)

### 优点

使用 Dubbo 协议作为隧道协议有以下几个优点：

* **使用 APISIX 网关，避免协议转化**：由于我们的网关采用了 APISIX 网关，因而希望 Dubbo 能够直线转为 Dubbo，这样可以避免两次序列化，也能规避那些主设施的调用。正如前文提到的 HttpClient 计划，采用单线程同步调用的方式，需要等待调用完成后才继续执行后续操作。在高并发情况下，这种方式是非常低效的，并且之前使用的其他方案也逐渐无法支撑我们不断增加的业务量，因此需要进行更新。

* **二进制协议**：总体而言，二进制协议相较于文本更为出色，也是相对经典的一种协议。

* **避免无效头部**：HTTP 的各种客户端可能会携带一些多余的 Header 信息，而使用 Dubbo 协议能避免携带这些无效的冗余信息。

* **长连接多路复用**：APISIX 可以实现多路复用。长连接可以将很多请求一起发送，而 HTTP 虽然可以将很多请求一直发出去，但必须等待一个请求回来后，才能继续接下来的请求。HTTP 和 Dubbo 在并发效率上会有一些差异。

* **四层协议扩展框架**：APISIX 实现了 xRPC 四层协议扩展框架，允许开发人员自定义特定于应用程序的协议。基于 xRPC 框架，APISIX 可以提供几种主要应用协议的代理实现，用户还可以基于该框架支持自己私有的基于 TCP 的应用协议，使其具有类似于 HTTP 协议代理的精确粒度和更高级别的 7 层控制。通过使用 APISIX 的 xRPC 扩展，我们成功地增加了对 Dubbo 协议的直接转发功能，从而实现了全链路 Dubbo 协议传输。

### 缺点

当然，在使用过程中，Dubbo 协议也存在一些自身特有的缺点：

* **穿透性不足**：Dubbo 协议存在一个明显的问题，即其穿透性不足。毕竟 Dubbo 是一种私有协议，而我们的网络可能会经过许多物理设备，除了软件层面的网关（APISIX/NGINX/WAF），还涉及一些物理设备，这实际上可能会遇到一些阻碍。

* **无法只读取关键信息**：HTTP 协议可以只读取 Header 信息到网关内存，且 Body 以零拷贝的形式直接转发，但是 Dubbo 协议无法做到这一点。

在这次实践中，尽管我们使用了 Dubbo，但实际上是更偏向于一种调研性质的尝试。我们能够利用的是我们内部基础设施。尽管内部集群的网络是通畅的，但由于我们已经采用 K8s 实现了容器化，K8s 中也有不同的 namespace。在这种情况下，它们之间的调用可能只能通过域名进行。

### 效果

在将 Dubbo 协议投入使用后，我们发现它为我们带来的的优化效果十分显著：

* **减少包的大小，提高网络吞吐量**

Dubbo 协议更加精简，承载的头部信息更少。协议设计上很紧凑，能用 1 个 bit 表示的，不会用一个 byte 来表示，比如 boolean 类型的标识。HTTP 为了更好的兼容性，请求头部携带了很多上下文和元数据。对于内部通信来说，服务端和客户端相对固定，很多信息是没有必要的。以下是 Dubbo 官方性能测试，Tps（每秒处理事务量）Dubbo 协议比 HTTP 高 30%-50% 左右（最常见的高并发小数据量场景）。

![Dubbo_test](https://static.apiseven.com/uploads/2023/12/08/ly2rVObV_ZCY-9.png)

另外，Dubbo 使用长连接，可以重复使用已经建立的 TCP 连接，减少了连接建立的开销。

* **传输协议开销**

由于整条链路使用了相同协议，可以避免不同协议间的装包和解包。

## 本轮改造不足

2022 年下半年，我们对各跨岛方案，进行了整合升级，也就是现在的“高速公路”方案，保障跨岛标准化同时，解决了之前方案实践过程中面临的很多业务痛点。通过替换隧道协议，我们希望优化网络 I/O 模型，提高链路转发效率。经初步测试，单次 2k 包请求 RT 可以降低 1/3 左右。

但是，在实践业务场景中，该架构下一些痛点也开始逐渐显现。

### 支持场景不足

对云岛业务结构的公司来说，云平台属于公司内部、完全可控的局域网，而岛端则是有自己安全网络策略的独立内部网络。我们的跨网 RPC 需要穿透混合云网络中的各种设备和网关，到达云岛的另一头服务。Dubbo 协议作为私有协议，在大部分的跨岛场景中并不适用。

目前，这种模式只能在内部的一些网络使用，比如独立搭建的 AI 集群和平台业务集群的通信。当然，基于“高速公路”架构的良好扩展性，我们可以做到不同场景自动切换协议，在获得 Dubbo 协议优势的前提下，也能退化 HTTP 协议兜底。我们对协议的扩展，并不会删除已有协议。

### 对网络吞吐量的优化不足

接口需要发送大量数据时，这些数据无法被放在一个 RPC 的请求或响应中，需要分批发送。Dubbo 协议下，这种情况只能串行发送。Dubbo 协议在单次请求下性能较好，但是整体吞吐量的提升仍然不够。

如前文所言，在我们的跨网第一个版本上线前，曾经做过性能压力测试。测试场景如下：云端调岛，上行数据，30M 带宽，发送 2KB 数据，逐步增大并发量。30M 入口带宽，发送 2KB 数据，TPS 大于 500/s，入口带宽将成为瓶颈。当发送数据增加到 80KB，TPS 下降约 16 倍，RT 上升约 1.5 倍。从监控上看，tps 到达一定量后，带宽即达到上限。

![Highway_test](https://static.apiseven.com/uploads/2023/12/08/zoVrWkHq_ZCY-11.png)

可以看到，当前“高速公路”的实际业务场景下，吞吐量是“高速公路”第一个版本最大的一个瓶颈。此次网关和协议的升级，显著降低了 RT 指标，一定程度提升了整体吞吐量。

## 后续规划

### Triple 协议调研

经过对 APISIX 的协议扩展，我们使用 APISIX 代替了 Dubbo 自研网关，基本实现了对通信效率的预期优化。但是，我们也有支持场景和通信效率两个明显的痛点需要解决。为此，我们重点调研了 Dubbo3 主力通信协议——Triple 协议。

Triple 协议是 Dubbo3 设计的基于 HTTP 的 RPC 通信协议规范，它完全兼容 gRPC 协议，支持 Request-Response、Streaming 流式等通信模型，可同时运行在 HTTP/1 和 HTTP/2 之上。对于我们项目来说，Triple 协议的几个特性刚好是我们欠缺的。

* 完全兼容基于 HTTP/2 的 gRPC 协议：Triple 协议听起来是个私有协议，实际上则是标准的公有协议，兼容 HTTP/1 和 HTTP/2。这意味着穿透性强，痛点之一的场景支持就不再是问题了。

* 兼容 HTTP/1 和 HTTP/2，穿透性强。

* 二进制分帧带来的并行效率提升，首部压缩减少大量包体，在网络吞吐量上，HTTP/2在性能上有了极大提升。

* 作为 Dubbo 主力协议，仍然保留着避免协议转换的优势，与“高速公路”架构契合。

### APISIX 对 Triple 的扩展

![APISIX_triple](https://static.apiseven.com/uploads/2023/12/08/LFmuvivP_ZCY-12.png)

APISIX 能够通过其 xRPC 机制来实现对新应用协议的扩展。xRPC 为我们提供了接口回放的功能，使得自定义协议的实现变得更为直观。此外，先前的实践案例，例如 Redis，已经为这样的扩展提供了可行的范例。

在我处理许多协议扩展的实际经验中，APISIX 作为基于 NGINX 的平台，能够对 TCP 四层协议进行转发。如果想将 Dubbo 通过 NGINX 转发到其他网络集群，这是完全可行的，因为 NGINX 专注于对 TCP 四层协议进行处理。然而，我们选择对 APISIX 进行扩展的原因在于，我们不仅需要进行 TCP 协议和数据的转发，还需要读取这些数据。这是因为我们需要处理一些公共特性，无论是限流还是其他功能，我们都需要在这一层面进行实现。

在这个过程中，通过为 APISIX 添加 Triple 协议的扩展，我们可以将数据放入类似于会话 session 的结构中。也就是说，在编写插件时，能够将读取到的头信息等内容传递到插件中，从而实现对功能的扩展，这很利于匹配我们的架构。

### 推动公司 Triple 协议的升级

经过 Dubbo2 协议的实践与总结，我们将着力推动 Triple 协议的升级，解决性能问题。

### 性能压测验证

对于当前架构，之前做了完整的压力测试，也明白瓶颈所在。后续我们将持续测试，深挖这一基础设施的性能潜力。

### 未来的高速公路架构

![Highway_future](https://static.apiseven.com/uploads/2023/12/08/qGJP1dKu_ZCY-13.png)

从架构的角度来看，未来可能会呈现如下变化：过去是由 Java 编写的 Dubbo 网关，而现在已经转变为 APISIX。在我们的测试环境和调研中，我们已经着手采用这种方式。然而，目前在生产环境中还未进行替换，因为我们计划在 Triple 完全实现后，再进行整个集群的升级。
