---
title: "分布式网关 APISIX 在大规模视频类业务中的落地实践"
authors:
  - name: 夏煜
    title: Author
  - name: Yilia Lin
    title: Technical Writer
    url: https://github.com/Yilialinn
    image_url: https://github.com/Yilialinn.png
keywords:
  - 开源社区
  - API 网关
  - Apache APISIX
  - 咪咕视频
  - 咪咕视讯
description: 咪咕视频借力 APISIX 应对大规模视频类业务需求场景下的挑战，其落地实践不仅提升了咪咕视频的业务性能，简化了后端架构，还为业务的快速发展提供了有力支持。
tags: [Case Studies]
image: https://static.apiseven.com/uploads/2023/12/06/ZYrbfw7r_Migu-video.png
---

> 作者：夏煜，咪咕视讯建设运行中心-高级应用运维工程师。本文整理自 2023 年 11 月夏煜在 APISIX 上海 Meetup 的演讲。
<!--truncate-->

今天由我为大家分享，咪咕视频在大规模视频业务类中使用到 APISIX 的方案落地与实践的一些经验。我将从 7 个方面跟大家分享我们的经验和成果。

## 咪咕视讯简介

咪咕文化科技有限公司（简称“咪咕公司”）是中国移动面向移动互联网领域设立的，负责数字内容领域产品提供、运营、服务的一体化专业子公司，是中国移动旗下音乐、视频、阅读、游戏、新空数字业务板块的唯一运营实体，下设咪咕音乐、咪咕视讯、咪咕数媒、咪咕互娱、咪咕新空五个子公司。目前, 咪咕公司已成为国内领先的全场景品牌沉浸平台，汇聚超过 3500 万+ 首歌曲，460 万条视频，60 万+ 册书刊，1100 + 款游戏，75 万集新空画。面向未来，咪咕公司将大力探索“互联网+数字内容”运营创新，将内容孵化与渠道合作结合，着力开展跨领域 IP 运营，积极打造新媒体融合、数字内容聚合、版权交易、内容创业创新四大平台，致力于为用户带来文娱生活方式的改变。

## APISIX 介绍及应用场景

首先，我们为什么需要使用 APISIX？

在网关选型时，我们就注意到 APISIX 是一个开源的 API 网关，并且提供了高性能、高可用、高扩展性的 API 网关服务；同时，APISIX 还支持多种协议，包括 HTTP、WebSocket、gRPC 等，同时还支持多种插件，如限流、认证、鉴权、日志等，可以满足各种场景下的 API 网关需求。另外在微服务框架和云原生方面，APISIX 具有其独特的优势。

我们比较看重的是 APISIX 的高性能、动态路由、以及安全防护等方面，还有插件的灵活运用。

![Features of Apache APISIX](https://static.apiseven.com/uploads/2023/11/30/POh6mmLf_%E5%92%AA%E5%92%951.jpg)

## 大规模视频类业务需求

在咪咕视频的业务场景中面临了一些挑战，比如高并发访问、安全性要求、故障恢复等等。由于直播和其他业务场景的实施，传输要求比较苛刻。同时，需要支持多格式和多协议，以及内容分发的加速，通过 CDN 实现加速。这些都是我们目前面临的业务类型的特点。APISIX 作为一个高性能实践的解决方案，可以帮助我们应对这些挑战。

- 大流量、高并发：视频类业务通常面临大量的用户请求，需要处理高并发访问。

- 实时性要求高：对于直播等场景，需要保证数据的实时传输和展示。

- 多格式、多协议支持：视频业务可能涉及多种视频格式和传输协议。

- 内容分发网络（CDN）加速：为了提供更好的用户体验，视频类业务通常需要使用 CDN 进行内容加速传输。

## APISIX 在大规模视频类业务中的实践

接下来介绍我们在业务中 APISIX 的具体应用场景，主要分为流量调度与管理（探索）、动态路由和安全防护三个方面。

- **流量调度与管理（探索）**：我们一直在探索流量调度的管理，希望通过 APISIX 来控制我们网关上的流量调度和限流，从而通过试用 APISIX 的插件进而规避或者拦截一些请求。

- **动态路由**：动态路由也是我们最初比较看好 APISIX 的一个功能。我们之前的中台网关主要使用的是 OpenResty 的一个版本，由于我们的业务可能会频繁变更路由信息，每次在线修改路由信息配置都存在一定的风险。而 APISIX 通过 Dashboard 的动态路由和热配置，能在不重新加载服务的情况下进行发布，对我们来说很有价值。

- **安全防护**：我们希望能够利用 APISIX 的安全防护功能，可以有效保护视频类业务免受各种网络攻击。例如，通过配置 APISIX 的防火墙规则，可以过滤掉恶意请求，确保业务的稳定运行。

### 现网网关改造现状

目前，咪咕视频已经完成了 11 套现网网关的 APISIX 改造，还有 4 套灰度环境的改造。已经完成的这 11 套中已经基本涵盖了我们中台业务的主要网关，例如用于用户登录的登陆公网网关、负责用户鉴权能力的用户管理中心网关和用于用户购买商品的销售网关，还有 2023 年新增的直播业务要用到的 PUGC 网关。另外，我们还对影院票务进行了网关的改造。

咪咕当前的现网 APISIX 网关环境一般都为双机房架构。每个机房都有多台 APISIX 服务，一套 etcd 集群（一般是3台），以及一台 Dashboard 服务用于前端路由配置。此外，我们还使用了自研的验签和验 token 插件，主要用于网关的签名和 token 的验证。

![API Gateways Customization within MiGu Vedio](https://static.apiseven.com/uploads/2023/11/30/JfZntG5g_%E5%92%AA%E5%92%952.jpg)

### 插件使用

除了我们自研的两个插件，还使用了 APISIX 自带的 Prometheus 插件，主要用于监控 APISIX 网关。

![MiGu Vedio's Plugins Using](https://static.apiseven.com/uploads/2023/11/30/sDD0IqLF_%E5%92%AA%E5%92%953.png)

在 APISIX 最初上线时，我们得到了原厂的技术支持，他们协助我们完成了线上环境的巡检，并修复了一些问题。其中包括插件类和资源分配类的调整，解决了之前在现网可能遇到的问题。

### 监控告警

接下来，我将与大家分享我们目前对网关的监控。我们从四个方面对网关进行监控：日志易、ZABBIX、Prometheus 和听云。

- **日志易**主要用于采集 APISIX 生成的日志，并对日志字段进行解析。通过相关配置，可以针对某个字段或某条路由信息设置告警规则，监控网关和后端服务是否正常。

- **ZABBIX** 主要基于服务器基线的一些指标，通常是虚拟机的 CPU、内存、TPS 等。我们还在 ZABBIX制定了一个 etcd 集群探活的监控，因为最初我们发现有一套 etcd 的共享内存占满时，虽然它在工作，但路由规则没有下发。为了解决这个问题，我们在 ZABBIX 中进行了自定义检测，以监测 etcd 集群的健康状况和存活情况。

- **Prometheus + Grafana** 是 APISIX 官方的插件，我们通过它主要监控 APISIX 网关的错误率、延迟、TPS 等数据，还包括etcd 集群的健康状况、共享内存情况和发送速率等信息。这些数据通常以图表形式展示，更直观清晰。

![MiGu Video Uses APISIX's Prometheus and Grafana for Monitoring](https://static.apiseven.com/uploads/2023/11/30/IMuCU0SN_%E5%92%AA%E5%92%954.png)

- **听云**主要用于监控整个请求链路。我们可以在听云上看到请求的上游和下游，以及每个环节的响应时间和正确率等；它在采集到信息后还能自动绘制上下游调用链路图，便于我们排查现网问题。

## APISIX 适配国产欧拉操作系统

另外，今年咪咕还做了一个基于国产欧拉操作系统的 APISIX 适配。近年来，国际科技环境对我国科技产业带来了一定的挑战。为了应对这种局势，我们集团今年启动了一个自主可控操作系统的项目。在服务器相关领域，我们致力于推动国产化操作系统的研发，并目前主要采用华为的欧拉操作系统。在适配过程中，我们也遇到了一些问题。

- **环境差异**：国产欧拉操作系统与 Windows、Unix、Linux 等操作系统存在一定的差异。我们使用的是三种操作系统，它们之间有一些差异。在适配 APISIX 时，我们需要进行一些依赖库兼容性的调整。

- **包管理**：国产操作系统有自己的定制化依赖包，我们在欧拉系统上适配 APISIX 时需要重新适配一些基础软件包。

- **性能**：一开始我们对 APISIX 在华为欧拉系统上的性能并不确定。因此，我们进行了一些测试工作。

首先，在测试环境中对 APISIX 和欧拉系统进行了适配，并解决了依赖包相关的问题。然后，我们对一套 PUGC 的网关进行了压力测试。这个业务今年在四赛的时候已经大规模应用在我们的服务上。目前， APISIX 在华为欧拉操作系统上至少可以承载若干路并发的直播。APISIX 在华为欧拉系统上经过了实际的考验，满足了我们的业务需求。

### 发展方向：APISIX 容器化

我们的发展方向之一是将 APISIX 容器化。因为我们目前的主要环境是 VM（虚拟机）操作系统，后续会改为 K8s。鉴于咪咕内部很多网关已经改造成了 APISIX，因而选型的时候我们选择了 APISIX Ingress Controller 作为我们容器化的网关。目前，我们的 VM 环境是基于 LVS 的，而我们期待转变为在容器化环境中使用 APISIX Ingress Controller。

容器化的规划会分两步进行。由于业务对稳定性的要求较高，我们可能首先替换部分业务，使 VM 和容器化环境并存，逐步进行从虚拟机到容器化的迁移。

![MiGu Vedio's Containerization Plan](https://static.apiseven.com/uploads/2023/11/30/ZprhDMoU_%E5%92%AA%E5%92%955.jpg)

## 实践效果与优化

### 使用 APISIX 后业务性能的提升情况

- **请求处理效率提升**：APISIX 采用了高性能的异步非阻塞设计，可以处理大量并发请求，使得视频类业务的请求处理效率得到显著提升。

- **延迟降低**：通过 APISIX 的智能路由和就近节点分发策略，有效降低了视频类业务的网络延迟，提高了用户体验。

- **稳定性增强**：APISIX 自身具有高可用性和容错机制，减少了后端服务的故障影响，增强了整体业务的稳定性。

### 落地实践的意义与价值

- **提升业务性能**：通过 APISIX 的高性能、高并发能力，视频类业务能够更好地应对大规模用户的访问请求，确保业务的稳定性和可用性。

- **简化架构和运维**：APISIX 提供了丰富的功能和插件，使得后端架构更加简洁，同时降低了运维的复杂性，提高了开发和运维的效率。

- **增强扩展性**：基于 APISIX 的分布式特性，视频类业务可以更方便地进行横向扩展，满足业务不断增长的需求。

## 展望未来

当前，咪咕视频目前也遇到了一些问题，这些也是我们未来的研究方向：结合业务使用 APISIX 限流插件的使用，如设定阀值实现熔断和降级等机制；匹配业务实现网关主动健康检查功能；以及 Ingress Controller 的图形化路由配置界面的功能。

**我们期望 APISIX 未来能实现：**

- 更完善的功能插件：期待 APISIX 在未来能够提供更多、更完善的功能插件，以满足更多场景的业务需求。

- 更强的性能表现：随着 5G、云计算等技术的不断发展，对网关的性能要求也越来越高，希望 APISIX 能够持续优化性能，满足更高层次的需求。

- 更深入的生态合作：希望 APISIX 能够与更多的开源项目、商业公司进行深入的合作，共同打造更加完善的技术生态。

总结来说，分布式网关 APISIX 在大规模视频类业务中扮演着至关重要的角色。其落地实践不仅提升了业务性能，简化了后端架构，还为业务的快速发展提供了有力支持。未来，我们期待 APISIX 能够持续进化，为大规模视频类业务以及其他领域带来更多的价值和创新。
