---
title: "APISIX 的出海征程势如破竹：APISIX 马来西亚 Meetup"
authors:
  - name: Yilia Lin
    title: Author
    url: https://github.com/Yilialinn
    image_url: https://avatars.githubusercontent.com/u/114121331?v=4
keywords:
  - 开源社区
  - API 网关
  - Meetup
  - Apache APISIX
description: 7 月 4 日，2023 APISIX 开源社区 Meetup 在马来西亚首都吉隆坡成功举办。 
tags: [Community]
image: https://static.apiseven.com/uploads/2023/06/28/6T1RUrwQ_img_v2_6e1d6a11-db2a-4236-b715-38b20c2c12bg.png
---

> 7 月 4 日，2023 APISIX 开源社区 Meetup 在马来西亚首都吉隆坡成功举办。

<!--truncate-->

近日，Apache APISIX 发起的技术盛宴，在马来西亚首都吉隆坡隆重开幕！活动由 [API7（支流科技）](https://www.apiseven.com/)与 [N2N（N2N Connect Berhad，联圣）](https://www.n2nconnect.com/)及 [AMD（Advanced Micro Devices, Inc.,）](https://www.amd.com/en.html)联合举办，汇集了众多 API 网关技术领域的专家和爱好者。

APISIX 在马来西亚与新加坡有很多来自金融、IT 等领域的用户，其中不少公司专程来到了现场，亦有众多关注者在线上观看了此次活动。现场，[APISIX PMC 成员](https://apisix.apache.org/zh/team/)及众多贡献者齐聚一堂，探讨了 API 网关技术的最新进展和未来发展趋势，分享了他们在实践中的经验和见解。

热烈的氛围和交流让这个 Meetup 成为了一个汇聚智慧和创新的平台，为 API 网关技术的发展注入了新的活力和动力！

## 他们说

为期一天的 Meetup 大获好评！其中 Bryan 是马来西亚第一股票交易平台 N2N 的业务拓展经理，他表示：

> “今天的 meetup 很成功！对于马来西亚的工程师们来说，能和这么多开发人员当面沟通并解决问题，这是一次非常好的机会。因为他们几乎都是在线上学习研发，但是很多实际的问题很难在线上解决，因而线下的沟通和交流是很有必要的。
>
> 从整体来看，APISIX 前景一片光明。从今天参会人员的反馈来看，大家都很喜爱 APISIX 这个项目，也有很多用户正在使用 APISIX， 它在马来西亚一定会越来越好！我们很开心能见到这么多志趣相投的同伴，也希望以后会有更多的机会和你们一起合作！”

Michael 是一家跨国金融科技公司的 SRE 负责人，他表示：

> “我们正在寻求新的 API 网关，对 APISIX 处理流量的亮点很感兴趣，大会上分享的金融行业用户案例很有借鉴意义，非常期待能早日感受 APISIX 的魅力！”

Joey 是一名软件工程师，他对今天的 Meetup 内容赞不绝口：

> “今天的 meetup 内容翔实，演示的 demo 也很详尽，我学到了很多。之前并不了解 APISIX，只了解 GCP、AWS 等，现在了解了APISIX，以后一定会有更多机会在工作中使用。”

## 温铭：APISIX 的前世今生

> [温铭](https://www.linkedin.com/in/ming-wen-api7/)，Apache APISIX PMC 主席、Apache 软件基金会成员、Kubernetes 成员、API7.ai 联合创始人兼 CEO

![Ming Wen](https://static.apiseven.com/uploads/2023/07/07/wv8WK1TY_meetup1.jpeg)

温铭首先分享了 APISIX 诞生的故事。他和院生热爱代码，志同道合，想挑战自我，做些有难度的事情。在初创时期，他们没日没夜地待在逼仄的小房间里，专注于写代码，最终开创了 APISIX。

为了让全世界的开发者都能共享他们的成果，他们决定将 APISIX 捐赠给 Apache 软件基金会。自此以后，Apache APISIX 一直遵循“Community over Code”的原则，由[社区](https://apisix.apache.org/zh/blog/tags/community/)驱动。APISIX 将贡献者视为合作伙伴，这也吸引了世界各地的优秀开发人员持续为 APISIX 项目贡献自己的力量。四年如一日，APISIX 项目的问题响应时间都能维持在很短的时间内，活跃的社区是 APISIX 焕发生机的动力。它不断吸引着更多的人加入，为 APISIX 注入新的血液和灵魂。

![Time of Issues Responded](https://static.apiseven.com/uploads/2023/07/07/FGcdrAPT_2.png)

APISIX 的用户遍布海外，全球已经有数百家企业用户在使用我们的解决方案，涵盖了金融、互联网、制造、零售、运营商等多个行业。从月活用户 5.13 亿的[爱奇艺](https://api7.ai/blog/iqiyi-api-gateway-update-and-deployment-based-on-apache-apisix)到数据传输跨越超过 130 个国家和地区的 [Airwallex（空中云汇）](https://api7.ai/blog/how-airwallex-empowers-global-payment-through-apache-apisix)，甚至全球领先的在线会议平台 [Zoom](https://api7.ai/blog/zoom-uses-apisix-ingress) 以及累计交易总额超万亿的全球化加密金融服务商 [Amber 集团](https://api7.ai/blog/amber-api-gateway-architecture)，都在使用我们的方案处理核心业务流量。

未来，APISIX 将在 AI 方向发力。其实，早在 2022 年 10 月，APISIX 的 [AI 模块](https://github.com/apache/apisix/pull/8102/files)已经初具雏形。这一创新将为开发者带来更加智能化的 API 管理体验，帮助他们更好地应对日益复杂的业务场景。

除此之外，APISIX 还将致力于减轻 API 设计的成本，为开发者提供更加高效的工具和支持。同时，APISIX 还将协助管理层做出更明智的决策。这些举措将为开发者和企业带来更多的价值，也将推动整个行业向着更加智能化和高效的方向发展。

## 王院生：金融公司如何使用 APISIX？

> [王院生](https://www.linkedin.com/in/yuansheng-wang-84014022a/)，Apache APISIX PMC 成员、API7.ai 联合创始人兼 CTO、《Apache APISIX 实战》作者之一，下图是院生（右）在和现场观众探讨技术细节

![Yuansheng (right) is discussing technical details with the audience](https://static.apiseven.com/uploads/2023/07/07/3kshxsgx_3.jpeg)

API 连接着数字世界的“交通”，而 APISIX 则是“交通路线”上的核心工具。在现代架构中，APISIX 在 API 的全生命周期管理上扮演着举足轻重的角色。这一创新的 API 管理平台，为开发者和企业带来了更高效、更智能的 API 管理方案。

APISIX 已经赢得了众多金融公司用户的青睐，其中包括 [Airwallex](https://api7.ai/blog/how-airwallex-empowers-global-payment-through-apache-apisix)、[安信证券](https://api7.ai/blog/essence-securities-selects-apisix)、广发证券、[Amber 集团](https://api7.ai/blog/amber-api-gateway-architecture)、[雪球](https://api7.ai/blog/snowball-finance-with-apisix)等等。这些企业都深知 API 在数字化转型中的重要性，并通过 APISIX 获得了更加高效、安全和智能的 API 管理体验。APISIX 的成就不仅彰显了其在数字化转型过程中的重要性，也为整个行业提供了新的思路和方向。[API7](https://api7.ai/) 在 APISIX 的基础上提供了更深度的[企业级产品](https://api7.ai/enterprise)。

### 空中云汇（Airwallex）

随着 [Airwallex](https://api7.ai/blog/how-airwallex-empowers-global-payment-through-apache-apisix) 的业务在全球范围内扩展，数据治理面临重大挑战，同时内部系统管理和互联错综复杂，一旦某个系统出现问题，很容易影响其他系统的正常运行。为了解决这些问题，Airwallex 寻求高稳定、可靠、可用的 API 网关，要求低延迟和良好的性能，还要求支持自定义插件，例如按用户路由 API 和限速限流。APISIX 满足了这些要求，并帮助 Airwallex 解决了数据主权的问题，安全高效地支撑 Airwallex 覆盖 130 多个国家和地区 50 多种币种的业务。

### 安信证券

[安信证券](https://api7.ai/blog/essence-securities-selects-apisix)原有的技术栈比较复杂，包含 NGINX、Spring Cloud 网关和自主研发系统。这种分散的架构导致了系统管理和重复工作的问题，增加了开发成本。APISIX 易于与安信证券业务系统集成，具备高性能和横向扩展能力，同时拥有强大丰富的流量治理、安全、协议转换、授权、鉴权等功能。APISIX 帮助安信证券推进了流量治理，大大提高了研发的效率，同时增强了数据安全和权限管理。现在，APISIX 已经成为安信证券云原生开发的重要支撑，帮助他们更加高效地管理和开发业务。

查看更多类似用户案例，请查阅：[https://api7.ai/category/usercase](https://api7.ai/category/usercase)。

## Bobur：基于用户凭证对 API 网关进行动态路由

> [Bobur Umurzokov](https://www.linkedin.com/in/boburumurzokov/)，Apache APISIX 布道师，API7 布道师

通过使用 API 网关，用户可以根据各种标准将流量路由到不同的后端服务。通过演示，Bobur 讲解了如何根据请求头、请求查询或请求体中指定的用户属性来实现动态路由。

更多细节可查看 [Bobur 的文章](https://api7.ai/blog/dynamic-routing-based-on-user-credentials)。

![Bobur is demonstrating how to route traffic](https://static.apiseven.com/uploads/2023/07/07/AoFBgxlM_meetup5.png)

## 张超：Apache APISIX 云上实践

> [张超](https://www.linkedin.com/in/chao-zhang-52a106107/)，Apache APISIX PMC 成员，开源爱好者，OpenResty、Kubernetes Ingress-NGINX、Kuberentes Gateway API 等项目贡献者

![Chao Zhang](https://static.apiseven.com/uploads/2023/07/07/V4FYhaOD_6.jpeg)

如今，越来越多的公司正在采用云供应商提供的服务，越来越多的 IT 专业人员也在学习云技术堆栈，甚至进行自我认证。云作为基础设施，横跨 SaaS，已经成为了企业和个人进行数字化转型的首选之一，并且正在以惊人的速度增长。

考虑到多云和混合云的场景下，统一管理 API 的使用将会是一个巨大的挑战。这正是 [API7 Cloud](https://api7.ai/cloud) 应运而生的原因：它能够帮助企业解决多云和混合云场景下的问题。

API7 Cloud 基于 Apache APISIX，围绕着 Apache APISIX 所提供的功能进行了产品化，旨在让用户更简单、更放心地配置和使用 APISIX。API7 Cloud 以 Apache APISIX 为基础，又对它进行了更企业化的定制，例如强化了开源 APISIX 的动态能力，支持了动态的服务发现功能；开放 API 且提供 SDK，允许自动化的 API 管理，允许通过程序集成 API7 Cloud 实现自动化。

相比本地设备，API7 Cloud 具有更高的安全性、更好的可扩展性，而且维护和更新的成本也更低。API7 Cloud 能够托管控制面，同时在任何地方、任何基础设施上部署 API 网关的数据面，让用户能够更加轻松地管理他们的 API，同时内置可观测性，让用户能够更加清晰地了解他们 API 的使用情况和性能表现。

![Built-in Observability Support of API7](https://static.apiseven.com/uploads/2023/07/07/KE26wb3m_7.png)

## Nicolas：数据驻留管理

> [Nicolas Fränkel](https://www.linkedin.com/in/nicolasfrankel/)，研发工程师，APISIX 布道师，API7 布道师

![Nicolas Fränkel](https://static.apiseven.com/uploads/2023/07/07/YYJ9lHsQ_a5592a72-fb7d-4841-bbb6-ae29235bb569.jpeg)

数据驻留是一个备受关注的问题，因为在不同的国家和地区，法律法规对于数据存储和处理的要求是不同的。而在某些情况下，云供应商可能没有在所需位置建立数据中心，这就需要我们思考如何管理数据驻留问题。

针对这个问题，Nicolas 在会上分享了四种方式：在代码层、库/框架、代理和网关中管理数据驻留。这些方法可以帮助更好地管理数据，同时确保遵守不同国家和地区的法律法规，保护用户的隐私和数据安全。

通过现场演示 demo，Nicolas 生动形象地向与会者展示了这些方法的操作过程和效果，让大家更好地理解如何在不同的情况下管理数据驻留问题。

此外，来自 AMD 的东盟商务主管 [Koh Lian Chong](https://www.linkedin.com/in/koh-lian-chong-2b1713/?originalSubdomain=sg) 分享了 AMD 如何赋能全球数据中心，他向大家介绍了 AMD 的历史和产品。同时，来自 ShapeBlue 的质量保证工程师 [Kiran Chavala](https://www.linkedin.com/in/kiran-chavala-1bb6a97/) 介绍了 Apache CloudStack，它是一个高可用性和可扩展性的开源云计算平台，和 APISIX 搭配使用能够极大地提升开发效率。

## 迅猛发展的今天与未来

马来西亚有许多金融科技公司正在使用 [APISIX](https://github.com/apache/apisix-website)，极大的一个因素在于 APISIX 的高性能，同时它是轻量级的，易于管理和使用。APISIX 可以在单个服务器上运行，可以用于多个服务器处理数十亿流量，还可以快速地安装和引导。马来西亚的一家大型跨国集团正在使用 APISIX 来处理支付，众多金融科技公司都倾向于使用 APISIX 作为支付网关。

![2023 APISIX Meetup Malaysia](https://static.apiseven.com/uploads/2023/07/07/YFHhI10g_meetup10.jpeg)

感谢所有演讲者、参与者以及组织方，你们的支持使得 Apache APISIX 马来西亚站的 meetup 取得了圆满成功。正是因为你们的参与，这次活动才得以顺利进行，我们向你们致以最诚挚的感谢。

未来，我们期待更多这样的活动，期待看到社区将会带来哪些创新和进步。如果你错过了这次 meetup，不用担心！你仍然可以通过关注 Apache APISIX 的社交媒体，或参加未来的活动来跟上最新进展。

敬请关注更多更新和公告，和我们一起使用 Apache APISIX 构建 API 网关技术的未来！无论你是初学者还是有经验的专业人士，我们都欢迎你的加入，一起探索 [Apache APISIX](https://apisix.apache.org/) 的无限可能性！
