---
title: "API 网关日志的价值，你了解多少？"
authors:
  - name: "钱勇"
    title: "Author"
    url: "https://github.com/nic-6443"
    image_url: "https://github.com/nic-6443.png"
keywords: 
- Apache APISIX
- API 网关
- 日志
description: 本文介绍了 API 网关日志的价值，并以知名网关 Apache APISIX 为例，展示如何集成 API 网关日志。
tags: [Ecosystem]
---

> 本文介绍了 API 网关日志的价值，并以知名网关 Apache APISIX 为例，展示如何集成 API 网关日志。

<!--truncate-->

> 作者[钱勇](https://github.com/nic-6443)，API7.ai 技术工程师，Apache APISIX Committer

## 网关日志的价值

在数字化时代，软件架构随着业务成长而变得越来越复杂，这给故障的发现和排查都带来了非常大的挑战，进一步倒逼软件重视自身的可观测性能力。
而**日志被称为可观测性的三大支柱之一**，它可以帮助系统管理员和开发人员了解系统的运行状态，以便能够及时发现并解决问题。
此外，日志还可以用于数据挖掘、审计和安全监控等方向，以确保系统的合规性和安全性。

而 API 网关是在应用程序与外部世界之间构建的一道关口，它可以帮助组织更好地管理和监控 API 调用，其中之一重要的功能就是对于 API 调用日志的记录。

![API Gateway Log](https://static.apiseven.com/uploads/2023/01/29/q5vt6NM5_api-gateway-log.png)

下面将会从两个角度来分析 API 网关日志的价值。

### 运维价值

无论是传统系统运维，还是现代网站可靠性工程师（SRE），对于保障系统稳定性这个大目标而言，如何发现故障永远是排在最高优先级的任务，因为对于任何一个大型的在线业务，每一秒的故障时间都可能会带来巨大的业务损失和用户体验伤害。

而 API 网关处于整个系统的最前端，它可以扮演一个“哨兵”的角色，让我们从它的访问日志中提取非常多对于运维体系至关重要的指标数据：

- 通过上、下游状态码分析，监控网站整体可用性和具体上游服务的可用性；
- 通过访问日志整体统计，监控网站流量，及时发现 DDoS 一类的攻击；
- 流量的趋势分析可以作为业务系统扩缩容的参考依据；
- 请求耗时统计，为业务系统提供接口级别的性能报告，作为业务系统性能优化的数据参考。

以上都是一些在业界被广泛采用的 API 网关日志的最佳实践，在很多企业的运维体系中落地。

### 业务价值

与运维价值被广泛认可相比，网关日志的业务价值往往是被人们所忽视的。
例如在用户行为分析领域，在程序中使用编码的方式进行埋点上报是最常见的数据收集方式，而对于一套设计良好的 API 来说，网关日志是可以天然支持此类需求的。我们可以：

- 通过分析客户端 IP，统计流量的地理位置分布；
- 通过分析 HTTP Referer，了解用户进入各个页面的来源；
- 对于重点 API 的聚合统计，可以直接得到关键业务指标。例：统计用户注册、商品下单等 API 的成功调用，可以直接得到指定时间段内的新用户、新订单的数量指标。

当然网关日志显然不如程序埋点灵活，无法实现自定义数据收集需求，但其中蕴藏的业务价值足以满足简单的数据挖掘需求。

Apache APISIX 是一个动态、实时、高性能的云原生 API 网关，提供了负载均衡、动态上游、灰度发布、服务熔断、身份认证、可观测性等丰富的流量管理功能。
它的很多能力是通过可插拔的插件形式提供，这其中就包括十数个日志插件。下面将会以 APISIX 中典型的日志插件为例，介绍如何将网关日志与日志分析系统打通，挖掘出更多的价值。

## APISIX 典型日志插件介绍

### elasticsearch-logger

![Elastic Search And Apache APISIX](https://static.apiseven.com/uploads/2023/01/29/0qU8RQOO_elastic-apisix.png)

ElasticSearch 是一个分布式开源搜索和分析引擎，旨在处理大量数据，在日志分析领域享有极高知名度。
它提供的配套数据面板 Kibana，可以非常轻松的定制出各种统计图表，满足组织对于可视化查询分析的需求。

实际应用时，由于大多数传统软件的日志都是保存到本地文件，所以 ElasticSearch 生态中有一个项目叫 Filebeat，用于监控本地机器上的日志文件，并将增量的日志发送给 ElasticSearch 服务器。而 APISIX 提供的 `elasticsearch-logger` 插件，可以将 APISIX 的访问日志直接发送 ElasticSearch 服务器，这有几点好处：

- 无需部署 Filebeat 组件，处理链路更短，减少计算资源消耗；
- 日志不落盘，不用考虑日志文件的磁盘占用，因为访问日志的量级可能非常大，如果没有处理好文件的轮转，很容易将机器的磁盘打满，导致故障。此外，与磁盘进行交互也会一定程度上降低网关的性能。

### kafka-logger

网关访问日志有一个很明显的特点：日志的数据量与业务的请求量成正比，请求越多，日志越多。对于大多数在线业务，请求量会存在明显的周期性，比如外卖平台的流量高峰期会出现在餐点附近，而视频网站的高峰期则会出现在下班时间段。
这对于日志存储系统的挑战是巨大的，如何保证系统在流量高峰期依然可以正常工作，是每一个 ElasticSearch 管理员的必修课。

![Apache APISIX And Kafka](https://static.apiseven.com/uploads/2023/01/29/aNv4oh2Q_apisix-kafka-es.png)

消息队列是处理“削峰填谷”场景的不二法器，在网关与存储系统之间引入消息队列，提供日志缓冲区，将会极大的降低存储系统在流量高峰期的压力。
为此 APISIX 提供了 `kafka-logger` ，它可以将访问日志投递到 Kafka 服务器，避免对日志存储产生直接的冲击。

### loggly

近几年 SaaS 的概念逐渐深入人心，它凭借极低的接入门槛和按需付费的计价模型被众多中小型企业所青睐，在日志分析领域也涌现了诸多 SaaS 产品，Loggly 凭借着丰富的日志来源和分析手段成为其中的佼佼者。
在此背景下，活跃的 APISIX 社区开发了开箱即用的 `loggly` 插件，只需要配置好凭证信息，就可以将 APISIX 访问日志直接发送给 Loggly 服务，十分方便。

类似 `loggly` 插件，APISIX 还提供了 `google-cloud-logging` 、`sls-logger` 、`tencent-cloud-cls` 插件，可以轻松集成主流云厂商的日志服务。

![Apache APISIX Log SaaS](https://static.apiseven.com/uploads/2023/01/29/LnOhd04T_apisix-log-saas.png)

### error-log-logger

上面介绍的插件都是用于收集访问日志，在 APISIX 中还存在另外一类日志：错误日志（error.log），它对于排查网关自身故障非常关键，所以 APISIX 提供了 `error-log-logger` 插件 ，用于将错误日志发送到远端服务器进行存储分析。实际使用时，可以结合 APISIX 的日志等级配置，让网关打印出更多 debug 或者 info 级别的日志，这两个级别会包含更加详细的网关运行状态日志，利用这些日志通常可以定位出绝大多数问题。

## 总结

网关日志蕴藏着巨大的价值，从 Apache APISIX 项目丰富的日志插件中我们也可以看出，社区中的企业用户对于网关日志价值的肯定，而这些插件也进一步降低了新用户搭建日志系统的成本。
此外，APISIX 还有另外两类可观测性插件：`metrics`、`tracing`，它们配合上日志插件将会进一步提升网关的可观测性，助力系统稳定性建设。
