---
title: "智慧交通系统网新电气，如何基于 APISIX 迭代数字智联平台"
author: "沈巍"
keywords: 
- 用户案例
- 开源
- APISIX
- 浙大网新
description: 在城市智能交通的覆盖范围下，很多场景对于流量处理和系统稳定性都要求极高。为了应对这种城市级别的数字智能要求，网新电气基于 APISIX 进行了网关层面的迭代。
tags: [Case Studies]
---

> 在城市智能交通的覆盖范围下，很多场景对于流量处理和系统稳定性都要求极高。为了应对这种城市级别的数字智能要求，网新电气基于 APISIX 进行了网关层面的迭代。

<!--truncate-->

> 分享嘉宾沈巍，浙大网新研发总监。

网新电气成立于 2011 年，属于浙大网新旗下，为绿色智慧交通系统解决方案的提供商。业务范围包括铁路、隧道、城市智能交通、航空、高速公路等行业。整个高铁信息化的业务分布占到了全国市场的 20% 以上，比如参与建设了杭黄铁路、合肥南站等客服信息化系统；杭州文一路隧道、杭州紫之隧道等监控系统；首都机场物联网平台、数据交换平台等系统。

在城市智能交通的覆盖范围下，很多场景对于流量处理和系统稳定性都要求极高。为了应对这种城市级别的数字智能要求，对于基础架构的组件选择也是重中之重。本文将从数字化平台应用的角度，带来与 API 网关 Apache APISIX 的相遇相熟和应用，希望对仍在网关选型过程中的企业或用户有所帮助。

## 数字大桥智联平台应用场景

![网新数字大桥智联平台](https://static.apiseven.com/2022/12/09/639293149c4bc.png)

在数字领域的业务实践中，我们打造了网新数字大桥智联平台。数字大桥智联平台是一个非常庞大的交通领域管控系统，涵盖了整个交通领域比如结构化安全、病害检测、日常维养巡检、数字孪生与建模、交通应急指挥以及各类评估算法等等。

下图为网新数字大桥智联平原本的架构模式，整个系统主要分为四个部分。

![架构模式](https://static.apiseven.com/2022/12/09/63929314aa6c5.png)

最底层属于采集层，主要负责采集各类数据。目前采集数据的种类比较多，比如温度传感器会采集到路面的一些温度；结构层面的力学传感器会检测震动数据；GPS 传感器则会采集位移情况；无人机监测路面状态等等，所以整体监测类型的数据量也是非常大的。

在此之上，在中间层我们还构建了一个数据中枢，它可以把所有的业务数据都汇总到一起，然后再提供业务的 API 给各个业务系统使用。这个项目最大的一个特点，就是参与的公司很多（大概 30+），这些公司都会参与进来进行各自的业务系统搭建。

在业务层中，需要在同一套用户体系下访问业务系统，主要是给业务用户使用。在实际实践过程中，不同业务系统之间往往存在交叉访问。随着业务系统的增多，整个服务对外提供的 IP 和端口也会增多，一些问题开始应运而生。

### 痛点与现状

随着实践的增多，我们发现上述架构开始呈现如下问题：

1. 不同系统之间 API 鉴权各异，大量重复开发；
2. 不同系统对 API 的安全管理程度不同；
3. 缺少统一的 API 路由；
4. 缺少统一 API 监控等。

基于上述需求痛点，引申出了一个结论方向：即我们需要构建一个 API 网关。API 网关对于我们现阶段的系统而言，是一个刚需的组件。在这个过程中，我们也开始考虑如果引入 API 网关后会有什么优点。

![引入 API 网关后](https://static.apiseven.com/2022/12/09/63929315c57c8.png)

比如之前整个业务系统会暴露大量的服务端口，因为系统很多都需要暴露到外部去使用。引入 API 网关后，或许整个系统可以只暴露一个 443 端口，其他全部在内网访问即可，这样整个系统的安全性就更高。

其次 API 鉴权如果都放到 API 网关来做的话，那整个功能的实现就非常简单了，同时还降低了各个业务系统之间互相调用的开发工作量，避免重复开发。同理对于 API 的路由和监控也一样，都可以让整体业务更好地管理。

最后就是内网如果走 HTTP 的话，性能其实会更好。因为之前架构中，各个业务系统之间的互相调用，为了保证安全性所以选择了 HTTPS 模式，在一定程度上影响了整体性能。
所以总体来看，加入 API 网关这个组件，对于我们整体业务的提升是比较明显的。

## 网关层为何选择 APISIX

### 自研初尝试

在选型 API 网关之前，其实我们自己也尝试过一些操作。因为整个团队对 Java 技术栈和 Spring 框架都比较熟，所以就选择基于 Zuul 开发了一个 API 网关使用。当时这套网关对于 HTTP 场景也基本够用。随着后续继续使用，就有新的需求开始产生。比如：

- 需要对 WebSocket 的鉴权进行支持。很多实时类的告警信息需要通过 WebSocket 进行推送，如果需要支持这类信息，还需另行开发；同时 Zuul 对 WebSocket 的支持性不是很好，想要对 WebSocket 进行鉴权更是难上加难。

- 需要路由支持 HLS 和 FLV 等流媒体协议。由于本身业务实践场景中，对于视频处理的需求比较大，尤其是面向 ToB 和 ToG 的业务场景，视频监控是一个很重要的系统。因此如果视频处理走网关的话，就需要支持 HLS 和 FLV 流媒体协议（两种都基于 HTTP），同时视频对于延迟性和流量要求都是很高的，对网关压力极大。

- BIM 模型展示，基于 3D Tiles 协议需要在短时间下载数 GB 的数据。在前文提到的数字孪生场景下，BIM 建模非常火。因此整个模型体量是非常大的，大概几百个 G 。尽管 3D Tiles 协议支持动态加载能力，但是在短时间内需要完成的流量依旧很庞大，对于网关来说压力就更大了。

- 路由需要动态加载，即时生效。在动态加载层面，Zuul 没法满足我们即时生效的需求。即便是我们进行二次开发，也会加大额外的工作量，同时还并不能保证可以完美地实现这种效果。

### 调研选型主流网关

在自研道路上跌跌撞撞之后，我们开始对市场中主流的网关产品进行调研。当时我们调研了以下几个网关，调研完之后发现每个产品各自的优缺点都比较明显，但是都不能很好地契合我们的场景。比如 NGINX 无法做动态路由，Java 技术栈相关的性能又跟不太上等。

![选型优先级](https://static.apiseven.com/2022/12/09/6392931701477.png)

调研之后，我们并没有找到适合自己的产品，也一直都在观望和困惑中。但后来在选型过程中，无意间看到了由开源中国举办的 「2021 年年度中国开源项目」评选活动。因为我觉得这里面肯定有很多优秀的项目，于是抱着学习的心态就一个个点进去了解了一下，然后就看到了 API 网关产品 —— Apache APISIX。

![2021年年度中国开源项目](https://static.apiseven.com/2022/12/09/63929313912bb.png)

后来跟随 APISIX 的各种介绍，包括 GitHub 上的提问、社区官网上的技术文档以及 B 站上的一些用户案例和技术实践分享等等，我发现整个社区都非常有活力。比如在 GitHub 上有接近 3600 个 issue 而且已经解决了 3200 个左右，解决率高达 89%，这个数量占比还是非常可观的；同时有些社区反馈渠道也允许中文提问，这对于中国开发者而言非常友好。

同时 Apache APISIX 项目在全网有较多的参考资料。APISIX 社区在 B 站和 Youtube 上都有非常多的视频分享，包括用户案例和一些技术 tutorials（教程）。我曾经花了两天时间把 APISIX 的 B 站视频全都看了一遍，这个过程中我发现有很多企业类似的案例都跟我们的需求场景很类似，包括一些实践过程中踩的坑。这些对于我们而言，很多是可以直接拿来借鉴的真实经验，对于后续的架构更新有非常高的价值参考。

这些细节，都让我们对于产品的后续使用有了十足的安全感，最终我们选择了将 Apache APISIX 作为 API 网关进行后续架构和业务的迭代。

## 应用 APISIX 的业务实践

### 让 Kubernetes 中部署更可靠

![在 Kubernetes 上](https://static.apiseven.com/2022/12/09/6392931729609.png)

目前我们是将 APISIX 部署在 Kubernetes 上使用，整个用户侧的业务系统都是先经过 API 网关，然后再由 API 网关在路由上分发到各个业务服务，中间都是通过内部域名进行传递。
在高性能的体现上，我们采取了 Kubernetes 多实例的方案。比如说性能要求好，就可以给它配 10 个实例；性能要求差一些，就配 5 个实例。

同时域名也是我们很在意的点。因为按照前文所提到的预想规划，我们只希望暴露一个 443 的端口出去，其他都通过 Kubernetes 内部的域名进行整体服务的运转。在刚开始使用 APISIX 时我还有些担心，万一它只支持 IP 地址跟端口，那就很麻烦了。

后来经过测试发现效果也非常好。如下图左侧为 APISIX Dashboard，右侧是服务域名（Kubernetes 服务域名）。这里就可以直接配置 Kubernetes 的域名+一个端口，这样就可以直接完成域名的转发。这对整个系统的可靠性跟安全性都有了非常强力的功能支持。

![APISIX Dashboard](https://static.apiseven.com/2022/12/09/639293138baeb.png)

### 自定义服务轻松对接鉴权

单点登录与鉴权也是我们业务系统中非常重要的一部分。因为我们有大量的业务和用户需要进行管理，所以这一块肯定是由各自业务系统进行的，因此我们也自研了单点登录服务。

由于自研服务系统，所以相关 token 并不通用，其中就会携带一些业务特定的自定义信息。因此我们也害怕自己的 token 无法被 APISIX 鉴权相关功能所识别，因为 APISIX 提供的 token 是我们内部无法使用的。

![服务鉴权](https://static.apiseven.com/2022/12/09/6392931354abd.png)

但在后续的实践过程中我们发现，这种想法是多虑的。在实际生产过程中，只需把我们业务的 token 生产加密算法与 APISIX 的加密配置保持同步，就可以利用 APISIX 实现完整功能的鉴权。如上图所示，自研服务产生的 token 通过 APISIX 的 jwt-auth 插件完成了一整个服务鉴权。

### 针对业务的 etcd 处理

作为 APISIX 架构中的重要组件，etcd 对于我们的研发团队来说确实是一个挑战。由于本身对 etcd 并不熟悉，所以我们在 Kubernetes 环境中部署 etcd 集群折腾了很久。虽然在学习成本上有些折腾，但也意外发现了一个惊喜。

我们发现，APISIX 在 etcd 宕机后，非重启情况下还可以正常工作。等 etcd 恢复后， APISIX 会自动重连。基于此，我们提出了一个更贴合实际业务场景的方案。

因此我们放弃了配置 etcd 集群，而是只配置了一个 etcd 用来支撑整个 APISIX。只需要把 etcd 的数据备份好，重启完 APISIX 也能正常连接运作。实际运行起来的效果也是很不错的，至少对于我们的业务场景是够用的。同时因为 etcd 只部署了一个，所以后续的运维工作量也减少了很多。

### 开箱即用的 API 监控

对于我们的业务来说，是属于强依赖于系统集成的项目，因此业务系统之间互相调用 API 的环节就非常多。如果某些系统之间的调用 API 出现了问题，就会导致不同业务部门互相扯皮。为了应对这种环节，就需要有相应的监控系统进行排查。

APISIX 官方其实已经提供了一套完整的监控解决方案「APISIX+Prometheus+Grafana」。利用自带的 prometheus 插件，可以非常方便地与 Prometheus 进行集成，并实现请求状态码、实时带宽、etcd 可用性、TCP 连接指标和节点等信息的监控和管理。

![监控页面](https://static.apiseven.com/2022/12/09/63929319077ae.png)

依靠 APISIX 这套监控方案可以很容易地定位出哪部分调用 API 出现了问题，进行快速定位，避免了各业务系统之间集成对接时所产生的一些问题。

## 总结与展望

总体来看，我们接触 APISIX 的时间并不算长。2021 年 10 月份刚知道这个产品，在测试和需求检验等角度折腾了两三个月后，开始尝试部署到生产环境中，现在也是随着官方版本的更新逐渐迭代。

从我个人角度和业务运行的体验来看，APISIX 作为网关已经是一个很成熟的产品了。在使用的这段时间里，也逐渐从对这个产品的各种担心到真正上手后的惊喜回馈：

- 一开始曾担心配置上游时，无法使用 Kubernetes 的服务域名；使用过发现，原来完美支持服务域名访问。
- 基于 APISIX 实现了业务高可用方案，依赖 Kubernetes 云平台实现多实例+自动伸缩+健康监测+预警告警等功能。
- 对于系统集成项目，APISIX 完美解决了 API 的管理、 鉴权、路由问题。
- 其配置的热更新特性，极大避免了“因为更新导致服务无法正常访问”。
- 作为一个开箱即用的网关产品，让开发人员可以更专注于业务代码。

当然，在实践过程中，我们也基于这些操作提出了一些业务层面对于 APISIX 的功能需求，比如：

- 能否支持除 etcd 外的其他数据持久化方式，比如 MySQL、PostgreSQL 等。可让我们在熟悉的数据存储领域能够更好地应用与排查问题；
- APISIX Dashboard 能否支持一键数据备份与还原。

整体来看，在使用 APISIX 的过程中，对于开发人员的学习成本可能高了一些，但是产品服务于业务中所体现出来的整体效果是完全惊喜的。后续我们也计划在更多系列的业务产品中引入 APISIX，作为网关组件让我们的业务产品可以发挥更稳定更高效的价值。
