---
title: "琚致远：95 后 Apache Member 的成长之路"
authors:
  - name: "饶雅惠"
    title: "Author"
    url: "https://github.com/EstelleRao"
    image_url: "https://github.com/EstelleRao.png"
keywords:
- Apache APISIX
- API 网关
- ASF Member
- Apache Member
- 开源
- 远程
- web 全栈工程师
description: 2022 年 3 月，Apache APISIX PPMC 成员琚致远入选 Apache Member 和中国开源码力榜。Apache APISIX 社区邀请了致远聊聊他的开源经历和技术成长之路。
tags: [Community]
---

> 2022 年 3 月，Apache APISIX PPMC 成员琚致远（GitHub ID：juzhiyuan）入选 Apache Member 和中国开源码力榜。Apache APISIX 社区对此表示祝贺，也邀请了致远做客访谈，聊聊他的开源经历和技术成长之路。

<!--truncate-->

## 导语

**琚致远（GitHub ID：juzhiyuan）于 1997 年出生，2019 年 10 月成为 Apache APISIX PPMC Member，2022 年 3 月入选 Apache Member 和中国开源码力榜。他是开源软件商业公司 API7.ai 的 Global Team Leader，也是 ApacheCon Speaker、OSPP Mentor、GSoC Mentor、（2019 年之前）freeCodeCamp 中国核心组织者之一。**

![ASF Members](https://static.apiseven.com/202108/1651198214277-8bb73696-dbe0-4e24-b0b9-2bb65e1abbfd.png)

他小学开始接触电脑，学习 Flash 技术；初高中自学 Web 渗透，爱上黑客文化，向往成为一名乌云白帽；大学加入 freeCodeCamp 社区，成为 Web 技术的布道师、引路人，从此和开源结下不解之缘。毕业后，他成为开源社区的深度参与者和 Apache APISIX PMC 成员，广泛参与活动，对外讲述自己的开源经历、技术成长经历，传播开源文化和 Apache 文化。

**他说他是个极客，敢想敢做，不被条条框框束缚，所做的一切只是因为热爱，因为追求真理。他说每个开源项目的背后都有一个开源社区，开源精神在于我们有想法，我们想实现出来，公开出来，邀请更多的人参与进来。他说他很开心在技术学习、开源参与这条路上能为后来人提供力所能及的帮助，自己成长的前提是身边的朋友一起成长。**

作为 Apache APISIX PMC 成员，致远为 Apache APISIX 所做的贡献有目共睹。如今，他加入 Apache 软件基金会，成为 Apache Member，在开源这条路上走得更远。Apache APISIX 社区对此表示祝贺，也邀请了致远做客访谈，聊聊他**从接触开源到拥抱开源、贡献开源的经历，以及个人的技术积累和成长之路**。

![Open-Source Experience](https://static.apiseven.com/202108/1651201975732-aaafd882-b1ca-4bd3-945f-2eeb3aa72911.png)

## 开源经历

**Apache APISIX 社区：你从什么时候开始接触计算机，学习编程？**

**致远**：这得从我小时候说起。2003 年，我叔叔在中关村给我拼了一台主机，所以我接触计算机比较早，一开始喜欢玩些小游戏，后来会玩魔兽争霸等大型游戏，玩跑跑卡丁车，看大长今、哆啦 A 梦等电视剧。2008 年以前，我接触到了 Flash，因为我姑姑学过 Flash，会做动画，她的作品在网络上被河南豫剧节目选中了。我当时觉得非常酷，想学 Flash，缠着我妈买教程。说实话，我现在做的事情和做事方法受家人的影响很大。虽然家人有时会拿自己的经验套在我身上，但我比较固执，他们也会支持我。

后来我 QQ 被盗，为了拿回我的帐号，我发起了申诉，了解到黑客、木马、钓鱼等概念，找到了黑客基地等安全圈子熟知的论坛和相关的在线教程。如获至宝的我从此沉浸在黑客技术学习之中。那时的我并不知道有些行为是错误的，只知道黑客技术让自己有了超能力，除了打游戏，还可以社工、做木马、盗取 QQ 账号密码。为了检验技术，我还渗透了一些网站，如果发现网站有漏洞，我会告知网站的管理员。有一次我在渗透的网站上留了 QQ 号，我觉得这样做很酷。后来网站管理员联系到我，知道我是学生后，让我不要再做类似的事情。这是第一次有人告诉我这种行为是不对的。  

后来我了解到 WooYun 社区，被这群可爱的白帽子深深吸引。2016 年之前，乌云是一个非常棒的白帽子聚集地，撑起了中国网络安全的大半边天。大一时，我参加了乌云峰会。当时，我特别想加入这帮极客，成为其中一员，交流和学习技术，但最终没有通过加入门槛。在之后循序渐进的自我学习中，我能分辨白帽和黑帽了，能判断行为的对错。

![Homepage of the WooYun Website](https://static.apiseven.com/202108/1651198239470-d23346d4-efeb-46ff-81d3-d80a7511488a.png)

**Apache APISIX 社区：后来是因为什么契机接触开源、参与开源？**

**致远**：进入大学后，我了解到一个非盈利的、在线教授 Web 编程的平台 freeCodeCamp，以帮助世界各地的人们免费学习编程为使命，推动教育公益的发展。freeCodeCamp 的创始人是外国人，2015 年，成都的 Miya 把它引入到中国，开始在中国建立 freeCodeCamp 中国社区。现在，成都、深圳、杭州等国内多个城市都有 freeCodeCamp 的组织者，这些组织者不管在当地，还是在国内的圈子里都比较有声望，比如上海的组织者于航，他曾是饿了么的前端负责人，现在是 PayPal 的高级软件工程师，技术能力强，为人友善，性格活泼。通过 freeCodeCamp 社区，**我结交了更多朋友，逐渐打开了交际圈**。大家相距甚远但同在一个圈子，同在一个更大的社区，认识了他们，我去到每个城市都不会感到陌生。

因为 freeCodeCamp 是开源项目，连续多年都是 GitHub Top 1 的项目，有几百 K 的 Star，我会改 Bug，提交 PR，**很有成就感**。通过 freeCodeCamp 平台，我们也**吸引了很多技术爱好者，帮助他们从 0 到 1 学习技术**。在这个过程中，我也**形成了自己的做事方式**，不管是教人学习 Web 还是带人 On Boarding，都**沉淀了一些可持续的指导经验**，这也是我后面敢带其他人的原因。带他们上岸后，我会继续引导他们去带更多人。这是一个**良性循环**的过程。虽然做这些事情付出了很多时间，看似没有任何直接的物质收益，但却给我带来了很多精神上的收益和潜在收益，比如个人影响力有慢慢地提升，收获的感悟和形成的做事方式还在影响着我的现在和未来。

在大学期间，我持续参与了各种社区和技术分享，学习技术，分享技术，实践项目。因为热爱，我坚定走在 Web 技术学习这条路上，同时也不忘鼓励身边的朋友一起学习。我们会在宿舍、在学校机房举办计算机相关的活动，一起做项目，也会去其他城市的学校给同学们做分享。几年下来，我积攒了很多项目经验，拓展了技术栈，但是我发现重复做外包项目虽然可以带来暂时性收入，但不利于个人技术的成长。我意识到在开发过程中使用的开源库代码质量高，协作流程规范，我便开始学习开源项目的代码，关注开源社区的动态。毕业后，我接触到了 APISIX 开源项目，我就参与进来了。

![Zhiyuan's Resume Written in 2018](https://static.apiseven.com/202108/1651202016764-e461af74-7aca-466d-8824-e823195fc24f.png)

**Apache APISIX 社区：在 [Trillions and Trillions Served](https://www.youtube.com/watch?v=JUt2nb0mgwg) 视频里，Apache 软件基金会的创始成员 Jim Jagielski 在分享“什么是开源”时提到，“于我而言，参与开源是出于对古老的黑客文化的认同。开发者、贡献者都是艺术家。在我看来，所有的艺术家都乐于分享成果，喜于和志同道合的人协作，专注于磨练技能。”你初高中接触到黑客群体，大学接触到开源社区，你如何理解黑客精神、开源精神？在你看来，黑客文化和开源文化之间有何承继关系或有何渊源？**

**致远**：在我看来，真正的黑客不是带有贬义色彩的“骇客”，不会怀揣着恶意去破坏或侵入别人的计算机系统。**真正的黑客是一群敢想敢做的极客，他们信奉自由主义，不被条条框框束缚，他们所做的一切只是因为热爱，因为对真理的不懈追求**。我自认为我是个典型的极客，遇到问题则解决问题，见招拆招。

至于黑客和开源的渊源，我觉得乐于分享、追逐极致的精神在黑客和开源贡献者身上实现了完美的融合。典型的代表有 Linux 操作系统和 Git 版本控制系统的作者 **Linus Benedict Torvalds**、前端技术大牛 **TJ Holowaychuk**、前端框架 Vue.js 的作者**尤雨溪**。

Linus 的极客表现在他会把自己的想法付诸实现，还会把成果开源出来。他做 Git 的初衷很简单，因为代码在不断地迭代，他希望有一种方式能管理代码，做版本管理。尽管 Git 和 Linux 已有庞大的拥趸，被全球用户广泛使用，创造了难以预估的价值，但 Linus 没有借此盈利，项目仍在开源。

第二位同时体现了黑客精神和开源精神的技术大牛是 TJ。2015 年，我开始了解到他，他在前端圈子里很火，做了很多 Node.js 相关的工具，2017 年开始写偏后端的 Go 语言。Go 是比较适合云原生时代的编程语言，我在 2019 年才听说云原生的概念，但他在 2017 年就已经开始捣鼓这些东西了，而且他的技术都是自学的，他最开始的背景是一位设计师。

第三位极客是 Vue.js 的作者尤雨溪。他原本是 Google 的设计师，没有学过代码。写 Vue.js 是因为他找不到一个比较简洁的前端框架，于是 2015 年或者更早一些，他开始创造自己理想中的前端框架。当时这个项目只是一个很小的开源项目，没有什么人气，但 2017 年前后，一跃成为全球 Top 3 的开源框架。他从设计师转变为前端工程师，再到独立开源开发者，在开源框架中融入了他细腻的设计理念、艺术理念，最终贡献了一个小而美、高效好用的开源项目。Vue.js 的文档等配套周边也非常友好，社区也很活跃，完全是靠社区驱动。  

其实**每个开源项目的背后是一个开源社区，开源精神在于我们想实现自己的想法，把它做出来，公开出来，邀请更多的人参与进来**。在 GitHub 上有很多像尤雨溪一样的独立开发者，他们有了一个好的想法，会把它做出来，开源出来，Star 数多了，关注的人多了，个人的影响力自然也会越来越大。

关于黑客文化，我还想给大家推荐一本书——**《黑客与画家》**。《黑客与画家》的英文版出版于 2004 年，十年后，由阮一峰老师翻译成中文，于 2013 年出版，而后再版。中文版一经上市，即在国内 IT 业界、学界引起了巨大的反响，得到了广泛的肯定。这本书是硅谷创业之父 Paul Graham 的文集，主要讨论了黑客文化、黑客成长、黑客对世界的贡献、黑客的工作方法等话题。  

阮一峰老师在再版序言中写道，“在我看来，《黑客与画家》能吸引 10 年后的读者，主要有两大原因：第一，**他写的不是技术，而是技术背后的思想**。就像数学一样，正确的思想不会过时。第二，**他的着眼点是长远的未来**，不是分析现状，更不是总结过去，而是展望未来，以未来指导现在。比如第 11 章《一百年后的编程语言》就是研究一百年后人们会怎么编程，从而推导出我们现在应该如何编程。”

**Apache APISIX 社区：2019 年 7 月开始为 APISIX 开源项目做贡献，同年 10 月 APISIX 进入 Apache 孵化器。项目毕业后，你成为了 Apache APISIX PMC 成员。一路走来，你是如何让自己快速提升？做了哪些尝试？**

**致远**：毕业后，我关注到 APISIX 开源项目。因为它是一个纯开源的项目，而且是一个纯服务端的应用，我觉得很酷很有趣，就参与进来了。APISIX 刚开源时还没有捐给基金会，温铭联系到我，问我能不能帮 APISIX 做一个 Dashboard 控制台。其实我不太了解这方面，但又想尝试，于是就做了第一个版本。第一个版本比较粗糙，但具备 Apache APISIX 的核心能力。

![Apache APISIX Dashboard V1.0](https://static.apiseven.com/202108/1651198249692-cb1180ee-b23d-4b40-86a8-ccae475534f8.png)

后来这个项目捐给了 Apache 软件基金会。因为我参与项目比较早，项目捐给基金会后还在孵化中，所以我们最早的这批人就直接选入了 PPMC（Podling Project Management Committee，包括 ASF Mentors 和 Initial Committers，Podling 指孵化中），有了 Apache ID，非常酷。项目毕业后，我们就成了 PMC。

PMC 是项目管理委员会，带有管理属性，需要为项目和社区的现在和未来负责，如果不合格，可能会被投票取消资格。作为 PMC 成员，一个很重要的责任就是要为项目和社区寻找更多优秀的 Committer，为项目和社区注入中坚力量和生命力。在 Committer 的资格要求上，ASF 的官方文档提到**当有 PMC 为贡献者提名时，如果投赞同票的 PMC 成员人数大于投反对票的 PMC 成员人数，则该贡献者可选为 Committer**。选为 Committer 是对贡献者过去所做贡献的认可，但同时每个社区也期望 Committer 未来能为项目的发展继续添砖加瓦。

具体到每个社区，在评选 Committer 时，只要符合 Apache 基金会的流程，每个社区可以根据社区的实际情况和期望，采取不同的实践准则，设置不同的门槛。在 Apache APISIX 社区，无论是代码贡献，还是非代码贡献，只要所做的贡献得到 PMC 成员和社区的认可，即可成为 Apache APISIX 社区的 Committer。

作为 Apache APISIX 的 PMC 成员，我有责任为 Apache APISIX 社区寻找优秀的 Committer。在参与社区的过程中，天然的同理心也会引导我关注社区中的每一个人，主动参与进去、创造故事、传播故事。虽然大部分贡献者都没有见过，但基于 TA 的协作方式、交流内容、交流方式，我能感觉到 TA 对这个事情的理解有多深。就我自己提名 Committer 的实践而言，如果我认为某位贡献者做了很多贡献，我会主动为 TA 提名，在 PMC 成员里，我提名的 Committer 可能最多。

在 2020 开源之夏的活动中，我认识了白泽平，当时我在 GitHub 上放了一个 Dashboard 的议题，泽平申请了这个项目。他最开始贡献的是前端代码，后来他还写了 Go，写了服务端，给 APISIX 提交代码，写插件。当时他还在读大三，潜力非常大，我就提名他为 Committer 了。后面泽平做了越来越多的贡献，在社区、QQ 群、微信群答复问题也非常积极，所以去年年底，我又提名他为 PMC 成员，他成为了 Apache APISIX 年纪最小的 PMC Member。

另一位印象比较深刻的 Committer 是刘曦冉。2020 年 7 月左右，我们在 Dashboard 的项目里认识。曦冉在参与 Dashboard 项目时有非常好的远程协作习惯。她会在 GitHub 上把问题背景描述得很清楚，逻辑很清晰，尽管用英文交流很艰难，她还是会很努力地去做。曦冉修复了很多 Bug，做了很多贡献，发起或参与的讨论都很有价值，所以我就为她提名 Committer 了。后来她为 APISIX 社区带来了更多的贡献者和 Committer，吸引了更多的人加入 APISIX 社区，也做了更多的贡献，我就开始为她提名 PMC 成员。她是我们的第一位女性 PMC 成员，也是我们现在唯一的女性 PMC 成员。

除了泽平和曦冉，社区里还有许多经历、经验、背景各不相同的贡献者。对社区而言，每位贡献者都很重要，社区离不开每位贡献者的支持。

**Apache APISIX 社区：Apache 软件基金会在全球只有 850 多位成员，你觉得你是在哪方面做得比较好，所以得到了认可？**

**致远**：首先，温铭提名我为 Apache Member 有以下几点理由：第一，我是 Apache APISIX 的 PMC 成员，在 Apache APISIX 社区比较活跃。第二，我曾两次以导师身份参加谷歌编程之夏活动，同时也是 2021 开源之夏的导师，帮助过很多大学生参与 Apache 软件基金会的开源项目。第三，除了在 Apache APISIX 社区比较活跃，我在 Apache Community 邮件列表里也很活跃，会积极参与讨论，提供我力所能及的帮助。第四，除了关注开源项目，我也会参加播客的录制和大会的分享，做一些开源布道，让更多人了解 Apache 的文化。

这是温铭提名我为 Member 的几点理由，就我自己看来，我可能在这两方面做得还可以。首先，社区由人构成，除了代码，还需要和人打交道。在和社区小伙伴的沟通协作过程中，我会比较友好，乐于支持和鼓励大家。想起之前有个很偶然的机会，我结识了一位印度小哥 Ayush Das，并鼓励他参与到 Apache APISIX 社区和 Summer 2021 活动。在和他数月的沟通过程中，他在不停地学习新技术，帮助社区解决问题，但由于设备过于老旧，不得不频繁重启，他的开发环境受到了很大影响。在和他多次沟通和了解情况后，我决定赞助他一台 MacBook Pro M1，希望这台设备能够帮助他更有效率地学习。

![Ayush Das's Greeting to Zhiyuan on Happy Teacher's Day](https://static.apiseven.com/202108/1651198269797-6a64d882-5453-41df-bc83-7ef885537348.png)

其次，我会支持并鼓励大家在社区提出自己的想法，无论事情对错，TA 只要愿意提出来，愿意站出来，都是一件好事。作为 Apache APISIX 的 PMC 成员，我会始终坚持 Apache 的理念和原则，坚持 **The Apache Way** 和我们常说的 **Community Over Code**，将其融入到社区治理当中。我们有公开的 Dev 邮件列表，也有 Private 私人邮件列表。在仅有 PMC 成员的私人邮件列表里，我们偶尔会有一些争论，比如“哪位贡献者可以成为 Committer”、“社区里的问题要怎么解决”。在这些场合，有些 PMC 成员会选择沉默，有些 PMC 成员会积极参与讨论，而我就属于积极的讨论派。

**Apache APISIX 社区：在开源贡献或参与开源社区方面，后续有什么计划吗？**

**致远**：我依然会积极参与社区活动，为社区做贡献。还记得 2019 年年末至 2020 年年初，Web 项目的贡献者很少，我就鼓励我身边的人参与进来，这个项目才得以为继。现在这个项目又进入了一个瓶颈期，所以我还需要鼓励更多的开发者参与进来。

加入 Apache APISIX 社区后，我的注意力主要集中在这一个社区。成为 Apache Member 后，我会站在整个基金会的角度思考问题，会承担更多的责任。不仅关注
Apache APISIX 这一个开源项目，还会关注 ASF 的其他项目，包括孵化中的项目和已毕业的项目，和诸位 Apache Member 一起为开源布道，为项目注入活力，提供帮助和指导，期望 Apache 基金会在未来无数个 20 年里依旧常青。

## 个人生活与成长

![Zhiyuan Ju](https://static.apiseven.com/202108/1651198278354-f104ab0a-3939-42c3-b0a9-c2f91bdc3999.png)

**Apache APISIX 社区：我看你在博客和分享中有提到，自己热衷于 Web 技术，正在努力成为一名优秀的 Web 全栈工程师。请问你当初为什么会选择 Web 前端这个技术方向？在成为 Web 全栈工程师这条路上，现在处于什么阶段？**

**致远**：高中课余时间，我一直在做 Web 渗透，也想做 Web 安全。对于 Web 安全，我是知其然而不知其所以然，我不知道 Web 服务是如何搭建起来的，所以我开始学习 Web 的整套理论体系和运作原理。在 Web 学习过程中，我经历了三个阶段，**从最初的茫然、不知所措到以项目驱动、动手实践，再到最后拥抱开源、回馈开源**。

在第一个阶段，对于页面渲染、页面访问的原理和过程，我**毫无头绪**。2015 年高考结束后，我有了第一台 MacBook，便开始通过搜索引擎学习相关教程。到了大学，我开始**以项目为驱动，动手实践，提升技术，拓展技术栈**。我接了各种各样的项目，或单打独斗，或集团队之力。随着项目越来越多，需求变得越来越复杂，接触到的技术栈也越来越多。我在大学接到的第一个项目是全栈项目，帮学生处开发一套内容管理系统，需要独立负责需求、设计、前端、服务端、数据库。通过不断地学习、尝试、踩坑，我最终完成了这个项目，也实践了所学内容。

到了大四，我**接触到了开源项目，并开始关注开源社区**。因为我是自学 Web 技术，所以绕了许多弯路，没有体系化地学习 Web 技术。重复做外包项目虽然可以带来暂时性的收入，但不利于个人技术成长。偶然的一次思考，让我意识到在开发过程中使用到的**开源库代码质量高、协作流程规范**。因此我毅然把大部分时间投入到**学习开源项目代码、关注开源社区动态中**。

虽然 Web 全栈涉及前端、后端、需求、设计、测试等各种能力和活动，但没有一个具体的指标可以衡量一个人是否拥有全栈能力。就当初定下的这个小目标而言，我觉得我已经达成了。至少面对任何需求，我会表现得更加从容淡定，内心会更加坚定，自信自己可以基于已有经验做前后端的技术选型，可以给出最终的方案。

**Apache APISIX 社区：阿里云创始人王坚博士在 ArchSummit 全球架构师峰会上提到，“只有这个世界的挑战离年轻人更近，未来才会离我们更近。“你如何理解这句话？**

**致远**：当时王坚博士说完这句话后，我的第一印象是我要继续帮助更多的人，帮助更多身边的人。那时，我在 freeCodeCamp 比较活跃，除了线上邀请世界各地的朋友学习编程，也会在学校机房里举办一些计算机活动，带同学、室友学习 Web 技术，其中就有我隔壁宿舍的大学同学孙毅。我们在大学做了很多项目，后来他也是加入了 Apache APISIX 社区，加入了我现在的公司 API7.ai。  

记得有一次，我和孙毅还专门给一所江苏学校的几千名同学在线讲课。这个活动是科大讯飞组织的，当时还有点紧张，我们找了个酒店，特意准备了很久，分享了一个多小时。

**Apache APISIX 社区：参与开源项目往往是远程工作，你也很早就开始远程工作了。你是如何看待远程工作和自由职业的区别？**

**致远**：大二时，我在想毕业后一定要从事自由职业，而不是远程工作，但当时我没有搞清楚这两者的区别。

2018 年，我以交换生的身份在法兰克福待了半年。当时我有了第一份正式的远程工作，每个月会有一笔收入，体验非常好。出国前，在学校里接的各种项目其实也算远程，双方提前约定好 deadline，到点交付成果，工作比较自由。回国后，我在网易工作了一段时间，离开后又加入了一家美国的公司——Team 247，继续远程办公。 那是我第一次强烈地感受到 remote work 和 freelancer 的区别。Team 247 要求我们保持 Slack 通信，要响应得非常及时，这让我感觉不太自由，有点受限制。

后来我来到了现在的这家公司，在远程协作方面会有一些要求。最开始我会比较抵触，因为我来公司比较早，刚开始规模比较小，没有这么多要求。但和大家聊过后，我慢慢理解了公司在远程协作方面的考虑，因为国内整个行业还没有形成一个很好的远程办公环境，无论是工程师还是其他岗位的同学，还没有养成很好的远程办公习惯，所以公司会通过远程办公相关要求来帮助大家养成良好的远程协作习惯。

在以往的远程工作经历中，我发现大家在远程协作中普遍存在两个明显的问题。第一个问题是**大家潜意识里会被条条框框约束，不敢问，不敢说**。举个例子，在远程协作时，大家可能会有这些想法——“我需要技术同学的帮助，但我不知道对方忙不忙，我 @TA 合不合适”，“我是一个实习生，我 @TA 合不合适”，“我问的问题会不会太蠢”。其实我们不用顾虑这么多，只管大大方方请教，没人会在意这些细枝末节。而且大部分支持远程办公的公司都提倡"**Remote First**"，在远程协作中，沟通很重要。

第二个问题是大家还没有完全养成 **Document Anything 的习惯**。Document Anything 是很多 Remote First 的公司普遍提倡的做法，这也是我带领的 Global Team 把事项写进邮件列表的原因。一方面，如果有人员变动，至少后来人可以看到 Global Team 从刚搭建到现在的整个过程，了解大家做过什么事情，当前在做什么事情和当前的进展。另一方面，如果每次都是口头交流，没有文字记录，会导致信息流通、新人上手的成本非常高。所以在日常工作中，即使是面对面沟通，只要不是私事，我都会在公开渠道表达，这样既可以溯源，也可以尽可能地覆盖到更多的人。

**Apache APISIX 社区：远程工作需要工程师有较强的自我驱动力。在远程工作中，你如何保持自驱力？**

**致远**：首先，我们是一个创业公司，所以会有很多事情要做。其次，我早上醒得比较早，一般 5 点就会自然醒，醒后便开始计划一天的工作。我喜欢清晨独处的几个小时，可以安安静静地做很多事情，效率非常高。往往大家开会前，我已经处理完了今天的所有工作，所以下午偶尔会看看书，稍微放松一下。但大部分时间，我还是会和公司的同事保持同样的节奏。既然早上已经忙完了，下午可以再多做一点，多想一点。因为对我来说，事情真的是永远做不完。

**Apache APISIX 社区：你如何平衡工作和生活？进行两种模式的切换？**

**致远**：在工作和生活方面，我正在逐渐平衡它们的关系。从 2020 年到现在，我平均每天有 13 个小时在工作。从我来公司的第一天，我就说我是来创业的，所以我会投入非常多的精力。在这十多个小时里，我的效率会非常高，因为我知道我要做什么，我要优先做什么，我也知道这个问题该怎么解决。

从 2020 年末，我开始做公司内部的一些管理工作，今年开始带领我们的全球化团队。虽然我们的流程制度还在不断完善，但整个团队走在一个正确的轨道上，以目标为导向，用数据来验证，协作沟通越来越顺畅。所以到了月底，我应该也会休息一段时间，慢下来，充充电。

过去两年，我在不停地处理公司内部的事务，从这个月开始，我会报名参加活动，做更多对外的分享，分享 Apache 文化、Apache APISIX 开源项目、开源社区。

**Apache APISIX 社区：除了工作以外，平时生活中会关注哪些领域的东西呢？**

**致远**：我把当前的工作看成一个事业，也是一个兴趣爱好。而且创业本身很有趣，我现在负责公司的 Global Team，团队内有很多外国同事。

我也会关心教育公益，比如参与或组织 freeCodeCamp 的活动，鼓励并帮助身边的人学习计算机、学习技术。我认为**自己成长的前提是身边的人一起成长**。能帮助他们通过自己的手艺实现自己的想法，这是一件很酷的事情。虽然我现在个人精力有限，但是我会鼓励我 Mentor 过的同学带新人，帮助新人学习 Web 技术。

有时我也在想，如果我不干这行，我会做什么。我的博客签名是「**用魔法打败魔法**」。我觉得化学是一种很神奇的东西，小时候参加过巴斯夫小小化学家活动，知道著名化工企业巴斯夫在用化学改变生活。我对自然、生物也比较感兴趣，看过很多宇宙、自然相关的百科全书。  

大学期间，我还玩过无人机，和小伙伴们一起航拍学校，再用 Minecraft 复刻成视频，Bilibili 上有这个视频（[河南师范大学宣传视频](https://www.bilibili.com/video/BV1As411a7Mc?from=search&seid=7847808159839607455&spm_id_from=333.337.0.0)）。我们也会拎着无人机在泰山山顶拍日出，帮家乡拍各种视频，帮学校直播各种活动。

## 写在最后

致远有长期写作的习惯，平常会在博客里分享他最近的一些思考和感悟。在活泼写实、内容丰富的随笔中，我们可以看到一位朝气蓬勃的年轻人在开源、技术、工作、生活中的成长轨迹。如果大家想了解更多关于致远的故事，欢迎关注他的[博客](https://wineso.me/)和 [GitHub 主页](https://github.com/juzhiyuan)。

期待致远后续更精彩的表现，让我们一起关注这位年轻人在开源、在技术上的不懈探索和努力。
