---
title: "APISIX 在众安保险的应用实践"
author: "Sylvia"
authorURL: "https://github.com/SylviaBABY"
authorImageURL: "https://avatars.githubusercontent.com/u/39793568?v=4"
keywords: 
- API 网关
- Apache APISIX
- 众安保险
- 互联网保险
- Apache APISIX
description: 本文将通过介绍云原生 API 网关 Apache APISIX 在众安保险的一些使用场景与实践案例，为大家带来关于互联网保险场景下的网关选型与落地操作。
tags: [Case Studies]
image: https://static.apiseven.com/2022/blog/0817/%E4%BC%97%E5%AE%89%E4%BF%9D%E9%99%A9.png
---

> 本文内容整理自 Apache APISIX Weekly Meeting 中众安保险和科技基础架构负责人徐敏带来的相关分享。

<!--truncate-->

众安保险是中国首家和规模最大的互联网保险公司，销售采用全互联网形式进行产品销售，不设线下代理，线上则主要通过自营、伙伴公司网站、渠道等方式获取流量。通过积极提供个性化、定制化和智能化的保险品种，弥补了传统保险公司产品能力的不足。

从业务角度来看技术层面时，为了满足众安保险的复杂业务场景和行业的专有特性，就会对技术侧的流量治理产生了强烈的需求。本文将通过介绍众安保险的一些业务场景与实践案例，为大家带来关于「互联网保险」场景下的网关选型与落地操作。

## 业务场景特点

### 多险种

开头我们提到过，众安保险作为国内第一家互联网保险企业，提供非常多的保险品种，特别是像财产险。财产险的种类可谓是繁多，大家想到想不到的类型可能都会有，比如车险、碎屏险和健康险，还有日常常见的淘宝购物退运费险等等。

基本只要是大家生活中遇到的东西，都有可能会被设计成一种保险产品，所以互联网保险场景下，险种产品之多是其比较有特色的背景。

### 多渠道

虽然说互联网保险的所有操作流程都在线上进行，是典型的互联网+场景。它既有互联网的高频高并发或者说是一些爆款现象，也有像其它的低频低并发场景。但它既有互联网的流量特性，同时也还包含非常多的线下或者传统保险的业务特性。

更准确地说，互联网保险的很多场景入口依赖渠道进行，多渠道使得业务能够进行更多能力的释放。所以对于渠道流量的管理，也是互联网保险在实现业务层面的重要一环。

### 强监管

![强监管](https://static.apiseven.com/202108/1646279054405-a55ded0a-986f-4d49-a927-545999070d65.png)

除了业务领域，作为与钱直接打交道的行业，保险也属于金融的一部分，所以是和银行、证券一样会受到银保监会监督的金融产品，并遵守对应的条款。同时银保监会基本上每年都会针对业务和技术层面提出不同的要求，这些都是要去配合和发展的。

如上图中红色和绿色部分，就属于针对监管渠道或前置业务与核心业务分离的架构方式。在这里对于安全层面也存在一些规范要求，包括两地三中心的治理和针对中间件数据业务的隔离，对流量治理和安全性的要求相对是比较严格的。

## 场景痛点与需求

考虑到真实使用场景，每家公司对于流量治理的层次和需求其实也各不相同。比如有些公司可能相对来讲更希望网关更前置，仅作为边缘网关角色，有些可能希望网关能够处理南北流量或者是东西、南北流量共同治理。

这里从一些共性角度（更贴近众安保险的业务场景）大概整理出了以下几个痛点跟解决方向，即当下业务场景内网关层面的不足以及之后想要弥补的动作方向。

![痛点汇总](https://static.apiseven.com/202108/1646279106033-216d6453-c051-464f-9c17-8f2f3d87a738.png)

而在网关部署的真实场景下，除了上述问题之外，还需要考虑整体业务需求与部署环节中多类型网关的适配。下图展示的是在流量治理过程中的逻辑部署，主要涉及流量网关、微服务网关、统一运营网关、BaaS 网关和域网关。

![逻辑部署](https://static.apiseven.com/202108/1646279112162-1d2e492d-b8a8-44b9-937b-e20fa3c67d58.png)

在梳理清晰当下问题后，众安保险的技术团队开始将网关选型聚焦在一些比较成熟的开源产品之上，开始了新一轮的探索。

## 锁定 Apache APISIX

由于众安保险在选型之初就框定了「开源产品」，所以在评估开源产品的层面，也从企业角度给出了一定的参考标准，并从这些角度给予了 Apache APISIX 最直接的肯定。

![Apache APISIX 评估](https://static.apiseven.com/202108/1646279116675-c10ebbe4-7e7a-49e0-aeb7-6af18568bf5b.png)

当然，除了对开源产品本身角度的评估外，众安保险也对比了目前公司业务中仍在使用的 Kong 和 Traefik，同时也接触了阿里云分享的 MSE 产品等。

最终在以下项目中进行了全面的横向对比，可以看到不管是在企业级的长期规划还是短期规划中，Apache APISIX 都能很好地满足众安的业务需求。

![横向对比细节](https://static.apiseven.com/202108/1646279121377-8f21e5d6-f32f-450b-9445-392a8253dee8.png)

## 基于 Apache APISIX 的落地案例

### BaaS 产品的计量计费

众安保险目前正在业务内部逐步将底层产品 BaaS 化。由于是金融属性，所以对于 BaaS 产品的落地要求会更高，需要将基础架构产品与云产品一样实现统一标准的计量计费。

![BaaS 架构](https://static.apiseven.com/202108/1646279126510-bcfdcab1-7457-4ab6-8331-2a82e65a95d4.png)

因为公司内部用到的所有产品，都需要实现财务报表式的监管要求。因此在这种场景下，就需要实名认证和相关审计功能，这里就需要用到 APISIX 的鉴权模块了。也就是说公司内部的任何调用过程都需要被审计记录，包括调用次数、发生的费用等。所以在这个过程中，Apache APISIX  强大的日志相关功能也是起到了很好的支持。

同时在审计过程中也需要进行峰值审计的计算，这里就会涉及到很多计费公式，这里的计费公式里不仅有调用量，还有峰值等信息。所以基于 APISIX 的功能支持也可以实现相关 Metrics 指标的呈现，从而为计量计费场景奠定坚实基础。

![实现框架](https://static.apiseven.com/202108/1646279130416-c1c161d2-9fbf-4a48-b621-eadfe851c6b0.png)

具体的实现框架可以参考上图，其中配置中心是一个纯七层流量的协议，所以可以完全纳入到计量计费体系中，包括 ES 以及 APISIX 本身等。具体操作主要是基于 APISIX 目前的结构做了一些定义，比如去调用几个针对公司业务的需求，以及使用 APISIX 的一些插件进行相关编排能力的实现。

### 多租户多渠道流量隔离

面对众安保险的多险种多渠道使用场景，多租户多渠道的流量隔离也成为具备行业特征的需求。

而基于 Apache APISIX 的落地实践中，众安也针对多渠道场景下的要求与强管控进行了一些规划。得益于 APISIX 强大的流量编排和插件编排功能，为互联网保险场景下提供了之前从未体验过的流量精密控制效果。

比如有的业务方规模比较大，渠道也很大，就可能会把渠道单独建立一个集群来用；但有些渠道规模较小，可能 10% 的规模是大的，但大部分都很小。基于这样的场景，就可以尝试将这些小渠道融合到一个网关实体或实例里，然后再进行共享。

当然这里就会涉及到每个应用在接入的过程中，因为不同渠道会有不同的上下游去对接，就会产生不一样的域名。基于这种场景的隔离（如下图结构）称之为一级隔离。

![一级隔离](https://static.apiseven.com/202108/1646279134880-2d657934-68ac-40c4-9c29-2ead848ef663.png)

但当渠道对接进来后就需要进行后续相关操作，虽然流程是一模一样但接下来业务的管控能力要求是与上边提到的不同，所以就需要再对渠道进行二级隔离（如下图结构所示）。通过这样的一级隔离加二级隔离模式，就可以很好地解决了网关在多租户多渠道中的流量隔离。

![二级隔离](https://static.apiseven.com/202108/1646279139544-01337e7a-6360-453d-95d9-be3550b864d6.png)

## 后续规划与期望

### 加强跨部门之间的协同

目前众安保险不仅仅只有这一项业务，同时旗下还有非常多的子公司，在后续的推进过程中一定会面临很多这样多部门业务大规模的部署。所以在推进相关技术栈的时候，一定不是只由一个部门去主导，更多的是跨部门之间的共同协作，从而尽早实现 Apache APISIX 在众安的落地部署。

### 基于 APISIX 更新 Nacos 注册中心服务

目前众安保险内部正在基于 Nacos 进行服务的无损上下线，所以在后续规划中会将 APISIX 与 Nacos 对接实现统一管理。这样就可以将微服务通过路由方式对接到 Apache APISIX，达到无损或基于源数据的流量分发效果。当然也会继续借助 APISIX 来完善 BaaS 的相关能力。

### 持续观望服务网格产品

众安保险内部目前是在进行自己平台的服务网格搭建，但因为业务发展迅速导致目前的服务网格运行状态满足不了当下业务落地空间。所以也在持续关注外部的服务网格产品，比如 APISIX Service Mesh，或者是尝试利用 APISIX 与 etcd 的结合方案。

## 总结

纵观众安保险在追求流量治理和一些落地规划执行的过程中，不仅仅是把 Apache APISIX 作为一个边缘网关角色去控制点状流量，更多的则是基于整体架构进行流量的控制。即面向整个 DevOps 的全生命周期，进行诸如测试场景是否能提供测试能力或者多版本开发能力；生产侧提供流量录制、回放能力；大数据部门是否可以生产相关的沙箱环境，来评估更好的模型并进行域环境的隔离等能力。

![总体模式](https://static.apiseven.com/202108/1646279144771-483cfabe-753e-4570-8013-1eedbf88aed8.png)

希望在后续的落地实践中，众安保险可以基于 Apache APISIX 实现整体流量治理的完整落地，助力互联网保险领域的流量管控与安全治理。

:::note

1. 文中架构图涉及到的具体名词全部为抽象理解，非真实环境用词。
2. API Gateway 横向对比部分数据来源于互联网，可能与最新或真实数据存在偏差，不代表官网数据。

:::
