---
title: "Apache APISIX 存在改写 X-REAL-IP header 的风险公告（CVE-2022-24112）"
keywords: 
- API 网关
- 风险公告
- Header
- IP 限制
description: 在 Apache APISIX 2.12.1 之前的版本中，启用 Apache APISIX `batch-requests` 插件之后会存在改写 X-REAL-IP header 风险，现将处理信息进行相关公告。
tags: [Vulnerabilities]
image: https://static.apiseven.com/2022/blog/0818/cve/CVE-2022-24112.png
---

> 在 Apache APISIX 2.12.1 之前的版本中，启用 Apache APISIX `batch-requests` 插件之后会存在改写 X-REAL-IP header 风险，现将处理信息进行相关公告。

<!--truncate-->

## 问题描述

在 Apache APISIX 2.12.1 之前的版本中（不包含 2.12.1 和 2.10.4），启用 Apache APISIX `batch-requests` 插件之后，会存在改写 X-REAL-IP header 风险。

该风险会导致以下两个问题：

- 攻击者通过 `batch-requests` 插件绕过 Apache APISIX 数据面的 IP 限制。如绕过 IP 黑白名单限制。
- 如果用户使用 Apache APISIX 默认配置（启用 Admin API ，使用默认 Admin Key 且没有额外分配管理端口），攻击者可以通过 `batch-requests` 插件调用 Admin API 。

## 影响版本

- Apache APISIX 1.3 ~ 2.12.1  之间的所有版本（不包含 2.12.1 ）
- Apache APISIX 2.10.0 ~ 2.10.4 LTS 之间的所有版本（不包含 2.10.4）

## 解决方案

- 该问题目前已在 2.12.1 和 2.10.4 版本中得到解决，请尽快更新至相关版本。
- 在受影响的 Apache APISIX 版本中，可以对 `conf/config.yaml` 和 `conf/config-default.yaml` 文件显式注释掉 `batch-requests`，并且重启 Apache APISIX 即可规避此次风险。

## 漏洞详情

漏洞优先级：高

漏洞公开时间：2022 年 2 月 11 日

CVE 详细信息：https://nvd.nist.gov/vuln/detail/CVE-2022-24112

## 贡献者简介

该漏洞由 Sauercloud 上报给 Apache 软件基金会。感谢各位对 Apache APISIX 社区的贡献。

![Sauercloud](https://static.apiseven.com/202108/1644632196291-6b9bca14-7893-47c7-9f93-99c28ff54044.png)
