---
title: "Apache APISIX request_uri 变量控制不当，存在路径遍历风险公告(CVE-2021-43557)"
author: "苏钰"
authorURL: "https://github.com/SylviaBABY"
authorImageURL: "https://avatars.githubusercontent.com/u/39793568?v=4"
keywords:
- APISIX
- Apache APISIX
- Ingress Controller
- Request_uri
description: 在 Apache APISIX 2.10.2 之前的版本中，使用 Apache APISIX Ingress Controller 中 $request_uri 变量存在「绕过部分限制」导致路径穿透风险的处理公告。
tags: [Vulnerabilities]
image: https://static.apiseven.com/2022/blog/0818/cve/CVE-2021-43557.png
---

> 在 Apache APISIX 2.10.2 之前的版本中，使用 Apache APISIX Ingress Controller 中$request_uri 变量存在「绕过部分限制」导致路径穿透风险的处理公告。

<!--truncate-->

## 问题描述

在 Apache APISIX 2.10.2 之前的版本中，使用 Apache APISIX Ingress Controller 中$request_uri 变量存在「绕过部分限制」导致路径穿透风险的问题。

在使用 uri-blocker 插件进行测试场景时发现：

```shell
$ ./apisix_request.sh "/public-service/public"
Defaulted container "apisix" out of: apisix, wait-etcd (init)
{"data":"public data"}
```

```shell
$ ./apisix_request.sh "/protected-service/protected"
Defaulted container "apisix" out of: apisix, wait-etcd (init)
<html>
<head><title>403 Forbidden</title></head>
<body>
<center><h1>403 Forbidden</h1></center>
<hr><center>openresty</center>
</body>
</html>
```

在上述两种场景下，`public-service` 是可用的，`protected-service` 则被插件阻止了。后续对上述场景进行验证测试，发现两种情况均能绕过 Uri 的限制。

由于 `uri-blocker` 插件使用 `ctx.var.require_uri` 变量不当，导致：

- 攻击者可以绕过访问控制限制逻辑，访问本应该禁止的 API；
- 自定义插件的开发者或许不知道 `ngx.var.request_uri` 变量是不可信任的。

## 影响版本

Apache APISIX 2.10.2 之前的所有版本（不包含 2.10.2）

## 解决方案

该问题目前已在 [2.10.2](http://apisix.apache.org/downloads/)+ 版本中得到解决，请尽快更新至相关版本。

操作建议：如果在使用自定义插件时，可在使用 `ngx.var.request_uri` 变量前进行路径规范化的相关处理。同时额外检查下 `ctx.var.upstream_uri` 和 `ctx.var.uri` 这两个变量，虽然可能已经被规范化了，但防患于未然。

## 漏洞详情

漏洞公开时间：2021 年 11 月 22 日
CVE 详细信息：https://nvd.nist.gov/vuln/detail/CVE-2021-43557

## 贡献者简介

该漏洞由社区用户 Marcin Niemiec（GitHub[@xvnpw](https://github.com/xvnpw)）发现，并及时向 Apache 软件基金会上报该漏洞。

感谢 Marcin Niemiec 对 Apache APISIX 社区的贡献。
