---
title: "Apache APISIX 如何通过网关层为 Airwallex 数据主权保驾护航"
author: "李杨"
keywords: 
- Apache APISIX
- API 网关
- Airwallex
- 数据主权
- 数据中心
description: 本文介绍了 Airwallex 空中云汇是如何使用云原生 API 网关 Apache APISIX 进行网关层部署来加固数据主权方面的建设以及登录与密码重置、复杂场景下的业务操作等场景。
tags: [Case Studies]
image: https://static.apiseven.com/2022/blog/0817/Airwallex.png
---

> 本文将为大家带来关于 Airwallex 空中云汇是如何使用 Apache APISIX 进行网关层部署来加固数据主权方面的建设。

<!--truncate-->

作者李杨博士，Apache APISIX Committer，Airwallex 空中云汇技术平台负责人，负责公司技术平台的演进。曾就职于万向区块链领导运链盟和花旗集团领导 OTC 衍生品风控平台。

## 为什么要处理数据主权

[Airwallex 空中云汇](https://www.airwallex.com/cn)是一家全球金融科技公司，帮助全球用户进行收付款服务以及跨境支付等场景。构建了全球金融基础设施平台，支付网络已覆盖全球 130 多个国家和地区的 50 余种货币，为企业提供数字化的金融科技产品。

![空中云汇业务](https://static.apiseven.com/202108/1635907812263-929d9f89-2bee-403e-9641-2e18b077e1b3.png)

全球化服务内容需求下，公司业务的进行势必要考虑数据主权的风险。

### 什么是数据主权

数据主权是指网络空间中的国家主权，体现了国家作为控制数据权的主体地位。在描述数据主权重要性之前，我们简单举几个例子。

GDPR（General Data Protection Regulation，《通用数据保护条例》）是欧盟制定的监管文件，是针对个人数据的隐私和保护的条例。GDPR 中有一条最基本的要求，所有的用户数据收集行为都需要经过用户的同意，同时还要保证用户可以自行清除个人数据。

所以如果 Airwallex 空中云汇要把欧洲的数据转移到其他地区时，就必须要保证第三方国家对数据主权的要求符合欧盟对数据主权的要求。

关于数据需要符合地方法案的问题，跨国业务下确实需要顾虑很多。

比如《美国爱国者法案》要求所有在美国境内存储数据，或者美国公司存储的数据，都在美国的监管范围，美国的司法部、CIA 可以要求公司提供数据。

在 2013 年 911 事件之后，美国司法部要求微软提供其在爱尔兰服务器上存储的一些邮件信息，当时微软以会违反欧盟监管要求的理由拒绝了美国司法部请求。然后美国司法部将微软告上法庭，但是最后微软胜诉。后来，美国很多公司为了避免数据主权反面的风险，把数据中心直接放到了欧洲，认为这样就安全了。但是最近在一些案例中法官判定，美国仍然是有权限去索要美国公司在欧洲的数据。

从以上事件来看，数据主权确实为 Airwallex 空中云汇的全球业务带了很大的挑战，如何在业务中将数据主权问题处理得当也变得尤为重要。

### 跨国业务数据传输现状

由于业务涉及到跨国属性，所以在技术处理中会遇到一些问题。

![业务流程](https://static.apiseven.com/202108/1635907812252-3d427136-b986-4ac5-a853-d9bbbb4439d3.png)

跨国公司的数据流通体现在各个地区之间的多种交互。在没有数据主权要求时，数据可以存放在欧洲，然后同步到亚洲或者全球任何一个数据中心。后续进行数据业务请求时，只需将业务封装到一个服务里即可。

但在当下重视数据主权的时代，上述方法就行不通了。因为很多数据的流通开始受管控，无法沿用之前的架构。本国数据只允许本国当地处理，不可跨国请求处理。所以当我们把用户数据存储在用户本国范围（即下图「独自封闭」架构）内时，问题就开始涌现了。

![单独部署](https://static.apiseven.com/202108/1635907812255-73d11508-d9ec-4ac6-b0a0-5913a1acb2c8.png)

首先这种情况下无法让服务做到完全无状态模式，同时在实际业务中绝大部分场景并不会这么简单。因为业务的完成，势必会涉及到多集群之间的交互。

![多集群交互](https://static.apiseven.com/202108/1635907812257-962b1247-f5ca-448f-904d-fd47c3ea4586.png)

所以在数据存储方面，首先要解决的问题就是在数据入口处进行地区/区域辨别配置。就像亚马逊一样，用户在美区购买的电子书，是无法用国区账号下载到自己 Kindle 上。因为各个国家（区域）之间的数据是完全隔离的。只要用户点击了亚马逊中国站，就意味着你的所有请求都不会跨出中国数据中心。

亚马逊的这种操作模式其实就是让用户自己决定将个人数据存储在哪个地区，但是随之带来的问题就是单人多地区账号的情况下，对于个人用户而言是非常不方便进行管理与同步的。

所以对于多地区多场景下的业务处理，应该还需要一个「利器」来进行动态分配决定后续数据走向。

## 打造 Apache APISIX 智能路由网关

所以基于上述业务场景，我们决定采取「智能路由」模式，通过网关来决定不同类型数据请求的落脚点与走向。

![智能路由模式](https://static.apiseven.com/202108/1635907812259-59637175-4beb-4e1e-a813-bb7c40a5acf9.png)

如上图就是「智能路由」模式下的架构图。网关主要分为两层，第一层负责路由请求，根据条件来判断请求应到达哪个数据中心；第二层网关则是进行流量转发。所以网关在这个模式中主要解决的问题就是给每个请求分配好「归宿」，然后进行后续的流量转发与业务处理。

目前我们的业务场景中，流量信息主要分为两类：

- 不明身份请求
  - 注册：用户第一次注册时信息不全，不知道此用户的注册数据放在哪个数据中心
  - 静态资源：比如 HTML、CSS，这些不需要知道用户身份

- 已知身份请求
  - 登录：用户登录，说明已完成注册流程，此时已知数据中心在哪
  - 密码重置：可以通过用户名、手机号、邮箱、城市等信息反查数据在哪，再进行后续请求的分发
  - 复杂场景下的业务操作

在网关层面的部署上，我们采用了 [Apache APISIX](https://github.com/apache/apisix)。接下来就简单为大家介绍下，我们如何基于 Apache APISIX 的 API 网关来进行动态、多数据中心的路由场景处理。

### 场景一：登陆与密码重置

用户登录时我们能拿到用户名和密码，但是密码是不能作为识别信息的，而且也不允许随便传递。所以只能根据用户名查询，判断这个用户是属于哪个地区的。业务上是需要设计一个全球能够同步的数据存储。

![登陆模式](https://static.apiseven.com/202108/1635907812260-69fbda9e-56cc-443d-8ea7-a1f10dba041e.png)

在这种情况下，我们进行了如上所示的数据存储架构，可以保证全球化的数据同步。比如：一位用户在中国注册账号，我们通过 CDC（Change Data Capture）把相关数据转化成 Kafka message，通过专门的 listener 进行本地消息的接收，然后做进一步的转化。如：去除用户名、Email 等个人信息，这些信息都是不能跨境存储的。

在转化（Transformer）过程中可以进行加盐或者哈希加密处理，最后在网关层进行相关的业务请求处理，即数据区域分配及后续的流量转发。实现基于 Apache APISIX 网关层面的业务处理。

### 场景二：复杂场景下的业务操作

业务操作是当操作一笔数据时，我应该用怎样的方式决定这笔数据去哪里执行。常规的业务操作比如某用户查询自己的账户信息或历史记录等，这种情况下一般分为两种模式。

![业务操作模式](https://static.apiseven.com/202108/1635907812247-123eca67-5039-487c-9d02-f3881e16c411.png)

#### 有状态模式

有状态模式一般会利用 Session（如上图左侧），客户端登录完成后 Sever 会将附带 Session ID 的 Cookie 给到客户端。在请求时，基于 Apache APISIX 实现的网关层会使用 Cookie 中的信息查询用户所处的地区。即便用户更换了服务器，依然可以保持登录状态，系统也可以判定从哪里获取数据。
比如用户正在进行跨国旅行，最初在欧洲登录系统，坐飞机来到了亚洲。在亚洲登录时系统会通过 Session 判断该用户信息处于哪个数据中心，就会把请求分发给对应数据中心进行后续业务操作。

#### 无状态模式

通常我们不会仅提供网页访问这样一个功能，还会有一些 API 访问进行集成。所以当进行 API 访问时，通过 Cookie 传递 Session ID 的方式是不合适的。这种情况下我们采用了一个特殊的 Token（如上图右侧）。Token 内会包含所处数据中心的具体信息，这样 Apache APISIX 就可以根据 Token 决定访问哪个数据中心。

这样做的好处是当后续进行业务扩展时，能够保持动态性。如果最初是静态设计，基于最开始注册时的信息决定数据中心，那么未来出现跨数据中心场景时就会非常难处理。

无状态模式下还有一种场景也是比较复杂的，就是用户注册。因为注册时只能根据用户填写的注册信息，决定放到哪个数据中心。但假如后期用户移民了，或者公司迁移到别的地方，我们就要做相关的数据清除，把用户的交易数据、用户名、密码等全部迁移到另外一个数据中心。这种数据切换成本其实是比较高的，目前我们内部也是支持用户切换数据中心这样复杂的场景，但后面也会开始考虑怎样减少切换数据中心对整体架构的影响。

## 关于数据主权的态度

其实前边我们提到的所有内容，都在说明一个问题，那就是「数据和所属地」。但是在进行数据所属地划分之前，有一个前提是非常重要的，那就是信息处理度。

数据是敏感的，当我们拿到用户数据进行数据分析/商业 BI 或其他大数据分析时，是不能直接拿来就立即使用的。要先在个人层面进行敏感信息的过滤，除此之外还要在数据聚合层面，将同一地区数据汇聚看整体数据时，再对用户信息进行再次抽象处理，达到无法完全识别用户的状态。

这样才符合监管的要求，才可以将这些信息用于数据分析。这是关于数据处理最根本的要求，我们对数据监管是规范化的同时，也要保证用户信息的「安全化」。

当然，这次所分享的基于 Apache APISIX 进行网关层面处理数据主权只是在「应对数据主权风险」过程中所做的一部分。我们期望 Apache APISIX 网关可以帮助 Airwallex 在数据主权层面做的更好更完善，目前来看，Apache APISIX 已经做到了我们期望的那样。
