---
title: "APISIX 在移动云公司的应用实践"
author: "陈焱山"
keywords: 
- Apache APISIX
- 中国移动
- 对象存储
- 云服务
- API 网关
description: 通过阅读本文，您可以了解到中国移动云是如何基于云原生 API 网关 Apache APISIX 进行对象存储产品的开发和功能改进与更新，打造出更完善的移动云对象存储。
tags: [Case Studies]
image: https://static.apiseven.com/2022/blog/0817/%E7%A7%BB%E5%8A%A8%E4%BA%91.png
---

> 本文整理自中国移动云能力中心陈焱山在 ApacheCon 2021 亚洲站的演讲，通过阅读本文，您可以了解到中国移动云是如何基于 Apache APISIX 进行产品的开发和功能改进与更新，打造出更完善的移动云对象存储。

<!--truncate-->

作者陈焱山，来自中国移动云能力中心。从事分布式存储软件开发及架构方案设计工作，深度参与移动云的建设，在分布式对象存储领域有丰富的实战经验。

## 背景说明

中国移动云能力中心作为中国移动云设施构建者、云服务提供者以及云生态汇聚者，承担了移动云的技术研发、规划建设、运营维护、合作引入、销售支撑、支持上云六大工作职责。

截至 2020 年 10 月，全国共计建成 25 个公有云节点，省份覆盖率超过 80%。其中对象存储 EOS 作为底层基础设施能力之一，已在所有资源池中进行了部署建设，整体可用规模达到 EB 级。

移动云对象存储至今已经历了四代发展历程变迁。从自研开发起手，通过功能扩展、深度定制、性能提升到最新一代拥有跨区域全局纠删架构，实现了异地多活容灾效果。纵观下来，可谓是进步飞速。

在云对象存储技术选型初期，我们调研过很多的 API 网关，包括 Nginx、Apache APISIX 等，最终还是选择了 Apache APISIX。Apache APISIX 不仅能够满足当前的业务要求，同时还能在系统可用性、可维护性上为我们产品提供比较多的思路和选择，与后续整体产品演进规划和技术栈比较吻合。

## 为什么选择 Apache APISIX 作为网关

### 为什么抛弃 Nginx

#### 理由一：综合能力欠缺

Apache APISIX 作为一个微服务网关，与其他 API 网关相比，它的上游路由插件是全动态的，修改配置不需要重启。同时插件支持热加载，可以随时插拔、修改插件。尤其是业务连续性要求非常高的场景，这些能力都是 Nginx 不具备的。

#### 理由二：配置不灵活

众所周知，像 Nginx 所有的功能都是基于配置文件来实现的，因而像 Proxy 存在路由上游的证书不能动态加载。Apache APISIX 支持全平台、多协议、全动态、精细化路由、安全防护，而且运维友好，可以对接 Prometheus、SkyWalking 等，有高度扩展能力，这些都是实际生产中需要的能力。

### 在技术选型时，为什么我们最终选择 Apache APISIX

#### 理由一：基于产品架构的需要

前边提到过目前对象存储已经经历了四代发展历程。随着产品功能的丰富、整个架构集群规模变大，就需要有更多控制面策略，包括流量治理、服务治理等策略来保证整个系统的稳定运行。

#### 理由二：细粒度业务功能的实现

Apache APISIX 的特性、功能插件、自定义开发功能，都可以在后续的开发过程中满足我们的业务需求。

#### 理由三：SLA 服务等级保障

一般 SLA 服务等级的可用性强调两个指标：系统平均无故障时间和系统平均故障修复时间。如何有效拉长系统平均无故障时间？如何有效缩小系统平均故障修复时间？这两个问题是我们重点考虑的。而 Apache APISIX 在故障隔离和自愈方面都有着不错的流量治理和服务治理相关能力。

![SLA 服务等级](https://static.apiseven.com/202108/1631500451210-60ba58d6-1fc4-4db6-b658-5e0066bb1c9b.png)

## 在 Apache APISIX 的数据面，我们改了些什么

### 改进一：内外网请求分离访问

目前我们的业务模型有两个域名，内网域名和外网域名。内网域名的访问是资源池东西向的访问，如资源池内部虚拟机、应用平台类的产品等。外网域名，相当于是纯公网的访问，比如：公网的公有云、toC 和 toB 的客户，通过 satellite 或者物理专线访问对象存储。
我们通过接入 Apache APISIX 实现了内外网域名的多域名证书配置，并提供了加密访问功能，同时实现了 SSL 证书动态加载的功能实现。对于 24 小时不间断的业务，能够动态更新 SSL 证书是非常重要的。

### 改进二：请求熔断保护

在这里首先给大家简单描述一下目前接入 Apache APISIX 后的对象存储 EOS 节点管理。整个对象存储分为数据平面和控制平面。数据平面主要承载整个业务的 I/O 流。业务数据是从 Apache APISIX 的 7 层流量治理模块作为入口，通过 APISIX 后端上游的 Accesser，实现业务接口处理的主要模块。

![熔断保护](https://static.apiseven.com/202108/1631500499020-4297de78-f9e3-45a5-8f57-2a55280bf7b0.png)

控制平面主要有几大服务，包括自动驾驶服务 Manager、可观测系统 Observer 和混沌工程故障注入模块 Checker。还有额外的整体交互编排系统 Orchestrator 和灰度发布平台 Publisher。

![控制平面服务](https://static.apiseven.com/202108/1631500520579-1e40b538-377b-4356-b0f2-1038c0a798e4.png)

为了实现请求熔断保护，数据面在接入 Apache APISIX 后就实现了请求介入的处理能力。而控制面端的可观测系统主要是基于 Prometheus 搭建的，进行指标收集与告警，最终实现后端整体的熔断保护。

### 改进三：自定义 constant key 实现全局限流

limit-conn key 这个插件主要是支持 remote_addr、server_addr、X-Forwarded-For、X-Real-IP ，但不能对南北向网关的流量做全局限流。

为了匹配我们的业务需求，通过自定义一个 constant 常量作为 limit-conn key 范围，上图右侧即是接入 Apache APISIX 后修改过的配置，通过 constant 常量 key 实现全局限流的功能。

![全局限流](https://static.apiseven.com/202108/1631500546238-9fd5ebcf-d205-4d99-a34d-236d5589a7e6.png)

### 改进四：新增功能特性开关

#### 开关 1：临时关闭某个对象存储功能

在网关层通过接入 Apache APISIX，兼容了 S3 接口规范，避免对后端服务的接入层、持久化层的资源浪费。

#### 开关 2：支持 GET 请求优先级最高

实现了在支持 GET 请求优先的情况下，在取回用户数据时 GET 请求优先级最高，高于 PUT 、DELETE 等请求。

#### 开关 3：对 Ordered List 请求返回 501 Not Implemented

在对象存储中一般会有对桶的 Ordered List 的功能需求。第三、四代移动云对象存储面向的都是百亿文件对象，如果依旧使用 Ordered List，一方面请求访问后端响应的时间会特别长，另一方面会占用较多资源，对后端的稳定性提出较大的挑战。

所以接入 Apache APISIX 后将直接在网关层面进行拒绝请求，并返回 501 Not Implemented 的状态码。

### 改进五：实现透明升级/扩容/配置变更

结合 Apache APISIX 7 层治理能力，我们对上游组件和整个 I/O 路径上关键组件进行了升级、扩容和配置变更，通过动态扩容、动态升级等操作来控制后端权重，进行后续请求处理。

### 改进六：基于 request-id 实现请求日志跟踪分析

基于 access.log 实现了日志集中收集的管理方式，把 APISIX 的 log 和其他进程的 log 都收集起来，然后进行综合的分析。

![日志跟踪](https://static.apiseven.com/202108/1631500588620-9200d098-b4ac-4b9d-99f4-509f9fada70f.png)

上图右侧的配置项是使用了 Apache APISIX 的 request-id 插件。每个请求在经过 APISIX 时都会被分配一个 request-id，被用于业务逻辑处理层（Accesser）和数据持久化层，进而在 Loki 官方面板上过滤出不同组件的日志时间戳，有助于后续使用 AI 实现一些自动化的分析。

### 改进七：跨 AZ 请求调度功能

目前负载均衡的后端是基于 APISIX 实现的七层流量治理层，通过等 ECMP + BGP 路由实现多活的能力。我们定义了三种流量类型，每个 APISIX 节点收到业务流量时只打到本节点的上游服务去处理（level0，紫线），类似 SideCar 模式。

![AZ 调度](https://static.apiseven.com/202108/1631500626933-473fdd62-dcee-42cc-93c2-93d83acd796c.png)

如果一个节点的上游出现问题，就会被转发到同 AZ 的其他上游节点进行处理（绿线）。如果所有上游节点全部挂掉，则会基于 Apache APISIX 实现请求跨 AZ 的调用能力（level2，红线），把请求写入到其他 AZ 中，最终实现跨 AZ 的请求调度。

## 未来规划

未来移动云对象存储将会全面拥抱云原生，并逐步实现以下计划：

1. 整合数据面功能，最终实现全面的容器化部署编排
2. 陆续接入基于 APISIX 的 Ingress Controller，通过 APISIX 来统一访问入口
3. 加强与自动驾驶 Manager、可观测性系统 Observer 子系统的融合能力，进一步实现故障的隔离与自愈
4. 将对象存储 S3 方面的认证能力移入到接口层。更好地实现统一鉴权认证以及安全访问，达到保护后端的效果
