---
title: "Apache APISIX 在 Airwallex 的应用 | 专访 Airwallex 技术平台负责人李杨"
author: "Apache APISIX 社区"
keywords: 
- APISIX
- Airwallex
- 空中云汇
- 金融
- 数据主权
description: 本文介绍了 Airwallex 空中云汇在做技术选型时为什么选择云原生 API 网关 Apache APISIX以及 APISIX 在 Airwallex 空中云汇的使用场景和生产环境的表现等内容。
image: https://static.apiseven.com/2022/blog/0817/Airwallex.png
tags: [Case Studies]
---

> 本文采访了 Airwallex 空中云汇 Technical Platform Lead 李杨，李杨负责公司技术平台的演进。采访中详细介绍了 Airwallex 空中云汇在做技术选型时为什么选择 Apache APISIX、Apache APISIX 在 Airwallex 空中云汇的使用场景、Apache APISIX 在生产环境的表现等。

<!--truncate-->

我们有幸采访到了 Airwallex 的技术平台负责人李杨，在采访中，李杨谈到了为什么在技术选型时选择 Apache APISIX，以及 Apache APISIX 在 Airwallex 的应用。

**Q：李博士，您好，请简单介绍一下自己和目前从事的工作。**

**李杨：** 你好，我叫李杨（Jan Li），哲学博士，Apache APISIX Committer，Airwallex 空中云汇 Technical Platform Lead，负责公司技术平台的演进。在加入 Airwallex 之前，曾在万向区块链领导运链盟。在万向区块链之前，曾在花旗集团领导 OTC 衍生品风控平台。

Airwallex 空中云汇是一家全球金融科技公司，赋能各类规模的企业跨境运营，以此助力全球经济发展。以技术为核心，Airwallex（空中云汇）构建了专有的全球金融基础设施平台，全球支付网络已覆盖 130 多个国家和地区的 50 余种货币，为各类规模的企业提供数字化的金融科技产品，在全球互联的信息化时代，以更高效、安全的方式帮助企业在全世界高速发展。自 2015 年成立以来，Airwallex 空中云汇已获得来自顶级投资机构超 5 亿美元融资，目前在全球共有 12 个办公室及超过 900 名员工。

![Airwallex LiYang](https://static.apiseven.com/202108/20210816001.png)

**Q：在做技术选型的时候，是什么原因让您/您的技术团队选择使用 Apache APISIX？**

**李杨**：API 网关是极其重要的基础技术组件，在技术选型时我们主要从 6 个维度比较了主要的网关产品：

- **稳定性**：API 网关的稳定性至关重要，在世界排名前 1000 的网站中，有 62.1% 是 Nginx 系的，这说明 Nginx 系 web server 是经过了生产环境复杂多样场景考验的；Apache APISIX 全动态的设计也使得它能够在修改路由时不必 reload，client 的长链接也得以保持；我们也对 Apache APISIX 进行了压力测试，在 CPU 达到 70% 以上时 Apache APISIX 仍能稳定运转。

- **性能**：每个 API 请求都会经过 API 网关，减小网关性能损耗能大大降低公司 API 整体响应时间。在 PoC 中我们比较了主要的网关产品，Apache APISIX 的响应延迟比其它网关低 50% 以上；Apache APISIX 数据面的设计也使集群中的每一个实例都相互独立，这也使得它天生支持水平扩展。

- **可扩展性**： API 网关模式是非常重要的微服务架构模式，符合 API 网关模式的 API 网关必须支持企业复杂的鉴权、权限控制、服务发现、限流、降级、负载均衡、白名单、动态路由等功能，所以支持怎样的定制是选择 API 网关时非常关键的考量。

- **社区活跃度**：新的技术与需求层出不穷，一个活跃的社区是 API 网关跟上技术演进步伐的关键。早在 Apache APISIX 还是 Apache 孵化项目时，其社区就已经非常活跃，从 contributor 数量、issue 响应时间、Pull Request 数量三个指标来看都是非常活跃的社区。

- **私有部署**：API 网关作为企业核心技术架构组件，企业应该把它部署在自己的私有网络边缘。Apache APISIX 具有良好的环境适应性，能够被轻易地部署在包括云计算平台在内的各种环境上。

- **开源协议**：Apache 2.0 赋予了定制 APISIX 的企业相当大的技术自由度。

**Q：Apache APISIX 用在了哪些场景？解决了哪些问题？**

**李杨**：我们把 Apache APISIX 用作微服务网关模式的核心组件，它被部署在网络边缘，为所有进入 Airwallex 的流量提供通用网关功能，解决的问题包括：

- 数据主权问题：对于跨国运营的金融基础设施，数据主权是非常关键的监管要求。为此，我们利用 Apache APISIX 动态上游选择的功能开发了符合监管的动态路由插件。动态路由能够根据用户请求的特征智能选择上游来进行请求分发，将复杂的多数据中心协同问题从服务层抽象到网关层。动态路由实质是要回答两个问题：如何对上游进行分组？如何匹配请求与分组。

- 微服务隔离：Airwallex 希望各微服务的工程团队能够自主控制自己的服务，有效降低沟通协调的成本，提高工程效能。这一架构理念要求被各团队共享的基础架构组件，比如： API Gateway 都能支持多租户隔离。在保证整个系统的强壮性和成本可控的同时，允许业务团队根据自身的需要对网关功能进行配置和扩展，保持微服务团队与服务的独立性。

- 租户级限流：在多租户环境中，每个租户的流量特征是不同的。对不同的租户进行同样的限流无法满足商业上的需求，租户级限流能够根据用户特征做更恰当的限流。

- 租户级白名单：在多租户环境中，每个租户的访问 IP 是不同的。单一的白名单控制无法满足租户级安全管理的需要，租户级白名单使得每个租户可以控制自己的白名单，也不用担心白名单中的其它用户访问自己的资源。

- Authentication：API 网关不仅要支持请求 authentication，还需要支持动态更新密钥，经常更新密钥是保证用户资源安全的关键一环。

- Authorization：企业级应用的权限管理是非常复杂的，不同的应用场景有着截然不同的权限管理模型。API 网关可以根据路由配置验证请求用户是否有足够的权限访问接口，第一时间拦截非法的流量。

![Airwallex arch](https://static.apiseven.com/202108/20210816002.png)

内容比较多简化一下，可以更清楚：

![Airwallex arch](https://static.apiseven.com/202108/20210816003.png)

**Q:在 Apache APISIX 升级过程中是否顺利？分享一下升级过程中的感受或者故事。**

为了能够随时升级到新版本的 Apache APISIX，我们把主要的功能都实现为定制化插件。这意味着我们的代码库不可能与 Apache APISIX 主 Repo 核心代码产生冲突，这帮助我们避免了可能遇到的代码冲突。但有时我们也需要修改核心代码，此时我们会尽量在开源社区实现这些功能。在开源社区讨论这些功能的时候，社区的小伙伴们非常热心参与讨论，在大多数情况下都能很快解决我们的问题。

**Q:Apache APISIX 在生产环境运行多久了？在线上表现如何？**

**李杨**：生产环境运行了 15 个月了，在开启动态路由、租户级限流、租户级白名单、Authentication、Authorization 等功能的情况下 99% 响应延迟在 23ms 以内，整体表现非常稳定。得益于 Apache APISIX 优秀的插件机制，可以保障我们在几乎不修改它核心代码情况下，增加符合业务需求的私有插件。完备的测试体系也进一步保障了软件质量，可以放心增加插件个性化要求的同时，保证不破坏原有核心逻辑。

**Q：Apache APISIX 有哪些不足，希望社区一起建设完善？**

**李杨**：Apache APISIX 的数据面设计为它带来了无损的水平扩展和极致的性能，但这也使得路由配置很难做到向前兼容，为新版本的发布带来了一些协调上的困难。

**Q：后续有什么计划？**

**李杨**：后续计划主要包括三个方面：

1. 用多层网络将不同的网关逻辑拆分到不同的分层中，比如根据数据主权分发流量与其它网关逻辑属于不同的网络分层；
2. 易读易用的路由管理对 API 网关的成败非常关键，虽然网关的功能会不断迭代与增加，但路由管理需要对开发者友好，让开发者能够轻易理解网关能为他做什么、该怎么配置、怎么发布。
3. 用请求染色帮助实现生产环境测试。用 API 网关请求染色实现生产环境测试能为我们带来灵活性与易用性。

**Q：感谢李博士，期待 Apache APISIX 在 Airwallex 有更多的使用场景，发挥的更多作用。**
