---
title: "Apache APISIX 在移动云的应用"
slug: 2021/08/09/apache-apisix-in-china-mobile-cloud
author: "APISIX 社区"
keywords:
- API 网关
- APISIX
- Apache APISIX
- 中国移动
description: 本文介绍了移动云为什么选择云原生 API 网关 Apache APISIX 作为负载均衡网关，以及使用 Apache APISIX 所解决的场景，并且介绍了移动云后续的发展规划。
tags: [Case Studies]
image: https://static.apiseven.com/2022/blog/0817/%E7%A7%BB%E5%8A%A8%E4%BA%91.png
---

> 我们有幸采访了中国移动云能力中心的陈焱山，在采访中我们了解到中国移动公有云建设发展演进历程，了解了中国移动云为什么选择 Apache APISIX 作为负载均衡网关，并且知晓移动云后续的发展规划。

<!--truncate-->

中国移动云能力中心，对外也称“中移（苏州）软件技术有限公司”，是中国移动通信集团 2014 年注资成立的全资子公司，公司定位为云设施构建者、云服务提供者、云生态汇聚者，三年内推动中国移动云业务市场份额进入国内云服务商第一阵营。自 2019 年中国移动启动“云改”战略以来，作为助力中国移动 5G+AICDE 战略落地的基石，移动云经过长足发展，已完成覆盖全国的“N+31+X”整体资源布局。同时，移动云积极打造“云网、云数、云边、云智” 差异化特色优势，在业务体量、产品种类、可售资源等方面均实现飞跃式提升。“移动云”品牌也充分发挥了云网一体、贴身服务、随心定制、安全可控的优势，打造 5G 时代“你身边的智慧云”，为行业数字化转型发展提供“强引擎”。

**Q：非常高兴今天能跟陈焱山老师进行交流，可以麻烦您做下自我介绍，简单陈述下您现在的工作内容吗？**

大家好，我叫陈焱山，目前就职于中国移动云能力中心 IaaS 产品部，主要负责分布式对象存储软件的整体架构设计与开发工作，负责对象存储、API 网关的技术选型与方案落地实践工作。在分布式存储领域这块还是有比较丰富的经验的，深度参与了移动云的建设发展历程。

当前，我主要关注于对象存储在交互编排、流量治理等方面的能力，促进我们第四代对象存储产品进一步实现架构升级。同时，我们也希望能够基于 Ingress Controller 的能力，来实现统一流量访问入口，并包括灰度发布、流量管控等功能。这些是我们当前正在做的一些工作。

![China-Mobile-ChenYanshan](https://static.apiseven.com/202108/1639466964888-a7ee803d-16d2-4042-b538-326e90e36712.png)

**Q：您说的这些内容多少都与 Apache APISIX 有关联，您在今年 ApacheCon 亚洲大会上也有一场分享，想问下您会带来哪些精彩分享?**

首先，我会给大家介绍一下我们移动云对象存储产品 EOS 的整体发展和演进过程，同时重点介绍我们是如何基于 Apache APISIX 实现对象存储流量治理的，做了哪些工作，又是如何进行实践。最后对我们未来的架构演进做了一些规划说明。我们对象存储的整体演进过程主要经历了如下四个阶段，对于 Apache APISIX 引入主要是从第三代开始引入的，确实给我们产品在架构上带来很多便利。

- 第一代：从 2008 年开始投入自研，同年发布了我们的第一代对象对象存储产品；
- 第二代：主要基于开源 Ceph 实现深度定制，实现了接口的标准化，支持 AWS 的 S3 标准接口和 Openstack 的 Swift 接口协议，同时丰富了大量的功能特性；
- 第三代：主要解决内部一些专业公司海量数据上云需求。在第三代产品中，我们在性能上实现了一个新的跨越，单一存储桶同时支持百 PB 容量和百亿对象规模，入口带宽达到 Tb/s 级。同时，我们还引入了很多子模块，包括七层流量治理以及可观测系统。七层流量治理模块是基于 Apache APISIX 实现的，主要用于实现业务流量的分离治理；可观测系统则主要是实现了数据的采集、告警以及日志分析功能。
- 第四代：也是全新一代架构，支持跨区域全局纠删功能，支持 AZ/Region 级容灾。在流量治理方面，支持基于 Apache APISIX 实现的跨地域请求调度能力，支撑极致的业务连续性；同时系统可观测性进一步提升，落地了集中化日志分析系统。在可维护性上首次引入了自动驾驶服务和交付编排服务，能够自动有效收敛故障范围，减轻运维压力，实现故障隔离和自愈能力。

**Q：从您的讲述中可以感受到，这个系统不仅非常庞大，而且还非常重要。对于这样重要的系统，为什么会选择 Apache APISIX？主要出于哪些方面的考虑呢？**

是的，在技术选型初期我们也调研过很多的 API 网关，包括 Nginx 等，不过我们最终还是选择了 Apache APISIX。Apache APISIX 不仅能够满足当前的业务要求，同时还能在系统可用性、可维护性上为我们提供比较多的思路和选择，跟我们的整体产品演进规划和技术栈比较吻合。归结起来选择 Apache APISIX 主要基于以下几点：

#### 第一，内部驱动产品架构优化需要，促使我们开始在一些技术架构上寻找更高的突破点

在 2019 年的时候，中国移动从集团层面提出了“云改”战略转型，随后我们云能也就成了整个移动在云改转型上的战略支撑点。这也促使我们要在产品系统架构上做进一步的优化，能够满足未来 3~5 年以上的发展需要。不仅需要在功能和性能上进行提升，而且需要在可维护性、可观测性等方面上来引入更多的组件，来保证我们系统的稳定运行，提供可持续的、有保证的 SLA 服务等级。

#### 第二，基于自身业务实现需要，同时 Apache APISIX 功能插件全面，业务场景匹配度高

因为自身业务对网关能力的需要，我们通过对自有业务需求进行详细梳理分析，这其中就包括精细化路由、内/外网隔离以及访问控制，自动熔断保护，跨 AZ 请求调度等场景。同时，“运维友好”，这方面 Apache APISIX 做得非常好。

大家都知道，Apache APISIX 能够友好对接 Prometheus，前面我提到的可观测系统，它就是基于 Prometheus + Grafana + Loki 来实现的，所以之所以选择 Apache APISIX，很重要的一点是它能与我们现有的技术栈完美结合，这些都是我们比较看重的。

此外另外还有一个关键点，这也是 Apache APISIX 与其他网关产品的重要区别 —— 全动态加载，因为我们更希望所有的插件、路由都能够动态的扩展，这些是 Nginx 这样的产品所不具备的。举一个简单的应用场景的例子：前面我有提到过我们有一个子系统叫自动驾驶 Manager，当我后端的索引存储空间不足时，我们就是通过 Manager 自动使能一条默认高优先级的路由，禁用 PUT 和 POST 等功能，从而实现自动后端保护。

#### 第三，对社区开源文化的认同感

和其他网关产品不同，Apache APISIX 是 Apache 开源顶级项目，孵化时间也是最短的，足见项目的成功，产品已经被很多企业应用于生产环境下。此外不得不说社区也是十分活跃的，代码贡献者和使用者都非常多，与社区的沟通交流方式也很多样化，比如 maillist，issues，QQ 群，微信群，线上线下的 Meetup，沟通起来十分便捷且迅速有效。社区大佬也十分友好，乐于回复大家的提问。所以我们对 Apache APISIX 社区的未来也是非常看好的。

另外，Apache APISIX 的全产品线做得也非常好，包括 K8s Ingress Controller，以及 Service Mesh 等，虽然这些技术栈我们当前还用不到，但我觉得社区在产品定位、发展方向上都是非常清晰的，这也给了我们更充分的信心。

**Q：就像您说的，其实 Apache APISIX 不仅是希望能够满足用户当前的需求和架构的设计，我们更希望能够满足大家 3~5 年，甚至更长时期的架构变迁。现在 Apache APISIX 有跑在中国移动的一些业务系统上吗？**

有的。从我们的第三代对象存储产品开始，我们除了解决容量、性能以及扩容性的问题之外，我们还利用 Apache APISIX 来解决我们七层流量治理的需求。第三代对象存储从它的研发历程来看，前后加起来还不到半年的时间，并能够在 2020 年 7 月的时候在移动云十期中完成上线运行，主要服务于内部的一些专业公司数据上云的需求。主要是存储用户的一些摄像监控数据，所以对带宽的要求还是比较高的。目前整体投入生产运行已经有一年多了，从接入层到后端服务的运行情况还是非常平稳的，几乎没有出过什么问题。

**Q：在使用 Apache APISIX 的时候会做一些二次开发吗？另外，这些二次开发的成果是否有计划回归到社区呢？**

二次开发是有的，而且还有不少。

针对一些通用的功能，我们也会把他们贡献给社区。但我们的一些开发内容都是为了满足一些特定业务场景，比如跨 AZ 请求调度。该功能主要是面向我们第四代对象存储，它是一个全局跨域的版本，支持 AZ 级容灾，所以对业务的连续性要求非常高。为了解决请求调度的一些需求，我们在 Apache APISIX 上写了一个 Plugin，然后去运行。

通过这个 Plugin 的请求，首先会选择本节点上游去处理；如果本节点上游出现问题，就会转向到本 AZ 内的其他一些上游去进行处理。如果本 AZ 所有上游都出现故障的时候，那就直接采用跨 AZ 的请求调度处理机制。这样一来，我们整个业务请求的过程中，即使出现 AZ 级的故障，请求还是能够被正常处理。换句话说，我们利用 Apache APISIX 做了一部分 “多活” 架构的实现。

**Q：除了 Apache APISIX 现有的功能之外，你们后续还会有一些什么样的计划吗？**

我觉得后续的话，我们应该主要会围绕这几个方面开展。

#### 第一，容器化编排和统一入口

因为我们现在主要在开发第四代对象存储，我们正在做的事情就是实现所有组件的容器化部署编排。这中间既有数据面也有控制面，控制面我们已经是 K8s 化了，当前正在做数据面组件的容器化部署编排工作。对于外部访问需求，我们也在采用 Ingress Controller 来统一访问入口。

#### 第二，将更多的功能前置到网关层面来处理

前面我有提到，在我们的控制面有多个子系统，后续我们希望把流量治理与一些自动驾驶、可观测子系统能够更多的去融合起来，通过实现故障自愈、故障隔离等功能，从而保证产品对外的访问能力，这也就要求我们匹配更多的业务场景能力。

另外，我们现在的网关接入层主要是实现了流量转发控制功能，而原来后端的认证、鉴权的那套逻辑是由业务逻辑层处理的，后续会考虑把这一部分内容统一前置到网关层面来处理。在数据迁移这块，由于历史遗留问题比较多，迁移过程还不能影响业务的连续性，不过我们也已经有了基于 Apache APISIX 的可行方案。

#### 第三，社区代码贡献上要加大

我们也会在这块加大人员投入，与社区有着更积极的互动，参与到社区的开发当中，为社区的发展做一些回馈，这也有利于打磨我们的产品。

#### 第四，推动内部技术栈的统一

目前在我们内部还存在多种技术栈并行的情况，同时也有多个团队在使用 Apache APISIX 网关，后期我们也将通过沟通，梳理业务模型，实现技术栈的统一，避免重复造轮子的情况发生，最终实现技术栈的统一，形成统一基座能力。

**Q：感谢陈老师，看来 Apache APISIX 在中国移动后面应该可以适用更多的场景，发挥的更多作用了。**
