---
title: "Apache APISIX Dashboard 访问控制绕过漏洞公告（CVE-2021-33190）"
slug: 2021/06/17/apache-apisix-dashboard-access-control-bypass-vulnerability-announcement
author: "琚致远"
authorURL: "https://github.com/juzhiyuan"
authorImageURL: "https://avatars.githubusercontent.com/u/2106987?v=4"
keywords:
- APISIX
- Apache APISIX
- Ingress Controller
description: 云原生 API 网关 Apache APISIX Dashboard 访问控制绕过漏洞公告，请尽快升级版本修复该漏洞。
tags: [Vulnerabilities]
image: https://static.apiseven.com/2022/blog/0818/cve/CVE-2021-33190.png
---

> 由于程序通过获取请求头 `X-Forwarded-For` 的值来进行访问控制判断，导致攻击者在调用 API 请求时，只需篡改该请求头即可实现访问控制绕过攻击。

<!--truncate-->
## 问题描述

在 Apache APISIX Dashboard 2.6 中，存在两个配置项：

1. `conf.listen.host` 的配置项，用于指定 ManagerAPI 在启动时监听哪个 IP 地址，它的默认值为 `0.0.0.0`（默认监听外部网络请求）；

2. `conf.allow_list` 的配置项，用于进行访问控制，默认只允许 `127.0.0.1`（即本地网络）进行访问。

由于程序通过获取请求头 `X-Forwarded-For` 的值来进行访问控制判断，导致攻击者在调用 API 请求时，只需篡改该请求头即可实现访问控制绕过攻击。

## 影响版本

Apache APISIX 2.6.0

## 解决方案

该问题已在 2.6.1 版本中解决，请尽快更新至最新版本，并在部署程序后修改默认用户名与密码。

## 漏洞详情

漏洞公开时间：2021 年 6 月 8 日

CVE 详细信息：https://nvd.nist.gov/vuln/detail/CVE-2021-33190

## 贡献者简介

该漏洞是由平安科技银河安全实验室的 Vern 发现，并向 Apache 软件基金会上报该漏洞。感谢 Vern 和平安科技银河安全实验室对 Apache APISIX 社区的贡献。

![2021-06-17-1](https://static.apiseven.com/202108/1639463130837-f27bf7bf-28b9-4742-a40f-ee43ebf5a7a8.jpeg)

## 拓展阅读

[Apache APISIX 贡献者专访 | 普华永道华南数据安全与隐私保护团队高级安全顾问王鹏诚](./2021-01-11-interview-Apache-APISIX-contributor-Wang-Pengcheng-Senior-Security-Advisor-of-PwC-South-China-Data-Security-and-Privacy-Protection-Team.md)
