---
title: "支持 10 亿日流量的基础设施：当 Apache APISIX 遇上腾讯"
slug: 2021/05/24/tencent-games
author: "徐鑫"
keywords:
- API 网关
- APISIX
- Apache APISIX
- 腾讯游戏
- 基础设施
description: 通过阅读本文，你不仅可以了解 API 网关是什么、网关模式对传统服务架构的改进，还可以了解腾讯 OTeam 诞生的原因以及 Apache APISIX 是如何在腾讯内部落地的。
tags: [Case Studies]
image: https://static.apiseven.com/2022/blog/0817/%E8%85%BE%E8%AE%AF.png
---

> 本文整理自腾讯游戏负责内部容器平台的工程师徐鑫在 Apache APISIX Meetup - 深圳站的演讲，通过阅读本文，您不仅可以了解网关是什么、网关模式对传统服务架构的改进，还可以了解腾讯 OTeam 诞生的原因，以及 Apache APISIX 是如何在腾讯内部落地的。

<!--truncate-->

在正式进入分享之前，先为大家介绍一下网关（Gateway）的作用和价值。

## 网关是什么

### 传统架构的通用功能

在传统的架构中，没有网关，那么通用功能该怎么复用起来呢？这里的通用功能指业务无关的一些特性，比如：

- 安全性：身份验证、授权、防重放、防篡改、对抗 DDos 等。
- 可靠性：服务降级、熔断、限流等。

这些功能在传统架构下，最常见的处理方法就是将其放入服务框架当中，通过 AOP 的方式去实现，类似下图：

![传统架构](https://static.apiseven.com/202108/1630640321175-ee272ad4-d8ee-45f3-8b67-9630fb534a82.png)

传统架构图中有以下几个模块：

- Backend：后端服务。
- AOP：框架携带的 AOP 分层。
- SD：服务中心，用于服务间发现，此组件在云原生环境下经常用 Service 替代。
- LB：负载均衡器，放置于网络边界上，作为外部流量的入口。

这种架构在早些年的设计中非常常见，由此诞生了很多大而全的服务框架，比如 Dubbo、SpringCloud 等。如果我们去认真研究它们的功能介绍，我们会发现这些功能点它们大多都有。

这种架构的优点在于上下游关系简单，网络传输中也少了一次转发。但是它们的缺点也很明显：

- 通用功能的迭代会迫使业务服务更新：由于采用的是代码引用，因此需要业务服务重新编译才能使功能生效。对一些没有实现平滑发布的团队，由于服务会中断，因此还得挑业务的空闲期发布。
- 版本难以管理：由于我们不可能每次发布都让所有业务服务升级最新版，长此以往，各个服务的版本将会不一致。

那么我们是否可以将这些通用功能下沉到一个独立的服务，它可以单独迭代且业务无关？

### 网关模式的出现

![网关模式](https://static.apiseven.com/202108/1630640321180-bd19ad6c-6116-4982-98e8-3b626285ed03.png)

从上图中，我们可以看到传统架构的大部分内容都没有变化，只是在后端服务与 LB（负载均衡器）之间多出了一个角色：网关。
（这里需要澄清的是，本文讨论的网关特指 API Gateway ，即针对后台服务以 API 提供服务的场景。）

在上面的这个图中，有时 LB 同时也起到网关的作用，比如 k8s 的 Ingress 组件。

有了网关这个组件后，我们就可以将传统架构的通用功能下沉到网关，这样一来我们获得了很多的好处：

- 网关可以独立迭代，不再需要业务服务配合。
- 与语言无关，可以配置专门的团队维护。

但是网关模式也有自己的缺点：

- 多了一次转发，延迟变高，排查问题复杂度变高。
- 网关如果不能正常工作，可能会成为整个平台的瓶颈。

如何平衡好网关模式的好处和缺点，不仅十分考验业务团队的实力，更是与网关的选型息息相关。接下来，我们要请出本文要介绍的两个重点对象：腾讯 OTeam 和 Apache APISIX。

## 项目介绍

### OTeam

很多人对腾讯内部的赛马文化恐怕早有耳闻。在腾讯内部，老板们为了创造更有竞争力的产品，通常会让不同的队伍去同一个赛道竞争。由于产品的竞争关系，下面的技术当然也不会共享，因此导致早期的腾讯在技术沉淀方面是互联网大厂中垫底的那个。

为了整合公司内的重复轮子，沉淀技术中台。腾讯将相同性质的几个技术产品都放入同一个 Oteam，将维护人员都整合起来，一起发力，让这些产品逐渐合并成一个大而全的产品，这就是 Oteam。

有的 Oteam 下面有多达十数种产品，而有的只有一种。比如 Apache APISIX 所在的 Oteam 就单单只有 Apache APISIX 这一个产品，这个 Oteam 成立的初衷是：维护腾讯内部的 Apache APISIX 定制化特性。

### Apache APISIX

感兴趣的同学可以看看 Apache APISIX 的 GitHub 项目主页：[Apache APISIX](https://github.com/apache/apisix)。我们在这里只简单介绍几个点：

- Apache APISIX 是基于 OpenResty 的高性能网关，比起竞品 Kong，它的路由性能高了一个数量级。
- Apache APISIX 使用 ETCD 作为配置存储，可以实现配置秒更新。
- Apache APISIX 是 Apache 基金会毕业最快、最让导师省心的项目之一。

## Apache APISIX in OTeam

大家是不是很好奇腾讯的 OTeam 是怎么运作，又如何和 GitHub 的社区形成双赢的关系的？
OTeam 的运作参考下图：

![OTeam 的运营策略](https://static.apiseven.com/202108/1630640321189-46cf2163-552c-4816-bdf6-ef4f58702667.png)

可以看到 OTeam 的特性迭代是一个完整的闭环：

- 用户通过 Issue 反馈问题和需求
- OTeam 的成员 在 周会 上讨论解决方案，或者直接在 Issue 中跟进
- 按照解决方案实现特性 or 修复 Bug
- 代码 Review 后，经历 CI 合入到主干中，再视情况需不需要打包镜像发版
这个流程其实和 GitHub 多数开源项目的贡献过程是没区别的，关键点在于：
- 解决了 Issue 后，腾讯工程师会判断这个问题对于社区来说，是否也是一个共性问题。如果是，则会发 PR 到社区的仓库去。
- 腾讯 OTeam 会定期 Review Apache APISIX 的新特性，判断其是否稳定、是否对腾讯内部也是一个痛点。如果答案是肯定的，合入相关代码。

最早期的时候，OTeam 会每 12 小时，自动合入社区代码到内部仓库中，以保证我们与社区能够共同前进，但这种做法带来了几个问题：

- 合入的代码通过目前的集成测试只能保证功能 正确性 却没法保证 稳定性，很多偶现的问题都是在并发中发生的。
- 合入的代码，有时会产生上游的多个 PR 在逻辑上出现冲突的问题，但是各自的 CI 无法检测出来，只有当合入主干后，才会发现主干的代码产生了问题。

出于以上原因，现在 OTeam 转为定期 Review 后合入所需特性的代码的策略。

## OTeam 发展情况

截止 2021 年 5 月，Apache APISIX 所在的 OTeam 在腾讯内部已为超过十个团队落地了 Apache APISIX，其中最大的业务日请求量已超过十亿，同时 OTeam 也为 Apache APISIX 开发了超过十个内部特性，其中包括内部的服务发现、RPC 协议转换、打通监控平台等。与此同时，OTeam 也将开发的一些通用的特性贡献到了社区，为社区带来了不少 Contributor。目前 OTeam 团队中，有两位成员同时也是 ApacheAPISIX 社区的 PMC，OTeam 为社区贡献了超过 50 个 PR。同时，我们相信 OTeam 今后还会与 Apache APISIX 社区开展更多的合作。

## 腾讯内部特性介绍

OTeam 的主要职责是维护 Apache APISIX 的一些针对腾讯内部的特性，那么这些特性都是哪些，又解决了什么样的痛点呢？

### 内部的痛点

先来看看，有哪些痛点是腾讯内部独有的：

- RPC 框架对前端不友好：腾讯内部有很多遗留项目使用了 TARS 框架，它不像 TRPC 一样可以直接支持 HTTP 协议，它只支持 RPC 框架最传统的 TCP 协议，传输内容都使用特定的二进制协议。这带来的一个问题是，我们需要维护一个中间服务来将这些接口转换为前端友好的 HTTP + Json 形式。
- 服务中心多样化：腾讯内部服务发现的组件众多，比如 CL5、L5、北极星等。虽然在未来，服务组件会逐渐统一，但在过渡期间，会存在多个服务中心同时使用的情况，最开始的 Apache APISIX 不支持这一点。
- 告警：作为一个网关解决方案，告警不是一个它应该关注的方向，但是作为网关这个基础组件，告警一定是团队所关心的事项，要怎么解决告警问题，也是一个痛点。
- 安全性：腾讯这种体量的公司，除了产品本身会面对大量流量之外，产品还有安全性的要求。不乏 ToC 的产品使用了 OTeam ，它们要面对的不止海量用户的误操作，还要面对来自网络的攻击，无论是善意还是恶意的，最典型的有 DDos、重放、篡改请求等。这些流量我们是否可以在网关层解决？

### 问题的解决

带着这些问题，让我们来看一个架构拓扑图，它来自一个腾讯内部某个落地案例的简化：

![OTeam 架构拓扑图](https://static.apiseven.com/202108/1630640321184-dfcba4df-1b97-4d6e-ab10-07f89e131438.png)

从上图可以看出，刚才提出的几个问题都在 OTeam 都得到了解决：

- 网关实现协议转换：OTeam 基于 Apache APISIX 实现了 TRPC 与 TARS 的协议转换，这样一来那些没有实现 HTTP 的遗留服务，可以在网关直接使用封装好的协议转换插件来实现 HTTP 和 RPC 互转的需求而不再需要编写中间服务。
- 支持多服务中心：这一点其实应该不止腾讯内部需要，相信外面也有很多同学在新老架构的过渡期需要，该特性我们已经反馈给了社区。
- 指标上报自研监控平台：OTeam 利用插件打通了腾讯内部的几个主要的监控平台，让用户可以简单配置后自动上报接口可观测性的相关信息（链路调用、日志、统计），上报后用户可自行在监控平台配置告警。
- 防重放与防篡改：OTeam 实现了防重放和防篡改插件，让需要这些能力的对外的业务可以直接开箱即用，保护自己的接口安全。
我们希望这些例子能起到抛砖引玉的作用，鼓励大家去发掘更多 Apache APISIX 的使用场景，更好的把 Apache APISIX 这个好用的工具用起来。比如在腾讯云团队，就有同学利用网关实现了一些腾讯云平台强制要求的 API 规范，将这逻辑下沉到了网关。

## 最后的话

转眼在腾讯内帮助各个团队维护 Apache APISIX 也一年多了，在这个过程中，OTeam 既帮助业务团队解决了他们的痛点，也不断完善了 Apache APISIX 在腾讯内部的特性，同时也间接推动了社区的发展，实现了共赢。
如果读者所在公司如果还没有落地网关的话，可以了解下 Apache APISIX。已经落地了网关的读者，也希望本文能够给你们带来一点在网关落地上的灵感和帮助。

> 欢迎感兴趣的同学访问 bilibili [Apache APISIX 在腾讯游戏的应用](https://www.bilibili.com/video/BV1yK4y1G7CP/)，观看视频。
