---
title: "Monthly Report (August 01 - August 31)"
keywords: ["Apache APISIX", "API Gateway", "Monthly Report", "Contributor"]
description: Our monthly Apache APISIX community report generates insights into the project's monthly developments. The reports provide a pathway into the Apache APISIX community, ensuring that you stay well-informed and actively involved.
tags: [Community]
image: https://static.apiseven.com/uploads/2024/08/30/VoTAlVBX_aug-cover-en.png
---

> We have recently made some additions and improvements to specific features within Apache APISIX. The main improvements include adding ai-prompt-template plugin and supporting AWS Secrets Manager. For detailed information, please read the monthly report.

<!--truncate-->

## Introduction

From its inception, the Apache APISIX project has embraced the ethos of open-source community collaboration, propelling it into the ranks of the most active global open-source API gateway projects. The proverbial wisdom of 'teamwork makes the dream work' rings true in our way and is made possible by the collective effort of our community.

From August 1 to August 31, a total of 16 contributors made 25 commits to Apache APISIX. We sincerely appreciate your contributions to Apache APISIX.

## Contributor Statistics

![Apache APISIX Contributors List](https://static.apiseven.com/uploads/2024/08/30/rjB3aezA_aug-cntributors.png)

![Apache APISIX New Contributors](https://static.apiseven.com/uploads/2024/08/30/CxoRAI3y_aug-new-contributors.png)

## Recent Feature Highlight

- [Add ai-prompt-template Plugin](https://github.com/apache/apisix/pull/11517)（Contributor: [shreemaan-abhishek](https://github.com/shreemaan-abhishek))

- [Support AWS Secrets Manager](https://github.com/apache/apisix/pull/11417)（Contributor: [HuanXin-Chen](https://github.com/HuanXin-Chen))

## Recent Blog Recommendations

- [Differentiating rate limits in Apache APISIX](https://apisix.apache.org/blog/2024/07/25/different-rate-limits-apisix/)

  This post examines the implementation of rate limiting using Apache APISIX. The rate limit is first applied to a specific route, then transitioned to individual consumers, and finally to consumer groups, allowing all members of a group to share a common "pool."
  
- [Free tier API with Apache APISIX](https://apisix.apache.org/blog/2024/08/01/free-tier-api-apisix/)

  In this day and age, most services are online and accessible via an API. A free tier is a must for any API service provider worth its salt. In this blog, a free tier with Apache APISIX is implemented.

The [official website](https://apisix.apache.org/) and [GitHub Issues](https://github.com/apache/apisix/issues) of Apache APISIX provide a wealth of documentation of tutorials and real-world use cases. If you encounter any issues, you can refer to the documentation, search for keywords in Issues, or participate in discussions on Issues to share your ideas and practical experiences.
