---
title: "Biweekly Report (November 20 - December 03)"
keywords: ["Apache APISIX", "API Gateway", "Weekly Report", "Contributor"]
description: Our bi-weekly Apache APISIX community report is your window into the project's weekly developments. It is a tool to facilitate your seamless integration into the Apache APISIX community, ensuring that you stay well-informed and actively involved.
tags: [Community]
image: https://static.apiseven.com/uploads/2023/12/04/ZD3OVqNc_1204-ENG.png
---

> We have recently made some additions and improvements to specific features within Apache APISIX. The updates include adding a `multi-auth` plugin, adding the required scopes configuration property to `openid-connect` plugin, and enhancing the `body-transformer` plugin. For additional information, please consult the bi-weekly report.
<!--truncate-->

## Introduction

From its inception, the Apache APISIX project has embraced the ethos of open-source community collaboration, propelling it into the ranks of the most active global open-source API gateway projects. The proverbial wisdom of 'Many hands make light work' rings true in our way, made possible by the collective dedication of our community.

From 11.20 to 12.03, a total of 22 contributors made 45 commits to Apache APISIX. We sincerely appreciate your contributions to Apache APISIX.

We have recently added and enhanced several plugins, and here is a summary of the updates:

1. Add a `multi-auth` plugin

2. Add the required scopes configuration property to `openid-connect` plugin

3. Enhance the `body-transformer` plugin

Our bi-weekly Apache APISIX community report is your window into the project's weekly developments. It is a tool to facilitate your seamless integration into the Apache APISIX community, ensuring that you stay well-informed and actively involved.

## Contributor Statistics

![Apache APISIX Contributors List](https://static.apiseven.com/uploads/2023/12/04/PnNWmVdX_1204-Con.png)

![Apache APISIX New Contributors](https://static.apiseven.com/uploads/2023/12/04/vrpTk1y4_1204-New.png)

## Highlight of Recent Feature

- [Add `multi-auth` plugin](https://github.com/apache/apisix/pull/10482) (Contributor: [madhawa-gunasekara](https://github.com/madhawa-gunasekara))

- [Add the required scopes configuration property to `openid-connect` plugin](https://github.com/apache/apisix/pull/10493) (Contributor: [csotiriou](https://github.com/csotiriou))

- [Enhance the `body-transformer` plugin](https://github.com/apache/apisix/pull/10496) (Contributor: [yongxiaodong](https://github.com/yongxiaodong))

## Recent Blog Recommendations

- [Release Apache APISIX 3.7.0](https://apisix.apache.org/blog/2023/11/21/release-apache-apisix-3.7.0/)

  We are glad to present Apache APISIX 3.7.0 with exciting new features, bug fixes, and other improvements to user experiences.

- [Embrace the Lightweight APISIX Ingress Controller Without etcd Dependency](https://apisix.apache.org/blog/2023/10/18/ingress-apisix/)

  The innovative architecture of the APISIX Ingress Controller eliminates the dependency on a standalone etcd cluster, greatly simplifying maintenance costs and system complexity.

- [Embracing GitOps: APISIX's New Feature for Declarative Configuration](https://apisix.apache.org/blog/2023/10/07/apisix-gitops-adc/)

  APISIX strengthens its integration with modern development and operational workflows by introducing the declarative configuration tool, ADC.

A wealth of documentation tutorials and experience has been accumulated on the Apache APISIX official website and GitHub. If you encounter problems, you can look into the documentation, search keywords in the issues, or participate in the discussion on the issues, proposing your own ideas and practical experience.
