---
title: "Biweekly Report (October 09 - October 22)"
keywords: 
- Apache APISIX
- API Gateway
- Weekly Report
- Contributor
description: Our bi-weekly Apache APISIX community report is your window into the project's weekly developments. It is a tool to facilitate your seamless integration into the Apache APISIX community, ensuring that you stay well-informed and actively involved.
tags: [Community]
image: https://static.apiseven.com/uploads/2023/10/23/yNWWMWEF_EN-1023.png
---

> We have recently made some fixes and improvements to specific features within Apache APISIX. These updates include upgrading lua-resty-healthcheck to version 3.2.0, adding support for configuring services in stream route, enhancing `authz-keycloak` plugin to support encryption using secrets, and updating the `openid-connect` plugin to support authorization_params. For additional information, please consult the bi-weekly report.
<!--truncate-->

## Introduction

From its inception, the Apache APISIX project has embraced the ethos of open-source community collaboration, propelling it into the ranks of the most active global open-source API gateway projects. The proverbial wisdom of 'Many hands make light work' rings true in our way, made possible by the collective dedication of our community.

From 10.09 to 10.22, a total of 21 contributors made 37 commits to Apache APISIX. We sincerely appreciate your contributions to Apache APISIX.

We have recently addressed and enhanced various features, and here is a summary of the updates:

1. Upgrade lua-resty-healthcheck to version 3.2.0

2. Add support for configuring services in stream routes

3. Enhance `authz-keycloak` plugin to support encryption using secrets

4. Update the `openid-connect` plugin to support authorization_params

Our bi-weekly Apache APISIX community report is your window into the project's weekly developments. It is a tool to facilitate your seamless integration into the Apache APISIX community, ensuring that you stay well-informed and actively involved.

## Contributor Statistics

![Apache APISIX Contributors List](https://static.apiseven.com/uploads/2023/10/23/2nDl86Bc_All-poster.png)

![Apache APISIX New Contributors](https://static.apiseven.com/uploads/2023/10/27/iEMZzOhZ_New-poster.png)

## Highlights of Recent Features

### Apache APISIX

- [Upgrade lua-resty-healthcheck to version 3.2.0](https://github.com/apache/apisix/pull/10307) (Contributor: [monkeyDluffy6017](https://github.com/monkeyDluffy6017))

- [Add support for configuring services in stream routes](https://github.com/apache/apisix/pull/10298) (Contributor: [lingsamuel](https://github.com/lingsamuel))

- [Enhance `authz-keycloak` plugin to support encryption using secrets](https://github.com/apache/apisix/pull/10353) (Contributor: [Revolyssup](https://github.com/Revolyssup))

- [Update the `openid-connect` plugin to support authorization_params](https://github.com/apache/apisix/pull/10058) (Contributor: [TrevorSmith-msr](https://github.com/TrevorSmith-msr))

## Recent Blog Recommendations

- [Embrace the Lightweight APISIX Ingress Controller Without etcd Dependency](https://apisix.apache.org/blog/2023/10/18/ingress-apisix/)

  The innovative architecture of the APISIX Ingress Controller eliminates the dependency on a standalone etcd cluster, greatly simplifying maintenance costs and system complexity.

- [Embracing GitOps: APISIX's New Feature for Declarative Configuration](https://apisix.apache.org/blog/2023/10/07/apisix-gitops-adc/)

  APISIX strengthens its integration with modern development and operational workflows by introducing the declarative configuration tool, ADC.

- [Coraza: Elevating APISIX with Cutting-Edge WAF Features](https://apisix.apache.org/blog/2023/09/08/APISIX-integrates-with-Coraza/)

  The integration of APISIX and Coraza provides reliable security protection and ensures the integrity and reliability of API services.

A wealth of documentation tutorials and experience has been accumulated on the Apache APISIX official website and GitHub. If you encounter problems, you can look into the documentation, search keywords in the issues, or participate in the discussion on the issues, proposing your own ideas and practical experience.
