---
title: "Accelerating API Gateway Excellence: Apache APISIX Community Meetup in Malaysia"
authors:
  - name: Yilia Lin
    title: Author
    url: https://github.com/Yilialinn
    image_url: https://avatars.githubusercontent.com/u/114121331?v=4
keywords:
  - Open Source 
  - Community
  - Meetup
  - Apache APISIX
description: Kuala Lumpur, the capital of Malaysia, witnessed the success of the 2023 APISIX open-source Community Meetup on July 4th. 
tags: [Community]
image: https://static.apiseven.com/uploads/2023/06/28/6T1RUrwQ_img_v2_6e1d6a11-db2a-4236-b715-38b20c2c12bg.png
---

Kuala Lumpur, the capital of Malaysia, witnessed the success of the 2023 APISIX open-source Community Meetup on July 4th.

<!--truncate-->

Kuala Lumpur, the vibrant capital of Malaysia, recently witnessed the grand opening of the highly anticipated technical extravaganza hosted by [Apache APISIX](https://apisix.apache.org/). This momentous event, brought to life through the collaboration of [API7.ai (API7)](https://api7.ai/), [N2N Connect Berhad (N2N)](https://www.n2nconnect.com/), and [Advanced Micro Devices, Inc. (AMD)](https://www.amd.com/en.html), saw the convergence of numerous API gateway technology experts and enthusiasts. The impact of APISIX resonates across multiple sectors, including finance and IT, attracting users from Malaysia and Singapore, who enthusiastically joined both on-site and online.

Distinguished by the presence of [APISIX PMC members](https://apisix.apache.org/team/) and a diverse array of contributors, the gathering served as a forum for discussing cutting-edge advancements and evolving trends in API gateway technology. The event proved invaluable for the exchange of experiences, insights, and practical knowledge, fostering an atmosphere brimming with warmth and intellectual synergy. Through this dynamic meetup, the development of API gateway technology received a rejuvenating boost, nourished by fresh wisdom and innovative ideas.

## The Voice of the Audience

The meetup garnered widespread acclaim, captivating attendees with its engaging program and fostering a spirit of knowledge exchange. Notably, Bryan, the esteemed Business Development Manager of N2N, the foremost stock trading platform in Malaysia, shared his insights:

> "In Malaysia's developer community, there has been a recurring challenge where most individuals learn development skills online but struggle to find local connections with other developers. Consequently, this has led to a shift in how ideas are shared, particularly when facing real-life development challenges.
>
> For example, while online learning is great for acquiring new programming languages, it falls short when it comes to addressing specific situations like making decisions on system architecture within the business landscape. These are instances where direct conversations with peers become essential. I strongly emphasize the importance of collaborative work for everyone's growth.
>
> Furthermore, I firmly believe that the open-source community plays a significant role in the lives of software developers. Projects like APISIX within the [Apache Software Foundation](https://www.apache.org/) are invaluable. That's why N2N is wholeheartedly supportive of open-source initiatives, including those led by the Apache Software Foundation. We are also enthusiastic about supporting any future open-source projects, non-profit or otherwise, as well as participating in open-source meetups.
>
> Speaking specifically about APISIX, we see a promising future for the product overall. We are genuinely excited and confident that it will excel, especially considering the positive feedback we received from attendees at this event. Additionally, the global interest from clients eager to utilize APISIX further strengthens our belief that the technological landscape in Malaysia will continue to thrive. We are truly delighted to have had the opportunity to connect with you all and eagerly await your future endeavors."

Michael, Head of SRE at a multinational fintech company, said:

> "We are actively seeking a new API gateway, and we have a keen interest in APISIX's exceptional traffic governance capabilities. The valuable insights and use cases presented at the conference, particularly within the financial services industry, provide invaluable references for our decision-making process. We eagerly look forward to experiencing the captivating features of APISIX at the earliest opportunity."

Joey, an accomplished Software Engineer, enthusiastically praised the Meetup:

> "The event is incredibly informative, with a remarkably detailed demo that left me enriched with knowledge. Prior to this, he was more familiar with platforms such as GCP and AWS, but the introduction to APISIX has opened up a plethora of prospects for my future work."

## Ming Wen: APISIX - Past, Present, and Future

> [Ming Wen](https://www.linkedin.com/in/ming-wen-api7/), Apache APISIX PMC Chair, member of Apache Software Foundation, member of Kubernetes, and co-founder and CEO of API7.ai

![Ming Wen](https://static.apiseven.com/uploads/2023/07/07/wv8WK1TY_meetup1.jpeg)

Ming kicked off the session by sharing the inspiring story behind the birth of APISIX. Driven by their shared love for coding and a common goal to take on challenging endeavors, Ming and Yuansheng dedicated themselves to the startup journey. They spent countless hours in a cramped small room, immersed in writing code, and ultimately brought APISIX to life.

With a vision to foster global collaboration and knowledge sharing among developers, they made the significant decision to donate APISIX to the Apache Software Foundation. Since then, APISIX has thrived under the guiding principle of "Community over Code." It treats contributors as valued partners, which has attracted exceptional developers from around the world to join and contribute to the APISIX project.

Over the course of four years, APISIX has built an active and vibrant [community](https://apisix.apache.org/blog/tags/community/), becoming a driving force behind its vitality. The community's responsiveness has been remarkable, swiftly addressing APISIX issues in a short period of time. This continuous growth and engagement continually attract new members, infusing APISIX with fresh perspectives and energy.

![Time of Issues Responded](https://static.apiseven.com/uploads/2023/07/07/FGcdrAPT_2.png)

APISIX has gained users across the globe, with hundreds of enterprise users representing various industries such as finance, internet, manufacturing, retail, and operators. Prominent companies like [iQIYI](https://api7.ai/blog/iqiyi-api-gateway-update-and-deployment-based-on-apache-apisix), [Airwallex](https://api7.ai/blog/how-airwallex-empowers-global-payment-through-apache-apisix), [Zoom](https://api7.ai/blog/zoom-uses-apisix-ingress), and the [Amber Group](https://api7.ai/blog/amber-api-gateway-architecture) rely on APISIX to handle their critical business traffic, serving millions of users worldwide.

Looking ahead, APISIX is committed to embracing AI advancements. In fact, as early as October 2022, [APISIX introduced its AI module](https://github.com/apache/apisix/pull/8102/files), paving the way for a more intelligent API management experience. This innovation empowers developers to navigate increasingly complex business scenarios with greater efficiency and effectiveness.

Furthermore, APISIX aims to streamline API design processes and provide developers with more efficient tools and support. Simultaneously, it endeavors to assist management in making informed decisions by delivering comprehensive insights. These initiatives will unlock added value for developers and enterprises alike, propelling the entire industry toward a more intelligent and efficient future.

## Yuansheng Wang: How Do Financial Services Companies Use APISIX?

> [Yuansheng Wang](https://www.linkedin.com/in/yuansheng-wang-84014022a/), member of Apache APISIX PMC, co-founder and CTO of API7.ai, one of the authors of *Apache APISIX in Action*

![Yuansheng (right) is discussing technical details with the audience](https://static.apiseven.com/uploads/2023/07/07/3kshxsgx_3.jpeg)

API connects the "traffic" of the digital world, and APISIX is the core tool on the "traffic route". In modern architecture, APISIX plays a pivotal role in the full lifecycle management of APIs. This innovative API management platform brings more efficient and smarter API management solutions to developers and enterprises.

APISIX has won the favor of many financial company users, including [Airwallex](https://api7.ai/blog/how-airwallex-empowers-global-payment-through-apache-apisix), [Essence Securities](https://api7.ai/blog/essence-securities-selects-apisix), GF Securities, [Amber Group](https://api7.ai/blog/amber-api-gateway-architecture), [Snowball Finance](https://api7.ai/blog/snowball-finance-with-apisix), and so on. These enterprises are well aware of the importance of APIs in digital transformation and have obtained a more efficient, secure, and intelligent API management experience through APISIX. The achievements of APISIX not only demonstrate its importance in the process of digital transformation but also provide new ideas and directions for the entire industry. [API7](https://api7.ai/) provides deeper [enterprise-level product](https://api7.ai/enterprise)s on the basis of APISIX.

### Airwallex

[Airwallex](https://api7.ai/blog/how-airwallex-empowers-global-payment-through-apache-apisix), a global financial technology company, faces significant challenges in data governance and internal system management as its business expands worldwide. The complexity of interconnecting systems poses intricate challenges, where issues in one system can disrupt the normal operation of others. To address these problems, Airwallex seeks a highly stable, reliable, and available API gateway with low latency, high performance, and support for custom plugins such as user-based routing and rate limiting. APISIX fulfills these requirements and helps Airwallex overcome data sovereignty challenges while efficiently supporting its business operations across 130 countries and regions, covering more than 50 currencies.

### Essence Securities

[Essence Securities](https://api7.ai/blog/essence-securities-selects-apisix), on the other hand, faced complexities due to their relatively complex original technology stack, including NGINX, Spring Cloud Gateway, and self-developed systems. This decentralized architecture resulted in issues related to system management and duplication of efforts, leading to increased development costs. By integrating APISIX into Essence Securities' business system, they gained access to a high-performance API gateway with horizontal scaling capabilities. APISIX offers powerful traffic management, security features, protocol translation, authentication and authorization, and more. This integration enhanced traffic governance, significantly improved research and development efficiency, and ensured data security and access management. APISIX has become an essential component for Essence Securities' cloud-native development, enabling them to manage and develop their business more efficiently.

For more user cases, please refer to [https://api7.ai/category/usercase](https://api7.ai/category/usercase).

## Bobur: Dynamic, User Credentials-based Routing

> [Bobur Umurzokov](https://www.linkedin.com/in/boburumurzokov/), Apache APISIX Developer Advocate, API7 Developer Advocate

By leveraging an API Gateway, users can effectively route traffic to different backend services based on various criteria. Bobur provides a demonstration that explains the implementation of dynamic routing, which considers user attributes specified in request headers, request queries, or request bodies.

To gain more insight into Bobur's demonstration and explore the details further, you can refer to [his article](https://api7.ai/blog/dynamic-routing-based-on-user-credentials)

![Bobur is demonstrating how to route traffic](https://static.apiseven.com/uploads/2023/07/07/AoFBgxlM_meetup5.png)

## Chao Zhang: Elevating Apache APISIX to the Cloud

> [Chao Zhang](https://www.linkedin.com/in/chao-zhang-52a106107/), member of Apache APISIX PMC, open source enthusiast, and contributor to projects such as OpenResty, Kubernetes Ingress-NGINX, and Kubernetes Gateway API

![Chao Zhang](https://static.apiseven.com/uploads/2023/07/07/V4FYhaOD_6.jpeg)

Today, the adoption of cloud services by companies is on the rise, and IT professionals are increasingly exploring cloud technology stacks and obtaining certifications. Cloud infrastructure, including Software-as-a-Service (SaaS), has become the preferred option for enterprises and individuals to undergo digital transformation, experiencing rapid growth in popularity.

However, the emergence of multi-cloud and hybrid-cloud scenarios presents a significant challenge in terms of unified management API usage. To address this challenge, [API7 Cloud](https://api7.ai/cloud) was developed as a solution, specifically designed to assist enterprises in overcoming problems encountered in multi-cloud and hybrid-cloud environments.

Built on the foundation of Apache APISIX, API7 Cloud leverages the functionalities provided by Apache APISIX, with the goal of simplifying and enhancing the configuration and usage of APISIX for users. It extends the capabilities of open-source APISIX by introducing more enterprise customizations, such as strengthening dynamic capabilities and supporting dynamic service discovery. Moreover, API7 Cloud offers an open API and an SDK, enabling automated API management and facilitating program integration for automation purposes.

In comparison to local devices, API7 Cloud offers heightened security, improved scalability, and reduced maintenance and update costs. While API7 Cloud hosts the control plane, the data plane of the API Gateway can be deployed anywhere, on any infrastructure. This flexibility allows users to manage their APIs more effectively. Additionally, API7 Cloud includes built-in observability, empowering users with clear insights into the usage and performance of their APIs.

![Built-in Observability Support of API7](https://static.apiseven.com/uploads/2023/07/07/KE26wb3m_7.png)

## Nicolas: Data Residency Management

> [Nicolas Fränkel](https://www.linkedin.com/in/nicolasfrankel/), Engineer, APISIX Developer Advocate, API7 Developer Advocate

![Nicolas Fränkel](https://static.apiseven.com/uploads/2023/07/07/YYJ9lHsQ_a5592a72-fb7d-4841-bbb6-ae29235bb569.jpeg)

Data residency poses significant concerns due to varying laws and regulations related to data storage and processing across different countries and regions. Additionally, cloud providers may not have data centers in specific locations, leading to the need for effective data residency management strategies.

To address this issue, Nicolas presented four methods: managing data residency in the code, library/framework, agent, and gateway layers. These approaches provide effective ways to manage data while ensuring compliance with diverse laws and regulations in different countries and regions, ultimately safeguarding user privacy and data security.

During the live demonstration, Nicolas vividly showcased the operational processes and the impact of these methods on the participants. This demonstration helped everyone gain a better understanding of how to manage data residency challenges in various scenarios.

During the event, [Koh Lian Chong](https://www.linkedin.com/in/koh-lian-chong-2b1713/?originalSubdomain=sg), ASEAN Business Director at AMD, captivated the audience with a compelling presentation on AMD's role in empowering global data centers. He provided a comprehensive overview of AMD's history and its cutting-edge product portfolio. In parallel, [Kiran Chavala](https://www.linkedin.com/in/kiran-chavala-1bb6a97/), Quality Assurance Engineer from ShapeBlue, introduced Apache CloudStack - a remarkable open-source cloud computing platform renowned for its exceptional scalability and high availability, which can significantly enhance development efficiency when combined with APISIX.

## A Glimpse into Tomorrow

Many financial technology companies in Malaysia are utilizing APISIX due to its exceptional performance and user-friendly features. [APISIX](https://github.com/apache/apisix-website) is renowned for its lightweight nature, ease of management, and seamless usability. It can efficiently operate on a single server and effortlessly handle billions of traffic when deployed across multiple servers. Furthermore, APISIX boasts quick installation and boot-up times. Notably, a prominent multinational conglomerate in Malaysia relies on APISIX for payment processing, and numerous fintech companies prefer APISIX as their go-to payment gateway.

![2023 APISIX Meetup Malaysia](https://static.apiseven.com/uploads/2023/07/07/YFHhI10g_meetup10.jpeg)

We would like to express our sincere gratitude to all the speakers, participants, and organizers for their invaluable support, which contributed to the resounding success of the Apache APISIX meetup in Malaysia. It is because of your active participation that this event was made possible, and we extend our deepest appreciation to each and every one of you.

Looking ahead, we eagerly anticipate future events like this, where we can continue to witness the innovative advancements and progress brought forth by our vibrant community. If you were unable to attend this meetup, there's no need to worry! You can stay updated by following Apache APISIX on social media or by attending upcoming events.

Stay tuned for further updates and announcements, and join us in shaping the future of API Gateway technology with Apache APISIX! Whether you are a novice or an experienced professional, we wholeheartedly welcome you to join us in exploring the boundless possibilities offered by [Apache APISIX](https://apisix.apache.org/).
