---
title: "Biweekly Report (Mar 27 - Apr 9)"
keywords: 
- Apache APISIX
- API Gateway
- Weekly Report
- Contributor
description: The Apache APISIX Community Biweekly Report can help community members better grasp the progress of the Apache APISIX community so that everyone can participate in the Apache APISIX community.
tags: [Community]
image: https://static.apiseven.com/uploads/2023/04/14/xNrvzURr_biweekly-report-0327-0412.png
---

> From 3.27 to 4.9, 24 contributors submitted 44 commits for Apache APISIX. Thank you for your contributions to Apache APISIX.

<!--truncate-->

## Introduction

Apache APISIX grew up as a community from the first day it was open-sourced, and quickly became the most active open-source API gateway project in the world. These achievements are inseparable from the joint efforts of community partners.

"If you want to go fast, go alone. If you want to go far, go together." The Apache APISIX Community Biweekly Report can help community members better grasp the progress of the Apache APISIX community so that everyone can participate in the Apache APISIX community.

We have also sorted out some issues for newcomers to the community to participate in! If you are interested, don't miss it!

## Contributor Statistics

![Apache APISIX Contributors List](https://static.apiseven.com/uploads/2023/04/10/DIDm2aDQ_%E7%A4%BE%E5%8C%BA%E5%8F%8C%E5%91%A8%E6%8A%A5-%E8%B4%A1%E7%8C%AE%E8%80%85%E6%B5%B7%E6%8A%A5-07%E6%9C%9F.png)

![Apache APISIX New Contributors](https://static.apiseven.com/uploads/2023/04/10/ysgQ4kpJ_%E7%A4%BE%E5%8C%BA%E5%8F%8C%E5%91%A8%E6%8A%A5-%E6%96%B0%E6%99%8B%E6%B5%B7%E6%8A%A5-07%E5%91%A8.png)

## Good First Issue

### Issue #8772

Link: [https://github.com/apache/apisix/issues/8772](https://github.com/apache/apisix/issues/8772)

Description: Set a validation on custom claims in OIDC auth

## Highlights of Recent Features

### Apache APISIX

- [Add upstream status report](https://github.com/apache/apisix/pull/9151)（Contributor: [kingluo](https://github.com/kingluo)）

- [Suppot header injection for fault-injection plugin](https://github.com/apache/apisix/pull/9039)（Contributor:  [kingluo](https://github.com/kingluo)）

### Apache APISIX Ingress

- [Support webhook validate plugin](https://github.com/apache/apisix-ingress-controller/pull/1355)（Contributor: [AlinsRan](https://github.com/AlinsRan)）

## Recent Blog Recommendations

- [Utilize APISIX in E-Commerce: User-friendly, Robust, and Delightful](https://apisix.apache.org/blog/2023/04/07/apisix-unity-group-q&a/)

  Lukasz Biegaj, System Architect of Unity Group, shares the changes that APISIX has brought to their company in the interview: "Simple to use, powerful, and enjoyable to use. For projects using the APISIX, the time-to-market is considerably shorter and we - as a team or as a company - are able to deliver solutions more quickly."

- [gRPC on the client side](https://apisix.apache.org/blog/2023/03/16/grpc-client-side/)

  This post explains how gRPC can benefit inter-service communication and demonstrates how to create a gRPC service using Spring Boot, and also provides a demonstration of how to configure APISIX with the grpc-transcode plugin to enable access for all clients.

- [Make your security policy auditable](https://apisix.apache.org/blog/2023/03/02/security-policy-auditable/)

  This blog shows how you can leverage OPA and Apache APISIX to move your authentication and authorization logic from the code to the infrastructure. The former allows you to audit your security policies, the latter coherence among all your upstream across all tech stacks.

A wealth of documentation tutorials and experience has been accumulated on the Apache APISIX official website and GitHub. If you encounter problems, you can look into the documentation, search keywords in the issues, or participate in the discussion on the issues, proposing your own ideas and practical experience.
