---
title: "Interview with JU Zhiyuan: Becoming One of the 918 ASF Members, I Felt Thrilled and Proud"
authors:
  - name: "Estelle Rao"
    title: "Author"
    url: "https://github.com/EstelleRao"
    image_url: "https://github.com/EstelleRao.png"
keywords:
- APISIX
- Apache APISIX
- API Gateway
- ASF Member
- Apache Member
- Open Source
- Remote Work
- Full-Stack Web Developer
description: Become an Apache Member in 2022, we invited Ju Zhiyuan to talk about his open source experience and technology growth.
tags: [Community]
---

> JU Zhiyuan, a PPMC member of Apache APISIX, was elected to be one of the 918 ASF Members in March 2022. In this interview, Zhiyuan shared his experience with open source and his self-learning journey in technology.

<!--truncate-->

**JU Zhiyuan (GitHub ID: juzhiyuan), born in 1997, became an Apache APISIX PPMC member in October 2019 and was elected as an ASF Member in March 2022. He is an active advocate for open source as an ApacheCon Speaker, OSPP Mentor, and GSoC Mentor and was one of the core organizers of freeCodeCamp China before 2019, spreading the word of open source and giving help and support for open-source newbies. Currently, he leads a global team in API7.ai, an open-source software company.**

![ASF Members](https://static.apiseven.com/202108/1651198214277-8bb73696-dbe0-4e24-b0b9-2bb65e1abbfd.png)

Back in primary school, he got his first computer. Intrigued by stunning Flash techniques, he started to teach himself technology. In junior and senior high school, he self-learned web penetration techniques, became obsessed with hacker culture, and yearned to be a WooYun member. After entering college, he joined the freeCodeCamp community and became an advocate and mentor for web technology. For the first time in his life, he was closely involved in an open-source community. After graduation, he made more contributions to open-source projects, became a PMC member of Apache APISIX, and shared his firsthand open-source experience and thoughts on the Apache Way on many public occasions.

As a PMC member of Apache APISIX, Zhiyuan deserves our respect for his contribution. Now, he has reaped another title, ASF Member Congratulations to Zhiyuan! At this merry moment, the Apache APISIX community invited Zhiyuan to talk about **his experience with open source and his self-learning journey in technology**.

![Open-Source Experience](https://static.apiseven.com/202108/1651198231486-5da0a1d2-a672-414f-a73f-8ddd24095b9b.png)

## Open-Source Experience

**When did you get your first computer and start to program?**

I got my first computer around 2003. My uncle assembled a personal computer at Zhongguancun Street in China. At first, I used it to play simple games. Later, I would play complex games such as Warcraft and CrazyRacing KartRider and watch TV dramas like Dae Jang Geum and Doraemon.

Then I came into Flash because my aunt learned Flash and could do animation, and her work was recognized by a TV program featuring Yuju Opera. I thought it was very cool, so I wanted to learn Flash and persuaded my mother into buying expensive tutorials for me. I really learned a lot from my family members. I drew on their experiences to make my past, current, and future decisions.

A few years passed. One day, I found that my QQ account was stolen. To get it back, I filed a complaint and found many materials to learn how hackers stole my account. The more I learned, the better I knew about Trojans, phishing, and other concepts. And I found online forums that host many hackers and hacking tutorials. Since then, I have fallen in love with hacking technology.

However, I didn't know that some hacking behaviors were wrong and unjust. I only knew that hacking technology empowers me to do something magic. So at that time, I wrote some Trojan scripts, performed social engineering attacks, and stole QQ accounts and passwords. To prove my capability, I even penetrated some websites. Once I left my QQ account on the penetrated website, which I thought was cool. Then the website administrator contacted me. After knowing that I was a student, the administrator told me not to do website penetration anymore. It was the first time someone had taught me that this behavior was wrong.

Later, I learned about the WooYun community and was interested in becoming one of white hat hackers. Before 2016, WooYun was a great gathering place for white hat hackers, contributing most to China's cybersecurity protection. As a freshman, I attended the WooYun Summit. At that time, I wanted to join this group of geeks and to communicate and learn technology, but in the end, I failed the entry test. As I learned more about hacking, I could distinguish between white hats and black hats and decide whether the behavior was right or wrong.

![Homepage of the WooYun Website](https://static.apiseven.com/202108/1651198239470-d23346d4-efeb-46ff-81d3-d80a7511488a.png)

**How did you get to know open source and engage in open-source communities and activities?**

After entering college, I learned about freeCodeCamp, a non-profit organization with the mission of helping people worldwide learn to program for free and advocating for education welfare. In 2015, Miya, the organizor of freeCodeCamp China in Chengdu, introduced the community to China and began building the community in China. FreeCodeCamp China has organizers in Chengdu, Shenzhen, Hangzhou, and other cities in China. Those organizers are reputed both locally and in professions. Through the freeCodeCamp community, **I made many friends and got to know more people with different backgrounds**. I felt that I was not alone when I was in a city I had never been to.

The open-source freeCodeCamp project has ranked Top 1 on GitHub for many years, and it has tens of thousands of stars. I fixed many bugs and committed many pull requests, which was very **fulfilling**. Through the freeCodeCamp platform, we also **attracted many technology enthusiasts and helped them learn technology from scratch**. During the process, I also formed my way of doing things, including guiding people to learn web technology or get onboard. After they get aboard and become more experienced, I will let them help others. Making contributions did consume a lot of time and seemed that it didn't benefit you a lot, but I did gain spiritual and potential benefits. For example, I have more influence, and the takeaways I gained and the experience I accumulated are helpful in my future.

In college days, I joined various communities and activities, learning technology, sharing technology, and doing projects. I also encouraged my friends to learn technology. We often held programming activities in dormitories and computer classrooms, completed projects as a team, and even went to schools in other cities to share our experience with students.

Over the past few years, I have accumulated much project experience and expanded my technology stack. However, I realized that though project practices could bring me income, it was not conducive to skill development. I found that the open-source code I used in projects was of high quality and community collaboration was patterned, so I began to study open-source code and keep abreast of open-source communities. After graduation, I joined the APISIX open-source community and contributed some code.

**What is open source? In the video named [Trillions and Trillions Served](https://www.youtube.com/watch?v=JUt2nb0mgwg), Jim Jagielski, one of the co-founders of the Apache Software Foundation, pointed out that "for me, it's an acknowledgment of what I see was the old hacker culture. I mean that developers and coders contributors are artists, and I think all artists want to share the results of their craft. They want to work with aligned people. They want to hone their skills." You got to know hackers early in your junior and high school and then engaged in open-source communities in college. How do you take the spirit of hackers and open source? In your opinion, is there any inheritance between hacker culture and open-source culture?**

In my opinion, a hacker is not a hacker in the pejorative sense with malicious intent to destroy or invade other people's computer systems. Hackers, as it means, are a group of geeks who dare to think and act and who believe in liberalism and are not bound by overt or covert rules. They make decisions and take actions based on their interest and pursuit of truth. I feel that I am one of them. Whatever difficulties I encounter, I will brave them and figure out the solution.

As for the inheritance between the hacker culture and open-source culture, I think both hackers and open-source contributors share the traits of being open to sharing and pursuing the best. The representatives are Linus Benedict Torvalds, founder of the Linux operating system and Git version control system, TJ Holowaychuk, a front-end expert engineer, and You Yuxi, founder of the front-end framework Vue.js.

Linus is a geek because he puts his ideas into practice and makes them open-sourced. He created Git merely because he wanted a method to manage his code and do version control as it is iterated. Although Git and Linux have a huge following and are widely used by global users, creating untold value, Linus hasn't capitalized on them and the projects are still open-sourced.

The second tech expert who embodies both the hacker culture and the open-source culture is TJ, who was very popular among front-end developers and made a lot of Node.js-related tools in 2015. In 2017, he started writing back-end code using Go, a programming language more suitable in the cloud-native era. Besides, he's self-taught. He used to be a designer.

The third geek is Yuxi You, the author of Vue.js. He used to be a designer at Google and had never learned how to code. He wrote Vue.js because he couldn't find a more simple front-end framework, so in 2015 or earlier, he started to create his ideal front-end framework. At that time, the project was just a simple open-source project with little popularity, but around 2017, it jumped to be one of the top 3 open-source frameworks in the world. Yuxi changed his career from a designer to a front-end engineer and an independent open-source developer, incorporated his delicate design principles and artistic ideas into the open-source framework, and created a small but beautiful, efficient, and easy-to-use open-source project. Besides, documentation and other support of Vue.js are also very accessible, and the community is very active and completely community-driven.

In fact, behind every open source project is an open-source community. The spirit of open source is that we want to realize and share our ideas and invite more people to improve them. There are a lot of independent developers on GitHub like Yuxi You. When they have a good idea, they will strive to make it come true and open source it. With more stars and more attention, they will naturally have more influence.

As for hacker culture, I also want to recommend a book named *Hackers and Painters*. The English version of *Hackers and Painters* was published in 2004, and 10 years later, it was translated into Chinese by Yifeng Ruan, a Chinese developer and technical translator, published in 2013, and then reprinted. Upon the release of the Chinese version, it received a huge response in the Chinese IT industry and academia and was widely recognized.

The book is a collection of essays written by Paul Graham, the father of Silicon Valley entrepreneurship. It covers hacker culture, hacker growth, hackers' contribution to the world, hackers' methodology, and other topics. In the preface to the reprint, Yifeng Ruan wrote, "In my opinion, there are two reasons why *Hackers and Painters* could attract so many readers after ten years. First, he wrote not about technology but the ideas behind technology. Truth is never outdated. Second, he looked into the future instead of focusing on analyzing the status quo and reflecting on the past."

**You have been making contributions to APISIX since July 2019. In October 2019, APISIX was accepted as an incubating project in the Apache Incubator. Upon its graduation from the ASF, you became an Apache APISIX PMC member. Can you share your secrets in improving your skills along the way and the efforts you have made?**

After graduation, I paid much attention to the open-source APISIX project because I liked the way that it is open-sourced and a server-side project was new to me. When I joined the community, APISIX has not been donated to the ASF. One day, Ming Wen contacted me and asked me if I could develop a dashboard for APISIX. Actually, I had no experience in this field but I wanted to go it a go, so I created the first version. The first version was rough but had the core capabilities of Apache APISIX.

![Apache APISIX Dashboard V1.0](https://static.apiseven.com/202108/1651198249692-cb1180ee-b23d-4b40-86a8-ccae475534f8.png)

Later, this project was donated to the ASF and became an incubating project. Upon its acceptance into the Apache Incubator, all those founding members, initial members, and I became PPMC (Podling Project Management Committee, including ASF Mentors and Initial Committers) members. It was very cool to have an Apache ID. After the project graduated from the ASF and became a top-level Apache project, we became PMC members.

PMC is a project management committee responsible for clarifying the objectives of the community at present and in the future. If PMC members fail their duty, they may be voted out. As a PMC member, they have to assume all the responsibilities, including identifying and inviting active contributors to be committers to increase the vitality of projects and communities. As for the qualification of being a committer, the official documents of ASF mention that when a PMC member nominates a contributor as a committer and the number of pro votes prevails, the contributor is qualified to be a committer. Being elected as a committer is a tribute to the contributor. The whole community recognizes all the contribution and expects that the committer can make continued contribution in the future.

When it comes to the committer qualification specific to each community, each community has the liberty to set other limitations as long as the general ASF principle is followed. In the Apache APISIX community, every contributor can be a committer, as long as the contribution, code or non-code contribution, is recognized by PMC members and the community.

As a PMC member of Apache APISIX, it is my responsibility to scout for good committers for the Apache APISIX community. Natural empathy will also guide me to engage, connect, and share, paying attention to community members. Though I haven't seen most contributors face-to-face, I can feel how deeply the person understands a matter based on the way the person talks and cooperates. If I think a contributor has made lots of contributions, I will take the initiative to nominate the person. Among all those PMC members, I may be the one who has nominated the most committers.

Contributors in the community have different experiences and backgrounds. For the community, every contributor matters. Without contributors, the community cannot move forward sustainably.

**There are a total of 918 individual ASF Members. In your opinion, what made you become one of them?**

As far as I know, Ming Wen nominated me as an ASF Member for the following reasons: First, I'm a PMC member of Apache APISIX and I'm active in the Apache APISIX community. Second, I have participated in Google Summer of Code twice and Open Source Promotion Plan 2021 once as a tutor, helping many college students participate in open-source projects of the Apache Software Foundation. Third, I also actively participate in discussions on the Apache Community mailing list and offer help to the best of my abilities. Last, I'm an advocate for open-source and ASF culture. I attended many conferences and recorded a few podcast recordings to let more people know about Apache culture.

![52 New ASF Members in 2022](https://static.apiseven.com/202108/1651198257037-1bec2eaf-8ffa-42ed-9aee-53bcb46c2d89.png)

Personally speaking, I feel that maybe I did two things well. First, I'm always friendly and willing to support and encourage contributors. Good communication matters in a community. Once upon a time, I got in touch with an Indian student named Ayush Das and encouraged him to participate in the Apache APISIX community and Open Source Promotion Plan 2021. During months of communication, I found that he kept learning new technologies to help the community solve problems. However, because the computer was too old, he had to restart it frequently, so the development efficiency was greatly affected. To help him study more efficiently, I decided to sponsor him with a MacBook Pro M1.

![Ayush Das's Greeting to Zhiyuan on Happy Teacher's Day](https://static.apiseven.com/202108/1651198269797-6a64d882-5453-41df-bc83-7ef885537348.png)

Secondly, I always encourage community members to put forward their ideas. Expressing your ideas and opinions aloud is beneficial to both the community and community members. As a PMC member of Apache APISIX, I stick to Apache's principles, including **The Apache Way** and **Community Over Code**, and integrate them into community governance. We have a public Dev mailing list and a Private mailing list. In the private mailing list with only PMC members, we occasionally have arguments like "whether a contributor can be a committer". On such an occasion, some PMC members may keep silent while other PMC members may actively participate in the discussion. As for me, I would like to stick to the truth and express my opinions directly.

**Any plans on more open-source contributions and further engagement?**

I will keep participating in community activities and contributing to the community. I still remember that from the end of 2019 to the beginning of 2020, there were very few contributors to the web project, so I encouraged people around me to contribute so that this project could survive. Now, this project has been set back by another difficulty, so I have to encourage more developers to participate.

After joining the Apache APISIX community, my focus has been on this one community. After becoming an ASF Member, I will think from the perspective of the whole foundation and take on more responsibilities. In the future, I will split my attention among ASF projects, including Apache APISIX, incubating ASF projects, and projects that have graduated. Together with other ASF Members, we will advocate for open source, increase project vitality, and offer help and guidance. I hope that the Apache Foundation will remain evergreen in the next 20 years.

## Work, Life, and Self-Taught Programming

![Zhiyuan Ju](https://static.apiseven.com/202108/1651198278354-f104ab0a-3939-42c3-b0a9-c2f91bdc3999.png)

**You mentioned in your blog that you were working hard to become a full-stack web developer. Why were you interested in web technology and where are you on the way to becoming a full-stack web developer?**

In my spare time in high school, I had been doing web penetration and wanted to learn web security. I was curious about how to build web services, so I began to learn web theories and principles. I have gone through three learning stages, from complete confusion to  project-driven practice and finally embracing open source and contributing to open source.

In the first stage, I had no clue about web page rendering and access. After the college entrance examination in 2015, I got my first MacBook and began to search for and learn related tutorials.

In college, I began to participate in all kinds of projects. As the saying goes, "practice makes perfect," the more practice I had, the more experienced I was in technology.  I took on all kinds of projects, either fighting alone or working as a group team. As the number of projects increased, user needs became more complex and I was exposed to more and more technology stacks. The first project I was involved in was a full-stack project aimed at helping the Student Office to develop a content management system. I was responsible for defining user needs, UI design, front-end development, and server and database deployment. By trial and error, I finally completed this project and practiced what I learned.

In my senior year, I was exposed to open-source projects and began to follow open-source communities. Because I am self-taught in web technology, I didn't learn web technology systematically. Repeated project practices can bring me income, but it is not conducive to my growth in technology. By chance, I realized that the open-source code I used in projects was of high quality and community collaboration was patterned. Therefore, I decided to devote most of my time to learning the open-source project code and following open-source communities.

Although full-stack web development involves various activities such as frontend and backend development, prototype design, UI design, testing, etc., there is no measurement for assessing whether a person has full-stack capabilities. To answer your question, I think I have achieved it. When I manage a big project, I'm more confident than ever.

**You have started to work remotely a few years ago. How do you sense the difference between remote work and freelance work?**

When I was a sophomore, I thought that I must work freelancing instead of working remotely after graduation, but at that time, I didn't figure out the difference between the two things.

In 2018, I stayed in Frankfurt for half a year as an exchange student. At that time, I had my first formal remote work, and I would earn a sum of money every month. The experience was very good. Before going abroad, I have completed many projects remotely in China. Based on my experience, you can work freely as long as both parties agree on a deadline and you can meet the deadline.

After backing to China, I worked in Netease for a while and then I joined an American company named Team 247 and continued to work remotely. That was the first time I felt strongly about the difference between remote work and freelance work. Team 247 required that every employee respond to Slack messages promptly, which made me feel a little confined.

Later, I came to API7.ai, and there are some requirements for remote collaboration. At first, I was reluctant to obey these rules because there were no such rules when I joined the company. But after I had more conversations with everyone, I slowly understood the company's considerations in remote collaboration. Because remote work is uncommon in China and there aren't good practices, engineers have not developed good habits. So the company will help its employees develop good habits through remote work guidelines.

In my experience working remotely, I have found two common problems in remote collaboration. The first problem lies in that people are afraid to speak aloud. For example, when collaborating remotely, people may have these thoughts like "whether it's proper for me, an intern, to ask help from a technical expert" and "whether the question I ask is stupid." In fact, we don't have to worry so much. Be brave to ask for advice, and no one will care about these details. Moreover, most companies that offer remote work advocate "**Remote First**" and open-minded communication really matters in remote collaboration.

The second problem is that people have not fully developed the habit of **Documenting Anything**. Documenting Anything is a common practice for many **Remote First** companies. This also explains why the Global Team I lead puts items on the mailing list. On the one hand, if there is a personnel change, new employees can have an idea of what happened in the Global Team and know what everyone has done and what they are doing now and the progress. On the other hand, if there is no written record, it will lead to information loss, and the cost for newcomers to get started is very high. Therefore, in my daily work, even if it is face-to-face communication, as long as it is not a private matter, I will move the conversation to a public channel, which can help us trace the source and sync the information to more people.

**Remote work requires strong self-motivation from engineers. How do you stay motivated in your remote work?**

First of all, we are a startup, so there are many things to do. Secondly, I wake up earlier in the morning, usually at 5 o'clock, and then I will start planning my work for the day. I like being alone in the morning silence. In the early morning, I can do things very efficiently. Often before the meeting, I have already done all the work today, so I will read a book in the afternoon to relax a little. But most of the time, I will work simultaneously with my colleagues. As for me, there are too many things to do.

**How do you balance your life and work?**

I am trying to make a balance between work and life. From 2020 to now, I have worked an average of 13 hours a day. From the first day I came to the company, I said that I was here to start a business, so I have put a lot of energy into it. During the ten-hour work, I will work very efficiently because I have a clear idea of the work I need to do, the priorities, and the approach to different issues.

From the end of 2020, I began to do some management work, and this year I lead a global team. Although our processes change constantly for improvement, all team members are on the right track, cooperating smoothly and aligning their actions with team goals. All the results will be verified by data. So at the end of the month, I will have a short vacation, slow down, and get recharged.

For the past two years, I have been dealing with company affairs. Starting from this month, I will sign up for public activities, do more public sharing, and talk about the Apache culture, Apache APISIX, and open-source communities.

**Besides work, what other things are you interested in?**

It feels good to grow with a startup company. I consider my current job as a career and a hobby. I also care about education welfare. When I'm free, I will join or organize freeCodeCamp activities, encouraging and helping people around me to learn computers and technology. When the community you are in is growing, you will grow too. It's also a cool thing to help them realize their ideas on their own.

Sometimes, I wonder what I will do if I don't code anymore. My blog signature is "use magic to defeat magic." I think chemistry is a magical thing. When I was a child, I participated in BASF's activities and knew that BASF, a famous chemical company, was changing the world with chemistry. I am also interested in nature and biology and have read many encyclopedias related to the universe and nature.

When I was in college, I also played drones, took aerial photos of the school with my friends, and then reproduced them into a video with Minecraft, which is available on Bilibili ([a promotional video of Henan Normal University](https://www.bilibili.com/video/BV1As411a7Mc?from=search&seid=7847808159839607455&spm_id_from=333.337.0.0)). We also used drones to shoot sunrise on the top of Mount Tai, help the hometown shoot various videos, and help schools broadcast various activities live.

## Knowing More About Zhiyuan

Zhiyuan usually shares his recent thoughts and insights in his blogs. Through his words, we can see a young man exploring freely in open source, technology, work, and life. If you want to know more about Zhiyuan, you can subscribe to his [Blog](https://wineso.me/) and [GitHub](https://github.com/juzhiyuan).

Looking forward to more exploration and sharing from Zhiyuan in the future!
