---
title: "The Vulnerability of Leaking Information in Error Response from jwt-auth Plugin（CVE-2022-29266）"
keywords: 
- Vulnerability
- jwt-auth
- Error Response
description: In APISIX 2.13.0 and previous versions, there is a problem of information leakage caused by the `jwt- auth` plugin.
tags: [Vulnerabilities]
image: https://static.apiseven.com/2022/blog/0818/cve/CVE-2022-29266-1.png
---

> In APISIX 2.13.0 and previous versions, there is a problem of information leakage caused by the `jwt- auth` plugin.

<!--truncate-->

## Problem Description

The `jwt- auth` plugin has a security problem of leaking the user's secret key because the error message returned from the dependent library `lua-resty-jwt` contains sensitive information.

## Affected Versions

Apache APISIX 2.13.0 and all previous versions

## Solution

1. Please upgrade to Apache APISIX 2.13.1 or above immediately.
2. If it is not convenient to update the version, install the corresponding version of the patch on Apache APISIX to implement refactoring to bypass the vulnerability (after the patch is installed and takes effect, the error message received by the caller will be the fixed error message and will no longer contain sensitive information).

The following patches apply to LTS 2.13.x or major versions:

- https://github.com/apache/apisix/pull/6846
- https://github.com/apache/apisix/pull/6847
- https://github.com/apache/apisix/pull/6858

The following patches apply to the latest version of LTS 2.10.x:

- https://github.com/apache/apisix/pull/6847
- https://github.com/apache/apisix/pull/6855

## Vulnerability details

Severity：Urgent

Vulnerability public date: April 20, 2022

CVE details: https://nvd.nist.gov/vuln/detail/CVE-2022-29266

## Contributor Profile

The vulnerability was discovered and reported by Tang Zhongyuan, Xie Hongfeng and Chen Bing of Kingdee Software (China). Thank you for your contribution to the Apache APISIX community.

![Kingdee logo](https://static.apiseven.com/202108/1650768035541-306d3c7d-cbd4-4b79-ad9c-9f916549b8e7.png)
