---
title: "Apache APISIX Vulnerability for Rewriting X-REAL-IP Header (CVE-2022-24112)"
keywords: 
- Vulnerability
- Header
- IP restrictions
description: In versions prior to Apache APISIX 2.12.1, there is a risk of rewriting X-REAL-IP header after enabling the Apache APISIX `batch- requests` plugin. 
tags: [Vulnerabilities]
image: https://static.apiseven.com/2022/blog/0818/cve/CVE-2022-24112.png
---

> In versions prior to Apache APISIX 2.12.1, there is a risk of rewriting X-REAL-IP header after enabling the Apache APISIX `batch-requests` plug-in. Now the processing information will be announced.

<!--truncate-->

## Problem Description

In versions of Apache APISIX prior to 2.12.1 (excluding 2.12.1 and 2.10.4), there is a risk of rewriting the X-REAL-IP header when the Apache APISIX batch-requests plugin is enabled.

This risk leads to two problems:

- An attacker bypasses the IP restrictions on the Apache APISIX data plane via the batch-requests plugin. For example, bypassing IP black and white list restrictions.
- If the user uses the default Apache APISIX configuration (Admin API enabled, with the default Admin Key and no additional admin port assigned), an attacker can invoke the Admin API via the batch-requests plug-in.

## Affected Versions

- All versions of Apache APISIX between 1.3 ~ 2.12.1 (excluding 2.12.1)
- All LTS versions of Apache APISIX between 2.10.0 ~ 2.10.4 (excluding 2.10.4)

## Solution

- This issue has been resolved in versions 2.12.1 and 2.10.4, please update to the relevant version as soon as possible.
- In affected versions of Apache APISIX, you can avoid this risk by explicitly commenting out batch-requests in the conf/config.yaml and conf/config-default.yaml files and restarting Apache APISIX.

## Vulnerability details

Severity：High

Vulnerability public date: February 11, 2022

CVE details: https://nvd.nist.gov/vuln/detail/CVE-2022-24112

## Contributor Profile

This vulnerability was reported to the Apache Software Foundation by Sauercloud. Thank you for your contributions to the Apache APISIX community.

![Sauercloud](https://static.apiseven.com/202108/1644632196291-6b9bca14-7893-47c7-9f93-99c28ff54044.png)
