---
title: "Apache APISIX Path traversal in request_uri variable(CVE-2021-43557)"
author: "Sylvia"
authorURL: "https://github.com/SylviaBABY"
authorImageURL: "https://avatars.githubusercontent.com/u/39793568?v=4"
keywords:
- APISIX
- Apache APISIX
- Ingress Controller
- Request_uri
description: Using the $request_uri variable in the Apache APISIX Ingress Controller, there is a processing announcement that "bypasses some restrictions" leading to the risk of path penetration.
tags: [Vulnerabilities]
image: https://static.apiseven.com/2022/blog/0818/cve/CVE-2021-43557.png
---

> In versions prior to Apache APISIX 2.10.2, there was a problem of "bypassing partial restrictions" that caused the risk of path penetration by using the $request_uri variable in Apache APISIX Ingress Controller.

<!--truncate-->

## Problem Description

In versions prior to Apache APISIX 2.10.2, there was a problem of "bypassing partial restrictions" that caused the risk of path penetration by using the $request_uri variable in Apache APISIX Ingress Controller.

When using the `uri-blocker` plug-in to test the scenario, we found that:

```shell
$ ./apisix_request.sh "/public-service/public"
Defaulted container "apisix" out of: apisix, wait-etcd (init)
{"data":"public data"}
```

```shell
$ ./apisix_request.sh "/protected-service/protected"
Defaulted container "apisix" out of: apisix, wait-etcd (init)
<html>
<head><title>403 Forbidden</title></head>
<body>
<center><h1>403 Forbidden</h1></center>
<hr><center>openresty</center>
</body>
</html>
```

In both scenarios, `public-service` is available and `protected-service` is blocked by plug-ins. After the verification and testing of the above scenarios, it is found that both cases can bypass the limitations of Uri.

Due to the improper use of `ctx.var.require_uri` variables by the `uri-blocker` plug-in, the following results:

- Attacker can bypass access control restrictions and perform successful access to routes that shouldn’t be able to;
- Developers of custom plugins have no knowledge that `ngx.var.request_uri` variable is untrusted.

## Affected Versions

All versions of Apache APISIX prior to 2.10.2 (excluding 2.10.2)

## Solution

This issue has been resolved in version [2.10.2](http://apisix.apache.org/downloads/) +, please update to the relevant version as soon as possible.

In case of custom plugins, we suggest to do path normalization before using `ngx.var.request_uri` variable. There are also two other variables, high probably normalized, to check `ctx.var.upstream_uri` and `ctx.var.uri`.

## Vulnerability details

Vulnerability public date: November 22, 2021
CVE details: https://nvd.nist.gov/vuln/detail/CVE-2021-43557

## Contributor Profile

The vulnerability was discovered by community user Marcin Niemiec (GitHub[@xvnpw](https://github.com/xvnpw)) and reported to the Apache Software Foundation in a timely manner.

Thanks to Marcin Niemiec for his contribution to the Apache APISIX community.
