---
title: How can I contribute to an open source project without writing code?
slug: 2021/09/09/how-to-contribute-to-an-openSource-without-coding
author: Ruofei Zhao
authorURL: "https://github.com/Serendipity96"
authorImageURL: "https://avatars.githubusercontent.com/u/23514812?v=4"
keywords: 
- Open Source
- Contribution
description: You can participate in open source projects by writing articles, making videos, sharing them externally, building local communities.
tags: [Community]
---

> This article describes many ways to contribute to open source projects without writing code. You can get involved in open source projects by writing articles, making videos, sharing them externally, building local communities, and participating actively in community discussions.

<!--truncate-->

I have contributed several PRs and submitted several issues to open source projects, and I still remember clearly the excitement when my first PR was merged a few years ago, and I experienced the fun of participating in open source. But my experience remains in the contributor stage with no further progress, because I changed my position from front-end developer to marketing. I am afraid that I would be less familiar with the code,  and I can not fix the bug, which will result in no contribution to the project.

There is a misunderstanding here, not only contributing code and fixing bugs are contributions to the project. Is the only way to become a contributor is to contribute code? **If I can't write code and I'm not a developer, how can I become a contributor to an open source project and even get promoted to committer?** If I don't know how to write code and am not a developer, how can I become a contributor to an open source project or even be promoted to committer?

After I sorted it out, I found that there are many ways to become a contributor, so I'll share them here. (The author is also on the way to practice)

## Contributing without Coding

### Writing articles

Writing articles is an easily overlooked way to promote and evangelize a technology. For example, writing a project's induction guide, a pit-stop record, an architectural design analysis, implementation principles, etc.

If it is difficult to start writing articles, you can start with translation, either from Chinese to English or from English to Chinese, as long as the content is meaningful to the project, you are contributing to it.

Or if you have watched others' technical practical sharing, organize others' sharing into a text version and share it to the community to help more people understand the project.

I have also noticed that some contributors have put together a development booklet, or a professional book, to systematically introduce a technology to others.

### Making videos

Making videos is also a good way to do this. We can convert the text into a video, introduce an open source project in a video way, record a guide, step in the record, architecture design analysis, implementation principles and so on. I also saw a lot of projects using video presentation, the video may be the form of animation, may also be a real person to explain, no matter which, the video presentation will be more vivid and interesting than the text some.

However, the pre-editing video for newcomers to the workload may be relatively large.

### Conference sharing

If you are not shy and like to share outside, then going to technical conferences to share and preach open source projects is also a very good choice. This may be difficult for newcomers who understand the project, with time, when we progress from the little white to familiar, go to share is easier to reach. Sharing can exercise their own expression skills, logical thinking skills, but also exercise their own guts ~ (may also harvest the olive branch)

### Improve the documentation

Most developers do not like to write documentation, but documentation is an important way for other people to understand the project and get started with the project. I once in the development experience, if you encounter a clear and detailed documentation, I feel very lucky thing, get started on the project will be much faster. Documentation is not limited to start-up instructions, if there is an architectural design, the principle of the introduction is even better.

We can submit documentation for open source projects of interest, or even fix the documentation, for example

- code updates, the documentation is not updated at the same time
- fix the wrong download links, documentation links
- Optimize the documentation, modify the description of the documentation to make it easier to understand
- Submit architecture design, schematic documentation

### Build local community, organize/participate in events

If you are interested in a project, get involved in the local community, communicate with like-minded people, organize local events, and contribute to the development of the project.

If there is no local community, you can build one as an initiator. I know that the Apache Software Foundation encourages people to build Local Communities, such as ALC Beijing, and other technical communities such as KubeSphere and Cloud Native Community are actively developing local communities.

### Actively participate in community discussions

#### is active on the Apache mailing list

The Apache culture encourages discussion and decision making through mailing lists, where everything is documented. Each Apache project has its own mailing list, and if you have an idea for a project, the community strongly encourages you to discuss it on the mailing list.

We can.

- Post a poll for a project
- Reply to discussions started by others to express our own views
- Start a discussion

Why a mailing list?

Mailing lists give me a very old-fashioned feeling. I went to learn about the history of the Apache Software Foundation, and initially the founders of the foundation discussed issues by way of mailing lists, is it a preservation of the old culture?

Although the Internet is developing rapidly, but the world still has difficulties in receiving pictures, difficulties in using other software, although wechat, Twitter users we know also do not cover the world, but the use of mail can be the smallest threshold to establish contact with others, to ensure that people around the world can participate in community discussions, this is the original intention of the Apache Software Foundation to retain the mailing list approach.

#### is active on Github

Github is the most common site for developers, and most open source projects are hosted on Github. I can

- raise an issue with my thoughts on how to improve the project
- submit a bug report
- review pr submitted by other partners

These are all ways to contribute to open source projects.

#### Apache mail list vs Github

Why use a mailing list when you have Github? The code is hosted on Github, and it seems like all the community collaboration is done on Github?

If there are no objections to discussing an issue on the mailing list, the proposal will be approved by default. If there are objections, they will be fully discussed and eventually agreed or set aside.

The use of mailing lists for discussion is also a way to identify with the Apache culture. For projects that follow Apache rules, the mailing list is the primary place for the community, and Github is a convenient collaborative tool.

## Contributing with Coding

### Contribute features, fix bugs

Of course, open source projects are inseparable from the code. If you are familiar with the technology stack of an open source project, you will soon be able to contribute code, work with community partners to improve the relevant features, fix bugs, and continue to contribute, becoming a project contributor, and further nominated to become a committer, PMC is very easy to do. Most of the contributors become committer by submitting code, but as a small partner like me who is not familiar with code, this one is not suitable.

It is important to note that a committer is an affirmation of a contributor's past contributions and will not be removed as a committer because he or she will no longer contribute in the future, nor will they have greater rights because they are a committer.

## Summary

If you are interested in open source projects but not familiar with the code, and want to participate in the open source community, writing articles, making videos, sharing with the public, building local communities, and actively participating in community discussions are all very good ways, welcome to practice.
