---
title: "Apply Plugin Orchestration in Apache APISIX"
slug: 2021/07/27/use-of-plugin-orchestration-in-apache-apisix
author: "Zhiyuan Ju"
authorURL: "https://github.com/juzhiyuan"
authorImageURL: "https://avatars.githubusercontent.com/u/2106987?v=4"
keywords:
- Apache APISIX
- Plugin Orchestration
- Apache APISIX Dashboard
- API Gateway
description: Read this article to learn about Apache APISIX and basic usage scenarios, and how Apache APISIX integrates "drag and drop" plugin orchestration capabilities in a low-code trend.
tags: [Ecosystem]
---

> Read this article to learn about Apache APISIX and basic usage scenarios, and how Apache APISIX integrates "drag and drop" plugin orchestration capabilities in a low-code trend.

<!--truncate-->

## What is Apache APISIX?

Apache APISIX is a dynamic, real-time, high-performance API gateway. Apache APISIX provides rich traffic management features such as load balancing, dynamic upstream, canary release, circuit breaking, authentication, observability, and more. It has more than 50 built-in plugins covering authentication, security, traffic control, Serverless, observability, and other aspects to meet the common usage scenarios of enterprise customers.

As shown in the architecture diagram below, Apache APISIX is divided into two parts: the data plane (left side) and the control plane (right side): the control plane sends down the configuration to ETCD, and the data plane handles internal and external traffic with the help of rich plug-ins.

![Apache APISIX architecture](https://static.apiseven.com/202108/1639466553989-ecae1a31-8121-4390-a830-f386b9b12322.png)

Apache APISIX exposes a set of interfaces that allow us to bind plugins to the API. If we want to add speed-limiting capabilities to the API, we can simply bind the `limit-req` plugin to the API.

``` shell
curl -X PUT http://127.0.0.1:9080/apisix/admin/routes/1 -d '

 {
   "uri": "/get",
   "methods": ["GET"],
   "upstream": {
     "type": "roundrobin",
     "nodes": {
       "httpbin.org:80": 1
     }
   },
   "plugins": {
     "limit-req": {
       "rate": 1,
       "burst": 2,
       "rejected_code": 503,
       "key": "remote_addr"
     }
   }
 }'
```

After a successful call, the request will be speed-limited when it reaches the API.

This example uses limit-req to implement API speed limit (which is a specific function of Apache APISIX), but how to do it for the scenario of "decide the subsequent request processing logic based on the processing result of a plugin"? Currently, the existing plugin mechanism can not meet this demand, which then leads to the ability of plugin orchestration to solve this problem.

## What is Plugin Orchestration?

Plugin orchestration is a form of low-code that can help enterprises reduce usage costs and increase operation and maintenance efficiency, and is an indispensable capability in the process of digital transformation. With the plugin orchestration capability in the low-code API gateway Apache APISIX, we can easily orchestrate 50+ plugins in a “drag-and-drop” way, and the orchestrated plugins can share contextual information to realize scenario-based requirements.

Extending the above API speed limit scenario: the request is authenticated using the key-auth plugin, and if the authentication passes, the kafka-logger plugin takes over and logs; if the authentication fails (the plugin returns a 401 status code), the limit-req plugin is used to limit the speed.

See the following video on how to do it.

<iframe
    height="350"
    width="100%"
    src="https://api7-website-1301662268.file.myqcloud.com/202107/%E6%8F%92%E4%BB%B6%E7%BC%96%E6%8E%92.mp4"
    frameborder="0">
</iframe>

In this video, the Web interface lists the currently available plugins and drawing boards, and we can drag and drop the plugins onto the drawing boards to arrange them and fill in the data bound to the plugins, and then the whole process is completed. In the whole process.

The Web interface lists the currently available plugins and drawing boards, and we can drag and drop the plugins onto the drawing boards to arrange them and fill in the data bound to the plugins, and then the whole process is completed. In the whole process.

1. operation visualization: we can use the interface visualization in addition to the creation of API, but also through the ability to orchestrate intuitive and clear scenario design.

1. process reusable: by importing and exporting the JSON data of the drawing board, you can easily reuse the project data generated by orchestration.

1. Combine to create new "plugins": treat each scene as a plugin, and combine different plugins by using conditional components to create "plugins".

## How Plugin Orchestration Works?

So how does Apache APISIX combine with low-code capabilities? This requires the data side Apache APISIX and the control side Apache APISIX Dashboard to work together. The overall process is as follows.

![Apache APISIX plugin orchestration flow](https://static.apiseven.com/202108/1639466624894-039f4e63-fd21-403a-94c5-6efc8425eb0f.png)

### Apache APISIX

In Apache APISIX, we have added `script` execution logic to the Route entity, which can be used to receive and execute Lua functions generated by Dashboard, and it supports calling existing plugins to reuse the code. In addition, it also works on various stages of the HTTP request lifecycle, such as `access`, `header_filer`, `body_filter`, etc. The system will automatically execute the script function corresponding to the stage code at the corresponding stage, see the following `script` example.

```shell
{

  "script": "local _M = {} \n function _M.access(api_ctx) \n ngx.log(ngx.INFO,\"hit access phase\") \n end \nreturn _M"

}
```

### Apache APISIX Dashboard

Dashboard contains two sub-components, Web and ManagerAPI: Web provides a visual interface to configure the API gateway; ManagerAPI provides a RESTful API for the Web or other clients to call in order to operate the configuration center (ETCD by default) and thus indirectly control Apache APISIX.

In order to generate legal and efficient script functions, ManagerAPI chose the DAG directed acyclic graph data structure for the underlying design and developed the `dag-to-lua` [project](https://github.com/api7/dag-to-lua): it takes the root node as the start node and decides the next flow plugin based on the judgment It uses the root node as the start node and decides the next flow plugin based on the judgment condition, which will effectively avoid logical dead loops. The following is a diagram of the DAG data structure.

![Apache APISIX plugin orchestration DAG data structure](https://static.apiseven.com/202108/1639466682723-dcfd5c1b-9ae7-42b4-b3c2-c00aaf7a5996.png)

Corresponding to the script parameters received by ManagerAPI, the example is as follows.

```shell
{
  "conf": {
    "1-2-3": {
      "name": "plugin-a",
      "conf": {
        ...

      }
    },

    "4-5-6": {
      "name": "plugin-b",
      "conf": {
        ...
      }
    },
    "7-8-9": {
      "name": "plugin-c",
      "conf": {
        ...
      }
    }
  },

  "rule": {
    "root": "1-2-3", # initial node ID
    "1-2-3": [
      [
        "code == 200",
        "4-5-6"
      ], [
        "",
        "7-8-9"
      ]
    ]
  }
}
```

After the client converts the final orchestrated data into the above format, ManagerAPI generates Lua functions with the help of the dag-to-lua project and hands them over to Apache APISIX for execution.

On the Web side, after selection, comparison and project validation, we chose Ant Group's open source X6 graph editing engine as the underlying framework for the Web part of the plugin orchestration. In addition to perfect and clear documentation, a series of out-of-the-box interactive components and node customizability are the reasons we chose it.

![X6 introduction](https://static.apiseven.com/202108/1639466742487-269ebd5a-4f6c-47c3-a941-1275a4b3d178.png)

In the process of orchestration implementation, we abstract the concept of generic components and plug-in components: generic components are start nodes, end nodes and conditional judgment nodes, while plug-in components are every available Apache APISIX plug-in, and the process of plug-in orchestration is completed by dragging and dropping these components into the drawing board. As shown in the figure.

![Apache APISIX dashboard plugin orchestration demo1](https://static.apiseven.com/202108/1639466805116-0e1c9a83-e5d0-40c1-8a76-8cb1402a491c.png)

During the drag and drop process, we need to restrict a series of boundary conditions, here are a few examples.

When the plugin is not configured, the system will show the error message "There are unconfigured components", which allows you to visually see which plugin does not have configuration data.

![Apache APISIX dashboard plugin orchestration demo2](https://static.apiseven.com/202108/1639466853301-a67de136-633d-4b5d-9062-ac17bf625063.png)

When an API is edited, if the API is already bound with plugin data, when using the plugin orchestration mode, a warning message will appear after detection, and the system can only proceed if the user explicitly confirms that he/she wants to use the orchestration mode. This can effectively prevent the API data from being manipulated by mistake.

![Apache APISIX dashboard plugin orchestration demo3](https://static.apiseven.com/202108/1639466907551-07ec82f9-8988-4a66-a5f2-d3944d4f239c.png)

In addition, there are cases such as the start element can only have one output and the conditional judgment element can only have one input. Imagine: if the system allows users to operate without restrictions, unreasonable plugin combinations will be meaningless and generate unpredictable errors, so the continuous enrichment of boundary conditions is also an important consideration when designing the plugin arrangement.

When we finish the orchestration, we will use the API exposed by X6 to generate the JSON data of the flowchart, then convert it into the DAG data needed by the system, and finally generate Lua functions.

## Future Plans

The drag-and-drop approach makes it easier for users to combine plugins to meet different scenarios to enhance the scalability and operation and maintenance experience of API gateways. In the process of actual use, there are the following issues that can continue to be optimized.

1. The current boundary judgment conditions of the components are not rich enough, by continuing to improve these conditions to reduce unreasonable combinations of orchestration.

1. There are not many orchestration examples at present, and providing more reference examples can facilitate developers to learn and users to use.

1. The current Apache APISIX uses the code defined by the plugin for status return (exceptions return the status code, the request is terminated), can support more HTTP Response field or even modify the plugin definition to extend the plugin orchestration capabilities, such as the following plugin definition.

```shell
local _M = {
  version = 0.1,
  priority = 2500,
  type = 'auth',
  name = plugin_name,
  schema = schema,
  # A new result field has been added to store the results of plugin runs and pass them on to the next plugin
  result = {
    code = {
      type = "int"
    }
  }
}
```
