---
title: APISIX Dashboard Access Control Bypass Vulnerability Advisory (CVE-2021-33190)
slug: 2021/06/17/apache-apisix-dashboard-access-control-bypass-vulnerability-announcement
author: Zhiyuan Ju
authorURL: "https://github.com/juzhiyuan"
authorImageURL: "https://avatars.githubusercontent.com/u/2106987?v=4"
keywords:
- APISIX
- Apache APISIX
- Ingress Controller
description: Cloud native API gateway Apache APISIX Dashboard Access Control bypass vulnerability announcement, please upgrade the version as soon as possible to fix this vulnerability.
tags: [Vulnerabilities]
image: https://static.apiseven.com/2022/blog/0818/cve/CVE-2021-33190.png
---

> Because the application makes access control determinations by obtaining the value of the request header `X-Forwarded-For`, an attacker can achieve an access control bypass attack by simply tampering with that request header when invoking the API request.

<!--truncate-->

## Problem Description

In Apache APISIX Dashboard 2.6, there are two configuration entries.

1. the `conf.listen.host` configuration item, which specifies which IP address ManagerAPI listens to at startup, and which defaults to `0.0.0.0` (listens to external network requests by default).

2. the configuration item `conf.allow_list`, which is used for access control and only allows access to `127.0.0.1` (i.e. local network) by default.

Since the program makes access control determinations by obtaining the value of the request header `X-Forwarded-For`, an attacker can achieve an access control bypass attack by simply tampering with this request header when invoking an API request.

## Affected Versions

Apache APISIX 2.6.0

## Solution

This issue has been resolved in version 2.6.1. Please update to the latest version as soon as possible and change the default username and password after deploying the application.

## Vulnerability details

Vulnerability public date: June 8, 2021

CVE details: https://nvd.nist.gov/vuln/detail/CVE-2021-33190

## Contributor Profile

This vulnerability was discovered by Vern at Ping An Technology Galaxy Security Lab and reported to the Apache Software Foundation. Thanks to Vern and Ping An Technology Galaxy Security Lab for their contributions to the Apache APISIX community.

![2021-06-17-1](https://static.apiseven.com/202108/1639463130837-f27bf7bf-28b9-4742-a40f-ee43ebf5a7a8.jpeg)

## Expanded Reading

[Apache APISIX Contributor Interview | Pengcheng Wang, Senior Security Consultant, PwC South China Data Security & Privacy Team](./2021-01-11-interview-Apache-APISIX-contributor-Wang-Pengcheng-Senior-Security-Advisor-of-PwC-South-China-Data-Security-and- Privacy-Protection-Team.md)
