---
title: "Apache APISIX not affected by NGINX CVE-2021-23017"
slug: 2021/06/07/apache-apisix-not-affected-by-nginx-cve-2021-23017
author: "Ruofei Zhao"
authorURL: "https://github.com/Serendipity96"
authorImageURL: "https://avatars.githubusercontent.com/u/23514812?v=4"
keywords:
- APISIX
- Apache APISIX
- API Gateway
- Security
description: Cloud-native API gateway Apache APISIX is not affected by the NGINX (CVE-2021-23017) vulnerability.
tags: [Vulnerabilities]
image: https://static.apiseven.com/2022/blog/0818/cve/CVE-2021-23017.png
---

> On May 26, NGINX issued a security announcement that fixed a DNS resolver vulnerability (CVE -2021-23017) in the NGINX resolver.

<!--truncate-->

`ngx_resolver_copy()` handles DNS responses with errors. When the "resolver" instruction is used in the NGINX configuration file, it might allow an attacker who is able to forge UDP packets from the DNS server to cause 1-byte memory overwrite, resulting in worker process crash or other potential impacts.

Vulnerability level: high risk, CVSS score 8.1

Affected versions: NGINX 0.6.18 - 1.20.0

If you want to know more details, you can visit the following link: https://cve.mitre.org/cgi-bin/cvename.cgi?name=2021-23017

Two days before this security vulnerability was disclosed, on May 24, [Apache APISIX released version 2.6](https://mp.weixin.qq.com/s?__biz=MzI1MDU3NjQ5OA==&mid=2247485444&idx=1&sn=5b0bab964490dc2d7a7b25262d9396b2&chksm=e9816319def6ea0fbdafa69426718184e042d6d1cde1d20e410e6ee414756960273f9d625bd2&scene=21#wechat_redirect). This version contains many excellent features, such as support for using Java to write plugins. Apache APISIX 2.6 is not affected by this vulnerability.

Apache APISIX only uses some features of NGINX, other core functions, such as:

- Route matching
- IP matching
- DNS resolve
- Dynamic Upstream
- Dynamic Certificate

are all implemented by Apache APISIX instead of the built-in mechanism of NGINX, so it will not be affected by this security vulnerability.

## Apache APISIX

Apache APISIX is a dynamic, real-time, high-performance API gateway that provides rich traffic management features  such as load balancing, dynamic upstream, canary release, service meltdown , authentication , observability and so on.

You can use Apache APISIX to handle traditional north-south traffic, as well as east-west traffic between services.

In the cloud-native era, dynamic and observability are standard features of API gateway.

This architecture of Apache APISIX can not only meet the elastic scaling and rapid release under the cloud-native architecture, but also be more efficient, flexible and secure. It also cooperates with SkyWalking deeply in observability,  improving service management capability greatly.

Welcome to follow and use Apache APISIX: https://github.com/apache/apisix
