# iowncode

The below resources largely pertain to iOS 13. For iOS 14 and above, do check out [this repository](https://github.com/anupamchugh/iOS14-Resources)

## SwiftUI
* [SwiftUI Bar Charts](https://iosdevie.substack.com/p/swiftui-bar-charts) | [Code](https://github.com/anupamchugh/iowncode/tree/master/SwiftUIBarCharts)
* [Gestures in SwiftUI](https://iosdevie.substack.com/p/swiftui-gestures) | [Code](https://github.com/anupamchugh/iowncode/tree/master/SwiftUIGestures)
* [SwiftUI Line Charts](https://iosdevie.substack.com/p/swiftui-line-chart) | [Code](https://github.com/anupamchugh/iowncode/tree/master/SwiftUILineChart)
* [SwiftUI WebView ProgressBar: Modify States During View Updates](https://iosdevie.substack.com/p/modify-states-during-view-updates-in-swiftui) | [Code](https://github.com/anupamchugh/iowncode/tree/master/SwiftUIWebViewsProgressBars)
* [SwiftUI Change App Icon](https://medium.com/better-programming/how-to-change-your-apps-icon-in-swiftui-1f2ff3c44344?source=friends_link&sk=687ac692bb6df5ce97669066d799fa2f) | [Code](https://github.com/anupamchugh/iowncode/tree/master/SwiftUIAlternateIcons)
* [SwiftUI Contact Search](https://medium.com/better-programming/build-a-swiftui-contacts-search-application-d41b414fe046?source=friends_link&sk=38c67b34ada448c52827f5be1f70ada8) | [Code](https://github.com/anupamchugh/iowncode/tree/master/SwiftUIContactSearch)
* [SwiftUI Pull To Refresh Workaround](https://iosdevie.substack.com/p/swiftui-pull-to-refresh-workaround) | [Code](https://github.com/anupamchugh/iowncode/tree/master/SwiftUIPullToRefresh)


## CoreML and CreateML
* CoreML 3 On Device Training [Part 1: Build Updatable Model](https://iosdevie.substack.com/p/coreml3-updatable-retrainable-model) | [Part 2: Re-train On Device](https://iosdevie.substack.com/p/coreml3-on-device-training) | [Code](https://github.com/anupamchugh/iowncode/tree/master/iOSCoreMLOnDeviceTraining)
* [PencilKit Run Core ML Model MNIST](https://iosdevie.substack.com/p/pencilkit-coreml-ios13) | [Code](https://github.com/anupamchugh/iowncode/tree/master/iOSPencilKitCoreMLMNIST)
* [Sound Classifier Using CoreML and CreateML](https://iosdevie.substack.com/p/sound-classification-coreml-createml-ios) | [Code](https://github.com/anupamchugh/iowncode/tree/master/CoreML3SoundClassifier)
* [CoreML CreateML Recommender System](https://iosdevie.substack.com/p/core-ml-movie-recommender-createml) | [Code](https://github.com/anupamchugh/iowncode/tree/master/CoreMLRecommender)
* [CoreML NSFW Classifier Using CreateML](https://iosdevie.substack.com/p/nsfw-image-image-classifier-coreml-createml) | [Code](https://github.com/anupamchugh/iowncode/tree/master/NSFWCreateMLImageClassifier)
* [SwiftUI CoreML Emoji Hunter Game](https://iosdevie.substack.com/p/build-a-swiftui-core-ml-emoji-hunt) | [Code](https://github.com/anupamchugh/iowncode/tree/master/SwiftUIVisionEmojiHunt)
* * [CoreML Background Removal](https://iosdevie.substack.com/p/core-ml-background-removal-in-swiftui) | [Code](https://github.com/anupamchugh/iowncode/tree/master/CoreMLBackgroundChangeSwiftUI)

* [Real-time Style Transfer On A Live Camera Feed](https://iosdevie.substack.com/p/running-create-ml-style-transfer) | [Code](https://github.com/anupamchugh/iOS14-Resources/tree/master/CreateMLVideoStyleTransfer)


## Vision Framework
* [Built-in Text Recognition](https://iosdevie.substack.com/p/ios13-vision-text-doc-scanner) | [Code](https://github.com/anupamchugh/iowncode/tree/master/iOS13VisionTextRecogniser)
* [Image Similarity](https://iosdevie.substack.com/p/vision-image-similarity-feature-print-ios) | [Code](https://github.com/anupamchugh/iowncode/tree/master/iOSImageSimilarityUsingVision)
* [Scanning Credit Card Using Rectangle Detection and Text Recognition](https://iosdevie.substack.com/p/vision-ios-credit-card-scanner) | [Code](https://github.com/anupamchugh/iowncode/tree/master/VisionCreditScan)
* [Cropping Using Saliency](https://iosdevie.substack.com/p/ios13-vision-saliency) | [Code](https://github.com/anupamchugh/iowncode/tree/master/iOSVisionCroppingSalientFeatures)
* [Find Best Face Captured In A Live Photo](https://iosdevie.substack.com/p/vision-facecapturequality-request-livephotos-ios) | [Code](https://github.com/anupamchugh/iowncode/tree/master/iOSVisionFaceQualityLivePhoto)

* [Vision Contour Detection](https://iosdevie.substack.com/p/new-in-ios-14-vision-contour-detection) | [Code](https://github.com/anupamchugh/iOS14-Resources/tree/master/iOS14VisionContourDetection)
* [Vision Hand Pose Estimation](https://iosdevie.substack.com/p/swipeless-tinder-using-ios-14-vision) | [Code](https://github.com/anupamchugh/iOS14-Resources/tree/master/iOS14VisionHandPoseSwipe)

## Natural Language Framework
* [Classify Movie Reviews Using Sentiment Analysis and also CoreML](https://iosdevie.substack.com/p/classify-movie-reviews-with-natural)
* [Sentiment Analysis Of Hacker News Feed Using SwiftUI](https://iosdevie.substack.com/p/hackernews-nlp-sentiment-analysis-apple-swiftui) | [Code](https://github.com/anupamchugh/iowncode/tree/master/SwiftUIHNSentiments)

## RealityKit
* [Introduction To Entities, Gestures and Raycasting](https://iosdevie.substack.com/p/introduction-to-realitykit-on-ios) | [Code](https://github.com/anupamchugh/iowncode/tree/master/RealityKitEntitiesVision)
* [Collisions](https://iosdevie.substack.com/p/realitykit-collision-events-ios) | [Code](https://github.com/anupamchugh/iowncode/tree/master/RealityKitCollisions)

</br>

Let's connect on [Twitter](https://twitter.com/chughanupam)!

</a>










