# awesome-computer-science-opportunities
An awesome list of events and fellowship opportunities for computer science students

## Contents

 - [Learning Platform](#learning-platform)
   - [Competitive Programming](#competitive-programming)
   - [Web Development](#web-development)
   - [Mobile Development](#mobile-development)
   - [DevOps](#devops)
   - [Data Science](#data-science)
   - [Artificial Intelligence](#artificial-intelligence)
   - [Computer Science](#computer-science)
   - [Open Source](#open-source)
 - [Infosec](#infosec)
 - [MOOCs](#moocs)
 - [Fellowships](#fellowshipsscholarships)
 - [Programming Events](#programming-events)
 - [Hackathons](#hackathons)
 - [General Opportunities](#general-opportunities)
 - [Projects](#projects)

## Learning Platform

[Back to Top](#contents)

 ### Competitive Programming

 * [HackerRank](http://hackerrank.com) - Solve code challenges to prepare for programming interviews.
 * [HackerEarth](http://hackerearth.com) - Solve code challenges to help companies find innovative solutions for their businesses.
 * [CodeChef](http://codechef.com) - Non-profit competitive programming platform.
 * [TopCoder](http://topcoder.com) - Participate in code challenges and help solve real world problems.
 * [CodeForces](http://codeforces.com) - Russian website dedicated to competitive programming.
 * [ProjectEuler](http://projecteuler.net) - Solve computational and mathematical problems using your programming skills.
 * [Spoj](http://spoj.com) - Programming contests with online judging system.
 * [InterviewBit](https://www.interviewbit.com) - A platform to learn and practice coding interview questions.
 * [VisuAlgo](https://visualgo.net/en) - Visualizing data structures and algorithms through animation.
 * [LeetCode](https://leetcode.com) - Develop programming skills for your next interview.
 * [FireCode](https://www.firecode.io/) - An online coding interview preparation.
 * [CodeWars](https://www.codewars.com/) - Code challenges platform to level up your skills.
 * [CodinGame](https://www.codingame.com/) - Learn to code by playing games.
 * [CodeForces](http://codeforces.com/) - Online platform that hosts competitions and problem sets	
 * [DailyProgrammer](https://www.reddit.com/r/dailyprogrammer/) - Solutions to programming challenges, peer reviewed with community feedback.
 * [CodeFights](https://codefights.com) - Practice programming and land a job.
 * [UVa](https://uva.onlinejudge.org) - Programming contests with online judging system.
 * [Stanford ACM ICPC](https://github.com/jaehyunp/stanfordacm) - Stanford [Notebook](https://github.com/jaehyunp/stanfordacm/blob/master/notebook.pdf) provides printable templates usable during online/on-site contests.
 * [Exercism](http://exercism.io/) - Solve programming challenges from your terminal.
 * [DailyCodingProblem](https://www.dailycodingproblem.com/) - Get exceptionally good at coding interviews by solving one problem every day.
 * [acmp.ru](http://acmp.ru) - Russian programming contests
 * [Timus Online Judge](http://acm.timus.ru/?locale=en) - Programming contests with online judging system.
 * [DMOJ: Modern Online Judge](https://dmoj.ca) - contest platform and archive of programming problems
 * [Rose Code](https://www.rosecode.net/) - Programming challenges with leaderboards and blog posts
 * [Coderbyte](https://coderbyte.com/) - Programming challenges and specific routes to help learn specific skills
 * [Code Golf](https://code-golf.io/) - Programming challenges with individual leaderboards for problems
 * [Daily Coding Problem](https://www.dailycodingproblem.com/) - Get emailed a new coding problem every day
 * [Halite](https://halite.io/) - Create AI to face off against other people's AI. More specialized on AI
 * [Advent of Code](https://adventofcode.com/) - A yearly set of coding challenges that published with leaderboards
 * [StopStalk](https://www.stopstalk.com/) - A tool to analyse and improve your Competitive Programming Progress
 * [Quine](https://quine.sh/) - Competitive open source contributing

 ### Web Development

 * [Learn Enough to Be Dangerous](https://www.learnenough.com/) - Free online coding tutorials on JavaScript, Ruby, Rails, CSS and more.
 * [FreeCodeCamp](http://freecodecamp.com) - Coding tutorials and challenges.
 * [Javascript Info](https://javascript.info/) - The Modern JavaScript Tutorial
 * [Thimble](https://thimble.mozilla.org/en-US/) - Free online code editor, web server, web browser & developer tools.
 * [NodeSchool](https://nodeschool.io) - Open source workshops that teach web software skills.
 * [The Odin Project](https://www.theodinproject.com/) - A full free open source coding curriculum.
 * [Egghead](https://egghead.io/) - Video tutorials on popular JavaScript frameworks.
 * [Codecademy](https://www.codecademy.com/) - Free and premium interactive tutorials for various languages.
 * [CodeSchool](https://www.codeschool.com/) - Combination of video and interactive tutorials.
 * [MDN web docs](https://developer.mozilla.org/en-US/docs/Learn) - Web development articles by Mozilla.
 * [W3Schools](https://www.w3schools.com/) - Tutorials on HTML, CSS, JavaScript and more.
 * [Eloquent JavaScript](http://eloquentjavascript.net/) - An online book about JavaScript.
 * [Coder-Coder](https://www.coder-coder.com/) - Tutorials on Web Development from basics including HTML, CSS, JavaScript and more.
 * [CodeCraft](https://codecraft.tv/) - Provide Web Development Courses on JavaScript, AngularJS, Angular 5 for free.
 * [Scrimba](https://scrimba.com/) - Provides Web Development Courses with a unique feature of live interaction with the instructor's code.
 * [FrontendMasters](https://frontendmasters.com/) - In-depth and advanced video tutorials on Frontend Devlopment from experts in the industry.
 * [MiguelGrinberg](https://blog.miguelgrinberg.com/) - In-depth and beginner friendly tutorial on using Flask with an interesting sample project.

 ### Mobile Development

 * [Udacity Android Nanodegree](https://in.udacity.com/course/android-developer-nanodegree-by-google--nd801) - Students can also apply for [scholarship](https://in.udacity.com/google-india-scholarships) given by Google.
 * [Android Developer Training](https://developers.google.com/training/android/) - Range of courses to help you build Android apps.
 * [Vogella](http://www.vogella.com/tutorials/android.html) - Tutorials about Android development.
 * [Android Hive](https://www.androidhive.info) - Android tutorials blog.
 * [iOS development](https://in.udacity.com/course/intro-to-ios-app-development-with-swift--ud585) - Build your first iOS app with an Udacity course.

 ### DevOps

 * [DevOps Bootcamp](http://devopsbootcamp.osuosl.org/start-here.html) - Course dedicated to teach core software development and systems operation skills.
 * [Google IT Support Course](https://www.coursera.org/specializations/google-it-support) - Google course to prepare you for a job in IT support.

 ### Data Science

 * [Kaggle](http://kaggle.com) - Data science competitive platform.
 * [DataQuest](http://dataquest.io) - Learn data science with your browser.
 * [DataCamp](http://datacamp.com) - Learn data science online.
 * [DrivenData](https://www.drivendata.org/) - Participate in data science competitions and help organizations.
 * [Analytics Vidhya](http://analyticsvidhya.com) - Training and Q&A platform based around data science.
 * [fast.ai](http://course.fast.ai/) - Deep Learning with only prerequisite being general coding skills.
 * [TunedIT](http://tunedit.org/data-competitions) - Data Mining competitions.
 * [Data Science Central](https://www.datasciencecentral.com/) - the online resource for big data practitioners.
 * [KPMG Data Science Virtual Internship](https://www.insidesherpa.com/virtual-internships/theme/m7W4GMqeT3bh9Nb2c/KPMG-Data-Analytics-Virtual-Internship) - learn data science from a Big 4 accounting firm and how it's used in industry.

 ### Artificial Intelligence

 * [Siraj Raval](https://www.youtube.com/channel/UCWN3xxRkmTPmbKwht9FuE5A) - YouTube channel with tutorials about AI.
 * [Sentdex](https://www.youtube.com/user/sentdex) - YouTube channel with programming tutorials.
 * [Two Minute Papers](https://www.youtube.com/user/keeroyz) - Learn AI with 5 mins videos.
 * [Andrej Karpathy](http://karpathy.github.io/) - Old blog about AI, now posting on [Medium](https://medium.com/@karpathy/).
 * [iamtrask](http://iamtrask.github.io/) - Machine Learning blog.
 * [colah's blog](http://colah.github.io/) - Blog about neural networks. 
 * [Google Machine Learning Course](https://developers.google.com/machine-learning/crash-course) - A crash course of machine learning taught by Google Engineers
 * [Google AI](https://ai.google/education/)- Learn from ML experts at Google

 ### Computer Science
 * [BaseCS](https://medium.com/basecs) - Explains computer science basics in easy-to-digest articles. Also in [podcast](https://www.codenewbie.org/basecs) format.
 * [Tutorials Point](http://tutorialspoint.com) - tutorials for technologies like web, mobile and many more.
 * [Introduction to Computer Science - CS101](https://classroom.udacity.com/courses/cs101/) - introduction to computer science in python language.

 ### Open Source

 * [Up For Grabs](http://up-for-grabs.net/#/) - Start exploring open source projects and get involved in them.
 * [24 Pull Requests](https://24pullrequests.com) - Yearly initiative to encourage developers to send 24 pull requests during December.
 * [HacktoberFest](https://hacktoberfest.digitalocean.com) - Similar to 24PullRequests, gives swag for 4 accepted pull requests.
 * [OpenHatch](https://openhatch.org/search/) - Non-profit providing tools for new open source contributors.
 * [First Timers Only](http://www.firsttimersonly.com) - Beginners-friendly open source projects.
 * [Your First PR](http://yourfirstpr.github.io/) - Helps you make a contribution by showcasing great starter issues on Github.
 * [Awesome For Beginners](https://github.com/MunGell/awesome-for-beginners) - A list of awesome beginners-friendly projects.
 * [CodeTriage](https://www.codetriage.com/) - Pick your favorite projects to receive a different issue in your inbox every day.
 * [Open Source Friday](https://opensourcefriday.com/) - Helps you find a project to contribute to.

## Infosec
__How to start? - blogs__
* [Beginner Bug Bounty Hunters resources](https://github.com/nahamsec/Resources-for-Beginner-Bug-Bounty-Hunters)- Collection of resources to build up the basics of Web Application Security
* [Getting Started in Bug Bounty Hunting](https://whoami.securitybreached.org/2019/06/03/guide-getting-started-in-bug-bounty-hunting/) - What You Should Know Before Starting to learn about Bug Bounty Hunting?
* [Getting started in Bug Bounty](https://medium.com/@ehsahil/getting-started-in-bug-bounty-7052da28445a) - How to get started in Bug Bounties
* [How to get started with bug Bounty?](https://medium.com/@unknownuser1806/what-i-have-learn-in-my-first-month-of-hacking-and-bug-bounty-dc1a4be58294) - What you need to learn before getting started with bug bounty
* [METHODOLOGY , TOOLKIT , TIPS & TRICKS](https://medium.com/bugbountywriteup/bug-bounty-hunting-methodology-toolkit-tips-tricks-blogs-ef6542301c65) - A complete bug bounty blog for beginners

__Recon__
* [Recon - by Sahil Ahamad](https://medium.com/@ehsahil/recon-my-way-82b7e5f62e21) - Blog post on reconnaissance processes for web applications security testing
* [Recon - by Adrien](https://medium.com/bugbountywriteup/whats-tools-i-use-for-my-recon-during-bugbounty-ec25f7f12e6d) - What tools I use for my recon during Bug Bounty

## MOOCs

[Back to Top](#contents)

* [Udacity](http://udacity.com) - Free and paid online classes.
* [Coursera](http://coursera.org) - Courses from schools and universities like Stanford and Yale.
* [Udemy](http://udemy.com) - Online learning and teaching platform.
* [edX](https://www.edx.org) - Free online courses from institutions like Harvard, MIT, Microsoft and more.
* [Codecademy](https://www.codecademy.com/) - Online learning platform for coding.
* [MIT OPENCOURSEWARE](https://ocw.mit.edu/courses/find-by-department/) - Browse and learn with free MIT courses' material.
* [Microsoft Virtual Academy](https://mva.microsoft.com) - Free courses on IT basic concepts and Microsoft products and services.
* [Awesome Courses](https://github.com/prakhar1989/awesome-courses) - List of awesome university courses for learning Computer Science.
* [Lynda](https://www.lynda.com) - Online learning platform.
* [Stanford Online](https://online.stanford.edu/courses) - Stanford's courses platform.
* [Pluralsight](https://www.pluralsight.com/) - Paid learning platform made to help you build your career or land a job.
* [Khan Academy](https://www.khanacademy.org/) - Free online learning platform.
* [Sololearn](https://www.sololearn.com/) - Learn coding from the ground up for free!! (also available on android)
* [Y Combinator](https://www.insidesherpa.com/virtual-internships/prototype/oRMogWRHeewqHzA7u/College-students%3A-Learn-how-to-work-at-a-YC-startup-) - Learn how engineering works at a Y Combinator startup
* [MOOC.fi](https://www.mooc.fi/en) - Free courses from the University of Helsinki's Department of Computer Science.

## Fellowships/Scholarships

[Back to Top](#contents)

* [Developer Scholarship from Google](https://in.udacity.com/google-india-scholarships) - Link for Indian students (Others click [here](https://www.udacity.com/scholarships)).
* [Scholarship Opportunities at Google](https://edu.google.com/scholarships/) - Google's scholarship opportunities.
* [Microsoft Scholarship Program](https://careers.microsoft.com/students/scholarships) - For students at US/Canada/Mexico only.
* [Fellowships at Microsoft Research Asia](https://www.microsoft.com/en-us/research/academic-program/fellowships-microsoft-research-asia/) - For students in mainland China, Hong Kong, Japan, Korea, Singapore, or Taiwan.
* [IBM PhD Fellowship](https://www.research.ibm.com/university/awards/fellowships.html) - For students who want to make their mark in promising and disruptive technologies.
* [Thiel Fellowship for young innovators](http://thielfellowship.org) - Intended for students under 23yo and offers a total of $100,000 and guidance to drop out of school and pursue other work.
* [The Facebook Fellowship Program](https://research.fb.com/programs/fellowship/) - Designed to encourage promising doctoral students who are engaged in areas related to computer science.
* [NVIDIA Graduate Fellowships](http://research.nvidia.com/graduate-fellowships) - Fellowship for AI,ML students.
* [S.N. Bose Scholars Program](http://iusstf.org/story/53-74-For-Indian-Students.html) - For Indian Students.
* [Richard E. Merwin Student Scholarship](https://www.computer.org/web/students/merwin) - For IEEE members.
* [The Data Science for Social Good Fellowship](https://dssg.uchicago.edu) - It is a University of Chicago summer program to train aspiring data scientists to work on data mining, machine learning, big data, and data science projects with social impact.
* [The Data Incubator](https://www.thedataincubator.com) - The Data Incubator is an 8-week educational fellowship preparing students with Master's degrees and PhDs for careers in big data and data science.
* [Kleiner Perkins Fellow - Engineering](http://fellows.kleinerperkins.com) - Kleiner Perkins Fellows program matches accepted fellows up with their partnering Silicon Valley startups over the summer.
* [Cern Openlab Summer Student Programme](https://openlab.cern/education) - CERN openlab is a 2 month long student program where students complete assigned projects with CERN members during the summer.
* [HackNY Fellow](https://apply.hackny.org/) -  Fellowship that matches students with New York City Startups 
* [Adobe India Women-in-Technology Scholarship](https://research.adobe.com/adobe-india-women-in-technology-scholarship/) - Adobe Scholarship for encouraging women to showcase their excellence in computing and technology.
* [Grace Hopper Scholarship](https://www.gracehopper-gitusc.com/#!) - A Scholarship by USC Girls in Tech.
* [WeTech Qualcomm Global Scholarship](https://www.iie.org/Programs/WeTech/STEM-Scholarships-for-Women/Qualcomm-Global-Scholars-Program) - A scholarship for women in technology by Qualcomm and IIE.
* [Emeritus fellowship](https://www.ugc.ac.in/ef/) - For the superannuated teachers.
* [Junior research fellowship in science, humanities and social science](https://www.ugc.ac.in/oldpdf/xplanpdf/JRFscience.pdf) - It is for qualifiers of UGC and UGC-CSIR tests.
* [UGC research fellowships in science for meritorious students](https://www.ugc.ac.in/oldpdf/xiplanpdf/meritorious%20students.pdf) - It is to promote quality research in University/Departments. 
* [Junior research fellowship in engineering and technology](https://www.ugc.ac.in/oldpdf/xiplanpdf/JRFE-T.pdf) - It is for those who wish to pursue Ph.D. degree in engineering and technology.
* [Swarnajayanti fellowships scheme](https://dst.gov.in/scientific-programmes/scientific-engineering-research/human-resource-development-and-nurturing-young-talent-swarnajayanti-fellowships-scheme) - For providing special assistance and support to talented young scientist.
* [MLH Fellowship](https://fellowship.mlh.io/programs/explorer) - The MLH Fellowship helps software engineers level up

## Programming Events

[Back to Top](#contents)

* [Google Summer of Code](https://summerofcode.withgoogle.com) - A global program focused on bringing more student developers into open source software development.
* [Google CodeJam](https://codingcompetitions.withgoogle.com/codejam) - Google’s largest coding competition.
* [Google Kickstart](https://codingcompetitions.withgoogle.com/kickstart) - Many online rounds to give students the opportunity to develop their coding skills and pursue a career at Google.
* [Google HashCode](https://hashcode.withgoogle.com) - Programming competition organized by Google for students and industry professionals across Europe, the Middle East and Africa.
* [Google Code-in](https://codein.withgoogle.com/) - A competition for pre-university students(13 to 17 years old) to introduce themselves to the world of open source by doing small tasks for various open source projects.
* [ACM-ICPC](https://icpc.baylor.edu/) - The International Collegiate Programming Contest is an algorithmic programming contest for college students.
* [Facebook HackerCup](https://www.facebook.com/hackercup/) - Annual programming contest organized by Facebook.
* [List of Open Source Internship Programs](https://github.com/tapasweni-pathak/SOC-Programs) - Includes [Rails Girls Summer of Code](https://railsgirlssummerofcode.org/) and [Outreachy](https://www.outreachy.org/).
* [Hactoberfest](https://hacktoberfest.digitalocean.com) - Organized by Digital Ocean in October.
* [IEEEXtreme](https://ieeextreme.org) - Annual 24 hour long team contest for IEEE members.

## Hackathons

[Back to Top](#contents)

* [Devpost](http://devpost.com/hackathons) - Online or in-person hackathons browsing platform.
* [hackathon.io](http://hackathon.io) - Browse in-person hackathons.
* [Hackalist](https://www.hackalist.org) - List of upcoming hackathons.
* [AngelHack](https://angelhack.com) - Hackathon planning organization.
* [Hackevents](https://hackevents.co/hackathons) - Hackathons search engine.
* [Yelp Dataset Challenge](https://www.yelp.com/dataset/challenge) - The challenge is a chance for students to conduct research or analysis on our data and share their discoveries with Yelp.
* [hack.summit()](https://www.crowdcast.io/hack_summit) - Virtual conference where you can learn from the world's most renowned programmers.
* [Major League Hacking Event Page](https://mlh.io/) - A list of a ton of events that are sponsored by the official hackathon league
* [Microsoft Imagine Cup](https://imaginecup.microsoft.com/en-us/Events?id=0)-Bring your tech idea to life with the Imagine Cup and make a difference through creativity, collaboration, and competition.

## General Opportunities

[Back to Top](#contents)

* [Github Student Pack](https://education.github.com/pack) - Get free access to the best developer tools in one place.
* [Visual Studio Dev Essentials](https://www.visualstudio.com/dev-essentials/) - Free learning resources and programming tools.

## Projects

[Back to Top](#contents)

* [CodeCrafters](https://app.codecrafters.io/tracks?r=2ay) — Recreate popular technologies from scratch, in any language. e.g Build your own Git, Docker, Redis, etc.
* [Community Driven Demo Projects](https://www.crio.do/projects/) - Find interesting mini projects for CSE and get started with an execution plan
