import { G2Spec } from '../../../src';
import { tooltipSteps } from './utils';

export function mockGroupInterval(): G2Spec {
  return {
    type: 'interval',
    data: {
      type: 'inline',
      value: [
        {
          '86693d71f3f84027991dbbf50996f821': 6053623.85,
          df21a9ed840b48a6a22435e031ab0671: 6613267,
          D2022010400161505000009920363_sum: 27616846.54,
          D2022010400161505000009920358: '德邦',
          '0223e03e9153401b8db66afb1e989526': 5571.16,
        },
        {
          '86693d71f3f84027991dbbf50996f821': 6035281.49,
          df21a9ed840b48a6a22435e031ab0671: 6537072,
          D2022010400161505000009920363_sum: 27701405.4,
          D2022010400161505000009920358: '邮政',
          '0223e03e9153401b8db66afb1e989526': 5535.71,
        },
        {
          '86693d71f3f84027991dbbf50996f821': 6345550.92,
          df21a9ed840b48a6a22435e031ab0671: 6475557,
          D2022010400161505000009920363_sum: 28880528.23,
          D2022010400161505000009920358: '申通',
          '0223e03e9153401b8db66afb1e989526': 5575.93,
        },
        {
          '86693d71f3f84027991dbbf50996f821': 6045575.04,
          df21a9ed840b48a6a22435e031ab0671: 6475313,
          D2022010400161505000009920363_sum: 27632017.31,
          D2022010400161505000009920358: '圆通',
          '0223e03e9153401b8db66afb1e989526': 5528.19,
        },
        {
          '86693d71f3f84027991dbbf50996f821': 5647259.32,
          df21a9ed840b48a6a22435e031ab0671: 6559678,
          D2022010400161505000009920363_sum: 26538220.29,
          D2022010400161505000009920358: '韵达',
          '0223e03e9153401b8db66afb1e989526': 5523.76,
        },
        {
          '86693d71f3f84027991dbbf50996f821': 5920258.17,
          df21a9ed840b48a6a22435e031ab0671: 6586067,
          D2022010400161505000009920363_sum: 27766226.48,
          D2022010400161505000009920358: '其他',
          '0223e03e9153401b8db66afb1e989526': 5589.46,
        },
        {
          '86693d71f3f84027991dbbf50996f821': 5590605.94,
          df21a9ed840b48a6a22435e031ab0671: 6557904,
          D2022010400161505000009920363_sum: 25899615.78,
          D2022010400161505000009920358: '顺丰',
          '0223e03e9153401b8db66afb1e989526': 5447.06,
        },
      ],
      transform: [
        {
          type: 'rename',
          D2022010400161505000009920363_sum: '单价',
          '0223e03e9153401b8db66afb1e989526': '折扣',
          '86693d71f3f84027991dbbf50996f821': '单位成本',
          df21a9ed840b48a6a22435e031ab0671: '数量',
        },
        {
          type: 'fold',
          fields: ['单价', '折扣', '单位成本', '数量'],
          key: 'folded_key',
          value: 'folded_value',
        },
      ],
    },
    encode: {
      x: 'D2022010400161505000009920358',
      y: 'folded_value',
      color: 'folded_key',
    },
    transform: [{ type: 'dodgeX' }],
    interaction: {},
  };
}

mockGroupInterval.steps = tooltipSteps(2);
