package com.openmeet.shared.data.storage;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Interface for extracting a specific Bean from a ResultSet.
 *
 * @see ResultSet
 *
 * @author Francesco Granozio
 * @author Angelo Nazzaro
 * */
public interface ResultSetExtractor<B> {

    /**
     * Extracts the Bean from a ResultSet generated by a CRUD Query.
     *
     * @param resultSet the resultSet to extract the bean from.
     * @return the Bean object extracted.
     *
     * @author Francesco Granozio
     * @author Angelo Nazzaro
     * */
    B extract(ResultSet resultSet) throws SQLException;
}
