# Contributing to OpenMeet
Hi and welcome to OpenMeet contributing guidelines! First of all, we want to thank you for investing your time and efforts into our project ❤️. <br>
If you are not familiar with the project, we suggest you to checkout the wiki where we describe the structure of the OpenMeet project and if you are really interested to know all the engineering process behind OpenMeet you can checkout the documentation: 
- [Wiki]()
- [Docs](https://github.com/sl1mSha4dey/openMeet_Classe03/tree/main/deliverables)


## How to submit changes
In order to submit changes to the project, please open up a **pull request** where you describe the changes you've made and why you have made them. <br>
The basic steps required to open a pull request are the following: 
- Fork the [main repository](https://github.com/sl1mSha4dey/openMeet_Classe03); 
- Clone your fork onto your machine; 
- Create your feature branch: `git checkout -b 'my-features'`; 
- Commit your changes: `git commit -m "Brief description"`; 
- Push to the branch: `git push origin my-features`; 
- Open up a pull request and explain what you did; 

Since the project is structured into multiple apps and directories, if you're willing to make a change on the code, your branch name should start with the app or directory you're intending to modify. For example, if you want to make changes to the webapp, your branch should be called `webapp-my-changes`. 

### I don't know how pull requests work
If it's your first time contributing to a project on Github, don't worry, Github's got you covered! Follow the guide [here](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests) to understand what pull requests are, how they work and why they are useful. 

## How to report a bug 
To report a bug don't try to fix it on your own! First, open up an issue, describe the bug you've found and your possible solution to it. <br> 
Before reporting a bug make sure it's not already been reported. 

### I don't know what an issue is
Once again, Github got you covered! Follow the guide [here](https://docs.github.com/en/issues/tracking-your-work-with-issues/about-issues) to understand what issues are and why are they useful. 

### Why should I open an issue in order to fix a bug?
Opening up an issue notifies the community of the existence of the bug; you can discuss with more experienced members to find the best solution together.  

## Not only code!
Submitting code is not the only way you can contribute to this repository. If you're not familiar with the technologies used in this project but you still want to contribute to it, you can! <br>
There are various ways you can help our community grow and evolve. You can review pull requests, look for bugs, test the various aspects and functionalities of the project, propose new additions and so on. <br>
Any received help is important and appreciated! ❤️
