/*
 * Decompiled with CFR 0.152.
 */
package com.openmeet.shared.utils;

import java.util.ArrayList;
import java.util.Map;

public class QueryBuilder {
    private final StringBuilder sqlBuilder;

    private QueryBuilder(StringBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    public static QueryBuilder SELECT(String ... columns) {
        if (columns == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select ");
        sqlBuilder.append(String.join((CharSequence)", ", columns));
        return new QueryBuilder(sqlBuilder);
    }

    public QueryBuilder FROM(String ... tables) {
        if (tables == null) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" from ");
        this.sqlBuilder.append(String.join((CharSequence)", ", tables));
        return this;
    }

    public QueryBuilder JOIN(String table) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" join ");
        this.sqlBuilder.append(table);
        return this;
    }

    public QueryBuilder LEFT_JOIN(String table) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" left join ");
        this.sqlBuilder.append(table);
        return this;
    }

    public QueryBuilder RIGHT_JOIN(String table) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" right join ");
        this.sqlBuilder.append(table);
        return this;
    }

    public QueryBuilder ON(String predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" on ");
        this.sqlBuilder.append(predicate);
        return this;
    }

    public QueryBuilder WHERE(String predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" where ");
        this.sqlBuilder.append(predicate);
        return this;
    }

    public QueryBuilder ORDER_BY(String ... columns) {
        if (columns == null) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" order by ");
        this.sqlBuilder.append(String.join((CharSequence)", ", columns));
        return this;
    }

    public QueryBuilder LIMIT(int row_count) {
        if (row_count < 0) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" limit ");
        this.sqlBuilder.append(row_count);
        return this;
    }

    public QueryBuilder LIMIT(int offset, int row_count) {
        if (offset < 0 || row_count < 0) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" limit ");
        this.sqlBuilder.append(offset);
        this.sqlBuilder.append(", ");
        this.sqlBuilder.append(row_count);
        return this;
    }

    public QueryBuilder UNION(QueryBuilder queryBuilder) {
        this.sqlBuilder.append(" union ");
        this.sqlBuilder.append(queryBuilder.toString());
        return this;
    }

    public static QueryBuilder INSERT_INTO(String table, Map<String, ?> values) {
        int i;
        if (table == null) {
            throw new IllegalArgumentException();
        }
        if (values == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("insert into ");
        sqlBuilder.append(table);
        sqlBuilder.append(" (");
        ArrayList<String> columns = new ArrayList<String>(values.keySet());
        int n = columns.size();
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                sqlBuilder.append(", ");
            }
            sqlBuilder.append((String)columns.get(i));
        }
        sqlBuilder.append(") values (");
        for (i = 0; i < n; ++i) {
            Object value;
            if (i > 0) {
                sqlBuilder.append(", ");
            }
            if ((value = values.get(columns.get(i))) instanceof QueryBuilder) {
                sqlBuilder.append("(");
                sqlBuilder.append(value);
                sqlBuilder.append(")");
                continue;
            }
            sqlBuilder.append(QueryBuilder.encode(value));
        }
        sqlBuilder.append(")");
        return new QueryBuilder(sqlBuilder);
    }

    public static QueryBuilder UPDATE(String table) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("update ");
        sqlBuilder.append(table);
        return new QueryBuilder(sqlBuilder);
    }

    public QueryBuilder SET(Map<String, ?> values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" set ");
        int i = 0;
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            if (i > 0) {
                this.sqlBuilder.append(", ");
            }
            this.sqlBuilder.append(entry.getKey());
            this.sqlBuilder.append(" = ");
            Object value = entry.getValue();
            if (value instanceof QueryBuilder) {
                this.sqlBuilder.append("(");
                this.sqlBuilder.append(value);
                this.sqlBuilder.append(")");
            } else {
                this.sqlBuilder.append(QueryBuilder.encode(value));
            }
            ++i;
        }
        return this;
    }

    public static QueryBuilder DELETE_FROM(String table) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from ");
        sqlBuilder.append(table);
        return new QueryBuilder(sqlBuilder);
    }

    private static String encode(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (str.startsWith(":") || str.equals("?")) {
                return str;
            }
            return "'" + str.replace("'", "''") + "'";
        }
        return String.valueOf(value);
    }

    public String toString() {
        return this.sqlBuilder.toString();
    }
}

