/*
 * Decompiled with CFR 0.152.
 */
package com.openmeet.shared.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultiMapList<K, V> {
    private List<Multimap<K, V>> data = new ArrayList<Multimap<K, V>>();
    private Multimap<K, V> bufferMap = ArrayListMultimap.create();

    public String toString() {
        return this.data.toString();
    }

    public int getRowsNumber() {
        return this.data.size();
    }

    public Collection<V> get(K key, int row) throws IndexOutOfBoundsException {
        if (row < 0 || row >= this.data.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.data.get(row).get(key);
    }

    public Collection<V> getRow(int row) throws IndexOutOfBoundsException {
        if (row < 0 || row >= this.data.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.data.get(row).values();
    }

    public void addEntryInCurrentRow(K key, V value) {
        this.bufferMap.put(key, value);
    }

    public void addCurrentRow() throws NullPointerException {
        if (this.bufferMap == null) {
            throw new NullPointerException("Buffer map is null");
        }
        this.data.add(this.bufferMap);
        this.bufferMap = ArrayListMultimap.create();
    }
}

