/*
 * Decompiled with CFR 0.152.
 */
package com.openmeet.shared.helpers;

import com.google.gson.Gson;
import com.openmeet.shared.helpers.JSONResponse;
import java.io.PrintWriter;
import java.util.HashMap;

public class ResponseHelper {
    private static final JSONResponse jsonResponse = new JSONResponse();
    private static final Gson gson = new Gson();

    public static boolean checkStringFields(String ... parameters) {
        for (String parameter : parameters) {
            if (parameter != null && parameter.length() != 0) continue;
            return false;
        }
        return true;
    }

    public static void sendGenericError(PrintWriter out) {
        jsonResponse.addPair("status", "error");
        jsonResponse.addPair("message", "An error occurred, please try again later.");
        ResponseHelper.writeResponse(out);
    }

    public static void sendCustomError(PrintWriter out, String value) {
        jsonResponse.addPair("status", "error");
        jsonResponse.addPair("message", value);
        ResponseHelper.writeResponse(out);
    }

    public static void sendCustomSuccess(PrintWriter out, String value) {
        jsonResponse.addPair("status", "success");
        jsonResponse.addPair("message", value);
        ResponseHelper.writeResponse(out);
    }

    public static void sendGenericResponse(PrintWriter out, HashMap<String, String> pairs) {
        pairs.forEach(jsonResponse::addPair);
        ResponseHelper.writeResponse(out);
    }

    private static void writeResponse(PrintWriter out) {
        out.write(gson.toJson(jsonResponse.getResponse()));
        out.flush();
        jsonResponse.clear();
    }
}

