/*
 * Decompiled with CFR 0.152.
 */
package com.openmeet.shared.data.storage;

import com.openmeet.shared.data.storage.DAO;
import com.openmeet.shared.data.storage.ResultSetExtractor;
import com.openmeet.shared.utils.QueryBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.DataSource;

public final class GenericDAO {
    private static final Logger logger = Logger.getLogger(DAO.class.getName());

    private GenericDAO() {
    }

    public static <E extends ResultSetExtractor<T>, T> List<T> genericDoRetrieveByCondition(String table, String condition, E extractor, DataSource source) throws SQLException {
        ArrayList<T> entity = new ArrayList<T>();
        try (Connection conn = source.getConnection();){
            String query = QueryBuilder.SELECT("*").FROM(table).WHERE(condition).toString();
            logger.info("[GENERIC-DO-RETRIEVE-BY-CONDITION] " + query);
            try (PreparedStatement ps = conn.prepareStatement(query);){
                ResultSet set = ps.executeQuery();
                while (set.next()) {
                    entity.add(extractor.extract(set));
                }
            }
        }
        return entity;
    }

    public static boolean genericDoSave(String table, HashMap<String, ?> map, DataSource source) throws SQLException {
        int rows;
        try (Connection conn = source.getConnection();){
            String query = QueryBuilder.INSERT_INTO(table, map).toString();
            logger.info("[GENERIC-DO-SAVE] " + query);
            try (PreparedStatement ps = conn.prepareStatement(query);){
                rows = ps.executeUpdate();
            }
        }
        return rows == 1;
    }

    public static boolean genericDoUpdate(String table, String condition, HashMap<String, ?> values, DataSource source) throws SQLException {
        int rows;
        try (Connection conn = source.getConnection();){
            String query = QueryBuilder.UPDATE(table).SET(values).WHERE(condition).toString();
            logger.info("[GENERIC-DO-UPDATE] " + query);
            try (PreparedStatement ps = conn.prepareStatement(query);){
                rows = ps.executeUpdate();
            }
        }
        return rows > 0;
    }

    public static boolean genericDoDelete(String table, String condition, DataSource source) throws SQLException {
        int rows;
        try (Connection conn = source.getConnection();){
            String query = QueryBuilder.DELETE_FROM(table).WHERE(condition).toString();
            logger.info("[GENERIC-DO-DELETE] " + query);
            try (PreparedStatement ps = conn.prepareStatement(query);){
                ps.execute("SET FOREIGN_KEY_CHECKS = 0;");
                rows = ps.executeUpdate();
                ps.execute("SET FOREIGN_KEY_CHECKS = 1;");
            }
        }
        return rows > 0;
    }
}

