/*
 * Decompiled with CFR 0.152.
 */
package com.openmeet.shared.data.ban;

import com.openmeet.shared.data.ban.Ban;
import com.openmeet.shared.data.ban.BanExtractor;
import com.openmeet.shared.data.storage.DAO;
import com.openmeet.shared.data.storage.GenericDAO;
import com.openmeet.shared.data.storage.SQLDAO;
import com.openmeet.shared.exceptions.InvalidPrimaryKeyException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;

public class BanDAO
extends SQLDAO
implements DAO<Ban> {
    public BanDAO(DataSource source) {
        super(source);
    }

    @Override
    public List<Ban> doRetrieveByCondition(String condition) throws SQLException {
        return GenericDAO.genericDoRetrieveByCondition("Ban", condition, new BanExtractor(), this.source);
    }

    @Override
    public List<Ban> doRetrieveByCondition(String condition, int row_count) throws SQLException {
        return GenericDAO.genericDoRetrieveByCondition("Ban", condition + " LIMIT " + row_count, new BanExtractor(), this.source);
    }

    @Override
    public List<Ban> doRetrieveByCondition(String condition, int offset, int row_count) throws SQLException {
        return GenericDAO.genericDoRetrieveByCondition("Ban", condition + " LIMIT " + offset + ", " + row_count, new BanExtractor(), this.source);
    }

    @Override
    public Ban doRetrieveByKey(String key) throws SQLException, InvalidPrimaryKeyException {
        if (key == null) {
            throw new InvalidPrimaryKeyException(key);
        }
        List<Ban> ban = this.doRetrieveByCondition(String.format("%s = '%s'", "Ban.id", key));
        return ban.isEmpty() ? null : ban.get(0);
    }

    @Override
    public List<Ban> doRetrieveAll() throws SQLException {
        return this.doRetrieveByCondition("TRUE");
    }

    @Override
    public List<Ban> doRetrieveAll(int row_count) throws SQLException {
        return this.doRetrieveByCondition("TRUE LIMIT " + row_count);
    }

    @Override
    public List<Ban> doRetrieveAll(int offset, int row_count) throws SQLException {
        return this.doRetrieveByCondition("TRUE LIMIT " + offset + ", " + row_count);
    }

    @Override
    public boolean doSave(Ban obj) throws SQLException {
        return GenericDAO.genericDoSave("Ban", obj.toHashMap(), this.source);
    }

    @Override
    public boolean doSave(HashMap<String, ?> values) throws SQLException {
        return GenericDAO.genericDoSave("Ban", values, this.source);
    }

    @Override
    public boolean doUpdate(HashMap<String, ?> values, String condition) throws SQLException {
        return GenericDAO.genericDoUpdate("Ban", condition, values, this.source);
    }

    @Override
    public boolean doSaveOrUpdate(Ban obj) throws SQLException {
        if (this.doRetrieveByKey(String.valueOf(obj.getId())) == null) {
            return this.doSave(obj);
        }
        return this.doUpdate(obj.toHashMap(), String.format("%s = '%s'", "Ban.id", obj.getId()));
    }

    @Override
    public boolean doDelete(String condition) throws SQLException {
        return GenericDAO.genericDoDelete("Ban", condition, this.source);
    }
}

