# ReactSnippet: How To
---

## Write a Function Component
---

### Description
We will write a simple functional component that displays the main header in the same style for different pages and find out key features of components

### Step 1
Add folder for your new component (we'll call it **Title**) into **components** folder and files <br />
(**index.js** - component file, **Title.module.css** - for its style)
<img src="img/1.png" width="100%"><br/>

### Step 2
Use the command **rafce** to create a function component and include a file with future styles <br />
> **Function component** is a Javascript function which return React element describing what should appear on the screen

<img src="img/2.png" width="100%"><br/>

### Step 3
Give html structure and style the component<br />
[How to style React components](https://github.com/andrewsinelnikov/ReactSnippet-How-To/edit/main/task13/README.md) <br />
<img src="img/3.png" width="100%"><br/>
<img src="img/4.png" width="100%"><br/>

### Step 4
Export your component into each page<br />
<img src="img/5.png" width="100%"><br/>
<img src="img/6.png" width="100%"><br/>
<img src="img/7.png" width="100%"><br/>

### Step 5
Change title for each page with **props**
> **props** is an object that represents function arguments that is being used for passing data from one component to another
<img src="img/8.png" width="100%"><br/>
<img src="img/9.png" width="100%"><br/>

Simplify it with destructuring
<img src="img/10.png" width="100%"><br/>
<img src="img/11.png" width="100%"><br/>
<img src="img/12.png" width="100%"><br/>
<img src="img/13.png" width="100%"><br/>

**You component is ready! 🎉**

Source files 📁 [here](https://github.com/andrewsinelnikov/ReactSnippet-How-To/tree/main/task11/src)

#### Got a question ❓   [✉️](https://twitter.com/Andrew79361148)

Want to know more? 👉 [Read next](https://github.com/andrewsinelnikov/ReactSnippet-How-To/blob/main/README.md)
