/*
 * Decompiled with CFR 0.152.
 */
package com.google.games.bridge;

import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.games.bridge.TokenResult;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TokenPendingResult
extends PendingResult<TokenResult> {
    private static final String TAG = "TokenPendingResult";
    private CountDownLatch latch = new CountDownLatch(1);
    TokenResult result = new TokenResult();
    private ResultCallback<? super TokenResult> resultCallback;

    @NonNull
    public TokenResult await() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            this.setResult(null, null, null, 14);
        }
        return this.getResult();
    }

    @NonNull
    public TokenResult await(long l, @NonNull TimeUnit timeUnit) {
        try {
            if (!this.latch.await(l, timeUnit)) {
                this.setResult(null, null, null, 15);
            }
        }
        catch (InterruptedException e) {
            this.setResult(null, null, null, 14);
        }
        return this.getResult();
    }

    public void cancel() {
        this.setResult(null, null, null, 16);
        this.latch.countDown();
    }

    public boolean isCanceled() {
        return this.getResult() != null && this.getResult().getStatus().isCanceled();
    }

    public void setResultCallback(@NonNull ResultCallback<? super TokenResult> resultCallback) {
        if (this.latch.getCount() == 0L) {
            resultCallback.onResult((Result)this.getResult());
        } else {
            this.setCallback(resultCallback);
        }
    }

    public void setResultCallback(@NonNull ResultCallback<? super TokenResult> resultCallback, long l, @NonNull TimeUnit timeUnit) {
        try {
            if (!this.latch.await(l, timeUnit)) {
                this.setResult(null, null, null, 15);
            }
        }
        catch (InterruptedException e) {
            this.setResult(null, null, null, 14);
        }
        resultCallback.onResult((Result)this.getResult());
    }

    private synchronized void setCallback(ResultCallback<? super TokenResult> callback) {
        this.resultCallback = callback;
    }

    private synchronized ResultCallback<? super TokenResult> getCallback() {
        return this.resultCallback;
    }

    private synchronized void setResult(String authCode, String email, String idToken, int resultCode) {
        String atok = this.result != null && authCode == null ? this.result.getAuthCode() : authCode;
        String itok = this.result != null && idToken == null ? this.result.getIdToken() : idToken;
        String em = this.result != null && email == null ? this.result.getEmail() : email;
        this.result = new TokenResult(atok, em, itok, resultCode);
    }

    private synchronized TokenResult getResult() {
        return this.result;
    }

    public void setStatus(int status) {
        this.result.setStatus(status);
        this.latch.countDown();
        ResultCallback<? super TokenResult> cb = this.getCallback();
        TokenResult res = this.getResult();
        if (cb != null) {
            Log.d((String)TAG, (String)(" Calling onResult for callback: " + cb + " result: " + res));
            this.getCallback().onResult((Result)res);
        }
    }

    public void setEmail(String email) {
        this.result.setEmail(email);
    }

    public void setAuthCode(String accessToken) {
        this.result.setAuthCode(accessToken);
    }

    public void setIdToken(String idToken) {
        this.result.setIdToken(idToken);
    }
}

