/*
 * Decompiled with CFR 0.152.
 */
package com.google.games.bridge;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.games.Games;
import com.google.games.bridge.TokenPendingResult;
import com.google.games.bridge.TokenResult;

public class TokenFragment
extends Fragment
implements GoogleApiClient.ConnectionCallbacks {
    private static final String TAG = "TokenFragment";
    private static final String FRAGMENT_TAG = "gpg.AuthTokenSupport";
    private static final int RC_ACCT = 9002;
    private static final Object lock = new Object();
    private static TokenRequest pendingTokenRequest;
    private static TokenFragment helperFragment;
    private static String currentEmail;
    private static String currentAuthCode;
    private static String currentIdToken;
    private GoogleApiClient mGoogleApiClient;
    private boolean requested_authcode;
    private boolean requested_email;
    private boolean requested_id_token;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PendingResult fetchToken(Activity parentActivity, boolean requestAuthCode, boolean requestEmail, boolean requestIdToken, String webClientId, boolean forceRefreshToken, String[] additionalScopes, boolean hidePopups, String accountName) {
        TokenFragment fragment;
        TokenRequest request = new TokenRequest(requestAuthCode, requestEmail, requestIdToken, webClientId, forceRefreshToken, additionalScopes, hidePopups, accountName);
        if (!(requestAuthCode && currentAuthCode == null || requestEmail && currentEmail == null || requestIdToken && currentIdToken == null)) {
            request.setAuthCode(currentAuthCode);
            request.setEmail(currentEmail);
            request.setIdToken(currentIdToken);
            request.setResult(0);
            return request.getPendingResponse();
        }
        boolean ok = false;
        Object object = lock;
        synchronized (object) {
            if (pendingTokenRequest == null) {
                pendingTokenRequest = request;
                ok = true;
            }
        }
        if (!ok) {
            Log.e((String)TAG, (String)"Already a pending token request!");
            request.setResult(10);
        }
        if ((fragment = (TokenFragment)parentActivity.getFragmentManager().findFragmentByTag(FRAGMENT_TAG)) == null) {
            try {
                Log.d((String)TAG, (String)"Creating fragment");
                fragment = new TokenFragment();
                FragmentTransaction trans = parentActivity.getFragmentManager().beginTransaction();
                trans.add((Fragment)fragment, FRAGMENT_TAG);
                trans.commit();
            }
            catch (Throwable th) {
                Log.e((String)TAG, (String)("Cannot launch token fragment:" + th.getMessage()), (Throwable)th);
                request.setResult(13);
                Object object2 = lock;
                synchronized (object2) {
                    pendingTokenRequest = null;
                }
            }
        } else {
            Log.d((String)TAG, (String)"Fragment exists.. calling processRequests");
            fragment.processRequest();
        }
        return request.getPendingResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signOut() {
        currentAuthCode = null;
        currentEmail = null;
        currentIdToken = null;
        Object object = lock;
        synchronized (object) {
            pendingTokenRequest = null;
        }
        if (helperFragment != null) {
            helperFragment.reset();
        }
    }

    private void reset() {
        if (this.mGoogleApiClient != null) {
            if (this.mGoogleApiClient.hasConnectedApi(Games.API)) {
                Games.signOut((GoogleApiClient)this.mGoogleApiClient);
                Auth.GoogleSignInApi.signOut(this.mGoogleApiClient);
            }
            this.mGoogleApiClient.disconnect();
            this.mGoogleApiClient = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest() {
        TokenRequest request;
        Object object = lock;
        synchronized (object) {
            request = pendingTokenRequest;
        }
        if (request == null) {
            return;
        }
        this.buildClient(request);
        object = lock;
        synchronized (object) {
            request = pendingTokenRequest;
        }
        if (request != null) {
            this.doAuthenticate(request);
        }
        Log.d((String)TAG, (String)"Done with processRequest!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildClient(TokenRequest request) {
        if (this.mGoogleApiClient == null || this.requested_authcode != request.doAuthCode || this.requested_email != request.doEmail || this.requested_id_token != request.doIdToken) {
            GoogleSignInOptions.Builder builder = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_GAMES_SIGN_IN);
            if (request.doAuthCode) {
                if (!request.getWebClientId().isEmpty()) {
                    builder.requestServerAuthCode(request.getWebClientId(), request.getForceRefresh());
                } else {
                    Log.e((String)TAG, (String)"Web client ID is needed for Auth Code");
                    request.setResult(10);
                    Object object = lock;
                    synchronized (object) {
                        pendingTokenRequest = null;
                    }
                    return;
                }
            }
            if (request.doEmail) {
                builder.requestEmail();
            }
            if (request.doIdToken) {
                if (!request.getWebClientId().isEmpty()) {
                    builder.requestIdToken(request.getWebClientId());
                } else {
                    Log.e((String)TAG, (String)"Web client ID is needed for ID Token");
                    request.setResult(10);
                    Object object = lock;
                    synchronized (object) {
                        pendingTokenRequest = null;
                    }
                    return;
                }
            }
            if (request.scopes != null) {
                for (String s : request.scopes) {
                    builder.requestScopes(new Scope(s), new Scope[0]);
                }
            }
            if (request.hidePopups) {
                Log.d((String)TAG, (String)"hiding popup views for games API");
                builder.addExtension((GoogleSignInOptionsExtension)Games.GamesOptions.builder().setShowConnectingPopup(false).build());
            }
            if (request.accountName != null && !request.accountName.isEmpty()) {
                builder.setAccountName(request.accountName);
            }
            this.requested_authcode = request.doAuthCode;
            this.requested_email = request.doEmail;
            this.requested_id_token = request.doIdToken;
            GoogleSignInOptions options = builder.build();
            GoogleApiClient.Builder clientBuilder = new GoogleApiClient.Builder((Context)this.getActivity()).addApi(Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions.HasOptions)options);
            clientBuilder.addApi(Games.API);
            clientBuilder.addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this);
            if (request.hidePopups) {
                View invisible = new View((Context)this.getActivity());
                invisible.setVisibility(4);
                invisible.setClickable(false);
                clientBuilder.setViewForPopups(invisible);
            }
            this.mGoogleApiClient = clientBuilder.build();
            this.mGoogleApiClient.connect(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doAuthenticate(TokenRequest request) {
        if (request == null) {
            return;
        }
        if (this.mGoogleApiClient == null) {
            throw new IllegalStateException("client is null!");
        }
        if (!(this.requested_authcode && currentAuthCode == null || this.requested_email && currentEmail == null || this.requested_id_token && currentIdToken == null)) {
            request.setAuthCode(currentAuthCode);
            request.setEmail(currentEmail);
            request.setIdToken(currentIdToken);
            request.setResult(0);
            Object object = lock;
            synchronized (object) {
                pendingTokenRequest = null;
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 9002) {
            GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
            GoogleSignInAccount acct = result.getSignInAccount();
            this.onSignedIn(result.getStatus().getStatusCode(), acct);
            return;
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSignedIn(int resultCode, GoogleSignInAccount acct) {
        TokenRequest request;
        Object object = lock;
        synchronized (object) {
            request = pendingTokenRequest;
            pendingTokenRequest = null;
        }
        if (request != null) {
            if (acct != null) {
                request.setAuthCode(acct.getServerAuthCode());
                request.setEmail(acct.getEmail());
                request.setIdToken(acct.getIdToken());
                currentAuthCode = acct.getServerAuthCode();
                currentEmail = acct.getEmail();
                currentIdToken = acct.getIdToken();
            }
            request.setResult(resultCode);
        }
    }

    public void onStart() {
        Log.d((String)TAG, (String)"onStart()");
        super.onStart();
        if (this.mGoogleApiClient != null) {
            this.mGoogleApiClient.connect(2);
        }
    }

    public void onStop() {
        Log.d((String)TAG, (String)"onStop()");
        super.onStop();
        if (this.mGoogleApiClient != null && this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.disconnect();
        }
    }

    public void onResume() {
        Log.d((String)TAG, (String)"onResume called");
        super.onResume();
        if (helperFragment == null) {
            helperFragment = this;
        }
        this.processRequest();
    }

    public void onConnected(@Nullable Bundle bundle) {
        if (this.mGoogleApiClient.hasConnectedApi(Games.API)) {
            Auth.GoogleSignInApi.silentSignIn(this.mGoogleApiClient).setResultCallback((ResultCallback)new ResultCallback<GoogleSignInResult>(){

                public void onResult(@NonNull GoogleSignInResult googleSignInResult) {
                    if (googleSignInResult.isSuccess()) {
                        TokenFragment.this.onSignedIn(googleSignInResult.getStatus().getStatusCode(), googleSignInResult.getSignInAccount());
                    } else {
                        Log.e((String)TokenFragment.TAG, (String)("Error with silentSignIn: " + googleSignInResult.getStatus()));
                        TokenFragment.this.onSignedIn(googleSignInResult.getStatus().getStatusCode(), googleSignInResult.getSignInAccount());
                    }
                }
            });
        } else {
            Intent signInIntent = Auth.GoogleSignInApi.getSignInIntent(this.mGoogleApiClient);
            this.startActivityForResult(signInIntent, 9002);
        }
    }

    public void onConnectionSuspended(int cause) {
        Log.d((String)TAG, (String)("onConnectionSuspended() called: " + cause));
    }

    private static class TokenRequest {
        private TokenPendingResult pendingResponse = new TokenPendingResult();
        private boolean doAuthCode;
        private boolean doEmail;
        private boolean doIdToken;
        private String webClientId;
        private boolean forceRefresh;
        private boolean hidePopups;
        private String accountName;
        private String[] scopes;

        public TokenRequest(boolean fetchAuthCode, boolean fetchEmail, boolean fetchIdToken, String webClientId, boolean forceRefresh, String[] oAuthScopes, boolean hidePopups, String accountName) {
            this.doAuthCode = fetchAuthCode;
            this.doEmail = fetchEmail;
            this.doIdToken = fetchIdToken;
            this.webClientId = webClientId;
            this.forceRefresh = forceRefresh;
            if (oAuthScopes != null && oAuthScopes.length > 0) {
                this.scopes = new String[oAuthScopes.length];
                System.arraycopy(oAuthScopes, 0, this.scopes, 0, oAuthScopes.length);
            } else {
                this.scopes = null;
            }
            this.hidePopups = hidePopups;
            this.accountName = accountName;
        }

        public PendingResult<TokenResult> getPendingResponse() {
            return this.pendingResponse;
        }

        public void setResult(int code) {
            this.pendingResponse.setStatus(code);
        }

        public void setEmail(String email) {
            this.pendingResponse.setEmail(email);
        }

        public void cancel() {
            this.pendingResponse.cancel();
        }

        public void setAuthCode(String authCode) {
            this.pendingResponse.setAuthCode(authCode);
        }

        public void setIdToken(String idToken) {
            this.pendingResponse.setIdToken(idToken);
        }

        public String getEmail() {
            return this.pendingResponse.result.getEmail();
        }

        public String getIdToken() {
            return this.pendingResponse.result.getIdToken();
        }

        public String getAuthCode() {
            return this.pendingResponse.result.getAuthCode();
        }

        public String toString() {
            return Integer.toHexString(this.hashCode()) + " (a:" + this.doAuthCode + " e:" + this.doEmail + " i:" + this.doIdToken + ")";
        }

        public String getWebClientId() {
            return this.webClientId == null ? "" : this.webClientId;
        }

        public boolean getForceRefresh() {
            return this.forceRefresh;
        }
    }
}

