/*
 * Decompiled with CFR 0.152.
 */
package com.google.games.bridge;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;

public final class NativeBridgeActivity
extends Activity {
    private static final String BRIDGED_INTENT = "BRIDGED_INTENT";
    private static final int GPG_RESPONSE_CODE = 4673607;
    private static final int BG_COLOR = 0x40FFFFFF;
    private static final String TAG = "NativeBridgeActivity";
    private boolean pendingResult;

    private native void forwardActivityResult(int var1, int var2, Intent var3);

    public void onCreate(Bundle savedInstanceState) {
        View v = new View((Context)this);
        v.setBackgroundColor(0x40FFFFFF);
        this.setContentView(v);
        super.onCreate(savedInstanceState);
    }

    protected void onStart() {
        Intent bridgedIntent = (Intent)this.getIntent().getParcelableExtra(BRIDGED_INTENT);
        if (bridgedIntent != null) {
            this.startActivityForResult(bridgedIntent, 4673607);
        }
        super.onStart();
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        boolean bl = this.pendingResult = requestCode == 4673607;
        if (this.pendingResult) {
            Log.d((String)TAG, (String)("starting GPG activity: " + intent));
        } else {
            Log.i((String)TAG, (String)("starting non-GPG activity: " + requestCode + " " + intent));
        }
        super.startActivityForResult(intent, requestCode);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 4673607) {
            Log.d((String)TAG, (String)"Forwarding activity result to native SDK.");
            this.forwardActivityResult(requestCode, resultCode, data);
            this.pendingResult = false;
        } else {
            Log.d((String)TAG, (String)("onActivityResult for unknown request code: " + requestCode + " calling finish()"));
        }
        this.finish();
        super.onActivityResult(requestCode, resultCode, data);
    }

    public static void launchBridgeIntent(Activity parentActivity, Intent intent) {
        Log.d((String)TAG, (String)("Launching bridge activity: parent:" + parentActivity + " intent " + intent));
        Intent bridgeIntent = new Intent((Context)parentActivity, NativeBridgeActivity.class);
        bridgeIntent.putExtra(BRIDGED_INTENT, (Parcelable)intent);
        parentActivity.startActivity(bridgeIntent);
    }

    protected void onDestroy() {
        if (this.pendingResult) {
            Log.w((String)TAG, (String)"onDestroy called with pendingResult == true.  forwarding canceled result");
            this.forwardActivityResult(4673607, 0, null);
            this.pendingResult = false;
        }
        super.onDestroy();
    }

    static {
        System.loadLibrary("gpg");
    }
}

