// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

package main

import (
	"golang.org/x/text/language"
	"golang.org/x/text/message"
	"golang.org/x/text/message/catalog"
)

type dictionary struct {
	index []uint32
	data  string
}

func (d *dictionary) Lookup(key string) (data string, ok bool) {
	p, ok := messageKeyToIndex[key]
	if !ok {
		return "", false
	}
	start, end := d.index[p], d.index[p+1]
	if start == end {
		return "", false
	}
	return d.data[start:end], true
}

func init() {
	dict := map[string]catalog.Dictionary{
		"ca":    &dictionary{index: caIndex, data: caData},
		"cs":    &dictionary{index: csIndex, data: csData},
		"de":    &dictionary{index: deIndex, data: deData},
		"en":    &dictionary{index: enIndex, data: enData},
		"es_ES": &dictionary{index: es_ESIndex, data: es_ESData},
		"fa":    &dictionary{index: faIndex, data: faData},
		"fi":    &dictionary{index: fiIndex, data: fiData},
		"fr":    &dictionary{index: frIndex, data: frData},
		"id":    &dictionary{index: idIndex, data: idData},
		"it":    &dictionary{index: itIndex, data: itData},
		"ja":    &dictionary{index: jaIndex, data: jaData},
		"ko":    &dictionary{index: koIndex, data: koData},
		"pa_IN": &dictionary{index: pa_INIndex, data: pa_INData},
		"pl":    &dictionary{index: plIndex, data: plData},
		"ro":    &dictionary{index: roIndex, data: roData},
		"ru":    &dictionary{index: ruIndex, data: ruData},
		"si_LK": &dictionary{index: si_LKIndex, data: si_LKData},
		"sk":    &dictionary{index: skIndex, data: skData},
		"sl":    &dictionary{index: slIndex, data: slData},
		"tr":    &dictionary{index: trIndex, data: trData},
		"uk":    &dictionary{index: ukIndex, data: ukData},
		"vi":    &dictionary{index: viIndex, data: viData},
		"zh_CN": &dictionary{index: zh_CNIndex, data: zh_CNData},
		"zh_TW": &dictionary{index: zh_TWIndex, data: zh_TWData},
	}
	fallback := language.MustParse("en")
	cat, err := catalog.NewFromMap(dict, catalog.Fallback(fallback))
	if err != nil {
		panic(err)
	}
	message.DefaultCatalog = cat
}

var messageKeyToIndex = map[string]int{
	"%.2f\u00a0GiB":                         49,
	"%.2f\u00a0KiB":                         47,
	"%.2f\u00a0MiB":                         48,
	"%.2f\u00a0TiB":                         50,
	"%d day(s)":                             41,
	"%d hour(s)":                            42,
	"%d minute(s)":                          43,
	"%d second(s)":                          44,
	"%d tunnels were unable to be removed.": 141,
	"%d year(s)":                            40,
	"%d\u00a0B":                             46,
	"%s\n\nPlease consult the log for more information.":                        36,
	"%s - Handshake did not complete after %d attempts, giving up":              227,
	"%s - Handshake did not complete after %d seconds, retrying (try %d)":       228,
	"%s - Removing all keys, since we haven't received a new one in %d seconds": 230,
	"%s - Retrying handshake because we stopped hearing back after %d seconds":  229,
	"%s You cannot undo this action.":                                           137,
	"%s ago":                                                                    45,
	"%s received, %s sent":                                                      75,
	"%s: %q":                                                                    51,
	"%v":                                                                        257,
	"%v - %v":                                                                   210,
	"%v - ConsumeMessageInitiation: handshake flood":                            176,
	"%v - ConsumeMessageInitiation: handshake replay @ %v":                      175,
	"%v - Failed to create initiation message: %v":                              209,
	"%v - Failed to create junk packet: %v":                                     223,
	"%v - Failed to create response message: %v":                                214,
	"%v - Failed to derive keypair: %v":                                         199,
	"%v - Failed to send data packets: %v":                                      226,
	"%v - Failed to send handshake initiation: %v":                              212,
	"%v - Failed to send handshake response: %v":                                215,
	"%v - Failed to send junk packets: %v":                                      211,
	"%v - Received handshake initiation":                                        195,
	"%v - Received handshake response":                                          198,
	"%v - Receiving keepalive packet":                                           202,
	"%v - Routine: sequential receiver - started":                               201,
	"%v - Routine: sequential receiver - stopped":                               200,
	"%v - Routine: sequential sender - started":                                 225,
	"%v - Sending handshake initiation":                                         208,
	"%v - Sending handshake response":                                           213,
	"%v - Sending keepalive packet":                                             207,
	"%v - Starting":                                                             177,
	"%v - Stopping":                                                             178,
	"%v - UAPI: Adding allowedip":                                               273,
	"%v - UAPI: Created":                                                        267,
	"%v - UAPI: Removing":                                                       268,
	"%v - UAPI: Removing all allowedips":                                        272,
	"%v - UAPI: Updating endpoint":                                              270,
	"%v - UAPI: Updating persistent keepalive interval":                         271,
	"%v - UAPI: Updating preshared key":                                         269,
	"&About AmneziaWG…":                                                         281,
	"&Activate":                                                                 14,
	"&Block untunneled traffic (kill-switch)":                                   86,
	"&Configuration:":                                                           89,
	"&Copy":                                                                     29,
	"&Deactivate":                                                               13,
	"&Edit":                                                                     115,
	"&Import tunnel(s) from file…":                                              107,
	"&Manage tunnels…":                                                          106,
	"&Name:":                                                                    83,
	"&Public key:":                                                              84,
	"&Remove selected tunnel(s)":                                                123,
	"&Save":                                                                     87,
	"&Save to file…":                                                            31,
	"&Toggle":                                                                   120,
	"&Tunnels":                                                                  109,
	"(no argument): elevate and install manager service":                        1,
	"(unknown)":                                                                 85,
	"A name is required.":                                                       91,
	"A tunnel was unable to be removed: %s":                                     139,
	"ASec: Received message with unknown type":                                  183,
	"About AmneziaWG":                                                           275,
	"Activating":                                                                100,
	"Active":                                                                    99,
	"Add &empty tunnel…":                                                        116,
	"Add Tunnel":                                                                117,
	"Addresses:":                                                                18,
	"Addresses: %s":                                                             113,
	"Addresses: None":                                                           105,
	"All peers must have public keys":                                           64,
	"Allowed IPs:":                                                              21,
	"AmneziaWG Activated":                                                       283,
	"AmneziaWG Deactivated":                                                     284,
	"AmneziaWG Tunnel Error":                                                    285,
	"AmneziaWG logo image":                                                      276,
	"AmneziaWG: %s":                                                             286,
	"AmneziaWG: Deactivated":                                                    282,
	"An interface must have a private key":                                      154,
	"Another tunnel already exists with the name ‘%s’":                          127,
	"Another tunnel already exists with the name ‘%s’.":                         95,
	"App version: %s\nWintun version: %s\nGo version: %s\nOperating system: %s\nArchitecture: %s": 277,
	"Are you sure you would like to delete %d tunnels?":                                           134,
	"Are you sure you would like to delete tunnel ‘%s’?":                                          136,
	"Bind close failed: %v":                 162,
	"Brackets must contain an IPv6 address": 147,
	"Cancel":                                88,
	"Close":                                 11,
	"Command Line Options":                  3,
	"Config key is missing an equals separator":                            150,
	"Configuration Files (*.zip, *.conf)|*.zip;*.conf|All Files (*.*)|*.*": 142,
	"Configuration ZIP Files (*.zip)|*.zip":                                144,
	"Could not decrypt invalid cookie response":                            190,
	"Could not enumerate existing tunnels: %v":                             126,
	"Could not import selected configuration: %v":                          125,
	"Create new tunnel":                                                    81,
	"DNS servers:":                                                         19,
	"Deactivating":                                                         26,
	"Delete %d tunnels":                                                    133,
	"Delete tunnel ‘%s’":                                                   135,
	"Device closed":                                                        165,
	"Device closing":                                                       164,
	"Dropped some packets from multi-segment read: %v":                     221,
	"E&xit":                                     108,
	"Edit &selected tunnel…":                    122,
	"Edit tunnel":                               82,
	"Endpoint:":                                 22,
	"Error":                                     0,
	"Error Exiting WireGuard":                   37,
	"Error in getting configuration":            65,
	"Error: ":                                   158,
	"Export all tunnels to &zip…":               121,
	"Export all tunnels to zip":                 119,
	"Export log to file":                        34,
	"Export tunnels to zip":                     145,
	"Failed to activate tunnel":                 77,
	"Failed to create cookie reply: %v":         217,
	"Failed to deactivate tunnel":               78,
	"Failed to decode cookie reply":             188,
	"Failed to decode initiation message":       193,
	"Failed to decode response message":         196,
	"Failed to determine tunnel state":          76,
	"Failed to load updated MTU of device: %v":  232,
	"Failed to read packet from TUN device: %v": 222,
	"Failed to receive %s packet: %v":           181,
	"Failed to write packets to TUN device: %v": 206,
	"File ‘%s’ already exists.\n\nDo you want to overwrite it?":   98,
	"IPv4 packet with disallowed source address from %v":          203,
	"IPv6 packet with disallowed source address from %v":          204,
	"Import tunnel(s) from file":                                  143,
	"Imported %d of %d tunnels":                                   131,
	"Imported %d tunnels":                                         130,
	"Imported tunnels":                                            129,
	"Inactive":                                                    25,
	"Interface closed, ignored requested state %s":                159,
	"Interface down requested":                                    236,
	"Interface state was %s, requested %s, now %s":                160,
	"Interface up requested":                                      235,
	"Interface: %s":                                               79,
	"Invalid %s":                                                  287,
	"Invalid IP address":                                          52,
	"Invalid MTU":                                                 56,
	"Invalid endpoint host":                                       55,
	"Invalid key for [Interface] section":                         152,
	"Invalid key for [Peer] section":                              153,
	"Invalid key for interface section":                           155,
	"Invalid key for peer section":                                157,
	"Invalid key: %v":                                             59,
	"Invalid name":                                                90,
	"Invalid network prefix length":                               53,
	"Invalid packet ended up in the handshake queue":              192,
	"Invalid persistent keepalive":                                58,
	"Invalid port":                                                57,
	"Key must have a value":                                       151,
	"Keys must decode to exactly 32 bytes":                        148,
	"Latest handshake:":                                           24,
	"Line must occur in a section":                                149,
	"Listen port:":                                                16,
	"Log":                                                         28,
	"Log message":                                                 33,
	"MTU not updated to negative value: %v":                       233,
	"MTU updated: %v%s":                                           234,
	"MTU:":                                                        17,
	"Missing port from endpoint":                                  54,
	"Now":                                                         38,
	"Number must be a number between 0 and 2^64-1: %v":            60,
	"Packet with invalid IP version from %v":                      205,
	"Peer":                                                        80,
	"Persistent keepalive:":                                       23,
	"Preshared key:":                                              20,
	"Protocol version must be 1":                                  156,
	"Public key:":                                                 15,
	"Received invalid initiation message from %s":                 194,
	"Received invalid response message from %s":                   197,
	"Received message with unknown type":                          184,
	"Received packet with invalid mac1":                           191,
	"Received packet with unknown IP version":                     220,
	"Receiving cookie response from %s":                           189,
	"Remove selected tunnel(s)":                                   118,
	"Routine: TUN reader - started":                               219,
	"Routine: TUN reader - stopped":                               218,
	"Routine: decryption worker %d - started":                     185,
	"Routine: encryption worker %d - started":                     224,
	"Routine: event worker - started":                             231,
	"Routine: event worker - stopped":                             237,
	"Routine: handshake worker %d - started":                      187,
	"Routine: handshake worker %d - stopped":                      186,
	"Routine: receive incoming %s - started":                      180,
	"Routine: receive incoming %s - stopped":                      179,
	"Scripts:":                                                    67,
	"Select &all":                                                 30,
	"Sending cookie response for denied handshake message for %v": 216,
	"Status:":                      12,
	"Status: %s":                   112,
	"Status: Unknown":              104,
	"System clock wound backward!": 39,
	"Table:":                       278,
	"Text Files (*.txt)|*.txt|All Files (*.*)|*.*":                       101,
	"The %s tunnel has been activated.":                                  110,
	"The %s tunnel has been deactivated.":                                111,
	"Time":                                                               32,
	"Transfer:":                                                          68,
	"Transport packet lined up with another msg type":                    182,
	"Trouble determining MTU, assuming default: %v":                      163,
	"Tunnel Error":                                                       35,
	"Tunnel already exists":                                              94,
	"Tunnel name is not valid":                                           62,
	"Tunnel name ‘%s’ is invalid.":                                       92,
	"Tunnels":                                                            114,
	"Two commas in a row":                                                61,
	"UAPI: Removing all peers":                                           261,
	"UAPI: Updating fwmark":                                              260,
	"UAPI: Updating init_packet_junk_size":                               265,
	"UAPI: Updating init_packet_magic_header":                            167,
	"UAPI: Updating junk_packet_count":                                   262,
	"UAPI: Updating junk_packet_max_size":                                264,
	"UAPI: Updating junk_packet_min_size":                                263,
	"UAPI: Updating listen port":                                         259,
	"UAPI: Updating private key":                                         258,
	"UAPI: Updating response_packet_junk_size":                           266,
	"UAPI: Updating response_packet_magic_header":                        169,
	"UAPI: Updating transport_packet_magic_header":                       173,
	"UAPI: Updating underload_packet_magic_header":                       171,
	"UAPI: Using default init type":                                      168,
	"UAPI: Using default response type":                                  170,
	"UAPI: Using default transport type":                                 174,
	"UAPI: Using default underload type":                                 172,
	"UDP bind has been updated":                                          166,
	"Unable to create new configuration":                                 96,
	"Unable to create tunnel":                                            132,
	"Unable to delete tunnel":                                            138,
	"Unable to delete tunnels":                                           140,
	"Unable to determine whether the process is running under WOW64: %v": 4,
	"Unable to exit service due to: %v. You may want to stop WireGuard from the service manager.": 146,
	"Unable to import configuration: %v":                128,
	"Unable to list existing tunnels":                   93,
	"Unable to open current process token: %v":          6,
	"Unable to update bind: %v":                         161,
	"Unable to wait for WireGuard window to appear: %v": 103,
	"Unknown state":                                     27,
	"Usage: %s [\n%s]":                                  2,
	"When a configuration has exactly one peer, and that peer has an allowed IPs containing at least one of 0.0.0.0/0 or ::/0, and the interface does not have table off, then the tunnel service engages a firewall ruleset to block all traffic that is neither to nor from the tunnel interface or is to the wrong DNS server, with special exceptions for DHCP and NDP.": 280,
	"WireGuard Detection Error": 102,
	"WireGuard is running, but the UI is only accessible from desktops of the Builtin %s group.": 8,
	"WireGuard may only be used by users who are a member of the Builtin %s group.":              7,
	"WireGuard system tray icon did not appear after 30 seconds.":                                66,
	"Writing file failed": 97,
	"You must use the native version of WireGuard on this computer.": 5,
	"[EnumerationSeparator]":            9,
	"[UnitSeparator]":                   10,
	"[none specified]":                  63,
	"allowed_ip=%s":                     256,
	"disabled, per policy":              73,
	"enabled":                           74,
	"endpoint=%s":                       250,
	"fwmark=%d":                         239,
	"h1=%d":                             245,
	"h2=%d":                             246,
	"h3=%d":                             247,
	"h4=%d":                             248,
	"invalid UAPI operation: %v":        274,
	"jc=%d":                             240,
	"jmax=%d":                           242,
	"jmin=%d":                           241,
	"last_handshake_time_nsec=%d":       252,
	"last_handshake_time_sec=%d":        251,
	"listen_port=%d":                    238,
	"no configuration files were found": 124,
	"off":                               279,
	"persistent_keepalive_interval=%d":  255,
	"post-down":                         72,
	"post-up":                           70,
	"pre-down":                          71,
	"pre-up":                            69,
	"protocol_version=1":                249,
	"rx_bytes=%d":                       254,
	"s1=%d":                             243,
	"s2=%d":                             244,
	"tx_bytes=%d":                       253,
}

var caIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x00000042, 0x00000056,
	0x00000071, 0x000000b0, 0x000000f5, 0x0000012c,
	0x0000018c, 0x00000215, 0x00000218, 0x0000021b,
	0x00000221, 0x00000228, 0x00000233, 0x0000023b,
	0x0000024a, 0x0000025a, 0x0000025f, 0x00000268,
	0x00000277, 0x0000028b, 0x00000299, 0x000002a1,
	0x000002bc, 0x000002ce, 0x000002d6, 0x000002e2,
	0x000002f3, 0x000002fc, 0x00000303, 0x00000315,
	// Entry 20 - 3F
	0x00000329, 0x0000032f, 0x00000344, 0x0000035e,
	0x0000036e, 0x000003ad, 0x000003ca, 0x000003ce,
	0x000003f5, 0x00000413, 0x00000431, 0x00000451,
	0x00000473, 0x00000495, 0x0000049e, 0x000004a7,
	0x000004b4, 0x000004c1, 0x000004ce, 0x000004db,
	0x000004e8, 0x000004fd, 0x00000521, 0x0000053b,
	0x0000055e, 0x0000056c, 0x0000057a, 0x000005a6,
	0x000005bc, 0x000005ea, 0x000005fd, 0x0000061d,
	// Entry 40 - 5F
	0x0000062e, 0x0000065d, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	// Entry 60 - 7F
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	// Entry 80 - 9F
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	// Entry A0 - BF
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	// Entry C0 - DF
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	// Entry E0 - FF
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	// Entry 100 - 11F
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	0x0000067a, 0x0000067a, 0x0000067a, 0x0000067a,
	// Entry 120 - 13F
	0x0000067a,
} // Size: 1180 bytes

const caData string = "" + // Size: 1658 bytes
	"\x02Error\x02(sense argument): eleva i instala el servei d'administrador" +
	"\x02Ús: %[1]s [\x0a%[2]s]\x02Opcions de línia d'ordres\x02No s'ha pogut " +
	"determinar si el procés corre sota WOW64: %[1]v\x02Heu de fer servir la " +
	"versio nativa de WireGuard en aquest ordinador.\x02No s'ha pogut obrir e" +
	"l token del procés actual: %[1]v\x02WireGuard només es pot fer servir pe" +
	"r els usuaris que són membres del grup del sistema %[1]s.\x02WireGuard s" +
	"'està executsnt, pero la interfície gràfica només és accessible als usua" +
	"ris que són membres del grup del sistema %[1]s.\x02, \x02, \x02Tanca\x02" +
	"Estat:\x02&Desactiva\x02&Activa\x02Clau pública:\x02Port d'escolta:\x02M" +
	"TU:\x02Adreces:\x02Servidors DNS:\x02Clau precompartida:\x02IPs permeses" +
	":\x02Extrem:\x02Missatge de persistència:\x02Últim handshake:\x02Inactiu" +
	"\x02Desactivant\x02Estat desconegut\x02Registre\x02&Copia\x02Selecciona-" +
	"ho tot\x02Desa en un arxiu…\x02Temps\x02Missatge de registre\x02Exporta " +
	"registre a fitxer\x02Error de túnel\x02%[1]s\x0a\x0aSi us plau, consulte" +
	"u el registre per més informació.\x02Error al sortir de WireGuard\x02Ara" +
	"\x02El rellotge del sistema s'ha atraçat!\x14\x01\x81\x01\x00\x02\x0a" +
	"\x02%[1]d any\x00\x0b\x02%[1]d anys\x14\x01\x81\x01\x00\x02\x0a\x02%[1]d" +
	" dia\x00\x0b\x02%[1]d dies\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d hora\x00" +
	"\x0c\x02%[1]d hores\x14\x01\x81\x01\x00\x02\x0c\x02%[1]d minut\x00\x0d" +
	"\x02%[1]d minuts\x14\x01\x81\x01\x00\x02\x0c\x02%[1]d segon\x00\x0d\x02%" +
	"[1]d segons\x02Fa %[1]s\x02%[1]d\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f" +
	"\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Adr" +
	"eça IP invàlida\x02Tamany del prefix de xarxa invàlid\x02Falta el port d" +
	"e l'extrem\x02El format de l'extrem no és valid\x02MTU invàlida\x02Port " +
	"invàlid\x02Temps de missatge de persistència invàlid\x02Clau invàlida: %" +
	"[1]v\x02El nombre ha de estar entre 0 i 2^64-1: %[1]v\x02Dos comes segui" +
	"des\x02El nom del túnel no és vàlid\x02[no especificat]\x02Tots els pare" +
	"lls han de tenir claus públiques\x02Error obtenint configuració"

var csIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x0000004f, 0x00000069,
	0x0000008a, 0x000000bd, 0x00000106, 0x00000138,
	0x00000193, 0x00000201, 0x00000204, 0x00000207,
	0x00000210, 0x00000216, 0x00000223, 0x0000022e,
	0x00000240, 0x00000258, 0x0000025d, 0x00000265,
	0x00000272, 0x00000289, 0x00000297, 0x000002a1,
	0x000002b7, 0x000002cc, 0x000002d7, 0x000002e2,
	0x000002f1, 0x000002fa, 0x00000306, 0x00000313,
	// Entry 20 - 3F
	0x0000032a, 0x0000032f, 0x0000033c, 0x0000035a,
	0x00000367, 0x000003a2, 0x000003ce, 0x000003d3,
	0x000003fc, 0x00000432, 0x00000468, 0x000004a7,
	0x000004e6, 0x00000529, 0x00000535, 0x0000053e,
	0x0000054b, 0x00000558, 0x00000565, 0x00000572,
	0x0000057f, 0x00000593, 0x000005b8, 0x000005ce,
	0x000005e1, 0x000005ef, 0x000005fe, 0x00000620,
	0x00000638, 0x0000066a, 0x00000680, 0x0000069b,
	// Entry 40 - 5F
	0x000006b2, 0x000006df, 0x00000703, 0x0000074f,
	0x00000758, 0x00000761, 0x00000771, 0x0000077d,
	0x0000078d, 0x00000799, 0x000007af, 0x000007b7,
	0x000007d7, 0x000007fa, 0x00000819, 0x0000083a,
	0x0000084b, 0x00000850, 0x00000866, 0x00000874,
	0x0000087d, 0x00000890, 0x0000089c, 0x000008c9,
	0x000008d2, 0x000008da, 0x000008e7, 0x000008f8,
	0x0000090c, 0x00000930, 0x0000095c, 0x00000970,
	// Entry 60 - 7F
	0x00000997, 0x000009c2, 0x000009de, 0x00000a12,
	0x00000a1b, 0x00000a24, 0x00000a5e, 0x00000a7b,
	0x00000aac, 0x00000abc, 0x00000acd, 0x00000ae1,
	0x00000b04, 0x00000b0e, 0x00000b16, 0x00000b32,
	0x00000b50, 0x00000b5c, 0x00000b6a, 0x00000b71,
	0x00000b7a, 0x00000b96, 0x00000ba4, 0x00000bbe,
	0x00000be0, 0x00000beb, 0x00000c11, 0x00000c2c,
	0x00000c47, 0x00000c77, 0x00000ca4, 0x00000cd9,
	// Entry 80 - 9F
	0x00000cff, 0x00000d23, 0x00000d37, 0x00000dac,
	0x00000e41, 0x00000e57, 0x00000ec1, 0x00000f6b,
	0x00000f83, 0x00000fab, 0x00000fd0, 0x00000fe6,
	0x0000100c, 0x00001023, 0x000010cd, 0x0000111b,
	0x0000113a, 0x00001161, 0x0000117a, 0x000011d4,
	0x000011f9, 0x0000122f, 0x00001254, 0x00001294,
	0x000012ae, 0x000012d5, 0x000012f7, 0x00001322,
	0x00001347, 0x00001364, 0x00001382, 0x00001382,
	// Entry A0 - BF
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	// Entry C0 - DF
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	// Entry E0 - FF
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	// Entry 100 - 11F
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	0x00001382, 0x00001382, 0x00001382, 0x00001382,
	// Entry 120 - 13F
	0x00001382,
} // Size: 1180 bytes

const csData string = "" + // Size: 4994 bytes
	"\x02Chyba\x02(žádný argument): Zvýšit oprávnění a instalovat službu sprá" +
	"vce\x02Použití: %[1]s [\x0a%[2]s]\x02Možnosti příkazového řádku\x02Nelze" +
	" zjistit, zda proces běží pod WOW64: %[1]v\x02Musíte použít nativní verz" +
	"i aplikace WireGuard na tomto počítači.\x02Nelze otevřít token aktuálníh" +
	"o procesu: %[1]v\x02WireGuard můžou používat pouze uživatelé, kteří jsou" +
	" členy Builtin skupiny %[1]s.\x02WireGuard je spuštěn, ale uživatelské r" +
	"ozhraní je přístupné pouze uživatelům Builtin skupiny %[1]s.\x02, \x02, " +
	"\x02Zavřít\x02Stav:\x02&Deaktivovat\x02&Aktivovat\x02Veřejný klíč:\x02Po" +
	"rt pro naslouchání:\x02MTU:\x02Adresy:\x02DNS servery:\x02Předsdílený kl" +
	"íč:\x02Povolené IP:\x02Endpoint:\x02Persistent keepalive:\x02Poslední h" +
	"andshake:\x02Neaktivní\x02Deaktivuji\x02Neznámý stav\x02Záznamy\x02&Kopí" +
	"rovat\x02Vybr&at vše\x02&Uložit do souboru…\x02Čas\x02Zpráva logu\x02Exp" +
	"ortovat záznam do souboru\x02Chyba tunelu\x02%[1]s\x0a\x0aPro více infor" +
	"mací se prosím podívejte do logu.\x02Chyba při ukončování aplikace WireG" +
	"uard\x02Teď\x02Systémové hodiny byly posunuty dozadu!\x14\x01\x81\x01" +
	"\x00\x04\x0b\x02%[1]d roky\x05\x0a\x02%[1]d let\x02\x0a\x02%[1]d rok\x00" +
	"\x0a\x02%[1]d let\x14\x01\x81\x01\x00\x04\x0a\x02%[1]d dny\x05\x0b\x02%[" +
	"1]d dnů\x02\x0a\x02%[1]d den\x00\x0a\x02%[1]d dny\x14\x01\x81\x01\x00" +
	"\x04\x0d\x02%[1]d hodiny\x05\x0c\x02%[1]d hodin\x02\x0d\x02%[1]d hodina" +
	"\x00\x0c\x02%[1]d hodin\x14\x01\x81\x01\x00\x04\x0d\x02%[1]d minuty\x05" +
	"\x0c\x02%[1]d minut\x02\x0d\x02%[1]d minuta\x00\x0c\x02%[1]d minut\x14" +
	"\x01\x81\x01\x00\x04\x0e\x02%[1]d sekundy\x05\x0d\x02%[1]d sekund\x02" +
	"\x0e\x02%[1]d sekunda\x00\x0d\x02%[1]d sekund\x02před %[1]s\x02%[1]d" +
	"\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%" +
	".2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Neplatná IP adresa\x02Neplatná délka " +
	"síťového prefixu\x02Endpointu chybí port\x02Neplatný endpoint\x02Neplatn" +
	"é MTU\x02Neplatný port\x02Neplatný persistentní keepalive\x02Neplatný k" +
	"líč: %[1]v\x02Číslo musí mít hodnotu mezi 0 a 2^64-1: %[1]v\x02Dvě čárky" +
	" za sebou\x02Název tunelu je neplatný\x02[není specifikováno]\x02Všichni" +
	" peeři musí mít veřejné klíče\x02Chyba při načítání konfigurace\x02Ikona" +
	" WireGuard se ani po 30 sekundách nezobrazila na systémové liště.\x02Skr" +
	"ipty:\x02Přenos:\x02před-zapnutím\x02po-zapnutí\x02před-vypnutím\x02po-v" +
	"ypnutí\x02vypnuto, podle zásad\x02zapnuto\x02%[1]s přijato, %[2]s odeslá" +
	"no\x02Nepodařilo se zjistit stav tunelu\x02Nepodařilo se aktivovat tunel" +
	"\x02Nepodařilo se deaktivovat tunel\x02Rozhraní: %[1]s\x02Peer\x02Vytvoř" +
	"it nový tunel\x02Upravit tunel\x02&Název:\x02&Veřejný klíč:\x02(neznámý)" +
	"\x02&Blokovat netunelovaný provoz (kill-switch)\x02&Uložit\x02Zrušit\x02" +
	"&Nastavení:\x02Neplatný název\x02Název je povinný.\x02Název tunelu '%[1]" +
	"s' je neplatný.\x02Nepodařilo se zobrazit existující tunely\x02Tunel již" +
	" existuje\x02Tunel s názvem '%[1]s' již existuje.\x02Nepodařilo se vytvo" +
	"řit novou konfiguraci\x02Zápis souboru se nezdařil\x02Soubor \x22%[1]s" +
	"\x22 již existuje.\x0a\x0aChcete jej přepsat?\x02Aktivní\x02Aktivuji\x02" +
	"Textové soubory (*.txt)|*.txt|Všechny soubory (*.*)|*.*\x02Chyba při det" +
	"ekci WireGuard\x02Nelze čekat na zobrazení okna WireGuard: %[1]v\x02Stav" +
	": Neznámý\x02Adresy: žádné\x02Spravovat tunely…\x02&Importovat tunel(y) " +
	"ze souboru…\x02U&končit\x02&Tunely\x02Tunel %[1]s byl aktivován.\x02Tune" +
	"l %[1]s byl deaktivován.\x02Stav: %[1]s\x02Adresy: %[1]s\x02Tunely\x02&U" +
	"pravit\x02Přidat &prázdný tunel…\x02Přidat tunel\x02Odstranit vybrané tu" +
	"nely\x02Exportovat všechny tunely do zip\x02&Přepnout\x02Exportovat všec" +
	"hny tunely do &zip…\x02Upravit &vybraný tunel…\x02&Odstranit vybrané tun" +
	"ely\x02nebyly nalezeny žádné konfigurační soubory\x02Nelze importovat vy" +
	"branou konfiguraci: %[1]v\x02Nepodařilo se vyjmenovat existující tunely:" +
	" %[1]v\x02Tunel s názvem '%[1]s' již existuje\x02Nelze importovat konfig" +
	"uraci: %[1]v\x02Importované tunely\x14\x01\x81\x01\x00\x04\x1a\x02Import" +
	"ovány %[1]d tunely\x05\x1b\x02Importováno %[1]d tunelů\x02\x18\x02Import" +
	"ován %[1]d tunel\x00\x1b\x02Importováno %[1]d tunelů\x14\x02\x80\x01\x04" +
	"#\x02Importováno %[1]d z %[2]d tunelů\x05#\x02Importováno %[1]d z %[2]d " +
	"tunelů\x02 \x02Importován %[1]d z %[2]d tunel\x00#\x02Importováno %[1]d " +
	"z %[2]d tunelů\x02Nelze vytvořit tunel\x14\x01\x81\x01\x00\x04\x17\x02Od" +
	"stranit %[1]d tunely\x05\x18\x02Odstranit %[1]d tunelů\x02\x16\x02Odstra" +
	"nit %[1]d tunel\x00\x18\x02Odstranit %[1]d tunelů\x14\x01\x81\x01\x00" +
	"\x04'\x02Opravdu chcete odstranit %[1]d tunely?\x05(\x02Opravdu chcete o" +
	"dstranit %[1]d tunelů?\x02&\x02Opravdu chcete odstranit %[1]d tunel?\x00" +
	"(\x02Opravdu chcete odstranit %[1]d tunelů?\x02Odstranit tunel \x22%[1]s" +
	"\x22\x02Opravdu chcete odstranit tunel \x22%[1]s\x22?\x02%[1]s Tuto akci" +
	" nelze vrátit zpět.\x02Nelze odstranit tunel\x02Tunel nebylo možné odstr" +
	"anit: %[1]s\x02Nelze odstranit tunely\x14\x01\x81\x01\x00\x04'\x02%[1]d " +
	"tunely nebylo možné odstranit.\x05(\x02%[1]d tunelů nebylo možné odstran" +
	"it.\x02&\x02%[1]d tunel nebylo možné odstranit.\x00(\x02%[1]d tunelů neb" +
	"ylo možné odstranit.\x02Konfigurace souborů (*.zip, *.conf)|*.zip; *.con" +
	"f|Všechny soubory (*.*)|*.*\x02Importovat tunel(y) ze souboru\x02Konfigu" +
	"race souborů ZIP (*.zip)|*.zip\x02Exportovat tunely do zip\x02Nelze ukon" +
	"čit službu z důvodu: %[1]v. WireGuard můžete zastavit ve správci služeb" +
	".\x02Závorky musí obsahovat IPv6 adresu\x02Klíče musí být dekódovány pře" +
	"sně na 32 bajtů\x02Řádek musí být v některé sekci\x02Konfigurační klíč n" +
	"eobsahuje oddělovač (znak 'rovná se')\x02Klíč musí mít hodnotu\x02Neplat" +
	"ný klíč pro sekci [Interface]\x02Neplatný klíč pro sekci [Peer]\x02Rozhr" +
	"aní musí obsahovat soukromý klíč\x02Neplatný klíč pro sekci rozhraní\x02" +
	"Verze protokolu musí být 1\x02Neplatný klíč v sekci peer"

var deIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000059, 0x00000074,
	0x0000008b, 0x000000e1, 0x00000137, 0x0000016b,
	0x000001c2, 0x0000023a, 0x0000023d, 0x00000240,
	0x0000024b, 0x00000253, 0x00000261, 0x0000026d,
	0x00000287, 0x00000295, 0x0000029a, 0x000002a4,
	0x000002b0, 0x000002c6, 0x000002d4, 0x000002de,
	0x000002f3, 0x0000030d, 0x00000315, 0x00000321,
	0x00000335, 0x0000033f, 0x00000349, 0x0000035a,
	// Entry 20 - 3F
	0x00000371, 0x00000376, 0x00000387, 0x000003a5,
	0x000003b3, 0x000003f4, 0x00000416, 0x0000041c,
	0x00000442, 0x00000462, 0x00000480, 0x000004a4,
	0x000004c8, 0x000004ee, 0x000004f8, 0x00000501,
	0x0000050e, 0x0000051b, 0x00000528, 0x00000535,
	0x00000542, 0x00000558, 0x00000580, 0x0000059e,
	0x000005b8, 0x000005c7, 0x000005d8, 0x000005f8,
	0x00000616, 0x00000642, 0x0000065e, 0x0000067b,
	// Entry 40 - 5F
	0x00000690, 0x000006ce, 0x000006f4, 0x00000744,
	0x0000074d, 0x0000075a, 0x0000076d, 0x00000784,
	0x00000799, 0x000007af, 0x000007cb, 0x000007d5,
	0x000007f5, 0x00000820, 0x00000845, 0x0000086c,
	0x00000881, 0x0000088c, 0x000008a9, 0x000008bb,
	0x000008c2, 0x000008dd, 0x000008e9, 0x0000091d,
	0x00000928, 0x00000932, 0x00000942, 0x00000953,
	0x0000096b, 0x0000098f, 0x000009c2, 0x000009db,
	// Entry 60 - 7F
	0x00000a13, 0x00000a41, 0x00000a61, 0x00000aa6,
	0x00000aac, 0x00000ab6, 0x00000ae7, 0x00000b02,
	0x00000b4a, 0x00000b5c, 0x00000b6c, 0x00000b81,
	0x00000ba2, 0x00000bab, 0x00000bb3, 0x00000bd5,
	0x00000bf9, 0x00000c07, 0x00000c17, 0x00000c1e,
	0x00000c2a, 0x00000c4e, 0x00000c61, 0x00000c7f,
	0x00000ca9, 0x00000cb5, 0x00000cda, 0x00000cfe,
	0x00000d1f, 0x00000d44, 0x00000d85, 0x00000db7,
	// Entry 80 - 9F
	0x00000df1, 0x00000e25, 0x00000e37, 0x00000e70,
	0x00000ebc, 0x00000edc, 0x00000f11, 0x00000f81,
	0x00000f9d, 0x00000fd4, 0x00001011, 0x00001030,
	0x00001060, 0x00001086, 0x000010e7, 0x00001131,
	0x0000114d, 0x00001176, 0x00001195, 0x00001201,
	0x00001235, 0x0000126c, 0x0000129d, 0x000012d8,
	0x000012f6, 0x00001324, 0x0000134c, 0x00001386,
	0x000013b3, 0x000013d4, 0x000013fc, 0x000013fc,
	// Entry A0 - BF
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	// Entry C0 - DF
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	// Entry E0 - FF
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	// Entry 100 - 11F
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	0x000013fc, 0x000013fc, 0x000013fc, 0x000013fc,
	// Entry 120 - 13F
	0x000013fc,
} // Size: 1180 bytes

const deData string = "" + // Size: 5116 bytes
	"\x02Fehler\x02(kein Argument): Als Administrator ausführen und den Manag" +
	"er-Dienst installieren\x02Verwendung: %[1]s [\x0a%[2]s]\x02Kommandozeile" +
	"noptionen\x02Es kann nicht festgestellt werden, ob der Prozess unter WOW" +
	"64 ausgeführt wird: %[1]v\x02Sie müssen die Version von Wireguard benutz" +
	"en, die für ihren Computer bestimmt ist.\x02Konnte aktuellen Prozess-Tok" +
	"en nicht öffnen: %[1]v\x02WireGuard kann nur von Benutzern verwendet wer" +
	"den, die Mitglied der Gruppe %[1]s sind.\x02WireGuard wird ausgeführt, a" +
	"ber auf die Benutzeroberfläche kann nur von Desktops der Gruppe %[1]s zu" +
	"gegriffen werden.\x02, \x02, \x02Schließen\x02Status:\x02&Deaktivieren" +
	"\x02&Aktivieren\x02Öffentlicher Schlüssel:\x02Eingangsport:\x02MTU:\x02A" +
	"dressen:\x02DNS-Server:\x02Geteilter Schlüssel:\x02Erlaubte IPs:\x02Endp" +
	"unkt:\x02Erhaltungsintervall:\x02Letzter Schlüsseltausch:\x02Inaktiv\x02" +
	"Deaktiviere\x02Unbekannter Zustand\x02Protokoll\x02&Kopieren\x02&Alles m" +
	"arkieren\x02&In Datei Speichern…\x02Zeit\x02Protokolleintrag\x02Exportie" +
	"re Protokoll in Datei\x02Tunnel Fehler\x02%[1]s\x0a\x0aBitte lesen Sie d" +
	"as Protokoll für weitere Informationen.\x02Fehler beim Beenden von WireG" +
	"uard\x02Jetzt\x02Die Systemuhr wurde zurück gestellt!\x14\x01\x81\x01" +
	"\x00\x02\x0b\x02%[1]d Jahr\x00\x0c\x02%[1]d Jahre\x14\x01\x81\x01\x00" +
	"\x02\x0a\x02%[1]d Tag\x00\x0b\x02%[1]d Tage\x14\x01\x81\x01\x00\x02\x0d" +
	"\x02%[1]d Stunde\x00\x0e\x02%[1]d Stunden\x14\x01\x81\x01\x00\x02\x0d" +
	"\x02%[1]d Minute\x00\x0e\x02%[1]d Minuten\x14\x01\x81\x01\x00\x02\x0e" +
	"\x02%[1]d Sekunde\x00\x0f\x02%[1]d Sekunden\x02vor %[1]s\x02%[1]d\u00a0B" +
	"\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f" +
	"\u00a0TiB\x02%[1]s: %[2]q\x02Ungültige IP-Adresse\x02Ungültige Länge des" +
	" Netzwerkpräfixes\x02Fehlender Port des Endpunktes\x02Ungültiger Endpunk" +
	"t-Host\x02Ungültige MTU\x02Ungültiger Port\x02Ungültiges Erhaltungsinter" +
	"vall\x02Ungültiger Schlüssel: %[1]v\x02Zahl muss zwischen 0 und 2^64-1 s" +
	"ein: %[1]v\x02Zwei Kommata in einer Zeile\x02Der Tunnelname ist ungültig" +
	"\x02[nicht spezifiziert]\x02Alle Teilnehmer (peers) müssen öffentliche S" +
	"chlüssel haben\x02Fehler beim Abrufen der Konfiguration\x02Das WireGuard" +
	"-Taskleistensymbol ist nicht innerhalb von 30 Sekunden erschienen.\x02Sk" +
	"ripte:\x02Übertragen:\x02vor Verbindsaufbau\x02nach Verbindungsaufbau" +
	"\x02vor Verbindungsabbau\x02nach Verbindungsabbau\x02deaktiviert, per Ri" +
	"chtlinie\x02aktiviert\x02%[1]s empfangen, %[2]s gesendet\x02Tunnelstatus" +
	" konnte nicht ermittelt werden\x02Tunnel aktivieren ist fehlgeschlagen" +
	"\x02Tunnel deaktivieren ist fehlgeschlagen\x02Schnittstelle: %[1]s\x02Te" +
	"ilnehmer\x02Einen neuen Tunnel erstellen\x02Tunnel bearbeiten\x02&Name:" +
	"\x02&Öffentlicher Schlüssel:\x02(unbekannt)\x02&Blockiere Verkehr außerh" +
	"alb des Tunnels (Not-Aus)\x02&Speichern\x02Abbrechen\x02&Konfiguration:" +
	"\x02Ungültiger Name\x02Ein Name ist notwendig.\x02Der Name „%[1]s“ ist u" +
	"ngültig.\x02Vorhandene Tunnel können nicht aufgelistet werden\x02Tunnel " +
	"existiert bereits\x02Ein Tunnel mit dem Namen „%[1]s“ existiert bereits." +
	"\x02Neue Konfiguration kann nicht erstellt werden\x02Schreiben der Datei" +
	" schlug fehl\x02Die Datei „%[1]s“ existiert bereits.\x0a\x0aMöchten Sie " +
	"sie ersetzen?\x02Aktiv\x02Aktiviere\x02Textdateien (*.txt)|*.txt|Alle Da" +
	"teien (*.*)|*.*\x02WireGuard Erkennungsfehler\x02Warten auf das Erschein" +
	"en des WireGuard Fensters nicht möglich: %[1]v \x02Status: Unbekannt\x02" +
	"Adressen: Keine\x02Tunnel &verwalten…\x02Tunnel aus Datei &importieren…" +
	"\x02&Beenden\x02&Tunnel\x02Der Tunnel %[1]s wurde aktiviert.\x02Der Tunn" +
	"el %[1]s wurde deaktiviert.\x02Status: %[1]s\x02Adressen: %[1]s\x02Tunne" +
	"l\x02&Bearbeiten\x02Einen &leeren Tunnel hinzufügen…\x02Tunnel hinzufüge" +
	"n\x02Markierte(n) Tunnel entfernen\x02Alle Tunnel in eine Zip-Datei expo" +
	"rtieren\x02&Umschalten\x02Exportiere alle Tunnel in &Zip-Datei\x02Ausgew" +
	"ählten Tunnel &bearbeiten…\x02Ausgewählte(n) Tunnel &löschen\x02keine K" +
	"onfigurationsdateien gefunden\x02Ausgewählte Konfiguration konnte nicht " +
	"importiert werden: %[1]v\x02Konnte existierende Tunnel nicht auflisten: " +
	"%[1]v\x02Es existiert bereits ein Tunnel mit dem Namen „%[1]s“\x02Import" +
	"ieren der Konfiguration nicht möglich: %[1]v\x02Tunnel importiert\x14" +
	"\x01\x81\x01\x00\x02\x18\x02%[1]d Tunnel importiert\x00\x18\x02%[1]d Tun" +
	"nel importiert\x14\x02\x80\x01\x02\x22\x02%[1]d von %[2]d Tunnel importi" +
	"ert\x00\x22\x02%[1]d von %[2]d Tunnel importiert\x02Tunnel erstellen nic" +
	"ht möglich\x14\x01\x81\x01\x00\x02\x16\x02%[1]d Tunnel löschen\x00\x16" +
	"\x02%[1]d Tunnel löschen\x14\x01\x81\x01\x00\x024\x02Möchten Sie diesen " +
	"%[1]d Tunnel wirklich löschen?\x003\x02Möchten Sie diese %[1]d Tunnel wi" +
	"rklich löschen?\x02Tunnel „%[1]s“ löschen\x02Möchten Sie den Tunnel „%[1" +
	"]s“ wirklich löschen?\x02%[1]s Dieser Schritt kann nicht rückgängig gema" +
	"cht werden.\x02Tunnel löschen nicht möglich\x02Ein Tunnel konnte nicht g" +
	"elöscht werden: %[1]s\x02Tunnel konnten nicht gelöscht werden\x14\x01" +
	"\x81\x01\x00\x02+\x02%[1]d Tunnel konnte nicht entfernt werden.\x00-\x02" +
	"%[1]d Tunnel konnten nicht gelöscht werden.\x02Konfigurationsdateien (*." +
	"zip, *.conf)|*.zip;*.conf|Alle Dateien (*.*)|*.*\x02Importiere Tunnel au" +
	"s Datei\x02Konfigurations-ZIP-Dateien (*.zip)|*.zip\x02Exportiere Tunnel" +
	" in Zip-Datei\x02Der Dienst konnte nicht gestoppt werden: %[1]v. Versuch" +
	"en Sie WireGuard in der Dienstverwaltung zu beenden.\x02Eckige Klammern " +
	"müssen eine IPv6 Adresse enthalten\x02Schlüssel müssen auf exakt 32 Byte" +
	"s dekodiert werden\x02Die Zeile muss innerhalb eines Abschnitts stehen" +
	"\x02Konfigurationsschlüssel fehlt ein Gleichheitstrennzeichen\x02Eintrag" +
	" muss einen Wert haben\x02Ungültiger Eintrage im [Interface] Abschnitt" +
	"\x02Ungültiger Eintrag im [Peer] Abschnitt\x02Eine Schnittstelle muss ei" +
	"nen privaten Schlssel enthalten\x02Ungültiger Eintrag im Abschnitt [inte" +
	"rface]\x02Die Protokollversion muss 1 sein\x02Ungültiger Eintrag im Absc" +
	"hnitt [peer]"

var enIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x00000039, 0x0000004f,
	0x00000064, 0x000000aa, 0x000000e9, 0x00000115,
	0x00000166, 0x000001c4, 0x000001c7, 0x000001ca,
	0x000001d0, 0x000001d8, 0x000001e4, 0x000001ee,
	0x000001fa, 0x00000207, 0x0000020c, 0x00000217,
	0x00000224, 0x00000233, 0x00000240, 0x0000024a,
	0x00000260, 0x00000272, 0x0000027b, 0x00000288,
	0x00000296, 0x0000029a, 0x000002a0, 0x000002ac,
	// Entry 20 - 3F
	0x000002bd, 0x000002c2, 0x000002ce, 0x000002e1,
	0x000002ee, 0x00000322, 0x0000033a, 0x0000033e,
	0x0000035b, 0x0000037b, 0x00000399, 0x000003b9,
	0x000003dd, 0x00000401, 0x0000040b, 0x00000414,
	0x00000421, 0x0000042e, 0x0000043b, 0x00000448,
	0x00000455, 0x00000468, 0x00000486, 0x000004a1,
	0x000004b7, 0x000004c3, 0x000004d0, 0x000004ed,
	0x00000500, 0x00000534, 0x00000548, 0x00000561,
	// Entry 40 - 5F
	0x00000572, 0x00000592, 0x000005b1, 0x000005ed,
	0x000005f6, 0x00000600, 0x00000607, 0x0000060f,
	0x00000618, 0x00000622, 0x00000637, 0x0000063f,
	0x0000065a, 0x0000067b, 0x00000695, 0x000006b1,
	0x000006c2, 0x000006c7, 0x000006d9, 0x000006e5,
	0x000006ec, 0x000006f9, 0x00000703, 0x0000072b,
	0x00000731, 0x00000738, 0x00000748, 0x00000755,
	0x00000769, 0x0000078d, 0x000007ad, 0x000007c3,
	// Entry 60 - 7F
	0x000007fc, 0x0000081f, 0x00000833, 0x00000872,
	0x00000879, 0x00000884, 0x000008b1, 0x000008cb,
	0x00000900, 0x00000910, 0x00000920, 0x00000933,
	0x00000952, 0x00000958, 0x00000961, 0x00000986,
	0x000009ad, 0x000009bb, 0x000009cc, 0x000009d4,
	0x000009da, 0x000009ef, 0x000009fa, 0x00000a14,
	0x00000a2e, 0x00000a36, 0x00000a54, 0x00000a6d,
	0x00000a88, 0x00000aaa, 0x00000ad9, 0x00000b05,
	// Entry 80 - 9F
	0x00000b3d, 0x00000b63, 0x00000b74, 0x00000baa,
	0x00000bf1, 0x00000c09, 0x00000c3b, 0x00000cad,
	0x00000cc7, 0x00000d01, 0x00000d24, 0x00000d3c,
	0x00000d65, 0x00000d7e, 0x00000dd7, 0x00000e1c,
	0x00000e37, 0x00000e5d, 0x00000e73, 0x00000ed2,
	0x00000ef8, 0x00000f1d, 0x00000f3a, 0x00000f64,
	0x00000f7a, 0x00000f9e, 0x00000fbd, 0x00000fe2,
	0x00001004, 0x0000101f, 0x0000103c, 0x00001048,
	// Entry A0 - BF
	0x00001078, 0x000010ae, 0x000010cb, 0x000010e4,
	0x00001115, 0x00001124, 0x00001132, 0x0000114c,
	0x00001174, 0x00001192, 0x000011be, 0x000011e0,
	0x0000120d, 0x00001230, 0x0000125d, 0x00001280,
	0x000012bb, 0x000012ed, 0x000012fe, 0x0000130f,
	0x00001339, 0x00001363, 0x00001389, 0x000013b9,
	0x000013e2, 0x00001405, 0x00001430, 0x0000145a,
	0x00001484, 0x000014a2, 0x000014c7, 0x000014f1,
	// Entry C0 - DF
	0x00001513, 0x00001542, 0x00001566, 0x00001595,
	0x000015bb, 0x000015dd, 0x0000160a, 0x0000162e,
	0x00001656, 0x00001685, 0x000016b4, 0x000016d7,
	0x0000170d, 0x00001743, 0x0000176d, 0x0000179a,
	0x000017bb, 0x000017e0, 0x00001813, 0x00001821,
	0x0000184c, 0x0000187f, 0x000018a2, 0x000018d3,
	0x00001904, 0x00001943, 0x00001968, 0x00001986,
	0x000019a4, 0x000019cc, 0x00001a00, 0x00001a2d,
	// Entry E0 - FF
	0x00001a59, 0x00001a84, 0x00001ab1, 0x00001adc,
	0x00001b1f, 0x00001b6c, 0x00001bbb, 0x00001c0b,
	0x00001c2b, 0x00001c57, 0x00001c80, 0x00001c98,
	0x00001caf, 0x00001cc8, 0x00001ce8, 0x00001cfa,
	0x00001d07, 0x00001d10, 0x00001d1b, 0x00001d26,
	0x00001d2f, 0x00001d38, 0x00001d41, 0x00001d4a,
	0x00001d53, 0x00001d5c, 0x00001d6f, 0x00001d7e,
	0x00001d9c, 0x00001dbb, 0x00001dca, 0x00001dd9,
	// Entry 100 - 11F
	0x00001dfd, 0x00001e0e, 0x00001e14, 0x00001e2f,
	0x00001e4a, 0x00001e60, 0x00001e79, 0x00001e9a,
	0x00001ebe, 0x00001ee2, 0x00001f07, 0x00001f30,
	0x00001f46, 0x00001f5d, 0x00001f82, 0x00001fa2,
	0x00001fd7, 0x00001ffd, 0x0000201c, 0x0000203a,
	0x0000204a, 0x0000205f, 0x000020c6, 0x000020cd,
	0x000020d1, 0x00002238, 0x0000224c, 0x00002263,
	0x00002277, 0x0000228d, 0x000022a4, 0x000022b5,
	// Entry 120 - 13F
	0x000022c3,
} // Size: 1180 bytes

const enData string = "" + // Size: 8899 bytes
	"\x02Error\x02(no argument): elevate and install manager service\x02Usage" +
	": %[1]s [\x0a%[2]s]\x02Command Line Options\x02Unable to determine wheth" +
	"er the process is running under WOW64: %[1]v\x02You must use the native " +
	"version of WireGuard on this computer.\x02Unable to open current process" +
	" token: %[1]v\x02WireGuard may only be used by users who are a member of" +
	" the Builtin %[1]s group.\x02WireGuard is running, but the UI is only ac" +
	"cessible from desktops of the Builtin %[1]s group.\x02, \x02, \x02Close" +
	"\x02Status:\x02&Deactivate\x02&Activate\x02Public key:\x02Listen port:" +
	"\x02MTU:\x02Addresses:\x02DNS servers:\x02Preshared key:\x02Allowed IPs:" +
	"\x02Endpoint:\x02Persistent keepalive:\x02Latest handshake:\x02Inactive" +
	"\x02Deactivating\x02Unknown state\x02Log\x02&Copy\x02Select &all\x02&Sav" +
	"e to file…\x02Time\x02Log message\x02Export log to file\x02Tunnel Error" +
	"\x02%[1]s\x0a\x0aPlease consult the log for more information.\x02Error E" +
	"xiting WireGuard\x02Now\x02System clock wound backward!\x14\x01\x81\x01" +
	"\x00\x02\x0b\x02%[1]d year\x00\x0c\x02%[1]d years\x14\x01\x81\x01\x00" +
	"\x02\x0a\x02%[1]d day\x00\x0b\x02%[1]d days\x14\x01\x81\x01\x00\x02\x0b" +
	"\x02%[1]d hour\x00\x0c\x02%[1]d hours\x14\x01\x81\x01\x00\x02\x0d\x02%[1" +
	"]d minute\x00\x0e\x02%[1]d minutes\x14\x01\x81\x01\x00\x02\x0d\x02%[1]d " +
	"second\x00\x0e\x02%[1]d seconds\x02%[1]s ago\x02%[1]d\u00a0B\x02%.2[1]f" +
	"\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB" +
	"\x02%[1]s: %[2]q\x02Invalid IP address\x02Invalid network prefix length" +
	"\x02Missing port from endpoint\x02Invalid endpoint host\x02Invalid MTU" +
	"\x02Invalid port\x02Invalid persistent keepalive\x02Invalid key: %[1]v" +
	"\x02Number must be a number between 0 and 2^64-1: %[1]v\x02Two commas in" +
	" a row\x02Tunnel name is not valid\x02[none specified]\x02All peers must" +
	" have public keys\x02Error in getting configuration\x02WireGuard system " +
	"tray icon did not appear after 30 seconds.\x02Scripts:\x02Transfer:\x02p" +
	"re-up\x02post-up\x02pre-down\x02post-down\x02disabled, per policy\x02ena" +
	"bled\x02%[1]s received, %[2]s sent\x02Failed to determine tunnel state" +
	"\x02Failed to activate tunnel\x02Failed to deactivate tunnel\x02Interfac" +
	"e: %[1]s\x02Peer\x02Create new tunnel\x02Edit tunnel\x02&Name:\x02&Publi" +
	"c key:\x02(unknown)\x02&Block untunneled traffic (kill-switch)\x02&Save" +
	"\x02Cancel\x02&Configuration:\x02Invalid name\x02A name is required.\x02" +
	"Tunnel name ‘%[1]s’ is invalid.\x02Unable to list existing tunnels\x02Tu" +
	"nnel already exists\x02Another tunnel already exists with the name ‘%[1]" +
	"s’.\x02Unable to create new configuration\x02Writing file failed\x02File" +
	" ‘%[1]s’ already exists.\x0a\x0aDo you want to overwrite it?\x02Active" +
	"\x02Activating\x02Text Files (*.txt)|*.txt|All Files (*.*)|*.*\x02WireGu" +
	"ard Detection Error\x02Unable to wait for WireGuard window to appear: %[" +
	"1]v\x02Status: Unknown\x02Addresses: None\x02&Manage tunnels…\x02&Import" +
	" tunnel(s) from file…\x02E&xit\x02&Tunnels\x02The %[1]s tunnel has been " +
	"activated.\x02The %[1]s tunnel has been deactivated.\x02Status: %[1]s" +
	"\x02Addresses: %[1]s\x02Tunnels\x02&Edit\x02Add &empty tunnel…\x02Add Tu" +
	"nnel\x02Remove selected tunnel(s)\x02Export all tunnels to zip\x02&Toggl" +
	"e\x02Export all tunnels to &zip…\x02Edit &selected tunnel…\x02&Remove se" +
	"lected tunnel(s)\x02no configuration files were found\x02Could not impor" +
	"t selected configuration: %[1]v\x02Could not enumerate existing tunnels:" +
	" %[1]v\x02Another tunnel already exists with the name ‘%[1]s’\x02Unable " +
	"to import configuration: %[1]v\x02Imported tunnels\x14\x01\x81\x01\x00" +
	"\x02\x16\x02Imported %[1]d tunnel\x00\x17\x02Imported %[1]d tunnels\x14" +
	"\x02\x80\x01\x02\x1f\x02Imported %[1]d of %[2]d tunnel\x00 \x02Imported " +
	"%[1]d of %[2]d tunnels\x02Unable to create tunnel\x14\x01\x81\x01\x00" +
	"\x02\x14\x02Delete %[1]d tunnel\x00\x15\x02Delete %[1]d tunnels\x14\x01" +
	"\x81\x01\x00\x024\x02Are you sure you would like to delete %[1]d tunnel?" +
	"\x005\x02Are you sure you would like to delete %[1]d tunnels?\x02Delete " +
	"tunnel ‘%[1]s’\x02Are you sure you would like to delete tunnel ‘%[1]s’?" +
	"\x02%[1]s You cannot undo this action.\x02Unable to delete tunnel\x02A t" +
	"unnel was unable to be removed: %[1]s\x02Unable to delete tunnels\x14" +
	"\x01\x81\x01\x00\x02'\x02%[1]d tunnel was unable to be removed.\x00)\x02" +
	"%[1]d tunnels were unable to be removed.\x02Configuration Files (*.zip, " +
	"*.conf)|*.zip;*.conf|All Files (*.*)|*.*\x02Import tunnel(s) from file" +
	"\x02Configuration ZIP Files (*.zip)|*.zip\x02Export tunnels to zip\x02Un" +
	"able to exit service due to: %[1]v. You may want to stop WireGuard from " +
	"the service manager.\x02Brackets must contain an IPv6 address\x02Keys mu" +
	"st decode to exactly 32 bytes\x02Line must occur in a section\x02Config " +
	"key is missing an equals separator\x02Key must have a value\x02Invalid k" +
	"ey for [Interface] section\x02Invalid key for [Peer] section\x02An inter" +
	"face must have a private key\x02Invalid key for interface section\x02Pro" +
	"tocol version must be 1\x02Invalid key for peer section\x04\x00\x01 \x07" +
	"\x02Error:\x02Interface closed, ignored requested state %[1]s\x02Interfa" +
	"ce state was %[1]s, requested %[2]s, now %[3]s\x02Unable to update bind:" +
	" %[1]v\x02Bind close failed: %[1]v\x02Trouble determining MTU, assuming " +
	"default: %[1]v\x02Device closing\x02Device closed\x02UDP bind has been u" +
	"pdated\x02UAPI: Updating init_packet_magic_header\x02UAPI: Using default" +
	" init type\x02UAPI: Updating response_packet_magic_header\x02UAPI: Using" +
	" default response type\x02UAPI: Updating underload_packet_magic_header" +
	"\x02UAPI: Using default underload type\x02UAPI: Updating transport_packe" +
	"t_magic_header\x02UAPI: Using default transport type\x02%[1]v - ConsumeM" +
	"essageInitiation: handshake replay @ %[2]v\x02%[1]v - ConsumeMessageInit" +
	"iation: handshake flood\x02%[1]v - Starting\x02%[1]v - Stopping\x02Routi" +
	"ne: receive incoming %[1]s - stopped\x02Routine: receive incoming %[1]s " +
	"- started\x02Failed to receive %[1]s packet: %[2]v\x02Transport packet l" +
	"ined up with another msg type\x02ASec: Received message with unknown typ" +
	"e\x02Received message with unknown type\x02Routine: decryption worker %[" +
	"1]d - started\x02Routine: handshake worker %[1]d - stopped\x02Routine: h" +
	"andshake worker %[1]d - started\x02Failed to decode cookie reply\x02Rece" +
	"iving cookie response from %[1]s\x02Could not decrypt invalid cookie res" +
	"ponse\x02Received packet with invalid mac1\x02Invalid packet ended up in" +
	" the handshake queue\x02Failed to decode initiation message\x02Received " +
	"invalid initiation message from %[1]s\x02%[1]v - Received handshake init" +
	"iation\x02Failed to decode response message\x02Received invalid response" +
	" message from %[1]s\x02%[1]v - Received handshake response\x02%[1]v - Fa" +
	"iled to derive keypair: %[2]v\x02%[1]v - Routine: sequential receiver - " +
	"stopped\x02%[1]v - Routine: sequential receiver - started\x02%[1]v - Rec" +
	"eiving keepalive packet\x02IPv4 packet with disallowed source address fr" +
	"om %[1]v\x02IPv6 packet with disallowed source address from %[1]v\x02Pac" +
	"ket with invalid IP version from %[1]v\x02Failed to write packets to TUN" +
	" device: %[1]v\x02%[1]v - Sending keepalive packet\x02%[1]v - Sending ha" +
	"ndshake initiation\x02%[1]v - Failed to create initiation message: %[2]v" +
	"\x02%[1]v - %[2]v\x02%[1]v - Failed to send junk packets: %[2]v\x02%[1]v" +
	" - Failed to send handshake initiation: %[2]v\x02%[1]v - Sending handsha" +
	"ke response\x02%[1]v - Failed to create response message: %[2]v\x02%[1]v" +
	" - Failed to send handshake response: %[2]v\x02Sending cookie response f" +
	"or denied handshake message for %[1]v\x02Failed to create cookie reply: " +
	"%[1]v\x02Routine: TUN reader - stopped\x02Routine: TUN reader - started" +
	"\x02Received packet with unknown IP version\x02Dropped some packets from" +
	" multi-segment read: %[1]v\x02Failed to read packet from TUN device: %[1" +
	"]v\x02%[1]v - Failed to create junk packet: %[2]v\x02Routine: encryption" +
	" worker %[1]d - started\x02%[1]v - Routine: sequential sender - started" +
	"\x02%[1]v - Failed to send data packets: %[2]v\x02%[1]s - Handshake did " +
	"not complete after %[2]d attempts, giving up\x02%[1]s - Handshake did no" +
	"t complete after %[2]d seconds, retrying (try %[3]d)\x02%[1]s - Retrying" +
	" handshake because we stopped hearing back after %[2]d seconds\x02%[1]s " +
	"- Removing all keys, since we haven't received a new one in %[2]d second" +
	"s\x02Routine: event worker - started\x02Failed to load updated MTU of de" +
	"vice: %[1]v\x02MTU not updated to negative value: %[1]v\x02MTU updated: " +
	"%[1]v%[2]s\x02Interface up requested\x02Interface down requested\x02Rout" +
	"ine: event worker - stopped\x02listen_port=%[1]d\x02fwmark=%[1]d\x02jc=%" +
	"[1]d\x02jmin=%[1]d\x02jmax=%[1]d\x02s1=%[1]d\x02s2=%[1]d\x02h1=%[1]d\x02" +
	"h2=%[1]d\x02h3=%[1]d\x02h4=%[1]d\x02protocol_version=1\x02endpoint=%[1]s" +
	"\x02last_handshake_time_sec=%[1]d\x02last_handshake_time_nsec=%[1]d\x02t" +
	"x_bytes=%[1]d\x02rx_bytes=%[1]d\x02persistent_keepalive_interval=%[1]d" +
	"\x02allowed_ip=%[1]s\x02%[1]v\x02UAPI: Updating private key\x02UAPI: Upd" +
	"ating listen port\x02UAPI: Updating fwmark\x02UAPI: Removing all peers" +
	"\x02UAPI: Updating junk_packet_count\x02UAPI: Updating junk_packet_min_s" +
	"ize\x02UAPI: Updating junk_packet_max_size\x02UAPI: Updating init_packet" +
	"_junk_size\x02UAPI: Updating response_packet_junk_size\x02%[1]v - UAPI: " +
	"Created\x02%[1]v - UAPI: Removing\x02%[1]v - UAPI: Updating preshared ke" +
	"y\x02%[1]v - UAPI: Updating endpoint\x02%[1]v - UAPI: Updating persisten" +
	"t keepalive interval\x02%[1]v - UAPI: Removing all allowedips\x02%[1]v -" +
	" UAPI: Adding allowedip\x02invalid UAPI operation: %[1]v\x02About Amnezi" +
	"aWG\x02AmneziaWG logo image\x02App version: %[1]s\x0aWintun version: %[2" +
	"]s\x0aGo version: %[3]s\x0aOperating system: %[4]s\x0aArchitecture: %[5]" +
	"s\x02Table:\x02off\x02When a configuration has exactly one peer, and tha" +
	"t peer has an allowed IPs containing at least one of 0.0.0.0/0 or ::/0, " +
	"and the interface does not have table off, then the tunnel service engag" +
	"es a firewall ruleset to block all traffic that is neither to nor from t" +
	"he tunnel interface or is to the wrong DNS server, with special exceptio" +
	"ns for DHCP and NDP.\x02&About AmneziaWG…\x02AmneziaWG: Deactivated\x02A" +
	"mneziaWG Activated\x02AmneziaWG Deactivated\x02AmneziaWG Tunnel Error" +
	"\x02AmneziaWG: %[1]s\x02Invalid %[1]s"

var es_ESIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x00000044, 0x00000058,
	0x00000077, 0x00000077, 0x00000077, 0x00000077,
	0x00000077, 0x00000077, 0x00000077, 0x00000077,
	0x0000007e, 0x00000086, 0x00000092, 0x0000009b,
	0x000000ab, 0x000000be, 0x000000c3, 0x000000d0,
	0x000000e0, 0x000000f2, 0x00000102, 0x00000102,
	0x00000102, 0x00000112, 0x0000011b, 0x00000128,
	0x0000013b, 0x00000144, 0x0000014c, 0x0000015e,
	// Entry 20 - 3F
	0x00000175, 0x0000017c, 0x00000191, 0x000001ae,
	0x000001c1, 0x00000200, 0x00000200, 0x00000206,
	0x00000206, 0x00000226, 0x00000245, 0x00000265,
	0x00000289, 0x000002af, 0x000002ba, 0x000002c2,
	0x000002ce, 0x000002da, 0x000002e6, 0x000002f2,
	0x000002f2, 0x0000030a, 0x00000330, 0x0000034c,
	0x00000368, 0x00000376, 0x00000388, 0x00000388,
	0x000003a0, 0x000003a0, 0x000003a0, 0x000003a0,
	// Entry 40 - 5F
	0x000003a0, 0x000003a0, 0x000003a0, 0x000003a0,
	0x000003a0, 0x000003ac, 0x000003ac, 0x000003ac,
	0x000003ac, 0x000003ac, 0x000003ac, 0x000003b5,
	0x000003b5, 0x000003b5, 0x000003d0, 0x000003ee,
	0x000003fe, 0x00000404, 0x0000041a, 0x00000428,
	0x00000431, 0x00000441, 0x0000044f, 0x0000044f,
	0x00000458, 0x00000461, 0x00000472, 0x00000484,
	0x0000049b, 0x000004cb, 0x000004cb, 0x000004cb,
	// Entry 60 - 7F
	0x000004cb, 0x000004cb, 0x000004cb, 0x000004cb,
	0x000004d2, 0x000004dc, 0x00000519, 0x00000519,
	0x00000519, 0x0000052d, 0x00000542, 0x00000542,
	0x00000542, 0x00000549, 0x00000553, 0x00000553,
	0x00000553, 0x00000561, 0x00000574, 0x0000057d,
	0x00000585, 0x0000059f, 0x000005ae, 0x000005ce,
	0x000005f0, 0x000005fa, 0x000005fa, 0x000005fa,
	0x000005fa, 0x000005fa, 0x000005fa, 0x0000062f,
	// Entry 80 - 9F
	0x0000065b, 0x00000687, 0x0000069b, 0x000006d5,
	0x00000720, 0x0000073b, 0x00000772, 0x00000772,
	0x0000078e, 0x000007ca, 0x000007f1, 0x0000080e,
	0x00000838, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	// Entry A0 - BF
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	// Entry C0 - DF
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	// Entry E0 - FF
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	// Entry 100 - 11F
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	0x00000854, 0x00000854, 0x00000854, 0x00000854,
	// Entry 120 - 13F
	0x00000854,
} // Size: 1180 bytes

const es_ESData string = "" + // Size: 2132 bytes
	"\x02Error\x02(sin argumento): eleva e instala el servicio de administrad" +
	"or\x02Uso: %[1]s [\x0a%[2]s]\x02Opciones de línea de comandos\x02Cerrar" +
	"\x02Estado:\x02&Desactivar\x02&Activar\x02Clave pública:\x02Puerto de es" +
	"cucha:\x02MTU:\x02Direcciones:\x02Servidores DNS:\x02Clave compartida:" +
	"\x02IPs permitidas:\x02Último saludo:\x02Inactivo\x02Desactivando\x02Est" +
	"ado desconocido\x02Registro\x02&Copiar\x02Seleccionar &todo\x02&Guardar " +
	"en archivo…\x02Tiempo\x02Registro de mensajes\x02Exportar archivo de reg" +
	"istro\x02Error en el túnel\x02%[1]s\x0a\x0aPor favor, consulte el regist" +
	"ro para más información.\x02Ahora\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d a" +
	"ño\x00\x0c\x02%[1]d años\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d día\x00" +
	"\x0b\x02%[1]d dias\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d hora\x00\x0c\x02" +
	"%[1]d horas\x14\x01\x81\x01\x00\x02\x0d\x02%[1]d minuto\x00\x0e\x02%[1]d" +
	" minutos\x14\x01\x81\x01\x00\x02\x0e\x02%[1]d segundo\x00\x0f\x02%[1]d s" +
	"egundos\x02hace %[1]s\x02%[1]d B\x02%.2[1]f KiB\x02%.2[1]f MiB\x02%.2[1]" +
	"f GiB\x02%.2[1]f TiB\x02Dirección IP inválida\x02Longitud de prefijo de " +
	"red no válida\x02Falta el puerto del extremo\x02Host de endpoint no váli" +
	"do\x02MTU no valido\x02Puerto no válido\x02Clave no válida: %[1]v\x02Tra" +
	"nsferir:\x02activado\x02Error al activar el túnel\x02Error al desactivar" +
	" el túnel\x02Interfaz: %[1]s\x02Pares\x02Crear un túnel nuevo\x02Editar " +
	"túnel\x02&Nombre:\x02Clave pública:\x02(desconocido)\x02&Guardar\x02Canc" +
	"elar\x02&Configuración:\x02Nombre no válido\x02Se requiere un nombre." +
	"\x02El nombre del túnel ‘%[1]s’ no es válido.\x02Activo\x02Activando\x02" +
	"Archivos de texto (*.txt)|*.txt|Todos los archivos (*.*)|*.*\x02Estado: " +
	"Desconocido\x02Direcciones: Ninguna\x02&Salir\x02&Túneles\x02Estado: %[1" +
	"]s\x02Direcciones: %[1]s\x02Túneles\x02&Editar\x02Añadir &túnel vacío…" +
	"\x02Añadir túnel\x02Eliminar túneles seleccionados\x02Exportar todos los" +
	" túneles a zip\x02&Alternar\x02No se pueden enumerar los túneles existen" +
	"tes: %[1]v\x02Ya existe otro túnel con el nombre '%[1]s'\x02Imposible im" +
	"portar la configuración: %[1]v\x02Túneles importados\x14\x01\x81\x01\x00" +
	"\x02\x17\x02%[1]d túnel importado\x00\x1a\x02%[1]d túneles importados" +
	"\x14\x02\x80\x01\x02 \x02Importado %[1]d de %[2]d túnel\x00#\x02Importad" +
	"os %[1]d de %[2]d túneles\x02No se pudo crear el túnel\x14\x01\x81\x01" +
	"\x00\x02\x16\x02Eliminar %[1]d túnel\x00\x18\x02Eliminar %[1]d túneles" +
	"\x02Eliminar túnel ‘%[1]s’\x02¿Está seguro de que desea eliminar el túne" +
	"l ‘%[1]s’?\x02%[1]s No puedes deshacer esta acción.\x02No se pudo elimin" +
	"ar el tunel\x02No se ha podido eliminar un túnel: %[1]s\x02Imposible eli" +
	"minar túneles"

var faIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000007, 0x00000007,
	0x0000002b, 0x0000002b, 0x0000002b, 0x0000002b,
	0x0000002b, 0x0000002b, 0x0000002f, 0x00000033,
	0x0000003c, 0x00000048, 0x00000063, 0x00000078,
	0x0000008d, 0x000000a0, 0x000000a5, 0x000000b8,
	0x000000cc, 0x000000f4, 0x00000107, 0x0000011c,
	0x00000147, 0x00000147, 0x00000156, 0x0000017c,
	0x00000198, 0x000001ae, 0x000001bc, 0x000001bc,
	// Entry 20 - 3F
	0x000001dd, 0x000001e6, 0x00000207, 0x00000243,
	0x00000257, 0x00000257, 0x0000028d, 0x0000029d,
	0x0000029d, 0x000002c0, 0x000002e3, 0x0000030a,
	0x00000335, 0x00000360, 0x0000036d, 0x0000037d,
	0x0000037d, 0x0000037d, 0x0000037d, 0x0000037d,
	0x0000037d, 0x000003aa, 0x000003aa, 0x000003aa,
	0x000003aa, 0x000003c4, 0x000003dc, 0x000003dc,
	0x000003dc, 0x000003dc, 0x000003dc, 0x000003dc,
	// Entry 40 - 5F
	0x000003f0, 0x00000440, 0x0000046a, 0x0000046a,
	0x0000046a, 0x00000478, 0x00000478, 0x00000478,
	0x00000478, 0x00000478, 0x00000478, 0x00000488,
	0x00000488, 0x00000488, 0x00000488, 0x00000488,
	0x00000498, 0x000004a1, 0x000004be, 0x000004d4,
	0x000004dd, 0x000004f3, 0x00000506, 0x00000506,
	0x00000512, 0x00000519, 0x0000052c, 0x00000542,
	0x00000563, 0x00000563, 0x000005a9, 0x000005d6,
	// Entry 60 - 7F
	0x000005d6, 0x000005d6, 0x000005d6, 0x000005d6,
	0x000005df, 0x000005ff, 0x000005ff, 0x000005ff,
	0x000005ff, 0x0000061c, 0x00000636, 0x00000657,
	0x00000657, 0x00000657, 0x00000657, 0x00000679,
	0x00000679, 0x0000068b, 0x0000068b, 0x0000069b,
	0x000006a9, 0x000006d7, 0x000006ed, 0x00000712,
	0x00000747, 0x00000747, 0x00000780, 0x00000780,
	0x00000780, 0x00000780, 0x00000780, 0x00000780,
	// Entry 80 - 9F
	0x00000780, 0x00000780, 0x000007a2, 0x000007e5,
	0x0000083d, 0x0000086a, 0x0000089f, 0x0000089f,
	0x000008bb, 0x000008bb, 0x000008bb, 0x000008ed,
	0x000008ed, 0x00000922, 0x00000922, 0x00000922,
	0x00000955, 0x00000991, 0x000009bf, 0x000009bf,
	0x000009bf, 0x000009bf, 0x000009bf, 0x000009bf,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	// Entry A0 - BF
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	// Entry C0 - DF
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	// Entry E0 - FF
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	// Entry 100 - 11F
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	0x000009f5, 0x000009f5, 0x000009f5, 0x000009f5,
	// Entry 120 - 13F
	0x000009f5,
} // Size: 1180 bytes

const faData string = "" + // Size: 2549 bytes
	"\x02خطا\x02گزینه\u200cهای خط فرمان\x02، \x02، \x02بستن\x02وضعیت:\x02&غیر" +
	"فعال\u200cسازی\x02&فعال\u200cسازی\x02کلید عمومی:\x02پورت شنود:\x02MTU:" +
	"\x02نشانی\u200cها:\x02سرورهای DNS:\x02کلید از پیش تقسیم شده:\x02IPهای مج" +
	"از:\x02نقطه پایان:\x02زنده نگه\u200cداشتن پیوسته:\x02غیرفعال\x02در حال " +
	"غیرفعال\u200cسازی\x02وضعیت ناشناخته\x02گزارش وقایع\x02&روگرفت\x02&ذخیره" +
	" در پرونده…\x02زمان\x02پیام گزارش رویداد\x02برون\u200cبرد گزارش رویداد ب" +
	"ه پرونده\x02خطالی تونل\x02خطا در هنگام خارج شدن از WireGuard\x02هم اکنو" +
	"ن\x14\x01\x81\x01\x00\x02\x0d\x02%[1]d سال\x00\x0d\x02%[1]d سال\x14\x01" +
	"\x81\x01\x00\x02\x0d\x02%[1]d روز\x00\x0d\x02%[1]d روز\x14\x01\x81\x01" +
	"\x00\x02\x0f\x02%[1]d ساعت\x00\x0f\x02%[1]d ساعت\x14\x01\x81\x01\x00\x02" +
	"\x11\x02%[1]d دقیقه\x00\x11\x02%[1]d دقیقه\x14\x01\x81\x01\x00\x02\x11" +
	"\x02%[1]d ثانیه\x00\x11\x02%[1]d ثانیه\x02%[1]s پیش\x02%[1]d\u00a0بایت" +
	"\x02نشانی آی\u200cپی نامعتبر است\x02MTU نامعتبر است\x02پورت نامعتبر\x02[" +
	"مشخص نشده]\x02همه همتاها باید کلید\u200cهای عمومی داشته باشند\x02خطا در" +
	" دریافت پیکربندی\x02انتقال:\x02فعال شده\x02رابط: %[1]s\x02همتا\x02ایجاد " +
	"تونل جدید\x02ویرایش تونل\x02&نام:\x02&کلید عمومی:\x02(ناشناخته)\x02&ذخی" +
	"ره\x02لغو\x02&پیکربندی:\x02نام نامعتبر\x02یک نام الزامی است.\x02نمی" +
	"\u200cتوان تونل\u200cهای موجود را فهرست کرد\x02تونل هم\u200cاکنون موجود " +
	"است\x02فعال\x02در حال فعال\u200cسازی\x02وضعیت: ناشناخته\x02نشانی\u200cه" +
	"ا: هیچ\x02&مدیریت تونل\u200cها…\x02تونل %[1]s فعال\u200cشده.\x02وضعیت: " +
	"%[1]s\x02تونل\u200cها\x02&ویرایش\x02افزودن &خالی\u200cکردن تونل…\x02افزو" +
	"دن تونل\x02حذف تونل(ها) انتخابی\x02برون\u200cبری همه تونل\u200cها به زی" +
	"پ\x02برون\u200cبری همه تونل\u200cها به &زیپ…\x02تونل\u200cهای وارد شده" +
	"\x14\x01\x81\x01\x00\x02\x1d\x02%[1]d تونل وارد شد\x00\x1d\x02%[1]d تونل" +
	" وارد شد\x14\x02\x80\x01\x02(\x02%[1]d از %[2]d تونل وارد شد\x00(\x02%[1" +
	"]d از %[2]d تونل وارد شد\x02نمی\u200cتوان تونل ایجاد کرد\x14\x01\x81\x01" +
	"\x00\x02\x16\x02حذف %[1]d تونل\x00\x16\x02حذف %[1]d تونل\x02حذف تونل ‘%[" +
	"1]s’\x02حذف تونل\u200c امکان\u200cپذیر نیست\x02نمی\u200cتوان تونل\u200cه" +
	"ا را حذف کرد\x02وارد کردن تونل(ها) از پرونده\x02پرونده\u200cهای پیکربند" +
	"ی زیپ (*.zip)|*.zip\x02برون\u200cبری تونل\u200cها به زیپ\x02کلید باید ی" +
	"ک مقدار داشته باشد"

var fiIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x00000006, 0x00000006,
	0x00000006, 0x00000006, 0x00000006, 0x00000006,
	0x00000006, 0x00000006, 0x00000009, 0x0000000c,
	0x00000012, 0x00000018, 0x00000018, 0x00000018,
	0x00000028, 0x0000003a, 0x0000003f, 0x0000004a,
	0x0000005a, 0x00000068, 0x0000007f, 0x0000008d,
	0x000000a0, 0x000000b4, 0x000000b4, 0x000000b4,
	0x000000b4, 0x000000b9, 0x000000c1, 0x000000c1,
	// Entry 20 - 3F
	0x000000c1, 0x000000c1, 0x000000c1, 0x000000c1,
	0x000000c1, 0x000000c1, 0x000000c1, 0x000000c5,
	0x000000e5, 0x000000e5, 0x000000e5, 0x000000e5,
	0x000000e5, 0x000000e5, 0x000000f2, 0x000000fa,
	0x000000fa, 0x000000fa, 0x000000fa, 0x000000fa,
	0x000000fa, 0x000000fa, 0x000000fa, 0x000000fa,
	0x000000fa, 0x0000010b, 0x0000011f, 0x0000013e,
	0x00000158, 0x00000158, 0x00000158, 0x00000158,
	// Entry 40 - 5F
	0x00000158, 0x00000158, 0x00000158, 0x00000158,
	0x00000167, 0x00000170, 0x00000170, 0x00000170,
	0x00000170, 0x00000170, 0x00000170, 0x0000017c,
	0x000001a2, 0x000001a2, 0x000001a2, 0x000001a2,
	0x000001b6, 0x000001bf, 0x000001d0, 0x000001e1,
	0x000001e8, 0x000001f9, 0x00000206, 0x00000236,
	0x00000240, 0x00000240, 0x00000250, 0x00000262,
	0x00000276, 0x00000276, 0x00000276, 0x0000028d,
	// Entry 60 - 7F
	0x0000028d, 0x0000028d, 0x0000028d, 0x0000028d,
	0x0000028d, 0x0000028d, 0x0000028d, 0x0000028d,
	0x0000028d, 0x0000028d, 0x0000028d, 0x0000028d,
	0x000002ac, 0x000002ac, 0x000002ac, 0x000002ac,
	0x000002ac, 0x000002ac, 0x000002ac, 0x000002b4,
	0x000002bd, 0x000002d8, 0x000002e8, 0x000002e8,
	0x000002e8, 0x000002e8, 0x000002e8, 0x000002e8,
	0x000002e8, 0x000002e8, 0x000002e8, 0x000002e8,
	// Entry 80 - 9F
	0x000002e8, 0x000002e8, 0x000002f8, 0x0000032a,
	0x0000032a, 0x0000032a, 0x0000032a, 0x0000032a,
	0x0000032a, 0x0000032a, 0x0000032a, 0x0000032a,
	0x0000032a, 0x00000344, 0x00000344, 0x00000344,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	// Entry A0 - BF
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	// Entry C0 - DF
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	// Entry E0 - FF
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	// Entry 100 - 11F
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	0x0000035f, 0x0000035f, 0x0000035f, 0x0000035f,
	// Entry 120 - 13F
	0x0000035f,
} // Size: 1180 bytes

const fiData string = "" + // Size: 863 bytes
	"\x02Virhe\x02, \x02, \x02Sulje\x02Tila:\x02Julkinen avain:\x02Kuuntele p" +
	"orttia:\x02MTU:\x02Osoitteet:\x02DNS palvelimet:\x02Jaettu avain:\x02Sal" +
	"litut IP-osoitteet:\x02Päätepiste:\x02Jatkuva keepalive:\x02Viimeisin kä" +
	"ttely:\x02Loki\x02&Kopioi\x02Nyt\x02Järjestelmän kello jättää!\x02%[1]s " +
	"sitten\x02%[1]d B\x02Virheellinen MTU\x02Virheellinen portti\x02Virheell" +
	"inen jatkuva keepalive\x02Virheellinen avain: %[1]v\x02Komentosarjat:" +
	"\x02Siirrot:\x02käytössä\x02%[1]s vastaanotettu, %[2]s lähetetty\x02Verk" +
	"koyhteys: %[1]s\x02Osapuoli\x02Luo uusi tunneli\x02Muokkaa tunnelia\x02&" +
	"Nimi:\x02&Julkinen avain:\x02(tuntematon)\x02&Estä tunneloimaton liikenn" +
	"e (pääkatkaisija)\x02&Tallenna\x02&Konfiguraatio:\x02Virheellinen nimi" +
	"\x02Nimi on pakollinen.\x02Tunneli on jo olemassa\x02Tuo tunnele&ita tie" +
	"dostosta…\x02Tunneli\x02&Muokkaa\x02Lisää tyhjä tunn&eli…\x02Lisää tunne" +
	"li\x02Tuodut tunnelit\x14\x01\x81\x01\x00\x02\x14\x02Tuotu %[1]d tunneli" +
	"\x00\x15\x02Tuotu %[1]d tunnelia\x02Tunnelia ei voitu poistaa\x02Tuo tun" +
	"neli(t) tiedostosta"

var frIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000046, 0x00000063,
	0x00000083, 0x000000cb, 0x00000112, 0x0000014b,
	0x000001ad, 0x00000225, 0x00000228, 0x0000022a,
	0x00000231, 0x00000239, 0x00000246, 0x0000024f,
	0x0000025f, 0x00000270, 0x00000276, 0x00000281,
	0x00000290, 0x000002a6, 0x000002c0, 0x000002d7,
	0x00000305, 0x0000032c, 0x00000335, 0x0000034d,
	0x0000035b, 0x00000363, 0x0000036b, 0x0000037f,
	// Entry 20 - 3F
	0x0000039f, 0x000003a5, 0x000003b8, 0x000003dc,
	0x000003ed, 0x00000437, 0x00000455, 0x00000460,
	0x00000483, 0x0000049f, 0x000004bf, 0x000004e1,
	0x00000505, 0x0000052b, 0x00000538, 0x00000541,
	0x0000054e, 0x0000055b, 0x00000568, 0x00000575,
	0x00000583, 0x00000599, 0x000005c1, 0x000005e7,
	0x00000610, 0x0000061f, 0x0000062f, 0x00000644,
	0x0000065c, 0x00000694, 0x000006b0, 0x000006c9,
	// Entry 40 - 5F
	0x000006e1, 0x00000715, 0x0000073c, 0x00000799,
	0x000007a3, 0x000007af, 0x000007bf, 0x000007cf,
	0x000007e3, 0x000007f7, 0x00000815, 0x00000820,
	0x00000841, 0x0000086d, 0x0000088c, 0x000008b0,
	0x000008c2, 0x000008cc, 0x000008e5, 0x000008f8,
	0x000008ff, 0x00000910, 0x0000091d, 0x00000950,
	0x0000095d, 0x00000965, 0x00000976, 0x00000985,
	0x0000099d, 0x000009c7, 0x000009fc, 0x00000a12,
	// Entry 60 - 7F
	0x00000a46, 0x00000a76, 0x00000a94, 0x00000ad3,
	0x00000adc, 0x00000af0, 0x00000b29, 0x00000b4b,
	0x00000b8d, 0x00000b9d, 0x00000baf, 0x00000bc7,
	0x00000bf9, 0x00000c02, 0x00000c0c, 0x00000c2a,
	0x00000c4c, 0x00000c5a, 0x00000c6b, 0x00000c73,
	0x00000c7d, 0x00000c98, 0x00000caa, 0x00000cd5,
	0x00000cf8, 0x00000d02, 0x00000d29, 0x00000d4e,
	0x00000d7a, 0x00000da1, 0x00000ddf, 0x00000e16,
	// Entry 80 - 9F
	0x00000e42, 0x00000e71, 0x00000e83, 0x00000eba,
	0x00000f03, 0x00000f22, 0x00000f5a, 0x00000fbe,
	0x00000fde, 0x00001014, 0x00001043, 0x00001065,
	0x0000109a, 0x000010be, 0x0000112a, 0x0000117d,
	0x000011ab, 0x000011d7, 0x000011f5, 0x00001270,
	0x000012a8, 0x000012d5, 0x00001301, 0x0000133c,
	0x00001357, 0x00001383, 0x000013aa, 0x000013d2,
	0x000013fe, 0x00001420, 0x0000144c, 0x0000144c,
	// Entry A0 - BF
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	// Entry C0 - DF
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	// Entry E0 - FF
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	// Entry 100 - 11F
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	0x0000144c, 0x0000144c, 0x0000144c, 0x0000144c,
	// Entry 120 - 13F
	0x0000144c,
} // Size: 1180 bytes

const frData string = "" + // Size: 5196 bytes
	"\x02Erreur\x02(sans argument) : élever et installer service du gestionna" +
	"ire\x02Utilisation : %[1]s [\x0a%[2]s]\x02Options de la ligne de command" +
	"e\x02Impossible de détecter si le processus s’exécute sous WOW64 : %[1]v" +
	"\x02Vous devez utiliser la version native de WireGuard sur cet ordinateu" +
	"r.\x02Impossible d'ouvrir le jeton du processus actuel : %[1]v\x02Seulem" +
	"ent les utilisateurs qui sont membres du groupe intégré %[1]s peuvent ut" +
	"iliser WireGuard.\x02WireGuard est en cours d'exécution, mais l'IU est a" +
	"ccessible seulement à partir des bureaux du group intégré %[1]s.\x02, " +
	"\x02 \x02Fermer\x02État :\x02&Désactiver\x02&Activer\x02Clé publique :" +
	"\x02Port d'écoute :\x02MTU :\x02Adresses :\x02Serveurs DNS :\x02Clé pré-" +
	"partagée :\x02Adresses IP autorisées :\x02Point de terminaison :\x02Cons" +
	"ervation de connexion active permanente :\x02Dernier établissement d'une" +
	" liaison :\x02Éteinte\x02Désactivation en cours\x02État inconnu\x02Journ" +
	"al\x02&Copier\x02Sélectionner &tout\x02&Enregistrer dans le fichier…\x02" +
	"Temps\x02Message du journal\x02Exporter le journal vers le fichier\x02Er" +
	"reur du tunnel\x02%[1]s\x0a\x0aConsultez le journal pour plus d’informat" +
	"ions, s'il vous plaît.\x02Erreur de sortie du WireGuard\x02Maintenant" +
	"\x02L’horloge système est inversé!\x14\x01\x81\x01\x00\x02\x09\x02%[1]d " +
	"an\x00\x0a\x02%[1]d ans\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d jour\x00" +
	"\x0c\x02%[1]d jours\x14\x01\x81\x01\x00\x02\x0c\x02%[1]d heure\x00\x0d" +
	"\x02%[1]d heures\x14\x01\x81\x01\x00\x02\x0d\x02%[1]d minute\x00\x0e\x02" +
	"%[1]d minutes\x14\x01\x81\x01\x00\x02\x0e\x02%[1]d seconde\x00\x0f\x02%[" +
	"1]d secondes\x02Il y a %[1]s\x02%[1]d\u00a0o\x02%.2[1]f\u00a0Kio\x02%.2[" +
	"1]f\u00a0Mio\x02%.2[1]f\u00a0Gio\x02%.2[1]f\u00a0Tio\x02%[1]s : %[2]q" +
	"\x02Adresse IP non valide\x02Longueur du préfixe réseau non valide\x02Po" +
	"rt manquant au point de terminaison\x02Hôte du point de terminaison non " +
	"valide\x02MTU non valide\x02Port non valide\x02Keepalive non valide\x02C" +
	"lé non valide : %[1]v\x02Le numéro doit être compris entre 0 et 2^64-1 :" +
	" %[1]v\x02Deux virgules consécutives\x02Nom du tunnel non valide\x02[auc" +
	"une spécification]\x02Toutes les pairs doivent contenir une clé publique" +
	"\x02Erreur d'obtention de la configuration\x02L’icône de la barre d’état" +
	" système du WireGuard n'est pas apparue après 30 secondes.\x02Scripts :" +
	"\x02Transfert :\x02pré-activation\x02post-activation\x02pré-désactivatio" +
	"n\x02post-désactivation\x02désactivé, par préférence\x02activé(e)\x02%[1" +
	"]s reçu(e), %[2]s envoyé(e)\x02Impossible de déterminer l'état du tunnel" +
	"\x02Impossible d'activer le tunnel\x02Impossible de désactiver le tunnel" +
	"\x02Interface : %[1]s\x02Homologue\x02Créer un nouveau tunnel\x02Modifie" +
	"r le tunnel\x02&Nom :\x02&Clé publique :\x02(inconnu(e))\x02&Bloquer tou" +
	"s le trafic hors tunnel (interrupteur)\x02&Enregistrer\x02Annuler\x02&Co" +
	"nfiguration :\x02Nom non valide\x02Le nom est obligatoire.\x02Nom de tun" +
	"nel « %[1]s » est non valide.\x02Impossible de créer une liste des tunne" +
	"ls existants\x02Tunnel existe déjà.\x02Nom « %[1]s » est déjà utilisé po" +
	"ur un tunnel.\x02Impossible de créer une configuration nouvelle\x02Échec" +
	" d'écriture du fichier\x02Fichier « %[1]s » existe déjà.\x0a\x0aVoulez-v" +
	"ous le remplacer ?\x02Activée\x02Activation en cours\x02Fichiers texte (" +
	"*.txt)|*.txt|Tous les fichiers (*.*)|*.*\x02Erreur de détection du WireG" +
	"uard\x02Impossible d’attendre l'affichage du fenêtre WireGuard : %[1]v" +
	"\x02État : Inconnu\x02Adresses : Aucune\x02&Gestion des tunnels…\x02&Imp" +
	"orter le(s) tunnel(s) à partir du fichier…\x02Q&uitter\x02& Tunnels\x02T" +
	"unnel %[1]s a été activé.\x02Tunnel %[1]s a été désactivé.\x02État : %[1" +
	"]s\x02Adresses : %[1]s\x02Tunnels\x02&Modifier\x02Ajouter un &tunnel vid" +
	"e…\x02Ajouter le tunnel\x02Supprimer le(s) tunnel(s) sélectionné(s)\x02E" +
	"xporter tous les tunnels vers zip\x02&Basculer\x02Exporter tous les tunn" +
	"els vers &zip…\x02Modifier &le tunnel sélectionné…\x02&Supprimer le(s) t" +
	"unnel(s) sélectionné(s)\x02aucun fichier de configuration trouvé\x02Impo" +
	"ssible d'importer la configuration sélectionnée : %[1]v\x02Impossible d'" +
	"énumérer les tunnels existantes : %[1]v\x02Un tunnel nommé « %[1]s » ex" +
	"iste déjà.\x02Impossible d'importer la configuration : %[1]v\x02Tunnels " +
	"importés\x14\x01\x81\x01\x00\x02\x16\x02%[1]d tunnel importé\x00\x18\x02" +
	"%[1]d tunnels importés\x14\x02\x80\x01\x02 \x02%[1]d de %[2]d tunnels im" +
	"porté\x00!\x02%[1]d de %[2]d tunnels importés\x02Impossible de créer le " +
	"tunnel\x14\x01\x81\x01\x00\x02\x17\x02Supprimer %[1]d tunnel\x00\x18\x02" +
	"Supprimer %[1]d tunnels\x14\x01\x81\x01\x00\x02-\x02Voulez-vous vraiment" +
	" supprimer %[1]d tunnel?\x00.\x02Voulez-vous vraiment supprimer %[1]d tu" +
	"nnels?\x02Supprimer le tunnel ‘%[1]s’\x02Voulez-vous vraiment supprimer " +
	"le tunnel « %[1]s »?\x02%[1]s Vous ne pouvez pas annuler cette action." +
	"\x02Impossible de supprimer le tunnel\x02Il a été impossible de supprime" +
	"r un tunnel : %[1]s\x02Impossible de supprimer les tunnels\x14\x01\x81" +
	"\x01\x00\x021\x02Il a été impossible de supprimer %[1]d tunnel.\x002\x02" +
	"Il a été impossible de supprimer %[1]d tunnels.\x02Fichiers de configura" +
	"tion (*.zip, *.conf)|*.zip;*.conf|Tous les fichiers (*.*)|*.*\x02Importe" +
	"r le(s) tunnel(s) à partir du fichier\x02Fichiers de configuration ZIP (" +
	"*.zip)|*.zip\x02Exporter les tunnels vers zip\x02Impossible de quitter l" +
	"e service en raison de : %[1]v. Essayez d'arrêter WireGuard à partir du " +
	"gestionnair des services.\x02L’adresse IPv6 doit être contenue entre des" +
	" crochets\x02Clés doivent être décodées sur 32 octets\x02Une ligne doit " +
	"apparaître dans une section\x02Il manque le séparateur égal à la clé de " +
	"configuration\x02Clé doit avoir une valeur\x02Clé non valide pour la sec" +
	"tion [Interface]\x02Clé non valide pour la section [Peer]\x02L'interface" +
	" doit avoir une clé privée\x02Clé non valide pour la section d'interface" +
	"\x02Version du protocole doit être 1\x02Clé non valide pour la section d" +
	"'homologue"

var idIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x0000000a, 0x00000047, 0x00000062,
	0x00000074, 0x000000bf, 0x000000bf, 0x000000f0,
	0x00000148, 0x000001a1, 0x000001a4, 0x000001a4,
	0x000001aa, 0x000001b2, 0x000001b2, 0x000001b2,
	0x000001b2, 0x000001b2, 0x000001b2, 0x000001b2,
	0x000001b2, 0x000001b2, 0x000001b2, 0x000001b2,
	0x000001b2, 0x000001b2, 0x000001bb, 0x000001c9,
	0x000001e0, 0x000001e8, 0x000001ee, 0x000001fa,
	// Entry 20 - 3F
	0x00000217, 0x0000021d, 0x00000227, 0x0000023f,
	0x0000024b, 0x00000281, 0x00000281, 0x0000028a,
	0x0000029d, 0x000002bc, 0x000002ce, 0x000002df,
	0x000002f2, 0x00000305, 0x00000315, 0x0000031d,
	0x00000329, 0x00000335, 0x00000341, 0x0000034d,
	0x0000035a, 0x00000370, 0x0000038b, 0x000003ab,
	0x000003c5, 0x000003d5, 0x000003e6, 0x00000407,
	0x0000041d, 0x0000044f, 0x00000469, 0x00000481,
	// Entry 40 - 5F
	0x00000492, 0x000004ba, 0x000004de, 0x00000513,
	0x00000513, 0x00000513, 0x00000513, 0x00000513,
	0x00000513, 0x00000513, 0x00000513, 0x00000513,
	0x00000513, 0x00000513, 0x00000513, 0x00000513,
	0x00000513, 0x00000513, 0x00000513, 0x00000513,
	0x00000513, 0x00000513, 0x00000513, 0x00000513,
	0x00000513, 0x00000513, 0x00000513, 0x00000513,
	0x00000513, 0x00000513, 0x00000513, 0x00000513,
	// Entry 60 - 7F
	0x00000513, 0x00000513, 0x00000513, 0x00000513,
	0x00000519, 0x00000526, 0x00000556, 0x0000056d,
	0x000005a2, 0x000005ba, 0x000005c9, 0x000005dc,
	0x000005f7, 0x000005ff, 0x000005ff, 0x000005ff,
	0x000005ff, 0x0000060d, 0x0000060d, 0x0000060d,
	0x0000060d, 0x0000060d, 0x0000060d, 0x0000060d,
	0x0000060d, 0x0000060d, 0x0000062c, 0x00000645,
	0x0000065c, 0x0000065c, 0x00000692, 0x00000692,
	// Entry 80 - 9F
	0x00000692, 0x00000692, 0x00000692, 0x00000692,
	0x00000692, 0x00000692, 0x00000692, 0x00000692,
	0x00000692, 0x00000692, 0x00000692, 0x00000692,
	0x00000692, 0x00000692, 0x00000692, 0x00000692,
	0x00000692, 0x00000692, 0x00000692, 0x00000692,
	0x000006b8, 0x000006e0, 0x000006fd, 0x000006fd,
	0x00000718, 0x00000742, 0x00000767, 0x0000078c,
	0x000007b6, 0x000007cd, 0x000007f2, 0x000007f2,
	// Entry A0 - BF
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	// Entry C0 - DF
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	// Entry E0 - FF
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	// Entry 100 - 11F
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	0x000007f2, 0x000007f2, 0x000007f2, 0x000007f2,
	// Entry 120 - 13F
	0x000007f2,
} // Size: 1180 bytes

const idData string = "" + // Size: 2034 bytes
	"\x02Kesalahan\x02(tidak ada argumen): naikkan akses dan instal servis ma" +
	"najer\x02Penggunaan: %[1]s [\x0a%[2]s]\x02Opsi Command Line\x02Tidak dap" +
	"at menentukan apakah proses sedang berjalan di bawah WOW64: %[1]v\x02Tid" +
	"ak dapat membuka token proses saat ini: %[1]v\x02WireGuard hanya dapat d" +
	"igunakan oleh pengguna yang merupakan anggota grup Bawaan %[1]s.\x02Wire" +
	"Guard sedang berjalan, tetapi UI hanya dapat diakses dari desktop grup B" +
	"awaan %[1]s.\x02, \x02Tutup\x02Status:\x02Nonaktif\x02Menonaktifkan\x02S" +
	"tatus tidak diketahui\x02Catatan\x02Salin\x02Pilih semua\x02Menyimpan ke" +
	" dalam berkas…\x02Waktu\x02Pesan log\x02Ekspor log kedalam file\x02Tunne" +
	"l eror\x02%[1]s\x0a\x0aSilakan baca log untuk informasi lebih lanjut." +
	"\x02Sekarang\x02Jam sistem mundur!\x14\x01\x81\x01\x00\x00\x18\x02%[1]d " +
	"tahun\x0a%[1]d tahun\x14\x01\x81\x01\x00\x00\x0b\x02%[1]d Hari\x14\x01" +
	"\x81\x01\x00\x00\x0a\x02%[1]d jam\x14\x01\x81\x01\x00\x00\x0c\x02%[1]d m" +
	"enit\x14\x01\x81\x01\x00\x00\x0c\x02%[1]d detik\x02%[1]s yang lalu\x02%[" +
	"1]d B\x02%.2[1]f KiB\x02%.2[1]f MiB\x02%.2[1]f GiB\x02%.2[1]f TiB\x02%[1" +
	"]s: %[2]q\x02Alamat IP tidak valid\x02Network prefix tidak valid\x02Port" +
	" belum terisi dari endpoint\x02Host endpoint tidak valid\x02MTU tidak va" +
	"lid\x02Port tidak valid\x02Persistent keepalive tidak valid\x02Kunci tid" +
	"ak sah:%[1]v\x02Nomor harus diantara 0 sampai dengan 2^64-1:%[1]v\x02Dua" +
	" koma dalam satu baris\x02Nama Tunnel tidak valid\x02Tidak Ditetapkan" +
	"\x02Semua peers harus memiliki kunci publik\x02Eror ketika mendapatkan k" +
	"onfigurasi\x02Ikon sistem WireGuard tidak muncul setelah 30 detik.\x02Ak" +
	"tif\x02Mengaktifkan\x02Berkas Txt (*.Txt)|*.Txt|Semua berkas (*.*)|*.*" +
	"\x02Deteksi eror WireGuard\x02Tidak dapat menunggu jendela WireGuard mun" +
	"cul: %[1]v\x02Status: Tidak diketahui\x02Alamat: Kosong\x02&Manajer Tunn" +
	"el…\x02&Impor tunnel dari file…\x02&Keluar\x02Status: %[1]s\x02Ekspor se" +
	"mua tunnel ke &zip…\x02Ubah tunnel &terpilih…\x02&Hapus tunnel terpilih" +
	"\x02Tidak dapat mengimpor konfigurasi yang dipilih: %[1]v\x02Dalam Kurun" +
	"g harus berisi alamat IPv6\x02Kunci harus diterjemahkan tepat 32 byte" +
	"\x02Garis harus muncul perbagian\x02Kunci harus memiliki value\x02Kunci " +
	"tidak valid pada bagian [Interface]\x02Kunci tidak valid pada bagian [Pe" +
	"er]\x02Interface harus memiliki Private Key\x02Kunci tidak valid pada ba" +
	"gian [Interface]\x02Versi protokol harus 1\x02Kunci tidak valid pada bag" +
	"ian [Peer]"

var itIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000044, 0x0000005d,
	0x00000075, 0x000000bd, 0x00000101, 0x0000013a,
	0x00000191, 0x00000202, 0x00000205, 0x00000207,
	0x0000020e, 0x00000215, 0x00000220, 0x00000228,
	0x00000239, 0x0000024b, 0x00000250, 0x0000025b,
	0x00000267, 0x0000027d, 0x0000028c, 0x00000296,
	0x000002ac, 0x000002c1, 0x000002ca, 0x000002d9,
	0x000002eb, 0x000002ef, 0x000002f6, 0x00000307,
	// Entry 20 - 3F
	0x00000319, 0x0000031f, 0x00000330, 0x00000344,
	0x00000356, 0x00000389, 0x000003b1, 0x000003b5,
	0x000003dc, 0x000003fb, 0x0000041e, 0x0000043b,
	0x0000045e, 0x00000483, 0x0000048c, 0x00000495,
	0x000004a2, 0x000004af, 0x000004bc, 0x000004c9,
	0x000004d6, 0x000004ee, 0x00000518, 0x00000535,
	0x00000553, 0x00000562, 0x00000573, 0x00000593,
	0x000005ac, 0x000005eb, 0x00000603, 0x00000624,
	// Entry 40 - 5F
	0x00000636, 0x00000664, 0x00000694, 0x000006e8,
	0x000006f0, 0x000006ff, 0x00000706, 0x0000070e,
	0x00000717, 0x00000721, 0x0000073b, 0x00000745,
	0x00000763, 0x00000796, 0x000007ba, 0x000007e1,
	0x000007f4, 0x000007f9, 0x00000805, 0x00000815,
	0x0000081c, 0x0000082e, 0x0000083c, 0x0000086c,
	0x00000873, 0x0000087b, 0x0000088c, 0x0000089c,
	0x000008b2, 0x000008e0, 0x00000908, 0x0000091e,
	// Entry 60 - 7F
	0x00000953, 0x0000097e, 0x0000099e, 0x000009d5,
	0x000009dc, 0x000009e8, 0x00000a1b, 0x00000a3e,
	0x00000a83, 0x00000a96, 0x00000aa9, 0x00000abf,
	0x00000ada, 0x00000ae0, 0x00000ae8, 0x00000b0b,
	0x00000b31, 0x00000b3e, 0x00000b4f, 0x00000b56,
	0x00000b60, 0x00000b7a, 0x00000b8a, 0x00000ba5,
	0x00000bc3, 0x00000bcc, 0x00000bee, 0x00000c11,
	0x00000c2f, 0x00000c55, 0x00000c90, 0x00000cc0,
	// Entry 80 - 9F
	0x00000cf4, 0x00000d23, 0x00000d34, 0x00000d6b,
	0x00000db3, 0x00000dd0, 0x00000e03, 0x00000e64,
	0x00000e7f, 0x00000eb4, 0x00000ee4, 0x00000f04,
	0x00000f36, 0x00000f55, 0x00000fbc, 0x00001007,
	0x0000101e, 0x00001047, 0x0000105d, 0x000010cf,
	0x000010ff, 0x00001131, 0x0000115e, 0x000011a1,
	0x000011c0, 0x000011ed, 0x00001215, 0x00001242,
	0x00001274, 0x0000129d, 0x000012c3, 0x000012c3,
	// Entry A0 - BF
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	// Entry C0 - DF
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	// Entry E0 - FF
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	// Entry 100 - 11F
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	0x000012c3, 0x000012c3, 0x000012c3, 0x000012c3,
	// Entry 120 - 13F
	0x000012c3,
} // Size: 1180 bytes

const itData string = "" + // Size: 4803 bytes
	"\x02Errore\x02(nessun argomento): eleva e installa il servizio di gestio" +
	"ne\x02Utilizzo: %[1]s [\x0a%[2]s]\x02Opzioni riga di comando\x02Impossib" +
	"ile determinare se il processo è in esecuzione in WOW64: %[1]v\x02Devi u" +
	"tilizzare la versione nativa di WireGuard su questo computer.\x02Impossi" +
	"bile aprire il token del processo corrente: %[1]v\x02WireGuard può esser" +
	"e utilizzato solo dagli utenti membri del gruppo %[1]s di sistema.\x02Wi" +
	"reGuard è in esecuzione, ma l'interfaccia utente è accessibile solo dai " +
	"desktop del gruppo %[1]s di sistema.\x02, \x02 \x02Chiudi\x02Stato:\x02&" +
	"Disattiva\x02&Attiva\x02Chiave pubblica:\x02Porta in ascolto:\x02MTU:" +
	"\x02Indirizzi:\x02Server DNS:\x02Chiave pre-condivisa:\x02IP consentiti:" +
	"\x02Endpoint:\x02Keepalive permanente:\x02Ultima negoziazione:\x02Inatti" +
	"vo\x02Disattivazione\x02Stato sconosciuto\x02Log\x02&Copia\x02Selezion&a" +
	" tutto\x02&Salva su file…\x02Tempo\x02Messaggio di log\x02Esporta log su" +
	" file\x02Errore del tunnel\x02%[1]s\x0a\x0aConsulta il log per ulteriori" +
	" Informazioni.\x02Errore durante la chiusura di WireGuard\x02Ora\x02L'or" +
	"ologio di sistema va all'indietro!\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d " +
	"anno\x00\x0b\x02%[1]d anni\x14\x01\x81\x01\x00\x02\x0d\x02%[1]d giorno" +
	"\x00\x0d\x02%[1]d giorni\x14\x01\x81\x01\x00\x02\x0a\x02%[1]d ora\x00" +
	"\x0a\x02%[1]d ore\x14\x01\x81\x01\x00\x02\x0d\x02%[1]d minuto\x00\x0d" +
	"\x02%[1]d minuti\x14\x01\x81\x01\x00\x02\x0e\x02%[1]d secondo\x00\x0e" +
	"\x02%[1]d secondi\x02%[1]s fa\x02%[1]d\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2" +
	"[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q" +
	"\x02Indirizzo IP non valido\x02Lunghezza del prefisso di rete non valida" +
	"\x02Manca la porta dall'endpoint\x02Host dell'endpoint non valido\x02MTU" +
	" non valido\x02Porta non valida\x02Keepalive permanente non valido\x02Ch" +
	"iave non valida: %[1]v\x02Il numero deve essere un numero compreso tra 0" +
	" e 2^64-1: %[1]v\x02Due virgole in una riga\x02Il nome del tunnel non è " +
	"valido\x02[non specificato]\x02Tutti i peer devono avere una chiave pubb" +
	"lica\x02Errore durante il recupero della configurazione\x02L'icona della" +
	" barra delle applicazioni di WireGuard non è apparsa dopo 30 secondi." +
	"\x02Script:\x02Trasferimento:\x02pre-up\x02post-up\x02pre-down\x02post-d" +
	"own\x02disattivato, per criterio\x02abilitato\x02%[1]s ricevuti, %[2]s i" +
	"nviati\x02Determinazione dello stato del tunnel non riuscita\x02Attivazi" +
	"one del tunnel non riuscita\x02Disattivazione del tunnel non riuscita" +
	"\x02Interfaccia: %[1]s\x02Peer\x02Crea tunnel\x02Modifica tunnel\x02&Nom" +
	"e:\x02Chiave &pubblica:\x02(sconosciuto)\x02&Blocca traffico fuori dal t" +
	"unnel (kill-switch)\x02&Salva\x02Annulla\x02&Configurazione:\x02Nome non" +
	" valido\x02Un nome è richiesto.\x02Il nome del tunnel ‘%[1]s’ non è vali" +
	"do.\x02Impossibile elencare i tunnel esistenti\x02Il tunnel esiste già" +
	"\x02Un altro tunnel con il nome ‘%[1]s’ esiste già.\x02Impossibile crear" +
	"e la nuova configurazione\x02Scrittura del file non riuscita\x02Il file " +
	"‘%[1]s’ esiste già.\x0a\x0aVuoi sovrascriverlo?\x02Attivo\x02Attivazio" +
	"ne\x02File di testo (*.txt)|*.txt|Tutti i file (*.*)|*.*\x02Errore di ri" +
	"levamento di WireGuard\x02Impossibile attendere la comparsa della finest" +
	"ra di WireGuard: %[1]v\x02Stato: sconosciuto\x02Indirizzi: nessuno\x02&G" +
	"estisci i tunnel…\x02&Importa tunnel da file…\x02E&sci\x02&Tunnel\x02Il " +
	"tunnel %[1]s è stato attivato.\x02Il tunnel %[1]s è stato disattivato." +
	"\x02Stato: %[1]s\x02Indirizzi: %[1]s\x02Tunnel\x02&Modifica\x02Aggiungi " +
	"tunn&el vuoto...\x02Aggiungi tunnel\x02Rimuovi tunnel selezionati\x02Esp" +
	"orta tutti i tunnel in zip\x02Commu&ta\x02Esporta tutti i tunnel in &zip" +
	"...\x02Modifica il tunnel &selezionato…\x02&Rimuovi i tunnel selezionati" +
	"\x02nessun file di configurazione trovato\x02Impossibile importare la co" +
	"nfigurazione selezionata: %[1]v\x02Impossibile enumerare i tunnel esiste" +
	"nti: %[1]v\x02Un altro tunnel esiste già con il nome ‘%[1]s‘\x02Impossib" +
	"ile importare la configurazione: %[1]v\x02Tunnel importati\x14\x01\x81" +
	"\x01\x00\x02\x17\x02%[1]d tunnel importato\x00\x17\x02%[1]d tunnel impor" +
	"tati\x14\x02\x80\x01\x02 \x02%[1]d de %[2]d tunnel importato\x00 \x02%[1" +
	"]d di %[2]d tunnel importati\x02Impossibile creare il tunnel\x14\x01\x81" +
	"\x01\x00\x02\x15\x02Elimina %[1]d tunnel\x00\x15\x02Elimina %[1]d tunnel" +
	"\x14\x01\x81\x01\x00\x02,\x02Sei sicuro di voler eliminare %[1]d tunnel?" +
	"\x00,\x02Sei sicuro di voler eliminare %[1]d tunnel?\x02Elimina tunnel ‘" +
	"%[1]s‘\x02Sei sicuro di voler eliminare il tunnel ‘%[1]s‘?\x02%[1]s Non " +
	"è possibile annullare questa azione.\x02Impossibile eliminare il tunnel" +
	"\x02Non è stato possibile rimuovere un tunnel: %[1]s\x02Impossibile elim" +
	"inare i tunnel\x14\x01\x81\x01\x00\x02/\x02Non è stato possibile elimina" +
	"re %[1]d tunnel.\x00/\x02Non è stato possibile eliminare %[1]d tunnel." +
	"\x02File di configurazione (*.zip, *.conf)|*.zip;*.conf|Tutti i file (*." +
	"*)|*.*\x02Importa tunnel da file\x02File di configurazione ZIP (*.zip)|*" +
	".zip\x02Esporta tunnel in zip\x02Impossibile uscire dal servizio a causa" +
	" di: %[1]v. Potresti voler interrompere WireGuard dal gestore dei serviz" +
	"i.\x02Le parentesi devono contenere un indirizzo IPv6\x02Le chiavi devon" +
	"o decodificare esattamente 32 byte\x02Una riga deve essere presente in u" +
	"na sezione\x02Manca un separatore di uguaglianza per la chiave di config" +
	"urazione\x02La chiave deve avere un valore\x02Chiave non valida per la s" +
	"ezione [Interface]\x02Chiave non valida per la sezione [Peer]\x02Un'inte" +
	"rfaccia deve avere una chiave privata\x02Chiave non valida per la sezion" +
	"e dell'interfaccia\x02La versione del protocollo deve essere 1\x02Chiave" +
	" non valida per la sezione peer"

var jaIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x0000000a, 0x0000005b, 0x00000075,
	0x0000009a, 0x000000e6, 0x00000140, 0x0000017e,
	0x000001d5, 0x00000258, 0x0000025b, 0x0000025d,
	0x00000267, 0x0000026f, 0x0000027d, 0x0000028b,
	0x00000296, 0x000002ad, 0x000002b2, 0x000002c0,
	0x000002cf, 0x000002e0, 0x000002ed, 0x00000304,
	0x00000324, 0x00000344, 0x0000034b, 0x00000358,
	0x00000368, 0x0000036f, 0x0000037d, 0x00000391,
	// Entry 20 - 3F
	0x000003ae, 0x000003b5, 0x000003cc, 0x000003f7,
	0x0000040d, 0x00000442, 0x0000045c, 0x00000460,
	0x00000488, 0x00000499, 0x000004aa, 0x000004be,
	0x000004cf, 0x000004e0, 0x000004ea, 0x000004f2,
	0x000004ff, 0x0000050c, 0x00000519, 0x00000526,
	0x00000533, 0x0000054d, 0x00000581, 0x000005af,
	0x000005d7, 0x000005e5, 0x000005fe, 0x00000629,
	0x0000063d, 0x00000690, 0x000006b4, 0x000006d3,
	// Entry 40 - 5F
	0x000006e2, 0x00000713, 0x00000747, 0x0000079c,
	0x000007ad, 0x000007b5, 0x000007bc, 0x000007c4,
	0x000007cd, 0x000007d7, 0x000007f9, 0x00000800,
	0x00000828, 0x00000859, 0x00000887, 0x000008b5,
	0x000008d5, 0x000008dc, 0x000008f8, 0x0000090e,
	0x0000091a, 0x00000929, 0x00000932, 0x0000098b,
	0x00000996, 0x000009a6, 0x000009b2, 0x000009c2,
	0x000009db, 0x00000a0a, 0x00000a38, 0x00000a60,
	// Entry 60 - 7F
	0x00000aaf, 0x00000ae0, 0x00000b05, 0x00000b57,
	0x00000b5e, 0x00000b6b, 0x00000bb5, 0x00000bcf,
	0x00000c11, 0x00000c20, 0x00000c35, 0x00000c52,
	0x00000c8a, 0x00000c95, 0x00000ca4, 0x00000cd6,
	0x00000d08, 0x00000d16, 0x00000d2a, 0x00000d37,
	0x00000d42, 0x00000d65, 0x00000d7b, 0x00000d9d,
	0x00000dd1, 0x00000de2, 0x00000e1d, 0x00000e46,
	0x00000e6c, 0x00000e97, 0x00000ee4, 0x00000f22,
	// Entry 80 - 9F
	0x00000f6e, 0x00000fa6, 0x00000fcb, 0x00001003,
	0x00001047, 0x0000106c, 0x0000108f, 0x000010cb,
	0x000010ee, 0x00001129, 0x0000115a, 0x0000117f,
	0x000011b4, 0x000011d9, 0x00001214, 0x00001267,
	0x00001298, 0x000012c2, 0x000012ea, 0x0000136e,
	0x0000139f, 0x000013d1, 0x000013fc, 0x00001433,
	0x00001464, 0x00001499, 0x000014c9, 0x00001500,
	0x00001533, 0x00001576, 0x000015a4, 0x000015a4,
	// Entry A0 - BF
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	// Entry C0 - DF
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	// Entry E0 - FF
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	// Entry 100 - 11F
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	0x000015a4, 0x000015a4, 0x000015a4, 0x000015a4,
	// Entry 120 - 13F
	0x000015a4,
} // Size: 1180 bytes

const jaData string = "" + // Size: 5540 bytes
	"\x02エラー\x02(引数なし): 管理者権限でmanagerサービスをインストールする\x02使い方: %[1]s [\x0a%[2]s]" +
	"\x02コマンドラインオプション\x02プロセスがWOW64下で動作しているか確認できません: %[1]v\x02このコンピュータではネイティブ" +
	"版の WireGuard を使ってください。\x02現在のプロセスのトークンを開けません: %[1]v\x02WireGuard は組み込み" +
	"の %[1]s グループのメンバーだけが使えます。\x02WireGuard は実行中ですが、UI画面は組み込みの %[1]s グループのデ" +
	"スクトップからしか開けません。\x02, \x02 \x02閉じる\x02状態:\x02無効化(&D)\x02有効化(&A)\x02公開鍵:" +
	"\x02待受ポート番号:\x02MTU:\x02アドレス:\x02DNS サーバ:\x02事前共有鍵:\x02Allowed IPs:\x02エ" +
	"ンドポイント:\x02持続的キープアライブ:\x02直近のハンドシェイク:\x02無効\x02無効化中\x02不明な状態\x02ログ\x02" +
	"コピー(&C)\x02すべて選択(&A)\x02ファイルに保存…(&S)\x02時刻\x02ログ メッセージ\x02ログをファイルにエクスポ" +
	"ート\x02トンネルエラー\x02%[1]s\x0a\x0a詳細はログを参照してください。\x02WireGuard 終了エラー\x02今" +
	"\x02システム時刻が巻き戻った！\x14\x01\x81\x01\x00\x00\x0a\x02%[1]d 年\x14\x01\x81\x01" +
	"\x00\x00\x0a\x02%[1]d 日\x14\x01\x81\x01\x00\x00\x0d\x02%[1]d 時間\x14\x01" +
	"\x81\x01\x00\x00\x0a\x02%[1]d 分\x14\x01\x81\x01\x00\x00\x0a\x02%[1]d 秒" +
	"\x02%[1]s 前\x02%[1]d B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]" +
	"f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02無効な IP アドレス\x02無効なネットワ" +
	"ークプレフィックス長\x02エンドポイントのポート指定なし\x02無効なエンドポイントホスト\x02無効な MTU\x02無効なポート番号" +
	"\x02無効な持続的キープアライブ値\x02不正な鍵: %[1]v\x02数値は0から2の64乗-1の範囲内の値でなければなりません: %[1]" +
	"v\x021行にカンマが2つあります\x02トンネル名が不正です\x02[指定なし]\x02すべてのピアには公開鍵が必須です\x02設定の読込中" +
	"にエラーが発生しました\x02WireGuard システムトレイアイコンは30秒後に非表示になります。\x02スクリプト:\x02転送:" +
	"\x02pre-up\x02post-up\x02pre-down\x02post-down\x02ポリシーにより無効です\x02有効\x02%" +
	"[1]s 受信済み、%[2]s 送信済み\x02トンネルの状態取得に失敗しました\x02トンネルの有効化に失敗しました\x02トンネルの無効化に" +
	"失敗しました\x02インターフェース: %[1]s\x02ピア\x02トンネルの新規作成\x02トンネルの編集\x02名前(&N):\x02" +
	"公開鍵(&P):\x02(不明)\x02トンネルを通らないトラフィックのブロック（キルスイッチ）(&B)\x02保存(&S)\x02キャンセ" +
	"ル\x02設定(&C):\x02無効な名前\x02名前は必須です。\x02トンネル名 ‘%[1]s’ は不正です。\x02既存のトンネルを表" +
	"示できません\x02トンネルはすでに存在します\x02‘%[1]s’ という名前の別のトンネルがすでに存在します。\x02新しい設定を作成で" +
	"きませんでした\x02ファイルの書き込みに失敗\x02ファイル ‘%[1]s’ はすでに存在します。\x0a\x0a上書きしますか？\x02" +
	"有効\x02有効化中\x02テキストファイル (*.txt)|*.txt|すべてのファイル (*.*)|*.*\x02WireGuard 検" +
	"出エラー\x02WireGuard ウィンドウが表示できませんでした: %[1]v\x02状態: 不明\x02アドレス: なし\x02トンネ" +
	"ルの管理…(&M)\x02トンネルをファイルからインポート…(&I)\x02終了(&X)\x02& トンネル\x02トンネル %[1]s は" +
	"有効になりました。\x02トンネル %[1]s は無効になりました。\x02状態: %[1]s\x02アドレス: %[1]s\x02トンネル" +
	"\x02編集(&E)\x02空のトンネルを追加…(&E)\x02トンネルの追加\x02選択したトンネルの削除\x02すべてのトンネルをzipにエ" +
	"クスポート\x02切り替え(&T)\x02すべてのトンネルをzipにエクスポート…(&Z)\x02選択したトンネルの編集…(&S)\x02選" +
	"択したトンネルの削除(&R)\x02設定ファイルが見つかりません\x02選択したファイルからインポートできませんでした: %[1]v\x02" +
	"既存のトンネルを表示できませんでした: %[1]v\x02‘%[1]s’ という名前の別のトンネルがすでに存在します\x02設定をインポート" +
	"できませんでした: %[1]v\x02トンネルのインポート結果\x14\x01\x81\x01\x00\x001\x02%[1]d トンネル" +
	"をインポートしました\x14\x02\x80\x01\x00>\x02%[2]d 中の %[1]d トンネルをインポートしました\x02トン" +
	"ネルを作成できません\x14\x01\x81\x01\x00\x00\x1c\x02%[1]d トンネルを削除\x14\x01\x81" +
	"\x01\x00\x005\x02本当に %[1]d トンネルを削除しますか？\x02トンネル ‘%[1]s’ を削除\x02本当にトンネル ‘" +
	"%[1]s’ を削除しますか？\x02%[1]s この操作はもとに戻せません。\x02トンネルを削除できません\x02トンネルを削除できませんで" +
	"した: %[1]s\x02トンネルを削除できません\x14\x01\x81\x01\x00\x004\x02%[1]d トンネルを削除できま" +
	"せんでした\x02設定ファイル (*.zip, *.conf)|*.zip;*.conf|すべてのファイル (*.*)|*.*\x02ファイ" +
	"ルからトンネルをインポート\x02ZIP形式設定ファイル (*.zip)|*.zip\x02トンネルをZIPにエクスポート\x02%[1]v" +
	" のためサービスを終了できませんでした。サービスマネージャから WireGuard を停止できます。\x02カッコ内は IPv6 アドレスが入り" +
	"ます\x02鍵は 32 バイトでなければなりません\x02行がセクション内にありません\x02設定項目にイコール(=)セパレータがない" +
	"\x02キー項目に対応する値がありません\x02無効な [Interface] セクションのキー項目\x02無効な [Peer] セクションのキ" +
	"ー項目\x02インターフェースには秘密鍵が必須です\x02無効な Interface セクションのキー項目\x02プロトコルバージョンは 1" +
	" でなければなりません\x02無効な Peer セクションのキー項目"

var koIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry 20 - 3F
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry 40 - 5F
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry 60 - 7F
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry 80 - 9F
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry A0 - BF
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry C0 - DF
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry E0 - FF
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry 100 - 11F
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry 120 - 13F
	0x00000007,
} // Size: 1180 bytes

const koData string = "\x02오류"

var pa_INIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000010, 0x00000010, 0x00000030,
	0x0000005d, 0x000000ea, 0x0000017f, 0x000001e6,
	0x000002b4, 0x0000039c, 0x0000039f, 0x000003a2,
	0x000003b6, 0x000003c7, 0x000003ec, 0x0000040a,
	0x0000042b, 0x00000453, 0x00000458, 0x0000046f,
	0x00000481, 0x00000481, 0x000004a2, 0x000004c0,
	0x000004c0, 0x000004c0, 0x000004d7, 0x00000516,
	0x0000053c, 0x00000549, 0x00000564, 0x00000582,
	// Entry 20 - 3F
	0x000005b9, 0x000005c6, 0x000005e3, 0x00000624,
	0x0000063b, 0x0000066f, 0x000006b1, 0x000006bb,
	0x000006fd, 0x00000726, 0x0000074f, 0x0000077e,
	0x000007ad, 0x000007e2, 0x000007fb, 0x00000804,
	0x00000811, 0x0000081e, 0x0000082b, 0x00000838,
	0x00000845, 0x0000086e, 0x000008ae, 0x000008f5,
	0x000008f5, 0x00000913, 0x0000093a, 0x00000969,
	0x0000099a, 0x00000a02, 0x00000a41, 0x00000a7a,
	// Entry 40 - 5F
	0x00000a7a, 0x00000a7a, 0x00000a7a, 0x00000b0b,
	0x00000b28, 0x00000b3f, 0x00000b3f, 0x00000b3f,
	0x00000b3f, 0x00000b3f, 0x00000b3f, 0x00000b56,
	0x00000b7d, 0x00000bc8, 0x00000c0a, 0x00000c53,
	0x00000c70, 0x00000c7d, 0x00000ca1, 0x00000cc2,
	0x00000cd1, 0x00000cf6, 0x00000d0e, 0x00000d85,
	0x00000d9c, 0x00000db0, 0x00000dc8, 0x00000ddf,
	0x00000e06, 0x00000e06, 0x00000e06, 0x00000e41,
	// Entry 60 - 7F
	0x00000e9f, 0x00000ef0, 0x00000f2e, 0x00000fd8,
	0x00000fe8, 0x00001020, 0x00001084, 0x000010a8,
	0x000010a8, 0x000010cf, 0x00001100, 0x0000113b,
	0x00001186, 0x00001197, 0x000011a5, 0x000011e3,
	0x00001228, 0x0000123f, 0x0000125f, 0x0000126f,
	0x00001280, 0x000012ab, 0x000012c2, 0x000012fc,
	0x0000135d, 0x0000136e, 0x000013d2, 0x000013fd,
	0x0000143b, 0x0000148e, 0x0000148e, 0x0000148e,
	// Entry 80 - 9F
	0x000014f3, 0x00001544, 0x0000157a, 0x000015ef,
	0x000015ef, 0x00001623, 0x0000166c, 0x0000173f,
	0x0000176c, 0x000017d4, 0x0000183c, 0x00001870,
	0x000018b2, 0x000018ec, 0x000018ec, 0x00001965,
	0x000019a9, 0x000019ea, 0x000019ea, 0x00001abe,
	0x00001abe, 0x00001b38, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	// Entry A0 - BF
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	// Entry C0 - DF
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	// Entry E0 - FF
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	// Entry 100 - 11F
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	0x00001b83, 0x00001b83, 0x00001b83, 0x00001b83,
	// Entry 120 - 13F
	0x00001b83,
} // Size: 1180 bytes

const pa_INData string = "" + // Size: 7043 bytes
	"\x02ਗ਼ਲਤੀ\x02ਵਰਤੋਂ: %[1]s [\x0a%[2]s]\x02ਕਮਾਂਡ ਲਾਈਨ ਚੋਣਾਂ\x02ਪਤਾ ਲਗਾਉਣ ਲ" +
	"ਈ ਅਸਮਰੱਥ ਹੈ ਕਿ ਪਰੋਸੈਸ WOW64 ਅਧੀਨ ਚੱਲ ਰਿਹਾ ਹੈ: %[1]v\x02ਤੁਹਾਨੂੰ ਇਸ ਕੰਪਿ" +
	"ਊਟਰ ਉੱਤੇ WireGuard ਦਾ ਮੂਲ ਵਰਜ਼ਨ ਵਰਤਣਾ ਚਾਹੀਦਾ ਹੈ।\x02ਮੌਜੂਦਾ ਪਰੋਸੈਸ ਟੋਕਨ " +
	"ਖੋਲ੍ਹਣ ਲਈ ਅਸਮਰੱਥ: %[1]v\x02WireGuard ਨੂੰ ਸਿਰਫ਼ ਉਹੀ ਵਰਤੋਂਕਾਰ ਵਰਤ ਸਕਦੇ ਹ" +
	"ਨ, ਜੋ ਕਿ ਪਹਿਲਾਂ ਮੌਜੂਦ %[1]s ਗਰੁੱਪ ਦੇ ਮੈਂਬਰ ਹਨ।\x02WireGuard ਚੱਲ ਰਿਹਾ ਹ" +
	"ੈ, ਪਰ UI ਨੂੰ ਸਿਰਫ਼ ਪਹਿਲਾਂ ਮੌਜੂਦ %[1]s ਗਰੁੱਪ ਦੇ ਡੈਸਕਟਾਪ ਰਾਹੀਂ ਹੀ ਵਰਤਿਆ " +
	"ਜਾ ਸਕਦਾ ਹੈ।\x02, \x02, \x02ਬੰਦ ਕਰੋ\x02ਸਥਿਤੀ:\x02ਨਾ-ਸਰਗਰਮ ਕਰੋ(&D)\x02ਸਰ" +
	"ਗਰਮ ਕਰੋ(&A)\x02ਪਬਲਿਕ ਕੁੰਜੀ:\x02ਸੁਣਨ ਵਾਲੀ ਪੋਰਟ:\x02MTU:\x02ਸਿਰਨਾਵੇ:\x02" +
	"DNS ਸਰਵਰ:\x02ਮਨਜ਼ੂਰ ਕੀਤੇ IP:\x02ਐਂਡ-ਪੁਆਇੰਟ:\x02ਨਾ-ਸਰਗਰਮ\x02ਨਾ-ਸਰਗਰਮ ਕੀਤਾ " +
	"ਜਾ ਰਿਹਾ ਹੈ\x02ਅਣਪਛਾਤੀ ਸਥਿਤੀ\x02ਲਾਗੂ\x02ਕਾਪੀ ਕਰੋ(&C)\x02ਸਾਰੇ ਚੁਣੋ(&a)" +
	"\x02ਫ਼ਾਇਲ ਵਿੱਚ ਸੰਭਾਲੋ(&S)…\x02ਸਮਾਂ\x02ਲਾਗ ਸੁਨੇਹਾ\x02ਲਾਗ ਫ਼ਾਇਲ ਵਿੱਚ ਬਰਾਮਦ" +
	" ਕਰੋ\x02ਟਨਲ ਗਲਤੀ\x02%[1]s\x0a\x0aPlease consult the log for more informa" +
	"tion.\x02WireGuard ਤੋਂ ਬਾਹਰ ਜਾਣ ਲਈ ਗ਼ਲਤੀ\x02ਹੁਣ\x02ਸਿਸਟਮ ਘੜੀ ਪੁ਼ੱਠੀ ਮੋੜੀ" +
	" ਗਈ!\x14\x01\x81\x01\x00\x02\x10\x02%[1]d ਸਾਲ\x00\x10\x02%[1]d ਸਾਲ\x14" +
	"\x01\x81\x01\x00\x02\x10\x02%[1]d ਦਿਨ\x00\x10\x02%[1]d ਦਿਨ\x14\x01\x81" +
	"\x01\x00\x02\x13\x02%[1]d ਘੰਟਾ\x00\x13\x02%[1]d ਘੰਟੇ\x14\x01\x81\x01\x00" +
	"\x02\x13\x02%[1]d ਮਿੰਟ\x00\x13\x02%[1]d ਮਿੰਟ\x14\x01\x81\x01\x00\x02\x16" +
	"\x02%[1]d ਸਕਿੰਟ\x00\x16\x02%[1]d ਸਕਿੰਟ\x02%[1]s ਪਹਿਲਾਂ\x02%[1]d\u00a0B" +
	"\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f" +
	"\u00a0TiB\x02%[1]s: %[2]q\x02ਅਵੈਧ IP ਸਿਰਨਾਵਾਂ\x02ਗਲਤ ਨੈੱਟਵਰਕ ਅਗੇਤਰ ਲੰਬਾਈ" +
	"\x02ਐਂਡਪੁਆਇੰਟ ਤੋਂ ਪੋਰਟ ਗੁੰਮ ਹੈ\x02ਗ਼ੈਰ-ਵਾਜਬ MTU\x02ਗ਼ੈਰ-ਵਾਜਬ ਪੋਰਟ\x02ਗ਼ੈ" +
	"ਰ-ਵਾਜਬ persistent keepalive\x02ਗ਼ੈਰ-ਵਾਜਬ ਕੁੰਜੀ: %[1]v\x02ਨੰਬਰ 0 ਅਤੇ 2^" +
	"64-1 ਦੇ ਵਿਚਾਲੇ ਹੋਣਾ ਚਾਹੀਦਾ ਹੈ: %[1]v\x02ਇੱਕ ਕਤਾਰ ਵਿੱਚ ਦੋ ਕੌਮੇ ਹਨ\x02ਟਨਲ " +
	"ਦਾ ਨਾਂ ਠੀਕ ਨਹੀਂ ਹੈ\x02WireGuard ਸਿਸਟਮ ਟਰੇ ਆਈਕਾਨ 30 ਸਕਿੰਟਾਂ ਬਾਅਦ ਦਿਖਾਈ " +
	"ਨਹੀਂ ਦਿੱਤਾ ਹੈ।\x02ਸਕ੍ਰਿਪਟਾਂ:\x02ਟਰਾਂਸਫਰ:\x02ਸਮਰੱਥ ਹੈ\x02%[1]s ਮਿਲੇ, %[" +
	"2]s ਭੇਜੇ\x02ਟਨਲ ਸਥਿਤੀ ਪਤਾ ਲਗਾਉਣ ਲਈ ਅਸਫ਼ਲ\x02ਟਨਲ ਸਰਗਰਮ ਕਰਨ ਲਈ ਅਸਫ਼ਲ ਹੈ" +
	"\x02ਟਨਲ ਨਾ-ਸਰਗਰਮ ਕਰਨ ਲਈ ਅਸਫ਼ਲ ਹੈ\x02ਇੰਟਰਫੇਸ: %[1]s\x02ਪੀਅਰ\x02ਨਵੀਂ ਟਨਲ ਬ" +
	"ਣਾਓ\x02ਟਨਲ ਨੂੰ ਸੋਧੋ\x02ਨਾਂ(&N):\x02ਪਬਲਿਕ ਕੁੰਜੀ(&P):\x02(ਅਣਪਛਾਤਾ)\x02ਬਿ" +
	"ਨਾਂ-ਟਨਲ ਵਾਲੇ ਟਰੈਫਿਕ ਉੱਤੇ ਪਾਬੰਦੀ ਲਾਓ (&B) (kill-switch)\x02ਸੰਭਾਲੋ(&S)" +
	"\x02ਰੱਦ ਕਰੋ\x02ਸੰਰਚਨਾ(&C):\x02ਅਯੋਗ ਨਾਂ\x02ਨਾਂ ਚਾਹੀਦਾ ਹੈ।\x02ਟਨਲ ਪਹਿਲਾਂ ਹ" +
	"ੀ ਮੌਜੂਦ ਹੈ\x02ਨਾਂ ‘%[1]s’ ਨਾਲ ਟਨਲ ਪਹਿਲਾਂ ਹੀ ਮੌਜੂਦ ਹੈ।\x02ਨਵੀਂ ਸੰਰਚਨਾ ਬ" +
	"ਣਾਉਣ ਲਈ ਅਸਮਰੱਥ ਹੈ\x02ਫ਼ਾਇਲ ਬਣਾਉਣ ਲਈ ਅਸਫ਼ਲ ਹੈ\x02‘%[1]s’ ਫ਼ਾਇਲ ਪਹਿਲਾਂ ਹ" +
	"ੀ ਮੌਜੂਦ ਹੈ।\x0a\x0aਕੀ ਤੁਸੀਂ ਇਸ ਉੱਤੇ ਲਿਖਣਾ ਚਾਹੁੰਦੇ ਹੋ?\x02ਸਰਗਰਮ\x02ਸਰਗਰ" +
	"ਮ ਕੀਤਾ ਜਾ ਰਿਹਾ ਹੈ\x02ਲਿਖਤ ਫ਼ਾਇਲਾਂ (*.txt)|*.txt|ਸਾਰੀਆਂ ਫ਼ਾਇਲਾਂ (*.*)|*" +
	".*\x02WireGuard ਖੋਜ ਗ਼ਲਤੀ\x02ਸਥਿਤੀ: ਅਣਪਛਾਤੀ\x02ਸਿਰਨਾਵੇਂ: ਕੋਈ ਨਹੀਂ\x02ਟਨਲ" +
	"ਾਂ ਦਾ ਇੰਤਜ਼ਾਮ ਕਰੋ(&M)…\x02ਫ਼ਾਇਲ ਤੋਂ ਟਨਲਾਂ ਦਰਾਮਦ ਕਰੋ(&I)…\x02ਬਾਹਰ(&x)" +
	"\x02ਟਨਲ(&T)\x02%[1]s ਟਨਲ ਸਰਗਰਮ ਕੀਤੀ ਗਈ ਹੈ।\x02%[1]s ਟਨਲ ਨਾ-ਸਰਗਰਮ ਕੀਤੀ ਗਈ" +
	" ਹੈ।\x02ਸਥਿਤੀ: %[1]s\x02ਸਿਰਨਾਵੇਂ: %[1]s\x02ਟਨਲਾਂ\x02ਸੋਧੋ(&E)\x02…ਖਾਲੀ ਟਨ" +
	"ਲ ਜੋੜੋ(&e)\x02ਟਨਲ ਜੋੜੋ\x02ਚੁਣੀਆਂ ਟਨਲਾਂ ਨੂੰ ਹਟਾਓ\x02ਸਾਰੀਆਂ ਟਨਲਾਂ ਨੂੰ ਜ਼ਿ" +
	"ੱਪ ਵਜੋਂ ਬਰਾਮਦ ਕਰੋ\x02ਪਲਟੋ(&T)\x02ਸਾਰੀਆਂ ਟਨਲਾਂ ਨੂੰ ਜ਼ਿੱਪ ਵਜੋਂ ਬਰਾਮਦ ਕਰੋ…" +
	"\x02ਚੁਣੀ ਟਨਲ ਸੋਧੋ(&s)…\x02ਚੁਣੀਆਂ ਟਨਲਾਂ ਨੂੰ ਹਟਾਓ(&R)\x02ਕੋਈ ਸੰਰਚਨਾ ਫ਼ਾਇਲਾ" +
	"ਂ ਨਹੀਂ ਲੱਭੀਆਂ\x02‘%[1]s’ ਨਾਂ ਨਾਲ ਹੋਰ ਟਨਲ ਪਹਿਲਾਂ ਹੀ ਮੌਜੂਦ ਹੈ\x02ਸੰਰਚਨਾ " +
	"ਇੰਪੋਰਟ ਕਰਨ ਲਈ ਅਸਮਰੱਥ: %[1]v\x02ਇੰਪੋਰਟ ਕੀਤੀਆਂ ਟਨਲਾਂ\x14\x01\x81\x01\x00" +
	"\x020\x02%[1]d ਟਨਲ ਇੰਪੋਰਟ ਕੀਤੀ\x00<\x02%[1]d ਟਨਲਾਂ ਇੰਪੋਰਟ ਕੀਤੀਆਂ\x02ਟਨਲ " +
	"ਬਣਾਉਣ ਲਈ ਅਸਮਰੱਥ\x14\x01\x81\x01\x00\x02\x1d\x02%[1]d ਟਨਲ ਹਟਾਓ\x00#\x02" +
	"%[1]d ਟਨਲਾਂ ਹਟਾਓ\x14\x01\x81\x01\x00\x02b\x02ਕੀ ਤੁਸੀਂ %[1]d ਟਨਲ ਨੂੰ ਹਟਾਉ" +
	"ਣਾ ਚਾਹੁੰਦੇ ਹੋ?\x00h\x02ਕੀ ਤੁਸੀਂ %[1]d ਟਨਲਾਂ ਨੂੰ ਹਟਾਉਣਾ ਚਾਹੁੰਦੇ ਹੋ?\x02" +
	"‘%[1]s’ ਟਨਲ ਨੂੰ ਹਟਾਓ\x02ਕੀ ਤੁਸੀਂ ‘%[1]s‘ ਟਨਲ ਨੂੰ ਹਟਾਉਣਾ ਚਾਹੁੰਦੇ ਹੋ?" +
	"\x02%[1]s ਤੁਸੀਂ ਇਹ ਕਾਰਵਾਈ ਵਾਪਸ ਨਹੀਂ ਲੈ ਸਕਦੇ ਹੋ।\x02ਟਨਲ ਹਟਾਉਣ ਲਈ ਅਸਮਰੱਥ" +
	"\x02ਟਨਲ ਹਟਾਉਣ ਲਈ ਅਸਮਰੱਥ ਹੈ: %[1]s\x02ਟਨਲਾਂ ਹਟਾਉਣ ਲਈ ਅਸਮਰੱਥ\x02ਸੰਰਚਨਾ ਫ਼ਾ" +
	"ਇਲਾਂ (*.zip, *.conf)|*.zip;*.conf|ਸਾਰੀਆਂ ਫ਼ਾਇਲਾਂ (*.*)|*.*\x02ਫ਼ਾਇਲ ਤੋ" +
	"ਂ ਟਨਲਾਂ ਦਰਾਮਦ ਕਰੋ\x02ਸੰਰਚਨਾ ਜ਼ਿੱਪ ਫਾਇਲਾਂ (*.zip)|*.zip\x02ਸੇਵਾ ਤੋਂ ਬਾਹਰ" +
	" ਜਾਣ ਲਈ ਅਸਮਰੱਥ, ਕਾਰਨ: %[1]v। ਤੁਸੀਂ ਸੇਵਾ ਮੈਨੇਜਰ ਤੋਂ WireGuard ਨੂੰ ਰੋਕਣਾ ਚ" +
	"ਾਹੋਗੇ।\x02ਕੁੰਜੀਆਂ ਠੀਕ 32 ਬਾਈਟ ਲਈ ਡੀਕੋਡ ਹੋਣੀਆਂ ਚਾਹੀਦੀਆਂ ਹਨ\x02ਭਾਗ ਵਿੱਚ " +
	"ਲਾਈਨ ਹੋਣੀ ਚਾਹੀਦੀ ਹੈ"

var plIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x0000004f, 0x00000067,
	0x0000007e, 0x000000cc, 0x00000108, 0x0000013f,
	0x000001a8, 0x00000228, 0x0000022b, 0x0000022e,
	0x00000236, 0x0000023e, 0x0000024a, 0x00000253,
	0x00000264, 0x00000274, 0x00000279, 0x00000281,
	0x0000028e, 0x00000293, 0x000002a8, 0x000002be,
	0x000002d7, 0x000002fb, 0x00000306, 0x00000315,
	0x00000323, 0x0000032c, 0x00000334, 0x00000346,
	// Entry 20 - 3F
	0x0000035a, 0x0000035f, 0x00000375, 0x00000391,
	0x0000039f, 0x000003df, 0x00000402, 0x00000408,
	0x0000042b, 0x00000461, 0x00000499, 0x000004dc,
	0x0000051b, 0x0000055e, 0x00000569, 0x00000572,
	0x0000057f, 0x0000058c, 0x00000599, 0x000005a6,
	0x000005b3, 0x000005cb, 0x000005f4, 0x00000616,
	0x00000641, 0x00000654, 0x00000668, 0x00000698,
	0x000006b4, 0x000006ee, 0x00000705, 0x00000726,
	// Entry 40 - 5F
	0x00000737, 0x00000768, 0x0000078f, 0x000007da,
	0x000007e3, 0x000007ed, 0x00000800, 0x0000080f,
	0x00000823, 0x00000833, 0x00000854, 0x0000085f,
	0x0000087e, 0x000008a6, 0x000008c8, 0x000008e8,
	0x000008f9, 0x000008fe, 0x00000911, 0x0000091e,
	0x00000926, 0x00000938, 0x00000943, 0x00000979,
	0x00000981, 0x00000988, 0x00000997, 0x000009ac,
	0x000009c1, 0x000009ec, 0x00000a18, 0x00000a2c,
	// Entry 60 - 7F
	0x00000a65, 0x00000a8d, 0x00000aac, 0x00000ae5,
	0x00000aed, 0x00000af9, 0x00000b30, 0x00000b4a,
	0x00000b88, 0x00000b99, 0x00000ba6, 0x00000bbe,
	0x00000be2, 0x00000bec, 0x00000bf4, 0x00000c14,
	0x00000c37, 0x00000c45, 0x00000c53, 0x00000c5a,
	0x00000c62, 0x00000c78, 0x00000c84, 0x00000ca1,
	0x00000ccc, 0x00000cd8, 0x00000d07, 0x00000d20,
	0x00000d3e, 0x00000d5c, 0x00000d92, 0x00000dc2,
	// Entry 80 - 9F
	0x00000dfa, 0x00000e27, 0x00000e3c, 0x00000eb4,
	0x00000f4b, 0x00000f67, 0x00000fbf, 0x00001077,
	0x0000108f, 0x000010bf, 0x000010e4, 0x000010ff,
	0x00001129, 0x00001144, 0x000011ef, 0x00001239,
	0x00001259, 0x0000127e, 0x0000129f, 0x00001329,
	0x0000134d, 0x00001388, 0x000013a9, 0x000013e5,
	0x00001400, 0x0000142c, 0x00001453, 0x00001477,
	0x000014a1, 0x000014bf, 0x000014e4, 0x000014e4,
	// Entry A0 - BF
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	// Entry C0 - DF
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	// Entry E0 - FF
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	// Entry 100 - 11F
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	0x000014e4, 0x000014e4, 0x000014e4, 0x000014e4,
	// Entry 120 - 13F
	0x000014e4,
} // Size: 1180 bytes

const plData string = "" + // Size: 5348 bytes
	"\x02Błąd\x02(brak argumentu): Podnieś uprawnienia i zainstaluj usługę me" +
	"nedżera\x02Użycie: %[1]s [\x0a%[2]s]\x02Opcje wiersza poleceń\x02Nie moż" +
	"na określić, czy proces jest uruchomiony w środowisku WOW64: %[1]v\x02Na" +
	"leży użyć natywnej wersji WireGuard na tym komputerze.\x02Nie można otwo" +
	"rzyć bieżącego tokenu procesu: %[1]v\x02WireGuard może być używany tylko" +
	" przez użytkowników, którzy są członkami wbudowanej grupy %[1]s.\x02Wire" +
	"Guard jest uruchomiony, ale interfejs jest dostępny tylko z poziomu użyt" +
	"kowników należących do wbudowanej grupy %[1]s.\x02, \x02, \x02Zamknij" +
	"\x02Status:\x02&Dezaktywuj\x02&Aktywuj\x02Klucz publiczny:\x02Port nasłu" +
	"chu:\x02MTU:\x02Adresy:\x02Serwery DNS:\x02PSK:\x02Dozwolone adresy IP:" +
	"\x02Urządzenie końcowe:\x02Utrzymanie połączenia:\x02Ostatni uścisk dłon" +
	"i (handshake):\x02Nieaktywny\x02Dezaktywowanie\x02Stan nieznany\x02Dzien" +
	"nik\x02&Kopiuj\x02Wybierz &wszystko\x02&Zapisz do pliku…\x02Czas\x02Wiad" +
	"omości dziennika\x02Eksportuj dziennik do pliku\x02Błąd tunelu\x02%[1]s" +
	"\x0a\x0aAby uzyskać więcej informacji, zapoznaj się z logiem.\x02Błąd po" +
	"dczas zamykania WireGuard\x02Teraz\x02Zegar systemowy został cofnięty!" +
	"\x14\x01\x81\x01\x00\x04\x0b\x02%[1]d lata\x05\x0a\x02%[1]d lat\x02\x0a" +
	"\x02%[1]d rok\x00\x0a\x02%[1]d lat\x14\x01\x81\x01\x00\x04\x0a\x02%[1]d " +
	"dni\x05\x0a\x02%[1]d dni\x02\x0d\x02%[1]d dzień\x00\x0a\x02%[1]d dni\x14" +
	"\x01\x81\x01\x00\x04\x0e\x02%[1]d godziny\x05\x0d\x02%[1]d godzin\x02" +
	"\x0e\x02%[1]d godzina\x00\x0d\x02%[1]d godzin\x14\x01\x81\x01\x00\x04" +
	"\x0d\x02%[1]d minuty\x05\x0c\x02%[1]d minut\x02\x0d\x02%[1]d minuta\x00" +
	"\x0c\x02%[1]d minut\x14\x01\x81\x01\x00\x04\x0e\x02%[1]d sekundy\x05\x0d" +
	"\x02%[1]d sekund\x02\x0e\x02%[1]d sekunda\x00\x0d\x02%[1]d sekund\x02%[1" +
	"]s temu\x02%[1]d\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1" +
	"]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Nieprawidłowy adres I" +
	"P\x02Nieprawidłowa długość prefiksu sieci\x02Brak portu urządzenia końco" +
	"wego\x02Nieprawidłowy host (urządzenie końcowe)\x02Nieprawidłowe MTU\x02" +
	"Nieprawidłowy port\x02Nieprawidłowy parametr utrzymania połączenia\x02Ni" +
	"eprawidłowy klucz: %[1]v\x02Liczba musi zawierać się w przedziale 0 - 2^" +
	"64-1: %[1]v\x02Dwa przecinki z rzędu\x02Nazwa tunelu jest nieprawidłowa" +
	"\x02[nie określono]\x02Wszyscy uczestnicy muszą mieć klucze publiczne" +
	"\x02Błąd podczas pobierania konfiguracji\x02Ikona WireGuard nie pojawiła" +
	" się po 30 sekundach w zasobniku systemowym.\x02Skrypty:\x02Transfer:" +
	"\x02przed włączeniem\x02po włączeniu\x02przed wyłączeniem\x02po wyłączen" +
	"iu\x02wyłączone, według zasad grupy\x02włączyć\x02%[1]s odebrano, %[2]s " +
	"wysłano\x02Nie udało się określić stanu tunelu\x02Nie udało się aktywowa" +
	"ć tunelu\x02Nie można dezaktywować tunelu\x02Interfejs: %[1]s\x02Peer" +
	"\x02Utwórz nowy tunel\x02Edytuj tunel\x02&Nazwa:\x02&Klucz publiczny:" +
	"\x02(nieznany)\x02Zablokuj niezabezpieczony ruch (wyłącznik awaryjny)" +
	"\x02&Zapisz\x02Anuluj\x02&Konfiguracja:\x02Nieprawidłowa nazwa\x02Nazwa " +
	"jest wymagana.\x02Nazwa tunelu ‘%[1]s’ jest niepoprawna.\x02Nie można wy" +
	"listować istniejących tuneli\x02Tunel już istnieje\x02Inny tunel już ist" +
	"nieje z tą samą nazwą ‘%[1]s’.\x02Nie można utworzyć nowej konfiguracji" +
	"\x02Zapis pliku się nie powiódł\x02Plik ‘%[1]s’ już istnieje. Czy chcesz" +
	" go nadpisać?\x02Aktywny\x02Aktywowanie\x02Pliki tekstowe (*.txt)|*.txt|" +
	"Wszystkie pliki (*.*)|*.*\x02Błąd detekcji WireGuard\x02Nie można poczek" +
	"ać na pojawienie się okna WireGuard: %[1]v\x02Status: Nieznany\x02Adresy" +
	": Brak\x02&Zarządzaj tunelami…\x02&Importuj tunel (tunele) z pliku…\x02W" +
	"&yjście\x02&Tunele\x02Tunel %[1]s został aktywowany.\x02Tunel %[1]s zost" +
	"ał dezaktywowany.\x02Status: %[1]s\x02Adresy: %[1]s\x02Tunele\x02&Edytuj" +
	"\x02Dodaj &pusty tunel…\x02Dodaj Tunel\x02Usuń wybrany tunel (tunele)" +
	"\x02Eksportuj wszystkie tunele do archiwum ZIP\x02&Przełącz\x02Eksportuj" +
	" wszystkie tunele do archiwum &zip…\x02Edytuj &wybrany tunel…\x02&Usuń w" +
	"ybrany tunel (tunele)\x02brak plików konfiguracyjnych\x02Nie można zaimp" +
	"ortować wybranej konfiguracji: %[1]v\x02Nie można wskazać istniejących t" +
	"uneli: %[1]v\x02Inny tunel już istnieje z tą samą nazwą ‘%[1]s’\x02Nie m" +
	"ożna zaimportować konfiguracji: %[1]v\x02Zaimportowane tunele\x14\x01" +
	"\x81\x01\x00\x04\x1b\x02Zaimportowano %[1]d tunele\x05\x1b\x02Zaimportow" +
	"ano %[1]d tuneli\x02\x1a\x02Zaimportowano %[1]d tunel\x00\x1b\x02Zaimpor" +
	"towano %[1]d tuneli\x14\x02\x80\x01\x04#\x02Zaimportowano %[1]d z %[2]d " +
	"tunele\x05#\x02Zaimportowano %[1]d z %[2]d tuneli\x02\x22\x02Zaimportowa" +
	"no %[1]d z %[2]d tunel\x00#\x02Zaimportowano %[1]d z %[2]d tuneli\x02Nie" +
	" można utworzyć tunelu\x14\x01\x81\x01\x00\x04\x13\x02Usuń %[1]d tunele" +
	"\x05\x13\x02Usuń %[1]d tuneli\x02\x12\x02Usuń %[1]d tunel\x00\x13\x02Usu" +
	"ń %[1]d tuneli\x14\x01\x81\x01\x00\x04+\x02Czy na pewno chcesz usunąć %" +
	"[1]d tunele?\x05+\x02Czy na pewno chcesz usunąć %[1]d tuneli?\x02*\x02Cz" +
	"y na pewno chcesz usunąć %[1]d tunel?\x00+\x02Czy na pewno chcesz usunąć" +
	" %[1]d tuneli?\x02Usuń tunel ‘%[1]s’\x02Czy na pewno chcesz usunąć tunel" +
	" ‘%[1]s’?\x02%[1]s Tej akcji nie można cofnąć.\x02Nie można usunąć tunel" +
	"u\x02Tunel nie mógł zostać usunięty: %[1]s\x02Nie można usunąć tuneli" +
	"\x14\x01\x81\x01\x00\x04'\x02%[1]d tunele nie mogą być usunięte.\x05'" +
	"\x02%[1]d tunele nie mogą być usunięte.\x02)\x02%[1]d tunel nie może zos" +
	"tać usunięty.\x00'\x02%[1]d tunele nie mogą być usunięte.\x02Pliki konfi" +
	"guracji (*.zip, *.conf)|*.zip;*.conf|Wszystkie pliki (*.*)|*.*\x02Import" +
	"uj tunel (tunele) z pliku\x02Pliki ZIP konfiguracji (*.zip)|*.zip\x02Eks" +
	"portuj tunele do archiwum ZIP\x02Nie można wyłączyć usługi ze względu na" +
	": %[1]v. Jeśli chcesz wyłączyć WireGuard możesz to zrobić z poziomu mene" +
	"dżera usług.\x02Nawiasy muszą zawierać adres IPv6\x02Klucze muszą zostać" +
	" zdekodowane do dokładnie 32 bajtów\x02Linia musi występować w sekcji" +
	"\x02Klucz konfiguracyjny nie zawiera separatora równorzędnego\x02Klucz m" +
	"usi mieć wartość\x02Nieprawidłowy klucz dla sekcji [Interface]\x02Niepra" +
	"widłowy klucz dla sekcji [Peer]\x02Interfejs musi mieć klucz prywatny" +
	"\x02Nieprawidłowy klucz dla sekcji interface\x02Wersja protokołu musi by" +
	"ć 1\x02Nieprawidłowy klucz dla sekcji peer"

var roIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x0000005d, 0x00000077,
	0x00000092, 0x000000d1, 0x0000011a, 0x0000014e,
	0x000001b2, 0x0000022e, 0x00000231, 0x00000234,
	0x0000023f, 0x00000246, 0x00000253, 0x0000025d,
	0x0000026d, 0x00000280, 0x00000285, 0x0000028d,
	0x0000029a, 0x000002b1, 0x000002c1, 0x000002ce,
	0x000002ea, 0x00000307, 0x0000030f, 0x00000320,
	0x00000333, 0x0000033a, 0x00000343, 0x00000356,
	// Entry 20 - 3F
	0x0000036e, 0x00000373, 0x00000383, 0x000003a0,
	0x000003b0, 0x000003e8, 0x00000409, 0x0000040e,
	0x00000435, 0x00000460, 0x0000048d, 0x000004ba,
	0x000004ee, 0x00000527, 0x00000532, 0x0000053b,
	0x00000548, 0x00000555, 0x00000562, 0x0000056f,
	0x0000057c, 0x00000591, 0x000005be, 0x000005e3,
	0x00000606, 0x00000614, 0x00000621, 0x00000644,
	0x0000065b, 0x00000697, 0x000006b9, 0x000006d8,
	// Entry 40 - 5F
	0x000006ef, 0x0000071e, 0x00000742, 0x0000078c,
	0x00000797, 0x000007a4, 0x000007b0, 0x000007bd,
	0x000007c8, 0x000007d4, 0x000007f2, 0x000007fc,
	0x00000817, 0x00000843, 0x00000861, 0x00000882,
	0x00000895, 0x0000089d, 0x000008ae, 0x000008bc,
	0x000008c3, 0x000008d4, 0x000008e3, 0x00000930,
	0x00000939, 0x00000941, 0x00000951, 0x0000095e,
	0x00000974, 0x0000099f, 0x000009c6, 0x000009db,
	// Entry 60 - 7F
	0x00000a0c, 0x00000a31, 0x00000a4f, 0x00000a95,
	0x00000a9b, 0x00000aa9, 0x00000ae0, 0x00000afe,
	0x00000b3c, 0x00000b50, 0x00000b60, 0x00000b78,
	0x00000b9d, 0x00000ba6, 0x00000bb0, 0x00000bce,
	0x00000bef, 0x00000bfc, 0x00000c0a, 0x00000c13,
	0x00000c1c, 0x00000c34, 0x00000c44, 0x00000c65,
	0x00000c87, 0x00000c91, 0x00000cb7, 0x00000cd2,
	0x00000cf4, 0x00000d1f, 0x00000d58, 0x00000d8d,
	// Entry 80 - 9F
	0x00000dbd, 0x00000de9, 0x00000dfc, 0x00000e4f,
	0x00000ebf, 0x00000ed9, 0x00000f2f, 0x00000fd9,
	0x00000ff5, 0x0000102f, 0x0000105d, 0x00001078,
	0x0000109f, 0x000010bc, 0x00001140, 0x00001190,
	0x000011b1, 0x000011db, 0x000011f6, 0x00001257,
	0x00001288, 0x000012cd, 0x000012f8, 0x0000133f,
	0x00001365, 0x00001393, 0x000013bc, 0x000013ed,
	0x0000141b, 0x00001443, 0x0000146e, 0x0000146e,
	// Entry A0 - BF
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	// Entry C0 - DF
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	// Entry E0 - FF
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	// Entry 100 - 11F
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	0x0000146e, 0x0000146e, 0x0000146e, 0x0000146e,
	// Entry 120 - 13F
	0x0000146e,
} // Size: 1180 bytes

const roData string = "" + // Size: 5230 bytes
	"\x02Eroare\x02(fără argument): obținere drept administrativ și instalare" +
	" serviciu de gestionare\x02Utilizare: %[1]s [\x0a%[2]s]\x02Opțiuni linie" +
	" de comandă\x02Nu se poate determina dacă procesul rulează sub WOW64: %[" +
	"1]v\x02Trebuie să utilizezi versiunea nativă a WireGuard pe acest calcul" +
	"ator.\x02Nu poate fi deschis tokenul actual de proces: %[1]v\x02WireGuar" +
	"d poate fi utilizat doar de către utilizatorii care sunt membri ai grupu" +
	"lui Builtin %[1]s.\x02WireGuard rulează, dar interfața cu utilizatorul e" +
	"ste accesibilă doar din spațiile de lucru ale grupului Builtin %[1]s." +
	"\x02, \x02, \x02Închidere\x02Stare:\x02&Dezactivare\x02&Activare\x02Chei" +
	"e publică:\x02Port de ascultare:\x02MTU:\x02Adrese:\x02Servere DNS:\x02C" +
	"heie predistribuită:\x02IP-uri permise:\x02Punct final:\x02Mesaj keepali" +
	"ve persistent:\x02Ultimul acord de interogare:\x02Inactiv\x02Se dezactiv" +
	"ează\x02Stare necunoscută\x02Jurnal\x02&Copiere\x02Selectare &totală\x02" +
	"&Salvare în fișier…\x02Timp\x02Mesaj de jurnal\x02Exportare jurnal în fi" +
	"șier\x02Eroare de tunel\x02%[1]s\x0a\x0aConsultă jurnalul pentru mai mu" +
	"lte informații.\x02Eroare la ieșirea din WireGuard\x02Acum\x02Ceasul de " +
	"sistem a fost dat în spate!\x14\x01\x81\x01\x00\x04\x0a\x02%[1]d ani\x02" +
	"\x09\x02%[1]d an\x00\x0d\x02%[1]d de ani\x14\x01\x81\x01\x00\x04\x0b\x02" +
	"%[1]d zile\x02\x09\x02%[1]d zi\x00\x0e\x02%[1]d de zile\x14\x01\x81\x01" +
	"\x00\x04\x0a\x02%[1]d ore\x02\x0b\x02%[1]d oră\x00\x0d\x02%[1]d de ore" +
	"\x14\x01\x81\x01\x00\x04\x0d\x02%[1]d minute\x02\x0c\x02%[1]d minut\x00" +
	"\x10\x02%[1]d de minute\x14\x01\x81\x01\x00\x04\x0e\x02%[1]d secunde\x02" +
	"\x0f\x02%[1]d secundă\x00\x11\x02%[1]d de secunde\x02acum %[1]s\x02%[1]d" +
	"\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%" +
	".2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Adresă IP invalidă\x02Lungimea prefix" +
	"ului de rețea este invalidă\x02Lipsește portul de la punctul final\x02Ga" +
	"zdă invalidă a punctului final\x02MTU invalidă\x02Port invalid\x02Mesaj " +
	"keepalive persistent invalid\x02Cheie invalidă: %[1]v\x02Numărul trebuie" +
	" să fie cuprins între 0 și 2^64-1: %[1]v\x02Două virgule una după cealal" +
	"tă\x02Numele tunelului nu este valid\x02[niciuna specificată]\x02Toate p" +
	"erechile trebuie să aibă chei publice\x02Eroare la obținerea configurați" +
	"ei\x02Pictograma WireGuard din bara de sistem nu a apărut după 30 de sec" +
	"unde.\x02Scripturi:\x02Transferare:\x02pre-pornire\x02post-pornire\x02pr" +
	"e-oprire\x02post-oprire\x02dezactivat, conform politicii\x02activată\x02" +
	"%[1]s primit, %[2]s trimis\x02Nu a putut fi determinată starea tunelului" +
	"\x02Tunelul nu a putut fi activat\x02Tunelul nu a putut fi dezactivat" +
	"\x02Interfață: %[1]s\x02Pereche\x02Creare tunel nou\x02Editare tunel\x02" +
	"&Nume:\x02Cheie &publică:\x02(necunoscută)\x02&Blochează traficul care n" +
	"u trece prin tunel (întrerupător de activitate)\x02&Salvare\x02Anulare" +
	"\x02&Configurație:\x02Nume invalid\x02Este necesar un nume.\x02Numele tu" +
	"nelului „%[1]s” este invalid.\x02Tunelurile existente nu pot fi listate" +
	"\x02Tunelul există deja\x02Există deja un alt tunel cu numele „%[1]s”." +
	"\x02Nu se poate crea configurația nouă\x02Scrierea fișierului a eșuat" +
	"\x02Fișierul „%[1]s” există deja.\x0a\x0aDorești suprascrierea acestuia?" +
	"\x02Activ\x02Se activează\x02Fișiere text (*.txt)|*.txt|Toate fișierele " +
	"(*.*)|*.*\x02Eroare de detectare WireGuard\x02Nu se poate aștepta ca fer" +
	"eastra WireGuard să apară: %[1]v\x02Stare: necunoscută\x02Adrese: niciun" +
	"a\x02&Gestionare tuneluri…\x02&Importare tunel(uri) din fișier…\x02Ie&și" +
	"re\x02&Tuneluri\x02Tunelul %[1]s a fost activat.\x02Tunelul %[1]s a fost" +
	" dezactivat.\x02Stare: %[1]s\x02Adrese: %[1]s\x02Tuneluri\x02&Editare" +
	"\x02Adăugare tunel &gol…\x02Adăugare tunel\x02Eliminare tunel(uri) selec" +
	"tat(e)\x02Exportă toate tunelurile în zip\x02&Comutare\x02Exportă toate " +
	"tunelurile în &zip…\x02Editare tunel &selectat…\x02&Eliminare tunel(uri)" +
	" selectat(e)\x02nu au fost găsite fișiere de configurare\x02Configurația" +
	" selectată nu a putut fi importată: %[1]v\x02Tunelurile existente nu au " +
	"putut fi enumerate: %[1]v\x02Există deja un alt tunel cu numele „%[1]s”" +
	"\x02Configurația nu poate fi importată: %[1]v\x02Tuneluri importate\x14" +
	"\x01\x81\x01\x00\x04\x18\x02Importat %[1]d tuneluri\x02\x15\x02Importat " +
	"%[1]d tunel\x00\x1b\x02Importat %[1]d de tuneluri\x14\x02\x80\x01\x04" +
	"\x22\x02Importat %[1]d din %[2]d tuneluri\x02\x1f\x02Importat %[1]d din " +
	"%[2]d tunel\x00%\x02Importat %[1]d din %[2]d de tuneluri\x02Tunelul nu p" +
	"oate fi creat\x14\x01\x81\x01\x00\x04\x19\x02Ștergere %[1]d tuneluri\x02" +
	"\x16\x02Ștergere %[1]d tunel\x00\x1c\x02Ștergere %[1]d de tuneluri\x14" +
	"\x01\x81\x01\x00\x045\x02Ești sigur că dorești să ștergi %[1]d tuneluri?" +
	"\x022\x02Ești sigur că dorești să ștergi %[1]d tunel?\x008\x02Ești sigur" +
	" că dorești să ștergi %[1]d de tuneluri?\x02Ștergere tunel „%[1]s”\x02Eș" +
	"ti sigur că dorești să ștergi tunelul „%[1]s”?\x02%[1]s Această acțiune " +
	"nu poate fi anulată.\x02Tunelul nu poate fi șters\x02Un tunel nu a putut" +
	" fi eliminat: %[1]s\x02Nu se pot șterge tunelurile\x14\x01\x81\x01\x00" +
	"\x04)\x02%[1]d tuneluri nu au putut fi eliminate.\x02$\x02%[1]d tunel nu" +
	" a putut fi eliminat.\x00,\x02%[1]d de tuneluri nu au putut fi eliminate" +
	".\x02Fișiere de configurare (*.zip, *.conf)|*.zip;*.conf|Toate fișierele" +
	" (*.*)|*.*\x02Importare tunel(uri) din fișier\x02Fișiere ZIP de configur" +
	"are (*.zip)|*.zip\x02Exportare tuneluri în zip\x02Nu se poate ieși din s" +
	"erviciu din cauza: %[1]v. Poți opri WireGuard din managerul de servicii." +
	"\x02Parantezele trebuie să conțină o adresă IPv6\x02Rezultatul decodific" +
	"at de chei trebuie să aibă exact 32 de octeți\x02Linia trebuie să apară " +
	"într-o secțiune\x02Cheii de configurare îi lipsește un separator de for" +
	"ma semnului egal\x02Cheia trebuie să conțină o valoare\x02Cheie invalidă" +
	" pentru secțiunea [Interface]\x02Cheie invalidă pentru secțiunea [Peer]" +
	"\x02O interfață trebuie să aibă o cheie privată\x02Cheie invalidă pentru" +
	" secțiunea interfeței\x02Versiunea de protocol trebuie să fie 1\x02Cheie" +
	" invalidă pentru secțiunea perechii"

var ruIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x0000000d, 0x000000a9, 0x000000d4,
	0x00000107, 0x00000166, 0x000001c9, 0x00000220,
	0x000002a7, 0x0000034b, 0x0000034e, 0x00000351,
	0x00000360, 0x0000036e, 0x00000382, 0x00000398,
	0x000003b5, 0x000003bf, 0x000003c4, 0x000003d5,
	0x000003e9, 0x000003fe, 0x00000426, 0x00000444,
	0x00000475, 0x000004a0, 0x000004b1, 0x000004c6,
	0x000004f0, 0x000004fd, 0x00000515, 0x0000052c,
	// Entry 20 - 3F
	0x0000054f, 0x0000055a, 0x0000057c, 0x000005a6,
	0x000005c2, 0x0000063d, 0x00000666, 0x00000673,
	0x000006b0, 0x000006dd, 0x0000070a, 0x00000737,
	0x00000774, 0x000007b1, 0x000007c2, 0x000007cb,
	0x000007d8, 0x000007e5, 0x000007f2, 0x000007ff,
	0x0000080c, 0x00000833, 0x00000871, 0x000008b0,
	0x000008de, 0x000008fb, 0x0000091d, 0x00000973,
	0x0000099c, 0x000009db, 0x000009fe, 0x00000a3d,
	// Entry 40 - 5F
	0x00000a53, 0x00000a99, 0x00000ad9, 0x00000b41,
	0x00000b51, 0x00000b63, 0x00000b87, 0x00000ba9,
	0x00000bcb, 0x00000beb, 0x00000c15, 0x00000c26,
	0x00000c59, 0x00000ca4, 0x00000cdc, 0x00000d12,
	0x00000d2c, 0x00000d33, 0x00000d51, 0x00000d7b,
	0x00000d8e, 0x00000dac, 0x00000dc3, 0x00000e0b,
	0x00000e1f, 0x00000e2c, 0x00000e47, 0x00000e71,
	0x00000e98, 0x00000edc, 0x00000f14, 0x00000f3f,
	// Entry 60 - 7F
	0x00000f87, 0x00000fce, 0x00000ff3, 0x00001055,
	0x00001068, 0x0000107f, 0x000010c7, 0x000010f5,
	0x00001149, 0x0000116c, 0x00001181, 0x000011ad,
	0x000011df, 0x000011eb, 0x000011fb, 0x00001224,
	0x0000124b, 0x0000125f, 0x00001273, 0x00001282,
	0x0000129e, 0x000012cf, 0x000012ef, 0x00001320,
	0x0000135b, 0x00001373, 0x000013b2, 0x000013f3,
	0x00001425, 0x00001466, 0x000014b6, 0x00001510,
	// Entry 80 - 9F
	0x00001557, 0x000015a7, 0x000015d5, 0x000016a9,
	0x000017a5, 0x000017d7, 0x00001877, 0x000019bf,
	0x000019e9, 0x00001a39, 0x00001a84, 0x00001ab6,
	0x00001af0, 0x00001b22, 0x00001c19, 0x00001c76,
	0x00001ca4, 0x00001cdc, 0x00001d0e, 0x00001da8,
	0x00001de0, 0x00001e35, 0x00001e68, 0x00001ebd,
	0x00001eef, 0x00001f29, 0x00001f5e, 0x00001fa8,
	0x00001feb, 0x00002023, 0x0000206a, 0x0000206a,
	// Entry A0 - BF
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	// Entry C0 - DF
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	// Entry E0 - FF
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	// Entry 100 - 11F
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	0x0000206a, 0x0000206a, 0x0000206a, 0x0000206a,
	// Entry 120 - 13F
	0x0000206a,
} // Size: 1180 bytes

const ruData string = "" + // Size: 8298 bytes
	"\x02Ошибка\x02(нет аргумента): получить права администратора и установит" +
	"ь административную службу\x02Использование: %[1]s [\x0a%[2]s]\x02Параме" +
	"тры командной строки\x02Ошибка определения или процесс работает как WOW" +
	"64: %[1]v\x02Используйте нативную версию WireGuard на этом компьютере." +
	"\x02Не удается открыть токен текущего процесса: %[1]v\x02WireGuard может" +
	" использоваться только пользователями, входящими в группу %[1]s.\x02Wire" +
	"Guard запущен, но пользовательский интерфейс доступен только с рабочих с" +
	"толов группы %[1]s.\x02, \x02, \x02Закрыть\x02Статус:\x02&Отключить\x02" +
	"&Подключить\x02Публичный ключ:\x02Порт:\x02MTU:\x02IP-адреса:\x02DNS-сер" +
	"веры:\x02Общий ключ:\x02Разрешенные IP-адреса:\x02IP-адрес сервера:\x02" +
	"Поддерживание соединения:\x02Последнее рукопожатие:\x02Отключен\x02Откл" +
	"ючение\x02Неизвестное состояние\x02Журнал\x02&Скопировать\x02Выбрать &в" +
	"се\x02&Сохранить в файл…\x02Время\x02Сообщение журнала\x02Экспорт журна" +
	"ла в файл\x02Ошибка туннеля\x02%[1]s\x0a\x0aОбратитесь к журналу для по" +
	"лучения дополнительной информации.\x02Ошибка выхода из WireGuard\x02Сей" +
	"час\x02Системные часы переведены назад!\x14\x01\x81\x01\x00\x04\x08\x02" +
	"%[1]dг\x05\x08\x02%[1]dг\x02\x08\x02%[1]dг\x00\x08\x02%[1]dг\x14\x01\x81" +
	"\x01\x00\x04\x08\x02%[1]dд\x05\x08\x02%[1]dд\x02\x08\x02%[1]dд\x00\x08" +
	"\x02%[1]dд\x14\x01\x81\x01\x00\x04\x08\x02%[1]dч\x05\x08\x02%[1]dч\x02" +
	"\x08\x02%[1]dч\x00\x08\x02%[1]dч\x14\x01\x81\x01\x00\x04\x0c\x02%[1]dмин" +
	"\x05\x0c\x02%[1]dмин\x02\x0c\x02%[1]dмин\x00\x0c\x02%[1]dмин\x14\x01\x81" +
	"\x01\x00\x04\x0c\x02%[1]dсек\x05\x0c\x02%[1]dсек\x02\x0c\x02%[1]dсек\x00" +
	"\x0c\x02%[1]dсек\x02%[1]s назад\x02%[1]d Б\x02%.2[1]f Кб\x02%.2[1]f Мб" +
	"\x02%.2[1]f Гб\x02%.2[1]f Тб\x02%[1]s: %[2]q\x02Недопустимый IP-адрес" +
	"\x02Недопустимая длина префикса сети\x02Отсутствует порт IP-адреса серве" +
	"ра\x02Неверный IP-адрес сервера\x02Недопустимый MTU\x02Недопустимый пор" +
	"т\x02Недопустимое значение поддержания соединения\x02Недопустимый ключ:" +
	" %[1]v\x02Число должно быть между 0 и 2^64-1: %[1]v\x02Две запятые подря" +
	"д\x02Название туннеля недействительно\x02[не указано]\x02Все пиры должн" +
	"ы иметь публичные ключи\x02Ошибка при получении конфигурации\x02Значок " +
	"в системном трее WireGuard не появился после 30 секунд.\x02Скрипты:\x02" +
	"Передача:\x02перед подключением\x02после подключения\x02перед отключени" +
	"ем\x02после отключения\x02отключено, по политике\x02включено\x02Получен" +
	"о %[1]s, отправлено %[2]s\x02Не удалось определить состояние туннеля" +
	"\x02Не удалось подключить туннель\x02Не удалось отключить туннель\x02Инт" +
	"ерфейс: %[1]s\x02Пир\x02Создать туннель\x02Редактировать туннель\x02&На" +
	"звание:\x02&Публичный ключ:\x02(неизвестно)\x02&Блокировать нетуннелиро" +
	"ванный трафик\x02&Сохранить\x02Отмена\x02&Конфигурация:\x02Некорректное" +
	" название\x02Необходимо название.\x02Название туннеля ‘%[1]s’ недопустим" +
	"о.\x02Не удалось отобразить туннели\x02Туннель уже существует\x02Туннел" +
	"ь с именем ’%[1]s’ уже существует.\x02Не удалось создать новую конфигур" +
	"ацию\x02Ошибка записи файла\x02Файл '%[1]s' уже существует!\x0a\x0aВы х" +
	"отите перезаписать его?\x02Подключен\x02Подключение\x02Текстовые файлы " +
	"(*.txt)|*.txt|Все файлы (*.*)|*.*\x02Ошибка обнаружения WireGuard\x02Не " +
	"удалось дождаться появления окна WireGuard: %[1]v\x02Статус: Неизвестен" +
	"\x02Адреса: нет\x02&Управление туннелями…\x02&Импорт туннелей из файла…" +
	"\x02Вы&ход\x02&Туннели\x02Туннель %[1]s подключен.\x02Туннель %[1]s откл" +
	"ючен.\x02Статус: %[1]s\x02Адреса: %[1]s\x02Туннели\x02&Редактировать" +
	"\x02Добавить &пустой туннель…\x02Добавить туннель\x02Удалить выбранные т" +
	"уннели\x02Экспорт всех туннелей в zip-архив\x02&Переключить\x02Экспорт " +
	"всех туннелей в &zip-архив…\x02Редактировать &выбранный туннель…\x02&Уд" +
	"алить выбранные туннели\x02файлы конфигурации не были найдены\x02Невозм" +
	"ожно импортировать конфигурацию: %[1]v\x02Не удалось перечислить сущест" +
	"вующие туннели: %[1]v\x02Туннель с именем ’%[1]s’ уже существует\x02Нев" +
	"озможно импортировать конфигурацию: %[1]v\x02Импортированные туннели" +
	"\x14\x01\x81\x01\x00\x041\x02Импортированы туннели: %[1]d\x051\x02Импорт" +
	"ированы туннели: %[1]d\x024\x02Импортированный %[1]d туннель\x001\x02Им" +
	"портированы туннели: %[1]d\x14\x02\x80\x01\x04<\x02Импортированы туннел" +
	"и: %[1]d из %[2]d\x05<\x02Импортированы туннели: %[1]d из %[2]d\x02<" +
	"\x02Импортированы туннели: %[1]d из %[2]d\x00<\x02Импортированы туннели:" +
	" %[1]d из %[2]d\x02Не удалось создать туннель\x14\x01\x81\x01\x00\x04%" +
	"\x02Удалить туннели: %[1]d\x05%\x02Удалить туннели: %[1]d\x02$\x02Удалит" +
	"ь %[1]d туннель\x00%\x02Удалить туннели: %[1]d\x14\x01\x81\x01\x00\x04O" +
	"\x02Вы уверены, что хотите удалить туннели: %[1]d?\x05O\x02Вы уверены, ч" +
	"то хотите удалить туннели: %[1]d?\x02N\x02Вы уверены, что хотите удалит" +
	"ь %[1]d туннель?\x00O\x02Вы уверены, что хотите удалить туннели: %[1]d?" +
	"\x02Удалить туннель ‘%[1]s’\x02Вы уверены, что хотите удалить '%[1]s' ту" +
	"ннель?\x02%[1]s Данное действие невозможно отменить.\x02Не удалось удал" +
	"ить туннель\x02Невозможно удалить туннель: %[1]s\x02Не удалось удалить " +
	"туннели\x14\x01\x81\x01\x00\x04;\x02туннелей не удалось удалить: %[1]d" +
	"\x05;\x02туннелей не удалось удалить: %[1]d\x029\x02%[1]d туннель не уда" +
	"лось удалить.\x00;\x02туннелей не удалось удалить: %[1]d\x02Файлы конфи" +
	"гурации (*.zip, *.conf)|*.zip;*.conf|Все файлы (*.*)|*.*\x02Импорт тунн" +
	"елей из файла\x02Конфигурация ZIP файлов (*.zip)|*.zip\x02Экспорт тунне" +
	"лей в zip-архив\x02Не удается выйти из сервиса из-за: %[1]v. Вы можете " +
	"остановить WireGuard из менеджера служб.\x02В скобках должен быть IPv6 " +
	"адрес\x02Ключи должны декодироваться ровно с 32 байтами\x02Строка должн" +
	"а быть в секции\x02В ключе конфигурации отсутствует разделитель\x02Ключ" +
	" должен иметь значение\x02Неверный ключ для секции [Interface]\x02Неверн" +
	"ый ключ для секции [Peer]\x02В Интерфейсе должен быть приватный ключ" +
	"\x02Неверный ключ для секции Интерфейса\x02Версия протокола должна быть " +
	"1\x02Недействительный ключ для секции пира"

var si_LKIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000013, 0x00000013, 0x00000036,
	0x00000036, 0x00000036, 0x00000036, 0x00000036,
	0x00000036, 0x00000036, 0x00000039, 0x0000003c,
	0x0000004c, 0x0000005d, 0x0000005d, 0x0000005d,
	0x0000005d, 0x0000008d, 0x0000008d, 0x0000009e,
	0x000000c8, 0x000000c8, 0x000000ef, 0x000000ef,
	0x000000ef, 0x000000ef, 0x000000ef, 0x000000ef,
	0x0000011b, 0x0000011b, 0x0000012f, 0x0000012f,
	// Entry 20 - 3F
	0x00000162, 0x00000172, 0x00000172, 0x00000172,
	0x00000172, 0x00000172, 0x000001ba, 0x000001c7,
	0x000001c7, 0x00000208, 0x00000237, 0x00000260,
	0x0000029b, 0x000002d0, 0x000002e4, 0x000002f0,
	0x00000304, 0x00000318, 0x0000032c, 0x00000340,
	0x0000034d, 0x00000396, 0x00000396, 0x00000396,
	0x00000396, 0x00000396, 0x000003cf, 0x000003cf,
	0x00000400, 0x00000400, 0x00000442, 0x00000442,
	// Entry 40 - 5F
	0x00000442, 0x00000442, 0x00000442, 0x00000442,
	0x00000442, 0x00000442, 0x00000442, 0x00000442,
	0x00000442, 0x00000442, 0x00000442, 0x0000045a,
	0x0000048d, 0x0000048d, 0x0000048d, 0x0000048d,
	0x000004b6, 0x000004b6, 0x000004b6, 0x000004b6,
	0x000004bf, 0x000004bf, 0x000004d1, 0x000004d1,
	0x000004eb, 0x000004fe, 0x0000051c, 0x00000546,
	0x0000056d, 0x0000056d, 0x0000056d, 0x0000056d,
	// Entry 60 - 7F
	0x0000056d, 0x000005bc, 0x000005f8, 0x000005f8,
	0x000005f8, 0x0000062d, 0x0000062d, 0x0000062d,
	0x000006af, 0x000006d0, 0x000006d0, 0x000006d0,
	0x000006d0, 0x000006e7, 0x000006e7, 0x000006e7,
	0x000006e7, 0x000006fe, 0x00000715, 0x00000715,
	0x0000072f, 0x0000072f, 0x0000072f, 0x0000072f,
	0x0000072f, 0x0000072f, 0x0000072f, 0x0000072f,
	0x0000072f, 0x0000072f, 0x0000072f, 0x0000072f,
	// Entry 80 - 9F
	0x0000072f, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x000007eb, 0x000007eb,
	0x000007eb, 0x000007eb, 0x000007eb, 0x000007eb,
	0x000007eb, 0x000007eb, 0x000007eb, 0x000007eb,
	0x000007eb, 0x000007eb, 0x000007eb, 0x000007eb,
	0x0000082b, 0x0000082b, 0x0000082b, 0x0000089c,
	0x0000089c, 0x000008f0, 0x000008f0, 0x000008f0,
	// Entry A0 - BF
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	// Entry C0 - DF
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	// Entry E0 - FF
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	// Entry 100 - 11F
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	0x000008f0, 0x000008f0, 0x000008f0, 0x000008f0,
	// Entry 120 - 13F
	0x000008f0,
} // Size: 1180 bytes

const si_LKData string = "" + // Size: 2288 bytes
	"\x02දෝෂයකි\x02භාවිතය: %[1]s [\x0a%[2]s]\x02, \x02, \x02වසන්න\x02තත්වය:" +
	"\x02සවන්දීමේ කෙවෙනිය:\x02ලිපින:\x02ව.නා.ප. සේවාදායක:\x02ඉඩදුන් අ.ජා.කෙ.:" +
	"\x02නොදන්නා තත්වයකි\x02&පිටපත්\x02&ගොනුවකට සුරකින්න…\x02වේලාව\x02වයර්ගාඩ" +
	"් පිටවීමේදී දෝෂයකි\x02දැන්\x14\x01\x81\x01\x00\x02\x1c\x02අවුරුදු %[1]" +
	"d\x00\x1c\x02අවුරුදු %[1]d\x14\x01\x81\x01\x00\x02\x13\x02දවස් %[1]d\x00" +
	"\x13\x02දවස් %[1]d\x14\x01\x81\x01\x00\x02\x10\x02පැය %[1]d\x00\x10\x02ප" +
	"ැය %[1]d\x14\x01\x81\x01\x00\x02\x19\x02විනාඩි %[1]d\x00\x19\x02විනාඩි" +
	" %[1]d\x14\x01\x81\x01\x00\x02\x16\x02තත්පර %[1]d\x00\x16\x02තත්පර %[1]d" +
	"\x02%[1]s ට පෙර\x02බ.\u00a0%[1]d\x02කි.බ. %.2[1]f\x02මෙ.බ. %.2[1]f\x02ගි" +
	".බ. %.2[1]f\x02ටෙ.බ. %.2[1]f\x02%[1]s: %[2]q\x02වලංගු නොවන අ.ජා.කෙ. ලිපි" +
	"නයකි\x02වලංගු නොවන කෙවෙනියකි\x02වලංගු නොවන යතුර: %[1]v\x02පේළියකට අල්ප" +
	"විරාම දෙකක්\x02සබල කර ඇත\x02%[1]s ලැබුණී, %[2]s යැවිණි\x02අතුරුමුහුණත:" +
	" %[1]s\x02&නම:\x02(නොදනී)\x02&සුරකින්න\x02අවලංගු\x02&වින්\u200dයාසය:\x02" +
	"වලංගු නොවන නමකි\x02නමක් අවශ්\u200dයයි.\x02නව වින්\u200dයාසය සෑදීමට නොහ" +
	"ැකියි\x02ගොනුව ලිවීමට අසමත්විය\x02ක්\u200dරියාත්මක වෙමින්\x02වයර්ගාඩ් " +
	"කවුළුව පෙනෙන තෙක් රැඳීසිටිය නොහැකිය: %[1]v\x02තත්වය: නොදනී\x02පි&ටවන්න" +
	"\x02තත්වය: %[1]s\x02ලිපින: %[1]s\x02&සංස්කරණය\x02වින්\u200dයාසය ආයාත කළ " +
	"නොහැකිය: %[1]v\x02%[1]s මෙම ක්\u200dරියාමාර්ගය ආපසු හැරවිය නොහැකිය." +
	"\x02යතුරට අගයක් තිබිය යුතුය\x02අතුරුමුහුතකට පුද්ගලික යතුරක් තිබිය යුතුය" +
	"\x02කෙටුම්පතෙහි අනුවාදය 1 විය යුතුය"

var skIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x0000005e, 0x00000078,
	0x00000097, 0x000000d1, 0x0000011e, 0x00000156,
	0x00000198, 0x00000202, 0x00000205, 0x00000207,
	0x00000211, 0x00000217, 0x00000226, 0x00000233,
	0x00000245, 0x00000255, 0x0000025a, 0x00000262,
	0x0000026f, 0x0000028a, 0x0000029f, 0x000002ad,
	0x000002c6, 0x000002e6, 0x000002f1, 0x000002ff,
	0x0000030d, 0x0000031f, 0x0000032c, 0x0000033d,
	// Entry 20 - 3F
	0x00000355, 0x0000035a, 0x00000377, 0x000003a0,
	0x000003ad, 0x000003e5, 0x00000400, 0x00000406,
	0x0000042e, 0x00000468, 0x000004a0, 0x000004e1,
	0x00000524, 0x00000569, 0x00000574, 0x0000057d,
	0x0000058a, 0x00000597, 0x000005a4, 0x000005b1,
	0x000005be, 0x000005d2, 0x000005f8, 0x0000061d,
	0x00000641, 0x0000064f, 0x0000065e, 0x00000680,
	0x00000699, 0x000006cc, 0x000006e2, 0x000006ff,
	// Entry 40 - 5F
	0x00000713, 0x00000748, 0x0000076c, 0x000007b6,
	0x000007bf, 0x000007c7, 0x000007d6, 0x000007e2,
	0x000007f1, 0x000007fd, 0x0000081e, 0x00000828,
	0x0000084c, 0x0000086e, 0x0000088d, 0x000008ae,
	0x000008bf, 0x000008c4, 0x000008da, 0x000008e9,
	0x000008f2, 0x00000905, 0x00000910, 0x0000093e,
	0x00000948, 0x00000951, 0x00000961, 0x00000972,
	0x00000986, 0x000009ae, 0x000009e4, 0x000009f7,
	// Entry 60 - 7F
	0x00000a21, 0x00000a4e, 0x00000a71, 0x00000aae,
	0x00000ab7, 0x00000ac3, 0x00000afc, 0x00000b15,
	0x00000b50, 0x00000b5e, 0x00000b6e, 0x00000b84,
	0x00000ba8, 0x00000bb3, 0x00000bbb, 0x00000bd8,
	0x00000bf7, 0x00000c03, 0x00000c11, 0x00000c18,
	0x00000c22, 0x00000c3d, 0x00000c4b, 0x00000c6f,
	0x00000c98, 0x00000ca3, 0x00000cd0, 0x00000cee,
	0x00000d0d, 0x00000d3d, 0x00000d77, 0x00000daa,
	// Entry 80 - 9F
	0x00000dcf, 0x00000e00, 0x00000e16, 0x00000e96,
	0x00000f3a, 0x00000f53, 0x00000fcc, 0x000010ba,
	0x000010da, 0x00001117, 0x00001143, 0x0000115e,
	0x00001186, 0x000011a4, 0x00001256, 0x000012a4,
	0x000012c4, 0x000012ec, 0x0000130a, 0x00001370,
	0x00001399, 0x000013ce, 0x000013ed, 0x0000142f,
	0x00001450, 0x00001475, 0x00001495, 0x000014c8,
	0x000014eb, 0x00001509, 0x00001527, 0x00001527,
	// Entry A0 - BF
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	// Entry C0 - DF
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	// Entry E0 - FF
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	// Entry 100 - 11F
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	0x00001527, 0x00001527, 0x00001527, 0x00001527,
	// Entry 120 - 13F
	0x00001527,
} // Size: 1180 bytes

const skData string = "" + // Size: 5415 bytes
	"\x02Chyba\x02(bez argumentu): získať administrátorské práva a nainštalov" +
	"ať službu manažéra\x02Použitie: %[1]s [\x0a%[2]s]\x02Možnosti príkazovéh" +
	"o riadku\x02Nepodarilo sa zistiť, či proces beží pod WOW64: %[1]v\x02V t" +
	"omto počítači musíte používať pôvodnú verziu programu WireGuard.\x02Nepo" +
	"darilo sa otvoriť token aktuálneho procesu: %[1]v\x02WireGuard môžu použ" +
	"ívať iba členovia Builtin skupiny %[1]s.\x02WireGuard je spustený, ale " +
	"používateľské rozhranie je prístupné iba členom Builtin skupiny %[1]s." +
	"\x02, \x02 \x02Zatvoriť\x02Stav:\x02a Deaktivovať\x02a Aktivovať\x02Vere" +
	"jný kľúč:\x02Otvorený port:\x02MTU:\x02Adresy:\x02Servery DNS:\x02Vopred" +
	" zdieľaný kľúč:\x02Povolené IP adresy:\x02Koncový bod:\x02Perzistentný k" +
	"eepalive:\x02Posledné spojenie (handshake):\x02Neaktívny\x02Deaktivuje s" +
	"a\x02Neznámy stav\x02Denník udalostí\x02&Kopírovať\x02Vybr&ať všetko\x02" +
	"Uložiť do &súboru…\x02Čas\x02Správa v denníku udalostí\x02Exportovať den" +
	"ník udalostí do súboru\x02Chyba tunela\x02%[1]s\x0a\x0aViac informácií n" +
	"ájdete v denníku udalostí.\x02Chyba ukončenia WireGuard\x02Teraz\x02Sys" +
	"témové hodiny sa vrátili v čase!\x14\x01\x81\x01\x00\x04\x0b\x02%[1]d ro" +
	"ky\x05\x0c\x02%[1]d rokov\x02\x0a\x02%[1]d rok\x00\x0c\x02%[1]d rokov" +
	"\x14\x01\x81\x01\x00\x04\x0a\x02%[1]d dni\x05\x0b\x02%[1]d dní\x02\x0b" +
	"\x02%[1]d deň\x00\x0b\x02%[1]d dní\x14\x01\x81\x01\x00\x04\x0d\x02%[1]d " +
	"hodiny\x05\x0d\x02%[1]d hodín\x02\x0d\x02%[1]d hodina\x00\x0d\x02%[1]d h" +
	"odín\x14\x01\x81\x01\x00\x04\x0e\x02%[1]d minúty\x05\x0d\x02%[1]d minút" +
	"\x02\x0e\x02%[1]d minúta\x00\x0d\x02%[1]d minút\x14\x01\x81\x01\x00\x04" +
	"\x0e\x02%[1]d sekundy\x05\x0e\x02%[1]d sekúnd\x02\x0e\x02%[1]d sekunda" +
	"\x00\x0e\x02%[1]d sekúnd\x02Pred %[1]s\x02%[1]d\u00a0B\x02%.2[1]f\u00a0K" +
	"iB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s:" +
	" %[2]q\x02Neplatná adresa IP\x02Neplatná dĺžka sieťového prefixu\x02Konc" +
	"ovému bodu chýba číslo portu\x02Neplatný hostiteľ koncového bodu\x02Nepl" +
	"atné MTU\x02Neplatný port\x02Neplatný perzistentný keepalive\x02Neplatný" +
	" kľúč: %[1]v\x02Číslo musí mať hodnotu medzi 0 a 2^64-1: %[1]v\x02Dve či" +
	"arky v poradí\x02Názov tunela nie je platný\x02[nešpecifikované]\x02Všet" +
	"ci peeri musia mať priradený verejný kľúč\x02Chyba pri získavaní konfigu" +
	"rácie\x02WireGuard ikona sa ani po 30 sekundách neobjavila na systémovej" +
	" lište.\x02Skripty:\x02Prenos:\x02pred-zapnutím\x02po-zapnutí\x02pred-vy" +
	"pnutím\x02po-vypnutí\x02zakázané, na základe pravidla\x02povolené\x02%[1" +
	"]s prijatých, %[2]s odoslaných\x02Nepodarilo sa zistiť stav tunela\x02Ne" +
	"podarilo sa aktivovať tunel\x02Nepodarilo sa deaktivovať tunel\x02Rozhra" +
	"nie: %[1]s\x02Peer\x02Vytvoriť nový tunel\x02Upraviť tunel\x02&Názov:" +
	"\x02&Verejný kľúč:\x02(neznámy)\x02&Blokovať netunelovaný prenos (kill-s" +
	"witch)\x02&Uložiť\x02Zrušiť\x02&Konfigurácia:\x02Neplatný názov\x02Názov" +
	" je povinný.\x02Názov tunela ‘%[1]s’ je neplatný.\x02Nepodarilo sa pripr" +
	"aviť zoznam existujúcich tunelov\x02Tunel už existuje\x02Tunel s názvom " +
	"‘%[1]s’ už existuje.\x02Nie je možné vytvoriť novú konfiguráciu\x02Nep" +
	"odarilo sa zapísať do súboru\x02Súbor ‘%[1]s’ už existuje.\x0a\x0aŽeláte" +
	" si ho prepísať?\x02Aktívny\x02Aktivuje sa\x02Textové súbory (*.txt)|*.t" +
	"xt|Všetky súbory (*.*)|*.*\x02Chyba detekcie WireGuard\x02Nie je možné č" +
	"akať na zobrazenie WireGuard okna: %[1]v\x02Stav: Nezámy\x02Adresa: žiad" +
	"na\x02&Spravovať tunely…\x02&Importovať tunel(y) zo súboru…\x02U&končiť" +
	"\x02&Tunely\x02Tunel %[1]s bol aktivovaný.\x02Tunel %[1]s bol deaktivova" +
	"ný.\x02Stav: %[1]s\x02Adresa: %[1]s\x02Tunely\x02&Upraviť\x02Pridať &prá" +
	"zdny tunel…\x02Pridať tunel\x02Odstrániť označený(é) tunel(y)\x02Export " +
	"všetkých tunelov do zip súboru\x02P&repnúť\x02Export všetkých tunelov do" +
	" &zip súboru…\x02Upraviť &označený tunel…\x02&Odstrániť označené tunely" +
	"\x02neboli nájdené žiadne konfiguračné súbory\x02Nepodarilo sa naimporto" +
	"vať vybrané konfigurácie: %[1]v\x02Nepodarilo sa načítať existujúce tune" +
	"ly: %[1]v\x02Už existuje tunel s názvom '%[1]s'\x02Nepodarilo sa naimpor" +
	"tovať konfiguráciu: %[1]v\x02Naimportované tunely\x14\x01\x81\x01\x00" +
	"\x04\x1c\x02Naimportované %[1]d tunely\x05\x1f\x02Naimportovaných %[1]d " +
	"tunelov\x02\x19\x02Importovaný %[1]d tunel\x00\x1f\x02Naimportovaných %[" +
	"1]d tunelov\x14\x02\x80\x01\x04%\x02Naimportované %[1]d z %[2]d tunelov" +
	"\x05'\x02Naimportovaných %[1]d z %[2]d tunelov\x02%\x02Naimportovaný %[1" +
	"]d z %[2]d tunelov\x00'\x02Naimportovaných %[1]d z %[2]d tunelov\x02Tune" +
	"l sa nedá vytvoriť\x14\x01\x81\x01\x00\x04\x19\x02Odstránene %[1]d tunel" +
	"y\x05\x1d\x02Odstránených %[1]d tunelov\x02\x19\x02Odstránený %[1]d tune" +
	"l\x00\x1d\x02Odstránených %[1]d tunelov\x14\x01\x81\x01\x00\x048\x02Ste " +
	"si istý, že si želáte odstrániť %[1]d tunely?\x059\x02Ste si istý, že si" +
	" želáte odstrániť %[1]d tunelov?\x027\x02Ste si istý, že si želáte odstr" +
	"ániť %[1]d tunel?\x009\x02Ste si istý, že si želáte odstrániť %[1]d tun" +
	"elov?\x02Odstránenie tunela ‘%[1]s’\x02Ste si istý, že si želáte odstrán" +
	"iť tunel ‘%[1]s’?\x02%[1]s Túto akciu nemôže vrátiť späť.\x02Tunel sa ne" +
	"dá odstrániť\x02Nebolo možné odstrániť tunel: %[1]s\x02Tunely sa nedajú " +
	"odstrániť\x14\x01\x81\x01\x00\x04)\x02%[1]d tunely nebolo možné odstráni" +
	"ť.\x05*\x02%[1]d tunelov nebolo možné odstrániť.\x02(\x02%[1]d tunel ne" +
	"bolo možné odstrániť.\x00*\x02%[1]d tunelov nebolo možné odstrániť.\x02K" +
	"onfirugačné súbory (*.zip, *.conf)|*.zip;*.conf|Všetky súbory (*.*)|*.*" +
	"\x02Importovať tunel(y) zo súboru\x02Konfiguračné ZIP súbry (*.zip)|*.zi" +
	"p\x02Export tunelov do zip súboru\x02Nie je možné ukončiť služby z dôvod" +
	"u: %[1]v. Skúste zastaviť WireGuard v správcovi služieb.\x02Medzi zátvor" +
	"kami musí byť IPv6 adresa\x02Dekódované kľúče musia mať veľkosť 32 bajto" +
	"v\x02Sekcia musí obsahovať čiaru\x02Konfiguračný kľúč neobsahuje separát" +
	"or (znamienko rovnosti)\x02Kľúč musí obsahovať hodnotu\x02Neplatný kľúč " +
	"sekcie [Interface]\x02Neplatný kľúč sekcie [Peer]\x02Rozhranie musí mať " +
	"priradený súkromný kľúč\x02Neplatný kľúč sekcie rozhrania\x02Verzia prot" +
	"okolu musí byť 1\x02Neplatný kľúč peer sekcie"

var slIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000058, 0x00000070,
	0x00000089, 0x000000c1, 0x00000111, 0x00000148,
	0x0000019a, 0x00000200, 0x00000203, 0x00000205,
	0x0000020b, 0x00000213, 0x00000220, 0x0000022b,
	0x00000239, 0x0000024c, 0x00000251, 0x0000025a,
	0x0000026a, 0x00000280, 0x00000291, 0x000002a1,
	0x000002bd, 0x000002cf, 0x000002d9, 0x000002e7,
	0x000002f6, 0x000002fe, 0x00000307, 0x00000313,
	// Entry 20 - 3F
	0x0000032b, 0x00000330, 0x00000346, 0x00000360,
	0x0000036e, 0x0000039d, 0x000003bd, 0x000003c2,
	0x000003e1, 0x00000419, 0x00000450, 0x00000484,
	0x000004c4, 0x00000508, 0x00000514, 0x0000051d,
	0x0000052a, 0x00000537, 0x00000544, 0x00000551,
	0x0000055e, 0x00000571, 0x00000595, 0x000005b7,
	0x000005e0, 0x000005ed, 0x000005fc, 0x00000620,
	0x00000637, 0x0000066b, 0x00000680, 0x00000697,
	// Entry 40 - 5F
	0x000006a5, 0x000006cc, 0x000006ec, 0x00000730,
	0x00000739, 0x00000741, 0x00000751, 0x0000075f,
	0x00000771, 0x00000781, 0x0000079f, 0x000007aa,
	0x000007c7, 0x000007eb, 0x00000809, 0x00000829,
	0x00000838, 0x00000840, 0x00000852, 0x0000085e,
	0x00000864, 0x00000873, 0x0000087d, 0x000008a7,
	0x000008af, 0x000008b9, 0x000008c9, 0x000008d6,
	0x000008e6, 0x00000908, 0x00000938, 0x0000094a,
	// Entry 60 - 7F
	0x00000975, 0x0000099c, 0x000009ba, 0x000009f5,
	0x000009fd, 0x00000a09, 0x00000a41, 0x00000a5e,
	0x00000a99, 0x00000aa8, 0x00000ab6, 0x00000acd,
	0x00000aec, 0x00000af3, 0x00000afb, 0x00000b19,
	0x00000b39, 0x00000b47, 0x00000b56, 0x00000b5d,
	0x00000b64, 0x00000b7d, 0x00000b89, 0x00000ba1,
	0x00000bb9, 0x00000bc3, 0x00000be1, 0x00000bfa,
	0x00000c13, 0x00000c38, 0x00000c66, 0x00000c99,
	// Entry 80 - 9F
	0x00000cbe, 0x00000ce4, 0x00000cf4, 0x00000d58,
	0x00000de3, 0x00000e04, 0x00000e69, 0x00000f56,
	0x00000f71, 0x00000fac, 0x00000fd7, 0x00000ff1,
	0x00001019, 0x00001034, 0x000010e8, 0x00001135,
	0x0000114e, 0x00001179, 0x00001196, 0x00001203,
	0x00001229, 0x0000125a, 0x00001275, 0x000012a4,
	0x000012bf, 0x000012e4, 0x00001304, 0x00001326,
	0x00001348, 0x00001366, 0x00001388, 0x00001388,
	// Entry A0 - BF
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	// Entry C0 - DF
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	// Entry E0 - FF
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	// Entry 100 - 11F
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	0x00001388, 0x00001388, 0x00001388, 0x00001388,
	// Entry 120 - 13F
	0x00001388,
} // Size: 1180 bytes

const slData string = "" + // Size: 5000 bytes
	"\x02Napaka\x02(brez argumenta): povzdigni na skrbniške pravice in namest" +
	"i skrbniško storitev\x02Uporaba: %[1]s [\x0a%[2]s]\x02Možnosti ukazne vr" +
	"stice\x02Napaka pri določanju ali proces teče kot WOW64: %[1]v\x02Na tem" +
	"u računalniku morate uporabiti enako-arhitekturno različico WireGuarda." +
	"\x02Napaka pri odpiranju žetona trenutnega procesa: %[1]v\x02WireGuard l" +
	"ahko uporabljajo samo uporabniki, ki so člani vgrajene skupine %[1]s." +
	"\x02WireGuard je zagnan, vendar je up. vmesnik dostopen samo z namizij u" +
	"porabnikov članov skupine %[1]s.\x02, \x02 \x02Zapri\x02Status:\x02&Deak" +
	"tiviraj\x02&Aktiviraj\x02Javni ključ:\x02Vrata poslušanja:\x02MTU:\x02Na" +
	"slovi:\x02Strežniki DNS:\x02Ključ v skupni rabi:\x02Dovoljeni IP-ji:\x02" +
	"Končna točka:\x02Trajno ohranjanje povezave:\x02Zadnje rokovanje:\x02Nea" +
	"ktivno\x02Se deaktivira\x02Neznano stanje\x02Dnevnik\x02&Kopiraj\x02&Izb" +
	"eri vse\x02&Shrani v datoteko\u00a0…\x02Čas\x02Sporočilo v dnevniku\x02I" +
	"zvozi dnevnik v datoteko\x02Napaka tunela\x02%[1]s\x0a\x0aDodatne inform" +
	"acije najdete v dnevniku.\x02Napaka pri izhodu iz WireGuarda\x02Zdaj\x02" +
	"Sistemska ura prevrtena nazaj!\x14\x01\x81\x01\x00\x04\x0b\x02%[1]d leta" +
	"\x02\x0b\x02%[1]d leto\x03\x0b\x02%[1]d leti\x00\x0a\x02%[1]d let\x14" +
	"\x01\x81\x01\x00\x04\x0a\x02%[1]d dni\x02\x0a\x02%[1]d dan\x03\x0c\x02%[" +
	"1]d dneva\x00\x0a\x02%[1]d dni\x14\x01\x81\x01\x00\x04\x0a\x02%[1]d ure" +
	"\x02\x0a\x02%[1]d uro\x03\x0a\x02%[1]d uri\x00\x09\x02%[1]d ur\x14\x01" +
	"\x81\x01\x00\x04\x0d\x02%[1]d minute\x02\x0d\x02%[1]d minuto\x03\x0d\x02" +
	"%[1]d minuti\x00\x0c\x02%[1]d minut\x14\x01\x81\x01\x00\x04\x0e\x02%[1]d" +
	" sekunde\x02\x0e\x02%[1]d sekundo\x03\x0e\x02%[1]d sekundi\x00\x0d\x02%[" +
	"1]d sekund\x02%[1]s nazaj\x02%[1]d\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f" +
	"\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Nap" +
	"ačen naslov IP\x02Napačna dolžina predpone omrežja\x02Pri končni točki m" +
	"anjkajo vrata\x02Pri končni točki je gostitelj napačen\x02Napačen MTU" +
	"\x02Napačna vrata\x02Napačno trajno ohranjanje povezave\x02Napačen ključ" +
	": %[1]v\x02Številka mora biti število med 0 in 2^64-1: %[1]v\x02Dve zapo" +
	"redni vejici\x02Ime tunela ni veljavno\x02[ni navedeno]\x02Vsi vrstniki " +
	"morajo imeti javni ključ\x02Napaka pri branju konfiguracije\x02Ikona Wir" +
	"eGuarda se po 30 sekundah ni pojavila v sistemski vrstici.\x02Skripta:" +
	"\x02Prenos:\x02pred-aktivacijo\x02po-aktivaciji\x02pred-deaktivacijo\x02" +
	"po-deaktivaciji\x02onemogočeno, zaradi politike\x02omogočeno\x02%[1]s pr" +
	"ejeto, %[2]s poslano\x02Napaka pri določanju stanja tunela\x02Napaka pri" +
	" aktiviranju tunela\x02Napaka pri deaktiviranju tunela\x02Vmesnik: %[1]s" +
	"\x02Vrstnik\x02Ustvari nov tunel\x02Uredi tunel\x02&Ime:\x02&Javni ključ" +
	":\x02(neznano)\x02&Blokiraj promet izven tunela (varovalka)\x02&Shrani" +
	"\x02Prekliči\x02&Konfiguracija:\x02Napačno ime\x02Ime je obvezno.\x02Ime" +
	" tunela »%[1]s« ni veljavno.\x02Napaka pri pripravi seznama obstoječih t" +
	"unelov\x02Tunel že obstaja\x02Drug tunel z imenom »%[1]s« že obstaja." +
	"\x02Napaka pri izdelavi nove konfiguracije\x02Napaka pri pisanju v datot" +
	"eko\x02Datoteka »%[1]s« že obstaja.\x0a\x0aAli jo želite prepisati?\x02A" +
	"ktivno\x02Se aktivira\x02Tekstovne datoteke (*.txt)|*.txt|Vse datoteke (" +
	"*.*)|*.*\x02Napaka zaznavanja WireGuarda\x02Čakanje, da se pojavi WireGu" +
	"ardovo okno, ni možno: %[1]v\x02Status: Neznan\x02Naslovi: Brez\x02&Upra" +
	"vljaj tunele\u00a0…\x02&Uvozi tunel(e) iz datoteke…\x02I&zhod\x02&Tuneli" +
	"\x02Tunel %[1]s je bil aktiviran.\x02Tunel %[1]s je bil deaktiviran.\x02" +
	"Status: %[1]s\x02Naslovi: %[1]s\x02Tuneli\x02&Uredi\x02Dodaj &prazen tun" +
	"el\u00a0…\x02Dodaj tunel\x02Odstrani izbrane tunele\x02Izvozi vse tunele" +
	" v zip\x02&Preklopi\x02Izvozi vse tunele v &zip\u00a0…\x02Uredi &izbran " +
	"tunel\u00a0…\x02Odst&rani izbrane tunele\x02ni najdenih konfiguracijskih" +
	" datotek\x02Napaka pri uvozu izbrane konfiguracije: %[1]v\x02Napaka pri " +
	"preštevanju obstoječih tunelov: %[1]v\x02Tunel z imenom »%[1]s« že obsta" +
	"ja\x02Napaka pri uvozu konfiguracije: %[1]v\x02Uvoženi tuneli\x14\x01" +
	"\x81\x01\x00\x04\x16\x02Uvoženi %[1]d tuneli\x02\x14\x02Uvožen %[1]d tun" +
	"el\x03\x16\x02Uvožena %[1]d tunela\x00\x17\x02Uvoženo %[1]d tunelov\x14" +
	"\x02\x80\x01\x04 \x02Uvoženi %[1]d od %[2]d tunelov\x02\x1f\x02Uvožen %[" +
	"1]d od %[2]d tunelov\x03 \x02Uvožena %[1]d od %[2]d tunelov\x00 \x02Uvož" +
	"eno %[1]d od %[2]d tunelov\x02Tunela ni bilo mogoče ustvariti\x14\x01" +
	"\x81\x01\x00\x04\x16\x02Izbriši %[1]d tunele\x02\x15\x02Izbriši %[1]d tu" +
	"nel\x03\x16\x02Izbriši %[1]d tunela\x00\x17\x02Izbriši %[1]d tunelov\x14" +
	"\x01\x81\x01\x00\x048\x02Ali ste prepričani, da želite izbrisati %[1]d t" +
	"unele?\x027\x02Ali ste prepričani, da želite izbrisati %[1]d tunel?\x038" +
	"\x02Ali ste prepričani, da želite izbrisati %[1]d tunela?\x009\x02Ali st" +
	"e prepričani, da želite izbrisati %[1]d tunelov?\x02Izbriši tunel ‘%[1]s" +
	"’\x02Ali ste prepričani, da želite izbrisati tunel »%[1]s«?\x02%[1]s T" +
	"ega dejanja ne morete razveljaviti.\x02Napaka pri izbrisu tunela\x02Napa" +
	"ka pri odstranjevanju tunela: %[1]s\x02Napaka pri izbrisu tunelov\x14" +
	"\x01\x81\x01\x00\x04*\x02%[1]d tunelov ni bilo mogoče odstraniti.\x02)" +
	"\x02%[1]d tunela ni bilo mogoče odstraniti.\x03*\x02%[1]d tunelov ni bil" +
	"o mogoče odstraniti.\x00*\x02%[1]d tunelov ni bilo mogoče odstraniti." +
	"\x02Konfiguracijske datoteke (*.zip, *.conf)|*.zip;*.conf|Vse datoteke (" +
	"*.*)|*.*\x02Uvozi tunele iz datoteke\x02Konfiguracijske datoteke ZIP (*." +
	"zip)|*.zip\x02Izvozi tunele v datoteko zip\x02Storitve ni bilo mogoče za" +
	"ustaviti, ker: %[1]v. Poskusite zaustaviti WireGuard z uporabo programa " +
	"Storitve.\x02Oklepaji morajo vsebovati naslov IPv6\x02Dekodirani ključi " +
	"morajo biti natanko 32 bajtov\x02Vrstica mora biti v odseku\x02Ključu v " +
	"konfiguraciji manjka ločilo enačaj\x02Ključ mora imeti vrednost\x02Napač" +
	"en ključ za odsek [Interface]\x02Napačen ključ za odsek [Peer]\x02Vmesni" +
	"k mora imeti zasebni ključ\x02Napačen ključ za odsek vmesnika\x02Verzija" +
	" protokola mora biti 1\x02Napačen ključ za odsek vrstnika"

var trIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000005, 0x0000004c, 0x00000066,
	0x00000082, 0x000000c6, 0x0000010b, 0x00000136,
	0x0000018e, 0x0000022f, 0x00000232, 0x00000235,
	0x0000023b, 0x00000242, 0x00000258, 0x00000266,
	0x00000276, 0x00000285, 0x0000028a, 0x00000294,
	0x000002a5, 0x000002c7, 0x000002dd, 0x000002e8,
	0x000002ff, 0x00000315, 0x00000322, 0x0000033f,
	0x00000350, 0x00000359, 0x00000366, 0x00000376,
	// Entry 20 - 3F
	0x0000038d, 0x00000393, 0x000003a4, 0x000003c6,
	0x000003d5, 0x00000412, 0x0000042e, 0x00000435,
	0x00000456, 0x00000475, 0x00000494, 0x000004b3,
	0x000004d6, 0x000004f9, 0x00000505, 0x0000050e,
	0x0000051b, 0x00000528, 0x00000535, 0x00000542,
	0x0000054f, 0x00000563, 0x00000582, 0x0000059e,
	0x000005b2, 0x000005c0, 0x000005cf, 0x000005f2,
	0x0000060b, 0x00000640, 0x00000655, 0x00000671,
	// Entry 40 - 5F
	0x0000068f, 0x000006bc, 0x000006ec, 0x00000728,
	0x0000073a, 0x00000744, 0x00000757, 0x0000076b,
	0x00000784, 0x0000079e, 0x000007b3, 0x000007b9,
	0x000007db, 0x000007f7, 0x00000812, 0x00000837,
	0x00000847, 0x0000084b, 0x00000860, 0x00000871,
	0x00000879, 0x0000088a, 0x00000897, 0x000008ca,
	0x000008d2, 0x000008d9, 0x000008ea, 0x000008f9,
	0x0000090b, 0x0000092e, 0x0000094e, 0x00000962,
	// Entry 60 - 7F
	0x00000990, 0x000009b6, 0x000009c9, 0x00000a08,
	0x00000a0e, 0x00000a21, 0x00000a58, 0x00000a71,
	0x00000aa5, 0x00000ab7, 0x00000ac5, 0x00000adf,
	0x00000b06, 0x00000b11, 0x00000b20, 0x00000b40,
	0x00000b6a, 0x00000b77, 0x00000b87, 0x00000b91,
	0x00000b97, 0x00000bb0, 0x00000bbc, 0x00000bd8,
	0x00000c00, 0x00000c0c, 0x00000c38, 0x00000c56,
	0x00000c73, 0x00000c97, 0x00000cca, 0x00000cf9,
	// Entry 80 - 9F
	0x00000d26, 0x00000d51, 0x00000d6c, 0x00000db1,
	0x00000e01, 0x00000e1a, 0x00000e47, 0x00000eb6,
	0x00000ed0, 0x00000f0b, 0x00000f30, 0x00000f43,
	0x00000f66, 0x00000f7c, 0x00000fc3, 0x00001012,
	0x00001031, 0x0000105b, 0x0000107e, 0x000010e9,
	0x00001112, 0x00001144, 0x00001161, 0x00001198,
	0x000011ba, 0x000011e8, 0x00001211, 0x0000123f,
	0x00001267, 0x0000128a, 0x000012ad, 0x000012ad,
	// Entry A0 - BF
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	// Entry C0 - DF
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	// Entry E0 - FF
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	// Entry 100 - 11F
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	0x000012ad, 0x000012ad, 0x000012ad, 0x000012ad,
	// Entry 120 - 13F
	0x000012ad,
} // Size: 1180 bytes

const trData string = "" + // Size: 4781 bytes
	"\x02Hata\x02(argüman verilmediyse): gerekli izinleri al ve yönetim hizme" +
	"tini kur\x02Kullanım: %[1]s [\x0a%[2]s]\x02Komut Satırı Seçenekleri\x02İ" +
	"şlemin WOW64 altında çalıştığından emin olunamadı: %[1]v\x02Bu bilgisay" +
	"arda WireGuard'ın yerel sürümünü kullanmanız gerek.\x02Şu anki işlem jet" +
	"onu açılamadı: %[1]v\x02WireGuard sadece sisteme yerleşik %[1]s grubunun" +
	" üyeleri tarafından kullanılabilir.\x02WireGuard çalışıyor, fakat kullan" +
	"ıcı arayüzü sadece sisteme yerleşik %[1]s grubunun üyesi olan kullanıcı" +
	"lar tarafından masaüstünde erişilebilir.\x02, \x02, \x02Kapat\x02Durum:" +
	"\x02&Devre dışı bırak\x02&Etkinleştir\x02Açık anahtar:\x02Dinlenen port:" +
	"\x02MTU:\x02Adresler:\x02DNS sunucuları:\x02Önceden paylaşılmış anahtar:" +
	"\x02İzin verilen IP'ler:\x02Uç nokta:\x02Kalıcı açık tutma:\x02En son el" +
	" sıkışma:\x02Etkin değil\x02Devre dışı bırakılıyor\x02Durum bilinmiyor" +
	"\x02Günlük\x02Kopyala (&c)\x02&tümünü seç\x02Dosyaya kaydet (&s)…\x02Zam" +
	"an\x02Günlük mesajı\x02Günlük dosyasını dışa aktar\x02Tünel Hatası\x02%[" +
	"1]s\x0a\x0aLütfen daha fazla bilgi için günlüğe göz atın.\x02WireGuard Ç" +
	"ıkış Hatası\x02Şimdi\x02Sistem saati geriye sarılmış!\x14\x01\x81\x01" +
	"\x00\x02\x0b\x02%[1]d yıl\x00\x0b\x02%[1]d yıl\x14\x01\x81\x01\x00\x02" +
	"\x0b\x02%[1]d gün\x00\x0b\x02%[1]d gün\x14\x01\x81\x01\x00\x02\x0b\x02%[" +
	"1]d saat\x00\x0b\x02%[1]d saat\x14\x01\x81\x01\x00\x02\x0d\x02%[1]d daki" +
	"ka\x00\x0d\x02%[1]d dakika\x14\x01\x81\x01\x00\x02\x0d\x02%[1]d saniye" +
	"\x00\x0d\x02%[1]d saniye\x02%[1]s önce\x02%[1]d\u00a0B\x02%.2[1]f\u00a0K" +
	"iB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s:" +
	" %[2]q\x02Geçersiz IP adresi\x02Ağ öneki uzunluğu geçersiz\x02Uç nokta p" +
	"ort ayarı eksik\x02Geçersiz uç nokta\x02Geçersiz MTU\x02Geçersiz port" +
	"\x02Geçersiz kalıcı açık bırakma\x02Geçersiz anahtar: %[1]v\x02Sayı 0 ve" +
	" 2^64-1 arasında bir sayı olmalı: %[1]v\x02Yan yana iki virgül\x02Tünel " +
	"adı geçerli değil\x02[hiçbir şey belirtilmemiş}\x02Tüm eşler açık anahta" +
	"rlara sahip olmalı\x02Yapılandırma bilgisi alınırken hata oluştu\x02Wire" +
	"Guard sistem tepsisi ikonu 30 saniye sonunda belirmedi.\x02Komut dosyala" +
	"rı:\x02Aktarım:\x02bağlantı-öncesi\x02bağlantı-sonrası\x02bağlantı-kesme" +
	"-öncesi\x02bağlantı-kesme-sonrası\x02ilke gereği kapalı\x02etkin\x02%[1]" +
	"s alındı, %[2]s gönderildi\x02Tünel durumu belirlenemedi\x02Tünel etkinl" +
	"eştirilemedi\x02Tünel devre dışı bırakılamadı\x02Arabirim: %[1]s\x02Eş" +
	"\x02Yeni tünel oluştur\x02Tüneli düzenle\x02&İsim:\x02&Açık anahtar:\x02" +
	"(bilinmiyor)\x02&Tünelden geçmeyen trafiği durdur (kill-switch)\x02&Kayd" +
	"et\x02İptal\x02&Yapılandırma:\x02Geçersiz isim\x02Bir isim gerekli.\x02`" +
	"%[1]s` geçersiz bir tünel ismi.\x02Mevcut tüneller listelenemiyor\x02Tün" +
	"el zaten mevcut\x02‘%[1]s’ adında başka bir tünel mevcut.\x02Yeni yapıla" +
	"ndırma oluşturulamıyor\x02Dosya yazılamadı\x02`%[1]s` dosyası zaten mevc" +
	"ut.\x0a\x0aÜzerine yazmak ister misiniz?\x02Etkin\x02Etkinleştiriliyor" +
	"\x02Metin Dosyaları (*.txt)|*.txt|Tüm Dosyalar (*.*)|*.*\x02WireGuard Te" +
	"spit Hatası\x02WireGuard penceresinin belirmesi beklenemedi: %[1]v\x02Du" +
	"rum: Bilinmiyor\x02Adresler: Yok\x02Tünelleri yönet (&m)…\x02Dosyadan tü" +
	"nelleri içe aktar (&i)…\x02Çık (&x)\x02Tüneller (&t)\x02%[1]s tüneli etk" +
	"inleştirildi.\x02%[1]s tüneli devre dışı bırakıldı.\x02Durum: %[1]s\x02A" +
	"dresler: %[1]s\x02Tüneller\x02&Edit\x02Boş tünel ekle (&e)…\x02Tünel Ekl" +
	"e\x02Seçilen tünelleri kaldır\x02Tüm tünelleri zip olarak dışa aktar\x02" +
	"&Değiştir\x02Tüm tünelleri &zip olarak dışa aktar…\x02&Seçilen tüneli dü" +
	"zenle…\x02S&eçilen tünelleri kaldır\x02yapılandırma dosyası bulunamadı" +
	"\x02Seçilen yapılandırma içe aktarılamadı: %[1]v\x02Mevcut tüneller numa" +
	"ralandırılamadı: %[1]v\x02‘%[1]s’ adında başka bir tünel mevcut\x02Yapıl" +
	"andırma içe aktarılamıyor: %[1]v\x02Tüneller içe aktarıldı\x14\x01\x81" +
	"\x01\x00\x02\x1e\x02%[1]d tünel içe aktarıldı\x00\x1e\x02%[1]d tünel içe" +
	" aktarıldı\x14\x02\x80\x01\x02$\x02%[2]d/%[1]d tünel içe aktarıldı\x00$" +
	"\x02%[2]d/%[1]d tünel içe aktarıldı\x02Tünel oluşturulamıyor\x14\x01\x81" +
	"\x01\x00\x02\x12\x02%[1]d tüneli sil\x00\x12\x02%[1]d tüneli sil\x14\x01" +
	"\x81\x01\x00\x023\x02%[1]d tüneli silmek istediğinizden emin misiniz?" +
	"\x003\x02%[1]d tüneli silmek istediğinizden emin misiniz?\x02‘%[1]s’ tün" +
	"elini sil\x02‘%[1]s’ tünelini silmek istediğinizden emin misiniz?\x02%[1" +
	"]s Bu işlemi geri alamazsınız.\x02Tünel silinemiyor\x02Bir tünel kaldırı" +
	"lamadı: %[1]s\x02Tüneller silinemiyor\x14\x01\x81\x01\x00\x02\x1f\x02%[1" +
	"]d tünel kaldırılamadı.\x00\x1f\x02%[1]d tünel kaldırılamadı.\x02Yapılan" +
	"dırma Dosyaları (*.zip, *.conf)|*.zip;*.conf|Tüm Dosyalar (*.*)|*.*\x02T" +
	"ünelleri dosyadan içe aktar\x02Yapılandırma ZIP Dosyası (*.zip)|*.zip" +
	"\x02Tünelleri zip olarak dışa aktar\x02Hizmet şu nedenden dolayı kapatıl" +
	"amıyor: %[1]v. WireGuard'ı hizmet yöneticisinden durdurabilirsiniz.\x02P" +
	"arantezler bir IPv6 adresi içermelidir\x02Anahtarlar çözüldüğünde tam 32" +
	" byte olmalı\x02Satır bir bölümde olmalı\x02Yapılandırma anahtarında eşi" +
	"ttir operatörü eksik\x02Anahtar bir değere sahip olmalı\x02[Interface] b" +
	"ölümü için geçersiz anahtar\x02[Peer] bölümü için geçersiz anahtar\x02B" +
	"ir arabirim gizli anahtara sahip olmalıdır\x02Arabirim bölümünde geçersi" +
	"z anahtar\x02Protokol sürümü 1 olmak zorunda\x02Eş bölümünde geçersiz an" +
	"ahtar"

var ukIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x0000000f, 0x0000008e, 0x000000b7,
	0x000000ea, 0x00000144, 0x000001c2, 0x0000021b,
	0x000002b7, 0x00000339, 0x0000033c, 0x0000033f,
	0x0000034e, 0x0000035c, 0x00000376, 0x0000038c,
	0x000003a9, 0x000003b3, 0x000003b8, 0x000003c6,
	0x000003da, 0x000003ee, 0x00000412, 0x0000041c,
	0x00000432, 0x0000045d, 0x0000045d, 0x0000045d,
	0x0000045d, 0x0000045d, 0x0000045d, 0x0000045d,
	// Entry 20 - 3F
	0x0000045d, 0x0000045d, 0x0000045d, 0x0000045d,
	0x0000045d, 0x0000045d, 0x0000045d, 0x00000468,
	0x000004bb, 0x000004bb, 0x000004bb, 0x000004bb,
	0x000004bb, 0x000004bb, 0x000004ca, 0x000004d3,
	0x000004e0, 0x000004ed, 0x000004fa, 0x00000507,
	0x00000514, 0x00000535, 0x00000571, 0x000005ac,
	0x000005e4, 0x000005fb, 0x00000617, 0x00000647,
	0x0000066a, 0x000006b6, 0x000006d5, 0x00000702,
	// Entry 40 - 5F
	0x00000727, 0x00000773, 0x000007b5, 0x0000080c,
	0x0000081c, 0x0000082e, 0x0000084a, 0x00000864,
	0x00000880, 0x0000089a, 0x000008d7, 0x000008ea,
	0x0000091f, 0x0000095c, 0x00000992, 0x000009cc,
	0x000009e6, 0x000009ed, 0x00000a16, 0x00000a38,
	0x00000a45, 0x00000a63, 0x00000a78, 0x00000ab1,
	0x00000ac3, 0x00000ad6, 0x00000af1, 0x00000b04,
	0x00000b2d, 0x00000b60, 0x00000ba7, 0x00000bc6,
	// Entry 60 - 7F
	0x00000bff, 0x00000bff, 0x00000bff, 0x00000bff,
	0x00000bff, 0x00000bff, 0x00000bff, 0x00000bff,
	0x00000bff, 0x00000bff, 0x00000bff, 0x00000bff,
	0x00000bff, 0x00000bff, 0x00000bff, 0x00000bff,
	0x00000bff, 0x00000bff, 0x00000bff, 0x00000bff,
	0x00000bff, 0x00000bff, 0x00000bff, 0x00000bff,
	0x00000bff, 0x00000bff, 0x00000bff, 0x00000bff,
	0x00000bff, 0x00000c3b, 0x00000c95, 0x00000ce5,
	// Entry 80 - 9F
	0x00000d1d, 0x00000d68, 0x00000d8c, 0x00000e45,
	0x00000e45, 0x00000e45, 0x00000e45, 0x00000e45,
	0x00000e45, 0x00000e45, 0x00000e45, 0x00000e45,
	0x00000e45, 0x00000e45, 0x00000e45, 0x00000e45,
	0x00000e45, 0x00000e45, 0x00000e45, 0x00000e45,
	0x00000e80, 0x00000ec2, 0x00000f08, 0x00000f63,
	0x00000f95, 0x00000fcd, 0x00001000, 0x00001047,
	0x0000108e, 0x000010c8, 0x000010fb, 0x000010fb,
	// Entry A0 - BF
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	// Entry C0 - DF
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	// Entry E0 - FF
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	// Entry 100 - 11F
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	0x000010fb, 0x000010fb, 0x000010fb, 0x000010fb,
	// Entry 120 - 13F
	0x000010fb,
} // Size: 1180 bytes

const ukData string = "" + // Size: 4347 bytes
	"\x02Помилка\x02(немає аргумента): отримати права аднімістратора і встано" +
	"вити службу\x02Використання: %[1]s [\x0a%[2]s]\x02Параметри командного " +
	"рядка\x02Неможливо визначити, чи працює процес під WOW64: %[1]v\x02Ви п" +
	"овинні використовувати нативну версію WireGuard на цьому комп'ютері." +
	"\x02Не вдалося відкрити токен поточного процесу: %[1]v\x02WireGuard може" +
	" бути використаний тільки користувачами, які є членами вбудованих %[1]s " +
	"груп.\x02WireGuard запущено, але UI доступний лише з комп\x22ютерів вбу" +
	"дованої %[1]s групи.\x02, \x02, \x02Закрити\x02Статус:\x02&Деактивувати" +
	"\x02&Активувати\x02Відкритий ключ:\x02Порт:\x02MTU:\x02Адреси:\x02DNS-се" +
	"рвери:\x02Preshared ключ:\x02Дозволені IP адреси:\x02Endpoint:\x02Persi" +
	"stent keepalive:\x02Останнє рукостискання:\x02Зараз\x02Системний годинни" +
	"к налаштований некоректно!\x02%[1]s тому\x02%[1]d Б\x02%.2[1]f КБ\x02%." +
	"2[1]f МБ\x02%.2[1]f ГБ\x02%.2[1]f ТБ\x02%[1]s: %[2]q\x02Недійсна IP-адре" +
	"са\x02Невірна довжина префіксу мережі\x02Відсутній порт з кінцевої точк" +
	"и\x02Недійсний хост кінцевої точки\x02Недійсний MTU\x02Недійсний порт" +
	"\x02Некоректне значення keepalive\x02Недійсний ключ: %[1]v\x02Номер пови" +
	"нен бути числом від 0 до 2^64-1: %[1]v\x02Дві коми поспіль\x02Назва тун" +
	"елю некоректна\x02[жодного не вказано]\x02Всі учасники повинні мати від" +
	"криті ключі\x02Помилка при отриманні конфігурації\x02Значок системи Wir" +
	"eGuard не з'явився через 30 секунд.\x02Скрипти:\x02Передано:\x02перед-за" +
	"пуском\x02після-запуску\x02перед-зупинкою\x02після-зупинки\x02вимкнено," +
	" відповідно до політики\x02увімкнено\x02%[1]s отримано, %[2]s відправлен" +
	"о\x02Не вдалося визначити стан тунелю\x02Не вдалося активувати тунель" +
	"\x02Не вдалося деактивувати тунель\x02Інтерфейс: %[1]s\x02Пір\x02Створит" +
	"и новий тунель\x02Редагувати тунель\x02&Назва:\x02&Публічний ключ:\x02(" +
	"невідомий)\x02&Блокувати трафік поза тунелем\x02&Зберегти\x02Скасувати" +
	"\x02&Налаштування:\x02Хибне ім'я\x02Необхідно ввести ім'я.\x02Ім'я тунел" +
	"ю '%[1]s' некоректне.\x02Не вдалося відобразити існуючі тунелі\x02Тунел" +
	"ь вже існує\x02Тунель з ім'ям ‘%[1]s’ вже існує.\x02не знайдено файлів " +
	"конфігурації\x02Не вдалося імпортувати вибрану конфігурацію: %[1]v\x02Н" +
	"е вдалося перерахувати існуючі тунелі: %[1]v\x02Тунель з ім'ям ‘%[1]s’ " +
	"вже існує\x02Не вдалося імпортувати конфігурацію: %[1]v\x02Імпортовано " +
	"тунелі\x14\x01\x81\x01\x00\x04*\x02Імпортовано %[1]d тунелі\x05,\x02Імп" +
	"ортовано %[1]d тунелів\x02*\x02Імпортовано %[1]d тунель\x00,\x02Імпорто" +
	"вано %[1]d тунелів\x02Дужки повинні містити адресу IPv6\x02Ключ повинен" +
	" декодуватись до 32 байт\x02Рядок повинен бути вказаним у розділі\x02Клю" +
	"ч конфігурації відсутній роздільник рівності\x02Ключ повинен мати значе" +
	"ння\x02Хибний ключ для [Interface] розділу\x02Хибний ключ для [Peer] ро" +
	"зділу\x02Інтерфейс повинен мати особистий ключ\x02Недійсний ключ для ро" +
	"зділу інтерфейсу\x02Версія протоколу повинна бути 1\x02Хибний ключ для " +
	"[Peer] розділу"

var viIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x00000006, 0x00000006,
	0x00000006, 0x00000006, 0x00000006, 0x00000006,
	0x00000006, 0x00000006, 0x00000006, 0x00000006,
	0x0000000d, 0x0000001c, 0x0000001c, 0x0000001c,
	0x0000001c, 0x0000001c, 0x0000001c, 0x0000001c,
	0x0000001c, 0x0000001c, 0x0000001c, 0x0000002b,
	0x0000002b, 0x0000002b, 0x0000002b, 0x0000002b,
	0x0000002b, 0x0000002b, 0x0000002b, 0x0000002b,
	// Entry 20 - 3F
	0x0000002b, 0x0000002b, 0x0000002b, 0x0000002b,
	0x0000002b, 0x0000002b, 0x0000002b, 0x00000036,
	0x00000036, 0x00000048, 0x0000005b, 0x0000006e,
	0x00000081, 0x00000094, 0x000000a3, 0x000000a3,
	0x000000a3, 0x000000a3, 0x000000a3, 0x000000a3,
	0x000000a3, 0x000000c5, 0x000000c5, 0x000000c5,
	0x000000c5, 0x000000c5, 0x000000e5, 0x000000e5,
	0x000000e5, 0x000000e5, 0x000000e5, 0x00000100,
	// Entry 40 - 5F
	0x00000100, 0x00000100, 0x00000100, 0x00000100,
	0x00000100, 0x00000100, 0x00000100, 0x00000100,
	0x00000100, 0x00000100, 0x00000100, 0x00000112,
	0x0000012c, 0x00000158, 0x00000176, 0x00000197,
	0x00000197, 0x000001aa, 0x000001b4, 0x000001c6,
	0x000001c6, 0x000001c6, 0x000001c6, 0x000001c6,
	0x000001c6, 0x000001cc, 0x000001cc, 0x000001e3,
	0x000001fb, 0x00000221, 0x00000242, 0x00000257,
	// Entry 60 - 7F
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	// Entry 80 - 9F
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	// Entry A0 - BF
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	// Entry C0 - DF
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	// Entry E0 - FF
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	// Entry 100 - 11F
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	0x00000284, 0x00000284, 0x00000284, 0x00000284,
	// Entry 120 - 13F
	0x00000284,
} // Size: 1180 bytes

const viData string = "" + // Size: 644 bytes
	"\x02Lỗi\x02Đóng\x02Trạng thái:\x02Đầu cuối:\x02Vừa xong\x14\x01\x81\x01" +
	"\x00\x00\x0b\x02%[1]d năm\x14\x01\x81\x01\x00\x00\x0c\x02%[1]d ngày\x14" +
	"\x01\x81\x01\x00\x00\x0c\x02%[1]d giờ\x14\x01\x81\x01\x00\x00\x0c\x02%[1" +
	"]d phút\x14\x01\x81\x01\x00\x00\x0c\x02%[1]d giây\x02%[1]s trước\x02Địa " +
	"chỉ IP không hợp lệ\x02Cổng (port) không hợp lệ\x02Tên VPN không hợp lệ" +
	"\x02đã kích hoạt\x02Nhận %[1]s, gứi %[2]s\x02Không thể xác định tình trạ" +
	"ng VPN\x02Không thể kích hoạt VPN\x02Không thể vô hiệu hóa VPN\x02Mạng n" +
	"gang hàng\x02Tạo VPN\x02Chỉnh sửa VPN\x02Huỷ\x02Tên không hợp lệ\x02Yêu " +
	"cầu nhập tên.\x02Tên VPN ‘%[1]s' không hợp lệ.\x02Không thể liệt kê các " +
	"VPN\x02VPN đã tồn tại\x02Đã tồn tại VPN với tên ‘%[1]s’."

var zh_CNIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000030, 0x00000047,
	0x00000057, 0x0000008b, 0x000000c9, 0x000000ef,
	0x00000134, 0x0000018e, 0x00000192, 0x00000194,
	0x0000019b, 0x000001a3, 0x000001af, 0x000001bb,
	0x000001c3, 0x000001d1, 0x000001d6, 0x000001de,
	0x000001ed, 0x000001fe, 0x0000020c, 0x00000214,
	0x00000228, 0x0000023c, 0x00000246, 0x00000253,
	0x0000025a, 0x00000261, 0x0000026d, 0x00000279,
	// Entry 20 - 3F
	0x00000288, 0x0000028f, 0x0000029c, 0x000002a9,
	0x000002b6, 0x000002dc, 0x000002f7, 0x000002fe,
	0x00000317, 0x00000328, 0x00000339, 0x0000034d,
	0x00000361, 0x00000372, 0x0000037c, 0x00000384,
	0x00000391, 0x0000039e, 0x000003ab, 0x000003b8,
	0x000003c5, 0x000003d4, 0x000003ed, 0x0000040f,
	0x00000436, 0x00000441, 0x0000044e, 0x00000467,
	0x0000047f, 0x000004ad, 0x000004c6, 0x000004d9,
	// Entry 40 - 5F
	0x000004e5, 0x00000507, 0x0000051d, 0x00000554,
	0x0000055c, 0x00000564, 0x0000056e, 0x00000578,
	0x00000582, 0x0000058c, 0x000005ab, 0x000005b5,
	0x000005d0, 0x000005e9, 0x000005fc, 0x00000615,
	0x00000623, 0x0000062a, 0x0000063a, 0x00000647,
	0x00000654, 0x00000661, 0x0000066a, 0x00000699,
	0x000006a5, 0x000006ac, 0x000006b9, 0x000006c6,
	0x000006dc, 0x000006fa, 0x00000713, 0x00000723,
	// Entry 60 - 7F
	0x00000744, 0x0000075d, 0x00000770, 0x000007ab,
	0x000007b5, 0x000007c2, 0x000007f4, 0x0000080b,
	0x00000836, 0x00000845, 0x00000851, 0x00000866,
	0x00000884, 0x00000890, 0x0000089c, 0x000008ba,
	0x000008de, 0x000008ec, 0x000008fa, 0x00000901,
	0x0000090d, 0x00000925, 0x00000932, 0x00000945,
	0x00000968, 0x00000980, 0x000009ab, 0x000009c6,
	0x000009de, 0x000009f4, 0x00000a0e, 0x00000a2e,
	// Entry 80 - 9F
	0x00000a5b, 0x00000a75, 0x00000a82, 0x00000aa3,
	0x00000ad9, 0x00000aec, 0x00000b0a, 0x00000b3d,
	0x00000b55, 0x00000b7f, 0x00000b9d, 0x00000bb0,
	0x00000bca, 0x00000bdd, 0x00000c04, 0x00000c45,
	0x00000c5b, 0x00000c76, 0x00000c99, 0x00000cfa,
	0x00000d22, 0x00000d4c, 0x00000d68, 0x00000d8d,
	0x00000da0, 0x00000dc5, 0x00000de5, 0x00000e01,
	0x00000e1a, 0x00000e32, 0x00000e4b, 0x00000e4b,
	// Entry A0 - BF
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	// Entry C0 - DF
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	// Entry E0 - FF
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	// Entry 100 - 11F
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	0x00000e4b, 0x00000e4b, 0x00000e4b, 0x00000e4b,
	// Entry 120 - 13F
	0x00000e4b,
} // Size: 1180 bytes

const zh_CNData string = "" + // Size: 3659 bytes
	"\x02错误\x02(无参数): 提升并安装管理服务\x02用法: %[1]s [\x0a%[2]s]\x02命令行选项\x02无法确定该进程是" +
	"否在WOW64下运行: %[1]v\x02您必须在此计算机上使用原生版本的 WireGuard。\x02无法打开当前进程令牌: %[1]v" +
	"\x02WireGuard 可能只能被内建的 %[1]s 小组中的成员使用。\x02WireGuard 正在运行，但用户界面只能从内建的 %[1" +
	"]s 小组的桌面访问。\x02、\x02 \x02关闭\x02状态:\x02断开 (&D)\x02连接 (&A)\x02公钥:\x02监听端口:" +
	"\x02MTU:\x02地址:\x02DNS 服务器:\x02预共享密钥:\x02允许的 IP:\x02对端:\x02连接保活间隔:\x02上次" +
	"握手时间:\x02已断开\x02正在断开\x02未知\x02日志\x02复制 (&C)\x02全选 (&A)\x02导出… (&S)\x02" +
	"时间\x02日志消息\x02导出日志\x02隧道错误\x02%[1]s\x0a\x0a更多信息请查看日志。\x02退出 WireGuard " +
	"时出错\x02刚刚\x02系统时间倒退了！\x14\x01\x81\x01\x00\x00\x0a\x02%[1]d 年\x14\x01" +
	"\x81\x01\x00\x00\x0a\x02%[1]d 天\x14\x01\x81\x01\x00\x00\x0d\x02%[1]d 小时" +
	"\x14\x01\x81\x01\x00\x00\x0d\x02%[1]d 分钟\x14\x01\x81\x01\x00\x00\x0a\x02" +
	"%[1]d 秒\x02%[1]s 前\x02%[1]d B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB" +
	"\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02IP地址无效\x02网络" +
	"前缀长度无效\x02对端 (endpoint) 中缺少端口\x02对端主机名 (endpoint host) 无效\x02MTU 无效" +
	"\x02端口无效\x02连接保活间隔无效\x02无效的密钥：%[1]v\x02数值必须介于 0 至 2^64-1 之间: %[1]v\x02一行" +
	"中有两个逗号\x02隧道名称无效\x02[未指定]\x02每个节点都必须指定公钥\x02获取配置时出错\x02WireGuard 系统托盘图" +
	"标在30秒后没有出现。\x02脚本:\x02流量:\x02连接前\x02连接后\x02断开前\x02断开后\x02已禁用（依管理策略）" +
	"\x02已启用\x02接收 %[1]s, 发送 %[2]s\x02无法确认隧道状态\x02无法连接隧道\x02无法断开隧道连接\x02接口: %" +
	"[1]s\x02节点\x02创建新隧道\x02编辑隧道\x02名称 (&N):\x02公钥 (&P):\x02(未知)\x02拦截未经隧道的流量" +
	" (kill-switch) (&B)\x02保存 (&S)\x02取消\x02配置 (&C):\x02名称无效\x02必须输入名称。\x02隧" +
	"道名「%[1]s」无效。\x02无法列出现有隧道\x02隧道已存在\x02隧道名「%[1]s」已存在。\x02无法创建新的配置\x02写入文" +
	"件失败\x02文件「%[1]s」已存在。\x0a\x0a您确定要覆盖它吗？\x02已连接\x02正在连接\x02文本文件 (*.txt)|*" +
	".txt|所有文件 (*.*)|*.*\x02WireGuard 检测错误\x02无法等待 WireGuard 窗口出现: %[1]v\x02状" +
	"态: 未知\x02地址: 无\x02管理隧道… (&M)\x02从文件导入隧道… (&I)\x02退出 (&E)\x02隧道 (&T)" +
	"\x02隧道「%[1]s」已连接。\x02隧道「%[1]s」已断开连接。\x02状态: %[1]s\x02地址: %[1]s\x02隧道\x02" +
	"编辑 (&E)\x02新建空隧道… (&E)\x02新建隧道\x02删除所选隧道\x02导出所有隧道 (ZIP 压缩包)\x02切换连接状态" +
	" (&T)\x02导出所有隧道 (ZIP 压缩包)… (&Z)\x02编辑所选隧道… (&E)\x02删除所选隧道 (&R)\x02未找到配置文" +
	"件\x02无法导入配置: %[1]v\x02无法列出现有隧道: %[1]v\x02另一个同名的隧道「%[1]s」已存在\x02无法导入配置:" +
	" %[1]v\x02导入隧道\x14\x01\x81\x01\x00\x00\x1a\x02导入了 %[1]d 个隧道\x14\x02\x80" +
	"\x01\x000\x02导入了 %[2]d 个隧道中的 %[1]d 个隧道\x02无法创建隧道\x14\x01\x81\x01\x00\x00" +
	"\x17\x02删除 %[1]d 个隧道\x14\x01\x81\x01\x00\x00,\x02您确定要删除这 %[1]d 个隧道吗？\x02" +
	"删除隧道「%[1]s」\x02您确定要删除隧道「%[1]s」吗？\x02%[1]s此操作无法撤销。\x02无法删除隧道\x02无法删除隧道:" +
	" %[1]s\x02无法删除隧道\x14\x01\x81\x01\x00\x00 \x02无法删除 %[1]d 个隧道。\x02配置文件 (*." +
	"zip, *.conf)|*.zip;*.conf|所有文件 (*.*)|*.*\x02从文件导入隧道\x02配置文件 (*.zip)|*.zi" +
	"p\x02导出配置文件 (ZIP 压缩包)\x02无法停止服务: %[1]v。您可能需要在服务管理器中手动停止 WireGuard 服务。" +
	"\x02方括号中应包含一个 IPv6 地址\x02解码后的密钥长度必须为32字节\x02行必须出现在段落中\x02配置项必须要有一个等于号" +
	"\x02必须有一个值\x02[Interface] 段落中的该键无效\x02[Peer] 段落中的该键无效\x02接口必须有一个私钥\x02接口" +
	"段落的键无效\x02协议版本必须为 1\x02节点段落的键无效"

var zh_TWIndex = []uint32{ // 289 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000037, 0x00000056,
	0x00000066, 0x000000a4, 0x000000df, 0x00000110,
	0x00000153, 0x000001b8, 0x000001bc, 0x000001be,
	0x000001c5, 0x000001cc, 0x000001de, 0x000001ea,
	0x000001f1, 0x000001fb, 0x000001ff, 0x00000206,
	0x00000214, 0x00000224, 0x00000234, 0x0000023e,
	0x0000024f, 0x00000262, 0x00000272, 0x00000282,
	0x00000289, 0x00000290, 0x0000029c, 0x000002a8,
	// Entry 20 - 3F
	0x000002b7, 0x000002be, 0x000002cb, 0x000002db,
	0x000002e8, 0x00000317, 0x0000032f, 0x0000033c,
	0x00000355, 0x00000366, 0x00000377, 0x0000038b,
	0x0000039f, 0x000003b0, 0x000003ba, 0x000003c3,
	0x000003d0, 0x000003dd, 0x000003ea, 0x000003f7,
	0x00000406, 0x0000041a, 0x0000043c, 0x0000045b,
	0x00000475, 0x00000483, 0x00000493, 0x000004b9,
	0x000004d2, 0x000004fb, 0x00000514, 0x00000527,
	// Entry 40 - 5F
	0x00000533, 0x00000555, 0x00000571, 0x000005ad,
	0x000005ba, 0x000005c1, 0x000005cb, 0x000005d5,
	0x000005df, 0x000005e9, 0x00000601, 0x0000060b,
	0x0000062d, 0x00000646, 0x00000659, 0x00000672,
	0x00000681, 0x00000688, 0x00000698, 0x000006ab,
	0x000006b7, 0x000006c3, 0x000006cc, 0x00000701,
	0x0000070d, 0x00000714, 0x00000720, 0x00000730,
	0x00000746, 0x0000076a, 0x00000783, 0x00000793,
	// Entry 60 - 7F
	0x000007b4, 0x000007d3, 0x000007e6, 0x00000819,
	0x00000823, 0x00000833, 0x00000862, 0x0000087a,
	0x000008a7, 0x000008b7, 0x000008c4, 0x000008d6,
	0x000008ee, 0x000008fa, 0x000008fa, 0x00000915,
	0x00000939, 0x00000948, 0x00000956, 0x0000095d,
	0x00000969, 0x00000981, 0x0000098e, 0x000009a1,
	0x000009c4, 0x000009dc, 0x00000a01, 0x00000a19,
	0x00000a34, 0x00000a47, 0x00000a63, 0x00000a7f,
	// Entry 80 - 9F
	0x00000aa9, 0x00000ac5, 0x00000ad5, 0x00000af6,
	0x00000b29, 0x00000b3c, 0x00000b5a, 0x00000b8a,
	0x00000b9f, 0x00000bc9, 0x00000bef, 0x00000c02,
	0x00000c1e, 0x00000c31, 0x00000c55, 0x00000c99,
	0x00000cb5, 0x00000cd3, 0x00000cec, 0x00000d4d,
	0x00000d75, 0x00000d94, 0x00000db0, 0x00000dd8,
	0x00000dee, 0x00000e0d, 0x00000e27, 0x00000e4d,
	0x00000e6a, 0x00000e82, 0x00000e9a, 0x00000e9a,
	// Entry A0 - BF
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	// Entry C0 - DF
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	// Entry E0 - FF
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	// Entry 100 - 11F
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	0x00000e9a, 0x00000e9a, 0x00000e9a, 0x00000e9a,
	// Entry 120 - 13F
	0x00000e9a,
} // Size: 1180 bytes

const zh_TWData string = "" + // Size: 3738 bytes
	"\x02錯誤\x02(無參數)：提升權限並安裝管理服務\x02使用方法： %[1]s [\x0a%[2]s]\x02命令列選項\x02無法確定該" +
	"處理程序是否在 WOW64 下執行： %[1]v\x02您必須在此電腦上執行原生版本的 WireGuard。\x02無法開啓目前處理程序的權" +
	"杖： %[1]v\x02WireGuard 可能只能被內建的「%[1]s」群組成員使用。\x02WireGuard 正在執行，但 UI 只能" +
	"從內建的內建的「%[1]s」群組成員的桌面存取。\x02、\x02 \x02關閉\x02狀態\x02中斷連線 (&D)\x02連線 (&A)" +
	"\x02公鑰\x02監聽埠\x02MTU\x02位址\x02DNS 伺服器\x02預交換金鑰\x02允許的位址\x02連接點\x02Keepal" +
	"ive 間隔\x02最後交握時間\x02已中斷連線\x02正在中斷…\x02未知\x02日誌\x02複製 (&C)\x02全選 (&A)\x02" +
	"匯出… (&S)\x02時間\x02日誌訊息\x02匯出日誌…\x02隧道錯誤\x02%[1]s\x0a\x0a如需更多資訊，請查看日誌。" +
	"\x02離開 WireGuard 失敗\x02就是現在\x02系統時鐘倒退了！\x14\x01\x81\x01\x00\x00\x0a\x02%" +
	"[1]d 年\x14\x01\x81\x01\x00\x00\x0a\x02%[1]d 天\x14\x01\x81\x01\x00\x00" +
	"\x0d\x02%[1]d 小時\x14\x01\x81\x01\x00\x00\x0d\x02%[1]d 分鐘\x14\x01\x81\x01" +
	"\x00\x00\x0a\x02%[1]d 秒\x02%[1]s 前\x02%[1]d\u00a0B\x02%.2[1]f\u00a0KiB" +
	"\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s： %" +
	"[2]q\x02無效的 IP 位址\x02無效的網路位址首碼長度\x02Endpoint 中沒有指定埠號\x02無效的 Endpoint 位址" +
	"\x02無效的 MTU\x02無效的埠號\x02無效的 Persistent Keepalive 設定\x02無效的金鑰： %[1]v\x02數" +
	"值必須介於 0 到 2^64-1： %[1]v\x02一行中有兩個逗號\x02隧道名稱無效\x02[未指定]\x02每個 Peer 都必須要" +
	"有公鑰\x02讀取設定時發生錯誤\x02WireGuard 的工作列圖示在 30 秒後並沒有顯示。\x02指令碼：\x02流量\x02連接前" +
	"\x02連接後\x02斷線前\x02斷線後\x02已關閉, 隨著策略\x02已啓用\x02已收到 %[1]s；已傳送 %[2]s\x02無法確認" +
	"隧道狀態\x02無法連接隧道\x02無法斷開隧道連線\x02[隧道] %[1]s\x02節點\x02建立新隧道\x02編輯隧道設定\x02名" +
	"稱 (&N)\x02公鑰 (&P)\x02(未知)\x02阻斷未經過隧道的流量（kill-switch） (&B)\x02儲存 (&S)" +
	"\x02取消\x02設定 (&C)\x02無效的名稱\x02必須填寫名稱。\x02無效的隧道名稱「%[1]s」。\x02無法列出現有隧道\x02" +
	"隧道已存在\x02已有同名隧道「%[1]s」。\x02無法建立新的隧道設定\x02檔案寫入失敗\x02檔案已存在： %[1]s\x0a" +
	"\x0a您確定要覆蓋嗎？\x02已連線\x02正在連線…\x02純文字 (*.txt)|*.txt|所有檔案 (*.*)|*.*\x02偵測 W" +
	"ireGuard 錯誤\x02無法等待 WireGuard 視窗開啓： %[1]v\x02[狀態] 未知\x02[位址] 無\x02管理隧道 (" +
	"&M)\x02從檔案匯入… (&I)\x02離開 (&X)\x02已連線至隧道 - %[1]s\x02已中斷與隧道的連線 - %[1]s\x02" +
	"[狀態] %[1]s\x02位址: %[1]s\x02隧道\x02編輯 (&E)\x02新增隧道精靈 (&E)\x02新增隧道\x02刪除選取隧" +
	"道\x02匯出所有隧道（ZIP 格式）\x02切換連線狀態 (&T)\x02匯出所有隧道至 &ZIP 壓縮檔\x02編輯選取隧道 (&S)" +
	"\x02刪除已選取隧道 (&R)\x02找不到設定檔\x02無法匯入設定： %[1]v\x02無法列出隧道： %[1]v\x02已有另一個同名的" +
	"隧道「%[1]s」\x02無法匯入設定： %[1]v\x02已匯入隧道\x14\x01\x81\x01\x00\x00\x1a\x02已匯入" +
	" %[1]d 個隧道\x14\x02\x80\x01\x00-\x02已匯入 %[1]d 個隧道（共 %[2]d 個）\x02無法建立隧道" +
	"\x14\x01\x81\x01\x00\x00\x17\x02刪除 %[1]d 個隧道\x14\x01\x81\x01\x00\x00)" +
	"\x02您確定要刪除 %[1]d 個隧道嗎？\x02刪除隧道 - %[1]s\x02您確定要刪除隧道「%[1]s」嗎？\x02%[1]s\x0a" +
	"\x0a您將無法復原此操作。\x02無法刪除隧道\x02無法刪除隧道： %[1]s\x02無法刪除隧道\x14\x01\x81\x01\x00" +
	"\x00\x1d\x02無法刪除 %[1]d 個隧道\x02隧道設定檔 (*.zip, *.conf)|*.zip;*.conf|所有檔案 (*" +
	".*)|*.*\x02從檔案中匯入隧道…\x02隧道設定檔 (*.zip)|*.zip\x02匯出隧道設定至…\x02無法結束服務： %[1]v" +
	"。\x0a您可能需要手動從服務管理中結束 WireGuard 服務。\x02括號中必須包含一個 IPv6 位址\x02金鑰必須剛好長 32 " +
	"bytes\x02行必須出現在段落中\x02設定的項目必須要有一個等號\x02必須要有一個值\x02[Interface] 中有無效選項\x02" +
	"[Peer] 中有無效選項\x02Interface 中必須要有一把私鑰\x02Interface 中的金鑰無效\x02協定版本必須為 1" +
	"\x02Peer 中的金鑰無效"

	// Total table size 127902 bytes (124KiB); checksum: C1EDE612
