# Contributing to AB Download Manager

Thank you for your interest in contributing to AB Download Manager! I appreciate any help you can offer.

## What Contributions Are Accepted?

I welcome the following types of contributions:

- **Bug Reports**: If you find a bug, please report it by opening an issue with details about the problem.

- **Feature Requests**: Have an idea for a new feature? Let me know by opening an issue or starting a discussion.

- **Pull Requests**: If you’d like to contribute code, feel free to submit a pull request. Just make sure to read the guidelines below before you start.

## Pull Requests

If you're ready to contribute code, that's awesome! Before you start, here’s what you need to know about creating a pull request (PR):

- **Discuss First**: Before you start working on a PR, please open an issue or discussion to explain what you want to do. This helps me understand your idea and make sure it's something that can be merged. It also saves time if changes are needed.

- **Fork the Repo**: Fork this repository to your own GitHub account. This creates your own copy where you can make changes.

- **Create a Branch**: In your forked repository, create a new branch for your changes. Give it a descriptive name, like feature/add-some-feature or fix/some-error.

- **Make Your Changes**: Now you can start coding! Make sure your changes follow the project’s coding standards.

- **Submit the PR**: Once you're happy with your changes, push your branch to your fork and submit a pull request. In the PR description, explain what changes you made and why.

- **Review & Feedback**: I’ll review your PR as soon as I can. There might be some feedback or requests for changes, so be ready to make adjustments if needed.

- **Merging**: If everything looks good, I’ll merge your PR into the master branch.
